<?php 
require_once('../modelos/Almacen.php');

$almacen=new Almacen();

$idalmacen=isset($_POST["idalmacen"])? limpiarCadena($_POST["idalmacen"]):"";
$idusuario=isset($_POST["idusuario"])? limpiarCadena($_POST["idusuario"]):"";
$idtipo_almacen=isset($_POST["idtipo_almacen"])? limpiarCadena($_POST["idtipo_almacen"]):"";
$nombre=isset($_POST["nombre"])? limpiarCadena($_POST["nombre"]):"";
$direccion=isset($_POST["direccion"])? limpiarCadena($_POST["direccion"]):"";
$telefono=isset($_POST["telefono"])? limpiarCadena($_POST["telefono"]):"";
$estado=isset($_POST["estado"])? limpiarCadena($_POST["estado"]):"";

switch ($_GET["op"])
{
    case 'guardaryeditar':
      if(empty($idalmacen))
      {
        $rspta=$almacen->insertar($idusuario,$idtipo_almacen,$nombre,$direccion,$telefono,$estado);
        echo $rspta ? "Almacen Registrado" : "Almacen no se pudo registrar";
      }
      else {
          $rspta=$almacen->editar($idalmacen,$idusuario,$idtipo_almacen,$nombre,$direccion,$telefono,$estado);
          echo $rspta ? "Almacen Actualizada" : "Almacen no se pudo actualizar";
      }
    break;

    case 'mostrar':
      $rspta=$almacen->mostrar($idalmacen);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'eliminar':
      $rspta=$almacen->eliminar($idalmacen);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'listaralmacen':
      $rspta=$almacen->listaralmacen();
      //Vamos a declarar un array
      $data=Array();
      while($reg=$rspta->fetch_object())
      {
        $estado = ($reg->estado == 1) 
            ? '<button class="btn btn-success btn-xs btn-flat">Activa</button>' 
            : '<button class="btn btn-danger btn-xs btn-flat">Inactiva</button>';
        $data[]=array(
          "0"=>$reg->nombre,
          "1"=>$reg->almacen,
          "2"=>$reg->direccion,
          "3"=>$reg->telefono,
          "4"=>$reg->usuario,
          "5"=>$estado,          
          "6"=>'<a href="create.php?idalmacen=' . $reg->idalmacen . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-edit"></i></a>' .
               ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idalmacen . ')"><i class="fas fa-trash-alt"></i></button>'
        );
      }
      $results= array(
        "sEcho"=>1, //Informacion para el datatable
        "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
        "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);

    break;

    case 'selectTipoAlmacen': 
      $rspta = $almacen->selectTipoAlmacen();
      if ($rspta) {
          while ($reg = $rspta->fetch_object()) {
              echo "<option value='" . htmlspecialchars($reg->idtipo_almacen, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
          }
      } else {
          echo "<option value=''>No hay almacens disponibles</option>";
      }
      break;

      case 'selectAlmacen': 
        $rspta = $almacen->selectAlmacen();
        if ($rspta) {
            while ($reg = $rspta->fetch_object()) {
                echo "<option value='" . htmlspecialchars($reg->idalmacen, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
            }
        } else {
            echo "<option value=''>No hay almacens disponibles</option>";
        }
        break;
}

?>