<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (strlen(session_id()) < 1) session_start();

// Verifica que la sesión esté iniciada correctamente
if (!isset($_SESSION["idusuario"])) {
    echo json_encode(["error" => "Sesión no válida o no iniciada."]);
    exit;
}
require_once('../modelos/Apertura.php');

$apertura=new Apertura();

$idmovimientocaja=isset($_POST["idmovimientocaja"])? limpiarCadena($_POST["idmovimientocaja"]):"";
$fecha_apertura=isset($_POST["fecha_apertura"])? limpiarCadena($_POST["fecha_apertura"]):"";
$monto_apertura=isset($_POST["monto_apertura"])? limpiarCadena($_POST["monto_apertura"]):"";
$idusuario=$_SESSION["idusuario"];
$idcaja=$_SESSION["idcaja"];

switch ($_GET["op"])
{
    case 'guardaryeditar':
        if(empty($idmovimientocaja))
        {
          $rspta=$apertura->insertar($fecha_apertura,$monto_apertura,$idcaja);
          echo $rspta;
        }
        
      break;
  
      case 'mostrar':
        $rspta=$apertura->mostrar($idapertura);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;
  
      case 'eliminar':
        $rspta=$apertura->eliminar($idapertura);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;
  
      case 'listar':
        $rspta=$apertura->listar($idcaja);
        //Vamos a declarar un array
        $data=Array();
        while($reg=$rspta->fetch_object())
        {
          $data[]=array(
            "0"=>$reg->fecha_apertura,
            "1"=>$reg->caja,
            "2"=>$reg->monto_apertura,          
            "3"=>$reg->usuario
          );
        }
        $results= array(
          "sEcho"=>1, //Informacion para el datatable
          "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
          "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
          "aaData"=>$data);
        echo json_encode($results);
  
      break;

    
}