<?php 
require_once('../modelos/Categoria.php');

$categoria=new Categoria();

$nombre=isset($_POST["nombre"])? limpiarCadena($_POST["nombre"]):"";
$idcategoria=isset($_POST["idcategoria"])? limpiarCadena($_POST["idcategoria"]):"";
$descripcion=isset($_POST["descripcion"])? limpiarCadena($_POST["descripcion"]):"";
$condicion=isset($_POST["condicion"])? limpiarCadena($_POST["condicion"]):"";

switch ($_GET["op"])
{
    case 'guardaryeditar':
      if(empty($idcategoria))
      {
        $rspta=$categoria->insertar($nombre,$descripcion,$condicion);
        echo $rspta ? "Categoria Registrado" : "Categoria no se pudo registrar";
      }
      else {
          $rspta=$categoria->editar($idcategoria,$nombre,$descripcion,$condicion);
          echo $rspta ? "Categoria Actualizada" : "Categoria no se pudo actualizar";
      }
    break;

    case 'mostrar':
      $rspta=$categoria->mostrar($idcategoria);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'eliminar':
      $rspta=$categoria->eliminar($idcategoria);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'listarcategoria':
      $rspta=$categoria->listarcategoria();
      //Vamos a declarar un array
      $data=Array();
      while($reg=$rspta->fetch_object())
      {
        $condicion = ($reg->condicion == 1) 
            ? '<button class="btn btn-success btn-xs btn-flat">Activa</button>' 
            : '<button class="btn btn-danger btn-xs btn-flat">Inactiva</button>';
        $data[]=array(
          "0"=>$reg->nombre,
          "1"=>$reg->descripcion,
          "2"=>$reg->codigo,
          "3"=>$condicion,
          "4"=>'<a href="create.php?idcategoria=' . $reg->idcategoria . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-edit"></i></a>' .
            ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idcategoria . ')"><i class="fas fa-trash-alt"></i></button>'
        );
      }
      $results= array(
        "sEcho"=>1, //Informacion para el datatable
        "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
        "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);

    break;

    case 'selectCategoria': 
        $rspta = $categoria->selectCategoria();
        if ($rspta) {
            while ($reg = $rspta->fetch_object()) {
                echo "<option value='" . htmlspecialchars($reg->idcategoria, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
            }
        } else {
            echo "<option value=''>No hay categorias disponibles</option>";
        }
        break;

    
}
?>