<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (strlen(session_id()) < 1) session_start();

// Verifica que la sesión esté iniciada correctamente
if (!isset($_SESSION["idusuario"])) {
    echo json_encode(["error" => "Sesión no válida o no iniciada."]);
    exit;
} 
require_once('../modelos/CategoriaIngreso.php');

$categoria_ingreso=new CategoriaIngreso();

$idusuario=$_SESSION["idusuario"];
$idcaja=$_SESSION["idcaja"];
$nombre=isset($_POST["nombre"])? limpiarCadena($_POST["nombre"]):"";
$idcategoria_ingreso=isset($_POST["idcategoria_ingreso"])? limpiarCadena($_POST["idcategoria_ingreso"]):"";
$descripcion=isset($_POST["descripcion"])? limpiarCadena($_POST["descripcion"]):"";
$folio=isset($_POST["folio"])? limpiarCadena($_POST["folio"]):"";
$archivador=isset($_POST["archivador"])? limpiarCadena($_POST["archivador"]):"";
$condicion=isset($_POST["condicion"])? limpiarCadena($_POST["condicion"]):"";
$equivalencia=isset($_POST["equivalencia"])? limpiarCadena($_POST["equivalencia"]):"";

$idconcepto_ingreso=isset($_POST["idconcepto_ingreso"])? limpiarCadena($_POST["idconcepto_ingreso"]):"";
$idpersona=isset($_POST["idpersona"])? limpiarCadena($_POST["idpersona"]):"";
$tipopago=isset($_POST["tipopago"])? limpiarCadena($_POST["tipopago"]):"";
$idbanco=isset($_POST["idbanco"])? limpiarCadena($_POST["idbanco"]):"";
$nro_operacion=isset($_POST["nro_operacion"])? limpiarCadena($_POST["nro_operacion"]):"";
$hora=isset($_POST["hora"])? limpiarCadena($_POST["hora"]):"";
$fechapago=isset($_POST["fechapago"])? limpiarCadena($_POST["fechapago"]):"";
$monto=isset($_POST["monto"])? limpiarCadena($_POST["monto"]):"";
$comprobante=isset($_POST["comprobante"])? limpiarCadena($_POST["comprobante"]):"";
$nrorecibo=isset($_POST["nrorecibo"])? limpiarCadena($_POST["nrorecibo"]):"";
$idingreso=isset($_POST["idingreso"])? limpiarCadena($_POST["idingreso"]):"";

switch ($_GET["op"])
{
    case 'guardaryeditar':
      if(empty($idcategoria_ingreso))
      {
        $rspta=$categoria_ingreso->insertar($nombre,$descripcion,$folio,$archivador,$condicion,$equivalencia);
        echo $rspta ? "Categoria Ingreso Registrado" : "Categoria Ingreso no se pudo registrar";
      }
      else {
          $rspta=$categoria_ingreso->editar($idcategoria_ingreso,$nombre,$descripcion,$folio,$archivador,$condicion,$equivalencia);
          echo $rspta ? "Categoria Ingreso Actualizada" : "Categoria Ingreso no se pudo actualizar";
      }
    break;
    
    case 'guardar_ingreso':
      if(empty($idingreso))
      {
        $rspta=$categoria_ingreso->insertar_ingreso($idusuario,$idcaja,$idcategoria_ingreso,$idconcepto_ingreso,$idpersona,$tipopago,$idbanco,$nro_operacion,$hora,$fechapago,$monto,$comprobante,$nrorecibo);
        echo $rspta ? "Ingreso Registrado" : "Ingreso no se pudo registrar";
      }
    break;

    case 'mostrar':
      $rspta=$categoria_ingreso->mostrar($idcategoria_ingreso);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'eliminar':
      $rspta=$categoria_ingreso->eliminar($idcategoria_ingreso);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'listarcategoriaingreso':
      $rspta=$categoria_ingreso->listarcategoriaingreso();
      //Vamos a declarar un array
      $data=Array();
      while($reg=$rspta->fetch_object())
      {
        $condicion = ($reg->condicion == 1) 
            ? '<button class="btn btn-success btn-xs btn-flat">Activo</button>' 
            : '<button class="btn btn-danger btn-xs btn-flat">Inactivo</button>';
        $data[]=array(
          "0"=>$reg->nombre,
          "1"=>$reg->descripcion,
          "2"=>$reg->archivador,
          "3"=>$reg->folio,
          "4"=>$reg->equivalencia,
          "5"=>$condicion,
          "6"=>'<a href="create.php?idcategoria_ingreso=' . $reg->idcategoria_ingreso . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-edit"></i></a>' .
            ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idcategoria_ingreso . ')"><i class="fas fa-trash-alt"></i></button>'
        );
      }
      $results= array(
        "sEcho"=>1, //Informacion para el datatable
        "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
        "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);

    break;

    case 'selectCategoriaIngreso': 
      $rspta = $categoria_ingreso->selectCategoriaIngreso();
      if ($rspta) {
          while ($reg = $rspta->fetch_object()) {
              echo "<option value='" . htmlspecialchars($reg->idcategoria_ingreso, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
          }
      } else {
          echo "<option value=''>No hay Categoria disponibles</option>";
      }
      break;

   

    
}
?>