<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (strlen(session_id()) < 1) session_start();

// Verifica que la sesión esté iniciada correctamente
if (!isset($_SESSION["idusuario"])) {
    echo json_encode(["error" => "Sesión no válida o no iniciada."]);
    exit;
}
require_once "../modelos/Consulta.php";

$consulta=new Consulta();

$idverificar=isset($_POST["idverificar"])? limpiarCadena($_POST["idverificar"]):"";
$idbanco=isset($_POST["idbanco"])? limpiarCadena($_POST["idbanco"]):"";
$nroperacion=isset($_POST["nroperacion"])? limpiarCadena($_POST["nroperacion"]):"";
$fecha=isset($_POST["fecha"])? limpiarCadena($_POST["fecha"]):"";
$hora=isset($_POST["hora"])? limpiarCadena($_POST["hora"]):"";
$motivo=isset($_POST["motivo"])? limpiarCadena($_POST["motivo"]):"";
$idusuario=$_SESSION["idusuario"];
$idcaja=$_SESSION["idcaja"];


switch ($_GET["op"])
{

    case 'guardarImagen':
        $rspta=$consulta->insert($idusuario,$idverificar,$nroperacion,$idbanco,$fecha,$hora,$motivo);
        echo $rspta ? "Registro Actualizado" : "No se pudo registrar";
        break;

    case 'listar_acta':
        $rspta=$consulta->listar_acta();
        $data=Array();
        while($reg=$rspta->fetch_object()){

            $data[]=array(
	        "0"=>$reg->iddetalle,
                "1"=>$reg->producto,
                "2"=>$reg->cantidad,
                "3"=>$reg->codigo,
                "4"=>$reg->costo,
                "5"=>$reg->tipotrabajo,
                "6"=>$reg->nroacta,
                "7"=>$reg->tecnico,
                "8"=>$reg->cliente,
                "9"=>$reg->fecha_hora
            );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;
 
    case 'listar_incidencia':
        $rspta=$consulta->listar_incidencia();
        $data=Array();
        while($reg=$rspta->fetch_object()){

            if($reg->estado == 1){
                $tipo='<button class="btn btn-danger btn-xs btn-flat"></i>Pendiente</button></a>';
            }else if($reg->estado == 2){
                $tipo='<button class="btn btn-dark btn-xs btn-flat"></i>Atendido</button></a>';
            }
            
           $data[]=array(
                "0"=>$reg->sit_contrato,
                "1"=>$reg->nrocontrato,
                "2"=>$reg->persona,
                "3"=>$reg->celular,
                "4"=>$reg->direccion,
                "5"=>$reg->referencia,
                "6"=>$reg->descripcion,
                "7"=>$reg->fecha,
                "8"=>$tipo,
                "9"=>'<button class="btn btn-primary btn-xs btn-flat" onclick="actualizar_direccion(' .
                            $reg->iddireccion . ', ' .
                            '\'' . addslashes($reg->direccion) . '\', ' .
                            '\'' . addslashes($reg->referencia) . '\', ' .
                            '\'' . $reg->latitud . '\', ' .
                            '\'' . $reg->longitud . '\')">' .
                            '<i class="fa fa-map-location-dot"></i></button>'.
                               ' <a href="../averia/create.php?idincidencia=' . $reg->idincidencia . '&idpersona=' . $reg->idcliente . '&idcontrato='.$reg->idcontrato.'&descripcion='.$reg->descripcion.'&direccion='.$reg->direccion.'&referencia='.$reg->referencia.'&latitud='.$reg->latitud.'&longitud='.$reg->longitud.'&celular='.$reg->celular.'&sit_contrato='.$reg->sit_contrato.' " class="btn btn-warning btn-xs btn-flat"><i class="fa fa-eye"></i></a>'.
                  ' <button class="btn btn-success btn-xs btn-flat" onclick="actualizar_incidencia(' . $reg->idincidencia . ')"><i class="fas fa-check"></i></button>'
            );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

    case 'listar_pago':
         $rspta=$consulta->listar_pago();
         $data=Array();
         while($reg=$rspta->fetch_object()){
 
             if($reg->estado == 1){
                 $tipo='<button class="btn btn-danger btn-xs btn-flat"></i>Pendiente</button></a>';
                 $opcion='<button class="btn btn-danger btn-xs btn-flat" onclick="eliminar('.$reg->idverificar.')"><i class="fa fa-close"></i></button>'.
                ' <button class="btn btn-success btn-xs btn-flat" onclick="pagar_cuota('.$reg->idverificar.')"> Pagar</button>';
                $img_html = '<button class="btn btn-success btn-xs btn-flat" onclick="mostrar_imagen('.$reg->idverificar.')" data-toggle="modal" data-target="#modal_imagen"></i>Mostrar Imagen</button>';
             }else if($reg->estado == 2){
                 $tipo='<button class="btn btn-dark btn-xs btn-flat"></i>Pagado</button></a>';
                 $opcion='';
             }

             $nombre_url='<a target="_blank" href="../contrato/create_ver.php?idcontrato='.$reg->idcontrato.'"> <button class="btn btn-danger btn-flat btn-xs">'.$reg->nombre.'</button></a> ';
            
             
          
            $data[]=array(
                "0"=>$nombre_url,
                "1"=>$reg->montoapagar,
                "2"=>$reg->banco,
                "3"=>$reg->nroperacion,
                "4"=>$reg->fecha,
                "5"=>$img_html,
                "6"=>$tipo,
                "7"=>$opcion
            );
         }
         $results=array(
             "isEcho"=>1,
             "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
             "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
             "aaData"=>$data);
         echo json_encode($results);
     break;

    case 'listar_caja':
      
        $rspta=$consulta->listar_caja();
        $data=Array();
        while($reg=$rspta->fetch_object()){

        $cero=00;
        $ano = date("Y",strtotime ($reg->fecha_cierre));
        $mes = date("m",strtotime($reg->fecha_cierre));
        $nro = $ano.''.$mes.'-'.$cero.''.$reg->nrocorrelativo;
            if($reg->estado_caja == 2){
            $arg='<button class="btn btn-danger btn-xs btn-flat" >Cerrado</button>';
            }
           $imagenn = $reg->imagen ? "../../files/garantia/{$reg->imagen}" : "../../files/averia/no_disponible.jpg";
           $img_html = '<img src="'.$imagenn.'" width="50" height="50">';
           $opcion ='<a href="view_caja.php?idcierre='.$reg->idcierre.'" <button class="btn btn-warning btn-xs btn-flat" >Ver Caja</button></a>';

        $data[]=array(
            "0"=>$reg->fecha_cierre,
            "1"=>$nro,
            "2"=>$reg->caja,
            "3"=>number_format($reg->monto_apertura,2),
            "4"=>number_format($reg->monto_efectivo,2),
            "5"=>number_format($reg->monto_deposito,2),
            "6"=>$img_html,
            "7"=>$reg->descripcion,
            "8"=>$arg,
            "9"=>$opcion
            );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

    case 'listarkardex':
        $idalmacen=$_REQUEST["idalmacen"];
        $rspta=$consulta->listarkardex($idalmacen);
        $data=Array();
        while($reg=$rspta->fetch_object()){
         $total=$reg->stock_ingreso-$reg->stock_salida;
        $data[]=array(
            "0"=>$reg->nombre,
            "1"=>$reg->codigo,
            "2"=>$reg->producto,
            "3"=>$reg->categoria,
            "4"=>$reg->stock_ingreso,
            "5"=>$reg->stock_salida,
            "6"=>$total
        
        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

    case 'mostrarDetalle':
        $codigo = isset($_GET['id']) ? intval($_GET['id']) : 0;
        $rspta = $consulta->mostrarDetalle($codigo);
        echo json_encode($rspta);
    break;

    case 'listaMovimiento':
        $idtecnico=$_REQUEST["idtecnico"];

        $rspta=$consulta->listaMovimiento($idtecnico);
        $data=Array();
        while($reg=$rspta->fetch_object()){

            $suma=$reg->cantidaddevuelto+$reg->cantidadusado;
            if($reg->estado == '1'){
              $resultado='<button class="btn btn-success btn-xs btn-flat"></i>Conforme</button></a>';
              $total=0;
            }else{
                $resultado='<button class="btn btn-danger btn-xs btn-flat"></i>Faltante</button></a>';
                $total=$reg->cantidadsalida-$suma;
            }

         $opcion='<a href="#"<button class="btn btn-warning btn-xs btn-flat" onclick="mostrarDetalle('.$reg->codigo.')" data-toggle="modal" data-target="#modalVer">Ver</i></button></a>';
        $data[]=array(
            "0"=>$reg->codigo,
            "1"=>$reg->nombre,
            "2"=>$reg->marca,
            "3"=>$reg->mac,
            "4"=>$reg->cantidadsalida,
            "5"=>$reg->cantidaddevuelto,
            "6"=>$reg->cantidadusado,
            "7"=>$total,
            "8"=>$resultado,
            "9"=>$opcion
        
        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

    case 'listarIngreso':
       // $idtecnico=$_REQUEST["idtecnico"];

        $rspta=$consulta->listarIngreso();
        $data=Array();
        while($reg=$rspta->fetch_object()){

            if($reg->tipoingreso == 2){
                $tipo='<button class="btn btn-danger btn-xs btn-flat"></i>Efectivo</button></a>';
            }else if($reg->tipoingreso == 3){
                $tipo='<button class="btn btn-dark btn-xs btn-flat"></i>Transferencia</button></a>';
            }

         //$opcion='<a href="#"<button class="btn btn-warning btn-xs btn-flat" onclick="mostrarDetalle('.$reg->codigo.')" data-toggle="modal" data-target="#modalVer">Ver</i></button></a>';
        $data[]=array(
            "0"=>$tipo,
            "1"=>$reg->usuario,
            "2"=>$reg->cliente,
            "3"=>$reg->monto,
            "4"=>$reg->correlativo_pago,
            "5"=>$reg->nro_operacion,
            "6"=>$reg->descripcion,
            "7"=>$reg->fecha_pago
        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;
    
    case 'listar_usuario':
       // $idtecnico=$_REQUEST["idtecnico"];
        $rspta=$consulta->listar_usuario($idusuario);
        $data=Array();
        while($reg=$rspta->fetch_object()){

            if($reg->tipoingreso == 2){
                $tipo='<button class="btn btn-danger btn-xs btn-flat"></i>Efectivo</button></a>';
            }else if($reg->tipoingreso == 3){
                $tipo='<button class="btn btn-dark btn-xs btn-flat"></i>Transferencia</button></a>';
            }

         //$opcion='<a href="#"<button class="btn btn-warning btn-xs btn-flat" onclick="mostrarDetalle('.$reg->codigo.')" data-toggle="modal" data-target="#modalVer">Ver</i></button></a>';
        $data[]=array(
            "0"=>$tipo,
            "1"=>$reg->usuario,
            "2"=>$reg->cliente,
            "3"=>$reg->monto,
            "4"=>$reg->correlativo_pago,
            "5"=>$reg->nro_operacion,
            "6"=>$reg->descripcion,
            "7"=>$reg->fecha_pago
        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

    case 'listar_administrador':
        $fecha_inicio=$_REQUEST['fecha_inicio'];
        $fecha_fin=$_REQUEST['fecha_fin'];
        $rspta=$consulta->listar_administrador($fecha_inicio,$fecha_fin);
        $data=Array();
        while($reg=$rspta->fetch_object()){

            if($reg->tipoingreso == 2){
                $tipo='<button class="btn btn-danger btn-xs btn-flat"></i>Efectivo</button></a>';
            }else if($reg->tipoingreso == 3){
                $tipo='<button class="btn btn-dark btn-xs btn-flat"></i>Transferencia</button></a>';
            }

         //$opcion='<a href="#"<button class="btn btn-warning btn-xs btn-flat" onclick="mostrarDetalle('.$reg->codigo.')" data-toggle="modal" data-target="#modalVer">Ver</i></button></a>';
        $data[]=array(
            "0"=>$tipo,
            "1"=>$reg->usuario,
            "2"=>$reg->cliente,
            "3"=>$reg->monto,
            "4"=>$reg->correlativo_pago,
            "5"=>$reg->nro_operacion,
            "6"=>$reg->descripcion,
            "7"=>$reg->fecha_pago
        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

    case 'listar_fecha_usuario':
        $fecha_inicio=$_REQUEST['fecha_inicio'];
        $fecha_fin=$_REQUEST['fecha_fin'];
        $rspta=$consulta->listar_fecha_usuario($fecha_inicio,$fecha_fin,$idusuario);
        $data=Array();
        while($reg=$rspta->fetch_object()){

            if($reg->tipoingreso == 2){
                $tipo='<button class="btn btn-danger btn-xs btn-flat"></i>Efectivo</button></a>';
            }else if($reg->tipoingreso == 3){
                $tipo='<button class="btn btn-dark btn-xs btn-flat"></i>Transferencia</button></a>';
            }

         //$opcion='<a href="#"<button class="btn btn-warning btn-xs btn-flat" onclick="mostrarDetalle('.$reg->codigo.')" data-toggle="modal" data-target="#modalVer">Ver</i></button></a>';
        $data[]=array(
            "0"=>$tipo,
            "1"=>$reg->usuario,
            "2"=>$reg->cliente,
            "3"=>$reg->monto,
            "4"=>$reg->correlativo_pago,
            "5"=>$reg->nro_operacion,
            "6"=>$reg->descripcion,
            "7"=>$reg->fecha_pago
        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

    case 'listarEgreso':
        // $idtecnico=$_REQUEST["idtecnico"];
 
         $rspta=$consulta->listarEgreso();
         $data=Array();
         while($reg=$rspta->fetch_object()){
 
             if($reg->idtipo == 1){
                 $tipo='<button class="btn btn-danger btn-xs btn-flat"></i>Fijo</button></a>';
             }else if($reg->idtipo == 2){
                 $tipo='<button class="btn btn-dark btn-xs btn-flat"></i>Variable</button></a>';
             }

             if($reg->tipo_comprbante = 1){
                $comprobante='<button class="btn btn-danger btn-xs btn-flat"></i>Recibo de Egreso</button></a>';
             }else if($reg->tipo_comprbante = 2){
                $comprobante='<button class="btn btn-danger btn-xs btn-flat"></i>Boleta</button></a>';
             }else if($reg->tipo_comprbante = 3){
                $comprobante='<button class="btn btn-danger btn-xs btn-flat"></i>Factura</button></a>';
             }
 
          //$opcion='<a href="#"<button class="btn btn-warning btn-xs btn-flat" onclick="mostrarDetalle('.$reg->codigo.')" data-toggle="modal" data-target="#modalVer">Ver</i></button></a>';
         $data[]=array(
             "0"=>$tipo,
             "1"=>$reg->concepto,
             "2"=>$reg->monto,
             "3"=>$reg->banco,
             "4"=>$reg->nroperacion,
             "5"=>$reg->descripcion,
             "5"=>$reg->descripcion,
             "6"=>$comprobante,
             "7"=>$reg->nrorecibo,
             "8"=>$reg->pago
         );
         }
         $results=array(
             "isEcho"=>1,
             "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
             "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
             "aaData"=>$data);
         echo json_encode($results);
     break;


    case 'listar_recaudo':
        $fecha_inicio=$_REQUEST['fecha_inicio'];
        $fecha_fin=$_REQUEST['fecha_fin'];
        $rspta=$consulta->listar_recaudo($fecha_inicio,$fecha_fin);
        //Vamos a declarar un array
        $data=Array();
        while($reg=$rspta->fetch_object())
        {

            $suma1 = $reg->monto + $reg->montocuota;
            //$suma += $suma1;
            //$subtotal += $suma1;

            //$partesNombre = explode(' ', $reg->cliente);
            $partesNombre = array_values(array_filter(explode(' ', trim($reg->cliente))));
            $nombreFinal = [];
            $apellidoMaterno = '';
            $apellidoPaterno = '';
            $nombreSeparado1 = '';
            $nombreSeparado2 = '';
            $palabrasClave = ['de', 'la', 'del', 'los', 'las', 'san', 'santa'];

            $i = 0;
                while ($i < count($partesNombre)) {
                    $palabra = strtolower($partesNombre[$i]);

                    if (in_array($palabra, $palabrasClave) && isset($partesNombre[$i + 1])) {
                        $nombreCompuesto = $partesNombre[$i] . ' ' . $partesNombre[$i + 1];
                        $i += 2;

                        if (isset($partesNombre[$i]) && !empty($partesNombre[$i]) && ctype_upper($partesNombre[$i][0])) {
                            $nombreCompuesto .= ' ' . $partesNombre[$i];
                            $i++;
                        }

                        $nombreFinal[] = $nombreCompuesto;
                    } else {
                        $nombreFinal[] = $partesNombre[$i];
                        $i++;
                    }
                }

                $apellidoMaterno = isset($nombreFinal[0]) ? $nombreFinal[0] : '';
                $apellidoPaterno = isset($nombreFinal[1]) ? $nombreFinal[1] : '';
                $nombreSeparado1 = isset($nombreFinal[2]) ? $nombreFinal[2] : '';
                $nombreSeparado2 = isset($nombreFinal[3]) ? $nombreFinal[3] : '';
                $nombreconcat = trim("$nombreSeparado1 $nombreSeparado2");

                $codigom = 1;
                $prioridad = 1;
                $fechaVence = $reg->fecha_pago;
                $fechaFormateada = (new DateTime($fechaVence))->format("d/m/Y");
                $anio = explode('-', $reg->fechainicial)[0];
                $mes = explode('-', $reg->fechainicial)[1];
                $periodo = $anio . $mes;
                $tipomora = 0;
                $mora = 0;

       
          $data[]=array(
            "0"=>$reg->nrocontrato,
            "1"=>$reg->num_documento,
            "2"=>$apellidoPaterno,
            "3"=>$apellidoMaterno,
            "4"=>$nombreconcat,
            "5"=>$reg->cliente,
            "6"=>$reg->description,
            "7"=>$codigom,
            "8"=>$suma1,
            "9"=>$prioridad,
            "10"=>$periodo,
            "11"=>$fechaFormateada,
            "12"=>$tipomora,
            "13"=>$mora

          );
        }
        $results= array(
          "sEcho"=>1, //Informacion para el datatable
          "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
          "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
          "aaData"=>$data);
          echo json_encode($results, JSON_PRETTY_PRINT);
  
      break;

      case 'mostrar_pendiente':
        $fecha_inicio=$_REQUEST['fecha_inicio'];
        $fecha_fin=$_REQUEST['fecha_fin'];
        $rspta=$consulta->mostrar_pendiente($fecha_inicio,$fecha_fin);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;
      
         case 'mostrar_llamada':
        $fecha_inicio=$_REQUEST['fecha_inicio'];
        $fecha_fin=$_REQUEST['fecha_fin'];
        $rspta=$consulta->mostrar_llamada($fecha_inicio,$fecha_fin);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;

      case 'mostrar_finanza':
        $anio=$_REQUEST['anio'];
        $mes=$_REQUEST['mes'];
        $rspta=$consulta->mostrar_finanza($anio,$mes);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;

      case 'grafico_venta':
        $rspta=$consulta->grafico_venta();
        echo json_encode($rspta);
      break;

      case 'mostrar_imagen':
        $idverificar=$_REQUEST['idverificar'];
        $rspta=$consulta->mostrar_imagen($idverificar);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;

      case 'eliminar':
        $idverificar=$_REQUEST['idverificar'];
        $rspta=$consulta->eliminar($idverificar);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;

      case 'pagar_cuota':
        $idverificar=$_REQUEST['idverificar'];
        $rspta=$consulta->pagar_cuota($idverificar,$idcaja);
         //Codificar el resultado utilizando json
         echo $rspta;
      break;

      case 'actualizar_incidencia':
        $idincidencia=$_REQUEST['idincidencia'];
        $rspta=$consulta->actualizar_incidencia($idincidencia);
         //Codificar el resultado utilizando json
         echo $rspta;
      break;
      
      case 'actualizar_linea_pendiente':
        $fecha_inicio=$_REQUEST['fecha_inicio'];
        $fecha_fin=$_REQUEST['fecha_fin'];
        $rspta=$consulta->actualizar_linea_pendiente($fecha_inicio,$fecha_fin);
         //Codificar el resultado utilizando json
         echo $rspta;
      break;
      
      case 'listar_pendiente_actualizar':
        $rspta=$consulta->listar_pendiente_actualizar();
        $data=Array();
        while($reg=$rspta->fetch_object()){
         
        $data[]=array(
            "0"=>$reg->nombre,
            "1"=>$reg->nrocontrato,
            "2"=>$reg->sit_contrato,
            "3"=>number_format($reg->montomensualidad,2)
        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

     case 'actualizar_procesados':
        $rspta=$consulta->actualizar_procesados();
         //Codificar el resultado utilizando json
         echo $rspta;
      break;
      
      case 'mostrar_pendiente_egreso':
        $fecha_inicio=$_REQUEST['fecha_inicio'];
        $fecha_fin=$_REQUEST['fecha_fin'];
        $rspta=$consulta->mostrar_pendiente_egreso($fecha_inicio,$fecha_fin);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;
      
       case 'lista_sorteo':
        $rspta=$consulta->lista_sorteo();
        $data=Array();
        while($reg=$rspta->fetch_object()){

          
        $data[]=array(
            "0"=>$reg->idsorte,
            "1"=>$reg->nombre,
        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;
    
    case 'listarEgreso_usuario':
        // $idtecnico=$_REQUEST["idtecnico"];
 
         $rspta=$consulta->listarEgreso_usuario($idusuario);
         $data=Array();
         while($reg=$rspta->fetch_object()){
 
             if($reg->idtipo == 1){
                 $tipo='<button class="btn btn-danger btn-xs btn-flat"></i>Fijo</button></a>';
             }else if($reg->idtipo == 2){
                 $tipo='<button class="btn btn-dark btn-xs btn-flat"></i>Variable</button></a>';
             }

             if($reg->tipo_comprbante = 1){
                $comprobante='<button class="btn btn-danger btn-xs btn-flat"></i>Recibo de Egreso</button></a>';
             }else if($reg->tipo_comprbante = 2){
                $comprobante='<button class="btn btn-danger btn-xs btn-flat"></i>Boleta</button></a>';
             }else if($reg->tipo_comprbante = 3){
                $comprobante='<button class="btn btn-danger btn-xs btn-flat"></i>Factura</button></a>';
             }
 
          //$opcion='<a href="#"<button class="btn btn-warning btn-xs btn-flat" onclick="mostrarDetalle('.$reg->codigo.')" data-toggle="modal" data-target="#modalVer">Ver</i></button></a>';
         $data[]=array(
             "0"=>$tipo,
             "1"=>$reg->usuario,
             "2"=>$reg->concepto,
             "3"=>$reg->monto,
             "4"=>$reg->banco,
             "5"=>$reg->nroperacion,
             "6"=>$reg->descripcion,
             "7"=>$comprobante,
             "8"=>$reg->nrorecibo,
             "9"=>$reg->pago
         );
         }
         $results=array(
             "isEcho"=>1,
             "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
             "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
             "aaData"=>$data);
         echo json_encode($results);
     break;
     
     case 'actualizar_direccion':
        $iddireccion = $_POST['iddireccion'];
        $direccion = $_POST['direccion'];
        $referencia = $_POST['referencia'];
        $latitud = $_POST['latitud'];
        $longitud = $_POST['longitud'];
        $rspta = $consulta->actualizar_direccion($iddireccion, $direccion, $referencia, $latitud, $longitud);
         //Codificar el resultado utilizando json
         echo $rspta;
      break;

}
?>