<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (strlen(session_id()) < 1) session_start();

// Verifica que la sesión esté iniciada correctamente
if (!isset($_SESSION["idusuario"])) {
    echo json_encode(["error" => "Sesión no válida o no iniciada."]);
    exit;
}
require_once "../modelos/Facturacion.php";

$facturacion=new Facturacion();

$idpago=isset($_POST["idpago"])? limpiarCadena($_POST["idpago"]):"";
$codigotipo_comprobante=isset($_POST["codigotipo_comprobante"])? limpiarCadena($_POST["codigotipo_comprobante"]):"";
$serie=isset($_POST["serie"])? limpiarCadena($_POST["serie"]):"";
$correlativo=isset($_POST["correlativo"])? limpiarCadena($_POST["correlativo"]):"";


switch ($_GET["op"])
{

    case 'actualizacion_comprobante':
        
          $rspta=$facturacion->update($idpago,$codigotipo_comprobante,$serie,$correlativo);
          echo $rspta ? "Comprobante Registrado" : "Comprobante no se pudo registrar";
        
    break;

    case 'listarIngreso':
       // $idtecnico=$_REQUEST["idtecnico"];
        $rspta=$facturacion->listarIngreso();
        $data=Array();
        while($reg=$rspta->fetch_object()){

            $url_ticket='../facturacion/ticket_boleta.php?id=';
            $url_boleta='../facturacion/boleta.php?id=';
            $url_factura='../facturacion/factura.php?id=';

            $comprobante='-';

            if($reg->codigotipo_comprobante == 1){
                $tipo='Factura';
               
            }else if($reg->codigotipo_comprobante == 3){
                $tipo='Boleta';
            }else{
                $tipo='-';
            }
            
        if($reg->estado_facturacion == 1 && intval($reg->codigotipo_comprobante) === 0 ){
            $estado='<button class="btn btn-danger btn-xs btn-flat">Pendiente</i></button>';
            $opcion='<button class="btn btn-primary btn-xs btn-flat" onclick="mostrar_facturacion('.$reg->idpago.','.$reg->idtipo_documento.')" data-toggle="modal" data-target="#modal_facturacion"><i class="fa-solid fa-arrow-rotate-right"></i> Actualizar </button>';
            $sunat=' <button class="btn btn-danger btn-xs btn-flat"><i class="fas fa-sync"></i></i></button>';
            $baja='<button class="btn btn-danger btn-xs btn-flat"><i class="fa-solid fa-xmark"></i></button>';

        }else if($reg->estado_facturacion == 1 && intval($reg->codigotipo_comprobante) > 0){
            $estado='<button class="btn btn-danger btn-xs btn-flat">Pendiente</i></button>';
            $opcion='<button class="btn btn-warning btn-xs btn-flat" onclick="mostrar('.$reg->idpago.','.$reg->idtipo_documento.')" data-toggle="modal" data-target="#modal_facturacion"><i class="fa fa-eye"></i></button>';
            $sunat=' <button class="btn btn-danger btn-xs btn-flat" onclick="enviar_facturacion('.$reg->idpago.')"><i class="fas fa-sync"></i></i></button>';
            $baja='<button class="btn btn-danger btn-xs btn-flat"><i class="fa-solid fa-xmark"></i></button>';
        
        }else if($reg->estado_facturacion == 2){
            $estado='<button class="btn btn-success btn-xs btn-flat">Enviado</i></button>';
            $opcion='<button class="btn btn-warning btn-xs btn-flat" onclick="mostrar('.$reg->idpago.','.$reg->idtipo_documento.')" data-toggle="modal" data-target="#modal_facturacion"><i class="fa fa-eye"></i></button>';
            $sunat='<button class="btn btn-success btn-xs btn-flat" data-toggle="tooltip" title="'.$reg->sMesajeRespuesta.'"><i class="fa-solid fa-check"></i></button>';
            $baja='<button class="btn btn-danger btn-xs btn-flat" onclick="anular_documento('.$reg->idpago.')"><i class="fa-solid fa-xmark"></i> </button>';
            if($reg->codigotipo_comprobante == 1){
                $comprobante='<a target="_blank" href="'.$url_factura.$reg->idpago.'"> <button class="btn btn-danger btn-xs btn-flat"><i class="fa fa-file"></i> </button></a>';
            }else if($reg->codigotipo_comprobante == 3){
                $comprobante='<a target="_blank" href="'.$url_ticket.$reg->idpago.'"> <button class="btn btn-info btn-xs btn-flat"><i class="fa fa-file"></i> </button></a>'.
                '<a target="_blank" href="'.$url_boleta.$reg->idpago.'"> <button class="btn btn-danger btn-xs btn-flat"><i class="fa fa-file"></i> </button></a>';
            }else{
                $comprobante='-';
            }

        }else if($reg->estado_facturacion == 3){
            $estado='<button class="btn btn-dark btn-xs btn-flat"></i>Baja</button>';
            $opcion='<button class="btn btn-warning btn-xs btn-flat" onclick="mostrar('.$reg->idpago.','.$reg->idtipo_documento.')" data-toggle="modal" data-target="#modal_facturacion"><i class="fa fa-eye"></i></button>';
            $sunat='<button class="btn btn-success btn-xs btn-flat"><i class="fa-solid fa-check"></i></button>';
            $baja='<button class="btn btn-success btn-xs btn-flat" data-toggle="tooltip" title="'.$reg->sMesajeRespuesta.'"><i class="fa-solid fa-xmark"></i></button>';
        }

        $serie = (!empty($reg->serie)) ? $reg->serie : '-';
        $moneda='PEN';
               
        $data[]=array(
	    "0" => '<input type="checkbox" class="dt-checkboxes check-item" value="' . $reg->idpago . '">',
            "1"=>$reg->fecha_pago,
            "2"=>$tipo,
            "3"=>$serie,
            "4"=>$reg->correlativo,
            "5"=>$reg->num_documento,
            "6"=>$reg->cliente,
            "7"=>$moneda,
            "8"=>$reg->monto,
            "9"=>$estado,
            "10"=>$opcion,
            "11"=>$comprobante,
            "12"=>$sunat,
            "13"=>$baja

        );
        }
        $results=array(
            "isEcho"=>1,
            "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
            "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
            "aaData"=>$data);
        echo json_encode($results);
    break;

    case 'listar_facturacion':
        // $idtecnico=$_REQUEST["idtecnico"];
         $rspta=$facturacion->listar_facturacion();
         $data=Array();
         while($reg=$rspta->fetch_object()){

            $url_ticket='../facturacion/ticket_boleta.php?id=';
            $url_boleta='../facturacion/boleta.php?id=';
            $url_factura='../facturacion/factura.php?id=';

            $comprobante='-';
 
             if($reg->codigotipo_comprobante == 1){
                 $tipo='Factura';
                 $comprobante='-';
             }else if($reg->codigotipo_comprobante == 3){
                 $tipo='Boleta';
             }else{
                 $tipo='-';
                 $comprobante='-';
             }

         if($reg->estado_facturacion == 1 && intval($reg->codigotipo_comprobante) === 0 ){
             $estado='<button class="btn btn-danger btn-xs btn-flat">Pendiente</i></button>';
             $opcion='<button class="btn btn-primary btn-xs btn-flat" onclick="mostrar_facturacion('.$reg->idpago.','.$reg->idtipo_documento.')" data-toggle="modal" data-target="#modal_facturacion"><i class="fa-solid fa-arrow-rotate-right"></i> Actualizar </button>';
             $sunat=' <button class="btn btn-danger btn-xs btn-flat"><i class="fas fa-sync"></i></i></button>';
             $baja='<button class="btn btn-danger btn-xs btn-flat"><i class="fa-solid fa-xmark"></i></button>';
 
         }else if($reg->estado_facturacion == 1 && intval($reg->codigotipo_comprobante) > 0){
             $estado='<button class="btn btn-danger btn-xs btn-flat">Pendiente</i></button>';
             $opcion='<button class="btn btn-warning btn-xs btn-flat" onclick="mostrar('.$reg->idpago.','.$reg->idtipo_documento.')" data-toggle="modal" data-target="#modal_facturacion"><i class="fa fa-eye"></i></button>';
             $sunat=' <button class="btn btn-danger btn-xs btn-flat" onclick="enviar_facturacion('.$reg->idpago.')"><i class="fas fa-sync"></i></i></button>';
             $baja='<button class="btn btn-danger btn-xs btn-flat"><i class="fa-solid fa-xmark"></i></button>';
         
         }else if($reg->estado_facturacion == 2){
             $estado='<button class="btn btn-success btn-xs btn-flat">Enviado</i></button>';
             $opcion='<button class="btn btn-warning btn-xs btn-flat" onclick="mostrar('.$reg->idpago.','.$reg->idtipo_documento.')" data-toggle="modal" data-target="#modal_facturacion"><i class="fa fa-eye"></i></button>';
             $sunat='<button class="btn btn-success btn-xs btn-flat" data-toggle="tooltip" title="'.$reg->sMesajeRespuesta.'"><i class="fa-solid fa-check"></i></button>';
             $baja='<button class="btn btn-danger btn-xs btn-flat" onclick="anular_documento('.$reg->idpago.')"><i class="fa-solid fa-xmark"></i> </button>';
             if($reg->codigotipo_comprobante == 1){
                $comprobante='<a target="_blank" href="'.$url_factura.$reg->idpago.'"> <button class="btn btn-danger btn-xs btn-flat"><i class="fa fa-file"></i> </button></a>';
            }else if($reg->codigotipo_comprobante == 3){
                $comprobante='<a target="_blank" href="'.$url_ticket.$reg->idpago.'"> <button class="btn btn-info btn-xs btn-flat"><i class="fa fa-file"></i> </button></a>'.
                '<a target="_blank" href="'.$url_boleta.$reg->idpago.'"> <button class="btn btn-danger btn-xs btn-flat"><i class="fa fa-file"></i> </button></a>';
            }else{
                $comprobante='-';
            }
         }else if($reg->estado_facturacion == 3){
             $estado='<button class="btn btn-dark btn-xs btn-flat"></i>Baja</button>';
             $opcion='<button class="btn btn-warning btn-xs btn-flat" onclick="mostrar('.$reg->idpago.','.$reg->idtipo_documento.')" data-toggle="modal" data-target="#modal_facturacion"><i class="fa fa-eye"></i></button>';
             $sunat='<button class="btn btn-success btn-xs btn-flat"><i class="fa-solid fa-check"></i></button>';
             $baja='<button class="btn btn-success btn-xs btn-flat" data-toggle="tooltip" title="'.$reg->sMesajeRespuesta.'"><i class="fa-solid fa-xmark"></i></button>';
         }
 
         $serie = (!empty($reg->serie)) ? $reg->serie : '-';
         $moneda='PEN';
                
         $data[]=array(
             "0"=>$reg->idfacturacion,
             "1"=>$reg->fecha_pago,
             "2"=>$tipo,
             "3"=>$serie,
             "4"=>$reg->correlativo,
             "5"=>$reg->num_documento,
             "6"=>$reg->cliente,
             "7"=>$moneda,
             "8"=>$reg->monto,
             "9"=>$estado,
             "10"=>$opcion,
             "11"=>$comprobante,
             "12"=>$sunat,
             "13"=>$baja
 
         );
         }
         $results=array(
             "isEcho"=>1,
             "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
             "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
             "aaData"=>$data);
         echo json_encode($results);
     break;

      case 'enviar_facturacion':
        $idpago=$_REQUEST["idpago"];
        $rspta=$facturacion->enviar_facturacion($idpago);
         //Codificar el resultado utilizando json
         echo $rspta;
      break;

      case 'mostrar_facturacion':
        $idpago=$_REQUEST["idpago"];
        $idtipo_documento=$_REQUEST["idtipo_documento"];
        $rspta=$facturacion->mostrar_facturacion($idpago,$idtipo_documento);
         //Codificar el resultado utilizando json
        echo json_encode($rspta);
      break;

      case 'mostrar':
        $idpago=$_REQUEST["idpago"];
        $idtipo_documento=$_REQUEST["idtipo_documento"];
        $rspta=$facturacion->mostrar($idpago,$idtipo_documento);
         //Codificar el resultado utilizando json
        echo json_encode($rspta);
      break;

      case 'anular_documento':
        $idpago=$_REQUEST["idpago"];
        $rspta=$facturacion->anular_documento($idpago);
         //Codificar el resultado utilizando json
        echo json_encode($rspta);
      break;

      case 'cantidadTotales':
        $rspta=$facturacion->cantidadTotales();
        echo json_encode($rspta);
      break;
      
      case 'procesar':
            if (isset($_POST['ids']) && is_array($_POST['ids'])) {
                $resultado = $facturacion->procesar_facturas($_POST['ids']);

                echo json_encode([
                    'status' => 'ok',
                    'message' => "Se procesaron {$resultado['procesados']} comprobante(s).",
                    'errores' => $resultado['errores']
                ]);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'No se recibieron IDs.']);
            }
        break;

}
?>