<?php
function procesarImagen($origen, $destino, $max_width, $max_height, $calidad, $extension) {
    // 🔹 Desactivar advertencias de libpng
    putenv('GD_PNG_IGNORE_WARNINGS=1');

    $infoImagen = getimagesize($origen);
    if ($infoImagen === false) {
        die("Error: No se pudo obtener información de la imagen.");
    }
    list($ancho, $alto) = $infoImagen;

    $ratio = $ancho / $alto;
    if ($max_width / $max_height > $ratio) {
        $max_width = (int) ($max_height * $ratio);
    } else {
        $max_height = (int) ($max_width / $ratio);
    }

    if ($max_width <= 0 || $max_height <= 0) {
        die("Error: Dimensiones de imagen no válidas.");
    }

    if (!function_exists('imagecreatetruecolor')) {
        die("Error: La librería GD no está habilitada.");
    }
    $nuevaImagen = imagecreatetruecolor($max_width, $max_height);
    if (!$nuevaImagen) {
        die("Error: No se pudo crear la nueva imagen.");
    }

    if ($extension == "jpg" || $extension == "jpeg") {
        $imagenOrigen = imagecreatefromjpeg($origen);
    } elseif ($extension == "png") {
        $imagenOrigen = @imagecreatefrompng($origen); // Evita mostrar warnings
        if (!$imagenOrigen) {
            die("Error: No se pudo cargar la imagen PNG.");
        }

        // 🔹 Solución adicional: Convertir a TrueColor si la imagen es indexada
        if (function_exists('imagepalettetotruecolor')) {
            imagepalettetotruecolor($imagenOrigen);
        }

        imagealphablending($nuevaImagen, false);
        imagesavealpha($nuevaImagen, true);
    } else {
        die("Error: Formato de imagen no soportado.");
    }

    if (!imagecopyresampled($nuevaImagen, $imagenOrigen, 0, 0, 0, 0, $max_width, $max_height, $ancho, $alto)) {
        die("Error: Falló la redimensión de la imagen.");
    }

    if ($extension == "jpg" || $extension == "jpeg") {
        imagejpeg($nuevaImagen, $destino, $calidad);
    } elseif ($extension == "png") {
        imagepng($nuevaImagen, $destino, 8);
    }

    imagedestroy($imagenOrigen);
    imagedestroy($nuevaImagen);
    
    return true;
}
?>