<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (strlen(session_id()) < 1) session_start();

// Verifica que la sesión esté iniciada correctamente
if (!isset($_SESSION["idusuario"])) {
    echo json_encode(["error" => "Sesión no válida o no iniciada."]);
    exit;
}
require_once('../modelos/Garantia.php');

$garantia=new Garantia();

$idgarantia=isset($_POST["idgarantia"])? limpiarCadena($_POST["idgarantia"]):"";
$idinventario_ingreso=isset($_POST["idinventario_ingreso"])? limpiarCadena($_POST["idinventario_ingreso"]):"";
$idusuario=$_SESSION["idusuario"];
$descripcion_garantia=isset($_POST["descripcion_garantia"])? limpiarCadena($_POST["descripcion_garantia"]):"";
$estado_garantia=isset($_POST["estado_garantia"])? limpiarCadena($_POST["estado_garantia"]):"";
$condicion=isset($_POST["condicion"])? limpiarCadena($_POST["condicion"]):"";
$imagen=isset($_POST["nombre_imagen"])? limpiarCadena($_POST["nombre_imagen"]):"";
$nombre_envio=isset($_POST["nombre_envio"])? limpiarCadena($_POST["nombre_envio"]):"";
$fechaenvio=isset($_POST["fechaenvio"])? limpiarCadena($_POST["fechaenvio"]):"";
$fecharetorno=isset($_POST["fecharetorno"])? limpiarCadena($_POST["fecharetorno"]):"";
$codigo_producto=isset($_POST["codigo_producto"])? limpiarCadena($_POST["codigo_producto"]):"";
$descripcion_retorno=isset($_POST["descripcion_retorno"])? limpiarCadena($_POST["descripcion_retorno"]):"";


switch ($_GET["op"])
{
    case 'guardaryeditar':
        if(empty($idgarantia))
        {
          $rspta=$garantia->insertar($idinventario_ingreso,$idusuario,$descripcion_garantia,$condicion,$codigo_producto);
          echo $rspta;
        }
        else {
            $rspta=$garantia->editar($idgarantia,$idinventario_ingreso,$idusuario,$descripcion_garantia);
            echo $rspta ? "Garantia Actualizada" : "Garantiaa no se pudo actualizar";
        }
      break;

      case 'guardarproceso':
        if (!file_exists($_FILES['nombre_imagen']['tmp_name']) || !is_uploaded_file($_FILES['nombre_imagen']['tmp_name'])) {
          // Si no se sube una nueva imagen, usa la imagen actual
          $imagen = $_POST["imagenactual"];
      } else {
          // Procesar la nueva imagen
          $ext = explode(".", $_FILES["nombre_imagen"]["name"]);
          if ($_FILES['nombre_imagen']['type'] == "image/jpg" || 
              $_FILES['nombre_imagen']['type'] == "image/jpeg" || 
              $_FILES['nombre_imagen']['type'] == "image/png") {
              
              $imagen = round(microtime(true)) . '.' . end($ext);
              // Eliminar la imagen anterior si existe y no es una nueva inserción
              if (!empty($_POST["imagenactual"]) && file_exists("../files/garantia/" . $_POST["imagenactual"])) {
                  unlink("../files/garantia/" . $_POST["imagenactual"]);
              }
              // Mover la nueva imagen a la carpeta
              move_uploaded_file($_FILES["nombre_imagen"]["tmp_name"], "../files/garantia/" . $imagen);
          }
      }
        $rspta=$garantia->guardarproceso($idgarantia,$nombre_envio,$fechaenvio,$imagen);
        echo $rspta ? "Proceso Garantia Registrado" : "Proceso Garantia  no se pudo registrar";
      break;

      case 'guardarretorno':
        if (!file_exists($_FILES['nombre_imagen']['tmp_name']) || !is_uploaded_file($_FILES['nombre_imagen']['tmp_name'])) {
          // Si no se sube una nueva imagen, usa la imagen actual
          $imagen = $_POST["imagenactual"];
      } else {
          // Procesar la nueva imagen
          $ext = explode(".", $_FILES["nombre_imagen"]["name"]);
          if ($_FILES['nombre_imagen']['type'] == "image/jpg" || 
              $_FILES['nombre_imagen']['type'] == "image/jpeg" || 
              $_FILES['nombre_imagen']['type'] == "image/png") {
              
              $imagen = round(microtime(true)) . '.' . end($ext);
              // Eliminar la imagen anterior si existe y no es una nueva inserción
              if (!empty($_POST["imagenactual"]) && file_exists("../files/garantia/" . $_POST["imagenactual"])) {
                  unlink("../files/garantia/" . $_POST["imagenactual"]);
              }
              // Mover la nueva imagen a la carpeta
              move_uploaded_file($_FILES["nombre_imagen"]["tmp_name"], "../files/garantia/" . $imagen);
          }
      }
        $rspta=$garantia->guardarretorno($idgarantia,$fecharetorno,$imagen,$estado_garantia,$descripcion_retorno);
        echo $rspta ? "Retorno Garantia Registrado" : "Retorno Garantia  no se pudo registrar";
      break;
  
      case 'mostrar':
        $rspta=$garantia->mostrar($idgarantia);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;
  
      case 'eliminar':
        $rspta=$garantia->eliminar($idgarantia);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;

      case 'listar_garantia':
        $codigo_producto=$_REQUEST["codigo_producto"];
        $rspta=$garantia->listar_garantia($codigo_producto);
         //Codificar el resultado utilizando json
        echo json_encode($rspta);
      break;
  
      case 'listar':
        $rspta=$garantia->listar();
        //Vamos a declarar un array
        $data=Array();
        while($reg=$rspta->fetch_object())
        {
           if($reg->estado_garantia == 1){
            $estado='<button class="btn btn-success btn-xs btn-flat" onclick="mostrar_proceso('.$reg->idgarantia.')" data-toggle="modal" data-target="#modal_proceso"></i>Proceso Garantia</button>';
           }else if($reg->estado_garantia == 2){
              $estado='<button class="btn btn-warning btn-xs btn-flat" onclick="mostrar_proceso('.$reg->idgarantia.')" data-toggle="modal" data-target="#modal_retorno"></i>Enviado para Garantia</button>';
            }else if($reg->estado_garantia == 3){
              $estado='<button class="btn btn-primary btn-xs btn-flat"></i>Procedio Garantia</button>';
            }else if($reg->estado_garantia == 4){
              $estado='<button class="btn btn-danger btn-xs btn-flat"></i>No procedio Garantia</button>';
            }
          $data[]=array(
            "0"=>$reg->fechaenvio,
            "1"=>$reg->fecharetorno,
            "2"=>$reg->proveedor,
            "3"=>$reg->producto,
            "4"=>$reg->nrofactura, 
            "5"=>$reg->mac, 
            "6"=>$reg->codigo, 
            "7"=>$reg->garantia, 
            "8"=>$estado,          
            "9"=>'<a href="edit.php?idgarantia=' . $reg->idgarantia . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-edit"></i></a>' .
                 ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idgarantia . ')"><i class="fas fa-trash-alt"></i></button>'
          );
        }
        $results= array(
          "sEcho"=>1, //Informacion para el datatable
          "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
          "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
          "aaData"=>$data);
        echo json_encode($results);
  
      break;

    
}