<?php 
require_once('../modelos/Icono.php');
include_once 'funciones.php';

$icono =new Icono();

$idicono=isset($_POST["idicono"])? limpiarCadena($_POST["idicono"]):"";
$nombre=isset($_POST["nombre"])? limpiarCadena($_POST["nombre"]):"";
$descripcion=isset($_POST["descripcion"])? limpiarCadena($_POST["descripcion"]):"";

switch ($_GET["op"])
{
    case 'guardaryeditar':
          $imagen = '';
          $max_width = 800;
          $max_height = 600;
          $calidad = 80;
          $formatos_permitidos = ['image/jpeg', 'image/jpg', 'image/png'];
          // Validación de imagen (para insertar y editar)
          if (!isset($_FILES['nombre_imagen']) || $_FILES['nombre_imagen']['error'] !== UPLOAD_ERR_OK) {
              // Si no se sube imagen nueva, se usa la anterior
              $imagen = $_POST["imagenactual"] ?? '';
          } else {
              $infoImagen = getimagesize($_FILES['nombre_imagen']['tmp_name']);

              if (!$infoImagen || !in_array($infoImagen['mime'], $formatos_permitidos)) {
                  echo json_encode(["status" => "error", "message" => "Formato de imagen no permitido. Solo JPG o PNG."]);
                  exit;
              }
              $ext = image_type_to_extension($infoImagen[2], false); // ej. 'jpg'
              $nuevoNombre = round(microtime(true)) . "." . $ext;
              $rutaDestino = "../files/icono/" . $nuevoNombre;

              // Procesar y redimensionar imagen
              if (!procesarImagen($_FILES['nombre_imagen']['tmp_name'], $rutaDestino, $max_width, $max_height, $calidad, $ext)) {
                  echo json_encode(["status" => "error", "message" => "Error al procesar la imagen."]);
                  exit;
              }
              $imagen = $nuevoNombre;
          }
      // Insertar o editar
          if (empty($idicono)) {
              $rspta = $icono->insertar($nombre, $descripcion, $imagen);
              $mensaje = "Icono Registrado";
          } else {
              $rspta = $icono->editar($idicono, $nombre, $descripcion, $imagen);
              $mensaje = "Icono Actualizada";
          }
          // Respuesta
          if ($rspta) {
              echo json_encode(["status" => "success", "message" => $mensaje]);
          } else {
              echo json_encode(["status" => "error", "message" => "Error al guardar los datos"]);
          }
    break;

    case 'mostrar':
      $rspta=$icono->mostrar($idicono);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'eliminar':
      $rspta=$icono->eliminar($idicono);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'listaricono':
      $rspta=$icono->listaricono();
      //Vamos a declarar un array
      $data=Array();
      while($reg=$rspta->fetch_object())
      {
        
        $data[]=array(
          "0"=>$reg->nombre,
          "1"=>"<img src='../../files/icono/".$reg->imagen."' height='50px' width='50px' >",
          "2"=>$reg->descripcion,
          "3"=>'<a href="create_icono.php?idicono=' . $reg->idicono . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-edit"></i></a>' .
               ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idicono . ')"><i class="fas fa-trash-alt"></i></button>'
        );
      }
      $results= array(
        "sEcho"=>1, //Informacion para el datatable
        "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
        "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);

    break;

    case 'selectIcono': 
        $rspta = $icono->selectIcono();
        if ($rspta) {
            while ($reg = $rspta->fetch_object()) {
                echo "<option value='" . htmlspecialchars($reg->idicono, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
            }
        } else {
            echo "<option value=''>No hay olt disponibles</option>";
        }
        break;

}
?>