<?php 
require_once('../modelos/Servicio.php');

$servicio=new Servicio();

$idservicio=isset($_POST["idservicio"])? limpiarCadena($_POST["idservicio"]):"";
$codigo=isset($_POST["codigo"])? limpiarCadena($_POST["codigo"]):"";
$nombre=isset($_POST["nombre"])? limpiarCadena($_POST["nombre"]):"";
$descripcion=isset($_POST["descripcion"])? limpiarCadena($_POST["descripcion"]):"";
$estado=isset($_POST["estado"])? limpiarCadena($_POST["estado"]):"";

switch ($_GET["op"])
{
    case 'guardaryeditar':
      if(empty($idservicio))
      {
        $rspta=$servicio->insertar($codigo,$nombre,$descripcion,$estado);
        echo $rspta ? "Servicio Registrado" : "Servicio no se pudo registrar";
      }
      else {
          $rspta=$servicio->editar($idservicio,$codigo,$nombre,$descripcion,$estado);
          echo $rspta ? "Servicio Actualizada" : "Servicio no se pudo actualizar";
      }
    break;

    case 'mostrar':
      $rspta=$servicio->mostrar($idservicio);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'eliminar':
      $rspta=$servicio->eliminar($idservicio);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'listarservicio':
      $rspta=$servicio->listarservicio();
      //Vamos a declarar un array
      $data=Array();
      while($reg=$rspta->fetch_object())
      {
        $estado = ($reg->estado == 1) 
            ? '<button class="btn btn-success btn-xs btn-flat">Activa</button>' 
            : '<button class="btn btn-danger btn-xs btn-flat">Inactiva</button>';
        $data[]=array(
          "0"=>$reg->codigo,
          "1"=>$reg->nombre,
          "2"=>$reg->descripcion,
          "3"=>$estado,          
          "4"=>'<a href="create.php?idservicio=' . $reg->idservicio . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-edit"></i></a>' .
               ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idservicio . ')"><i class="fas fa-trash-alt"></i></button>'
        );
      }
      $results= array(
        "sEcho"=>1, //Informacion para el datatable
        "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
        "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);

    break;

    case 'selectServicio': 
      $rspta = $servicio->selectServicio();
      if ($rspta) {
          while ($reg = $rspta->fetch_object()) {
              echo "<option value='" . htmlspecialchars($reg->idservicio, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
          }
      } else {
          echo "<option value=''>No hay servicios disponibles</option>";
      }
      break;
}

?>