<?php
session_start();
require_once "../modelos/Usuario.php";

$usuario=new Usuario();
$idusuario=isset($_POST["idusuario"])? limpiarCadena($_POST["idusuario"]):"";
$nombre=isset($_POST["nombre"])? limpiarCadena($_POST["nombre"]):"";
$idtipo_documento=isset($_POST["idtipo_documento"])? limpiarCadena($_POST["idtipo_documento"]):"";
$num_documento=isset($_POST["num_documento"])? limpiarCadena($_POST["num_documento"]):"";
$direccion=isset($_POST["direccion"])? limpiarCadena($_POST["direccion"]):"";
$telefono=isset($_POST["telefono"])? limpiarCadena($_POST["telefono"]):"";
$email=isset($_POST["email"])? limpiarCadena($_POST["email"]):"";
$cargo=isset($_POST["cargo"])? limpiarCadena($_POST["cargo"]):"";
$login=isset($_POST["login"])? limpiarCadena($_POST["login"]):"";
$clave=isset($_POST["clave"])? limpiarCadena($_POST["clave"]):"";
$imagen=isset($_POST["imagen"])? limpiarCadena($_POST["imagen"]):"";
$condicion=isset($_POST["condicion"])? limpiarCadena($_POST["condicion"]):"";


switch ($_GET["op"]){

    case 'guardaryeditar':

        if (!file_exists($_FILES['imagen']['tmp_name']) || !is_uploaded_file($_FILES['imagen']['tmp_name']))
		{
			$imagen=$_POST["imagenactual"];
		}
		else
		{
			$ext = explode(".", $_FILES["imagen"]["name"]);
			if ($_FILES['imagen']['type'] == "image/jpg" || $_FILES['imagen']['type'] == "image/jpeg" || $_FILES['imagen']['type'] == "image/png")
			{
				$imagen = round(microtime(true)) . '.' . end($ext);
				move_uploaded_file($_FILES["imagen"]["tmp_name"], "../files/usuarios/" . $imagen);
			}
		}
        //HASH SHA256
		$clavehash=hash("SHA256",$clave);
        if(empty($idusuario))
        {
          $rspta=$usuario->insertar($nombre,$idtipo_documento,$num_documento,$direccion,$telefono,$email,$cargo,$login,$clavehash,$imagen,$condicion,$_POST['permiso']);
          echo $rspta ? "Usuario Registrado" : "Usuario no se pudo registrar";
        }
        else {
            $rspta=$usuario->editar($idusuario,$nombre,$idtipo_documento,$num_documento,$direccion,$telefono,$email,$cargo,$login,$clavehash,$imagen,$condicion,$_POST['permiso']);
            echo $rspta ? "Usuario Actualizada" : "Usuario no se pudo actualizar";
        }
      break;

      case 'mostrar':
        $rspta=$usuario->mostrar($idusuario);
         //Codificar el resultado utilizando json
         echo json_encode($rspta);
      break;

      case 'listarusuario':
		$rspta=$usuario->listarusuario();
 		//Vamos a declarar un array
 		$data= Array();
 		while ($reg=$rspta->fetch_object()){
            $condicion = ($reg->condicion == 1) 
            ? '<button class="btn btn-success btn-xs btn-flat">Activo</button>' 
            : '<button class="btn btn-danger btn-xs btn-flat">Inactivo</button>';
 			$data[]=array(
 				"0"=>$reg->nombre,
				"1"=>$reg->documento,
				"2"=>$reg->num_documento,
				"3"=>$reg->telefono,
				"4"=>$reg->nombrecargo,
				"5"=>$reg->login,
 				"6"=>"<img src='../../files/usuarios/".$reg->imagen."' height='50px' width='50px' >",
                "7"=>$condicion,
 				"8"=>'<a href="create.php?idusuario=' . $reg->idusuario . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-edit"></i></a>' .             
                    ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idusuario. ')"><i class="fas fa-trash-alt"></i></button>'
 				);
 		}
 		$results = array(
 			"sEcho"=>1, //Información para el datatables
 			"iTotalRecords"=>count($data), //enviamos el total registros al datatable
 			"iTotalDisplayRecords"=>count($data), //enviamos el total registros a visualizar
 			"aaData"=>$data);
 		echo json_encode($results);

	break;

    case 'listarpermiso':
		$rspta=$usuario->listarpermiso();
 		//Vamos a declarar un array
 		$data= Array();
 		while ($reg=$rspta->fetch_object()){
 			$data[]=array(
 				"0"=>$reg->idpermiso,
				"1"=>$reg->nombre
 				);
 		}
 		$results = array(
 			"sEcho"=>1, //Información para el datatables
 			"iTotalRecords"=>count($data), //enviamos el total registros al datatable
 			"iTotalDisplayRecords"=>count($data), //enviamos el total registros a visualizar
 			"aaData"=>$data);
 		echo json_encode($results);

	break;


    case 'permisos':
        require_once "../modelos/Permiso.php";
        $permiso=new Permiso();
        $rspta=$permiso->listar();
    
        //Obtener los permisos asignados al usuarios
        $id=$_GET['id'];
        $marcados=$usuario->listarmarcados($id);
        //DEcalaramos el array para alamacenar todos los permisos marcados
        $valores=array();
    
        //Almacenar los permisos asignados al usuario en el Array
        while($per=$marcados->fetch_object())
        {
            array_push($valores,$per->idpermiso);
        }
    
        //MOstramos la lsita de permisos en la vista y si están o no marcados
        while($reg=$rspta->fetch_object())
        {
            $sw=in_array($reg->idpermiso,$valores)?'checked':'';
            echo '<li><input type="checkbox" '.$sw.' name="permiso[]" value="'.$reg->idpermiso.'">'.$reg->nombre.'</li>';
        }
    
    
        break;

    case 'verificar':
        $logina=$_POST['logina'];
        $clavea=$_POST['clavea'];

        //hash sha256 en la contraseña
        $clavehash=hash("SHA256",$clavea);
        $rspta=$usuario->verificar($logina,$clavehash);
        $fetch=$rspta->fetch_object();

        if(isset($fetch))
        {
            //declaramos las variables de session
            $_SESSION['idusuario']=$fetch->idusuario;
            $_SESSION['nombre']=$fetch->nombre;
            $_SESSION['imagen']=$fetch->imagen;
            $_SESSION['login']=$fetch->login;
            $_SESSION['nombrecargo']=$fetch->nombrecargo;
            $_SESSION['estadocaja']=$fetch->estadocaja;
            $_SESSION['idcaja']=$fetch->idcaja;
            $_SESSION['idalmacen']=$fetch->idalmacen;

            //obtenemos los permisos del usuarios

            $marcados=$usuario->listarmarcados($fetch->idusuario);
            //declaramos el array para almacenar todos los permisos $marcados
            $valores=array();

            //almacenamos los permisos marcados en el array
            while($per=$marcados->fetch_object())
            {
                array_push($valores,$per->idpermiso);
            }
            //determinamos los accesos del usuarios
            in_array(1,$valores) ? $_SESSION['escritorio']=1 : $_SESSION['escritorio']=0;
            in_array(2,$valores) ? $_SESSION['almacen']=1 : $_SESSION['almacen']=0;
            in_array(3,$valores) ? $_SESSION['compras']=1 : $_SESSION['compras']=0;
            in_array(4,$valores) ? $_SESSION['ventas']=1 : $_SESSION['ventas']=0;
            in_array(5,$valores) ? $_SESSION['acceso']=1 : $_SESSION['acceso']=0;
            in_array(6,$valores) ? $_SESSION['consultac']=1 : $_SESSION['consultac']=0;
            in_array(7,$valores) ? $_SESSION['consultav']=1 : $_SESSION['consultav']=0;
            in_array(8,$valores) ? $_SESSION['confidencial']=1 : $_SESSION['confidencial']=0;
            in_array(9,$valores) ? $_SESSION['despacho']=1 : $_SESSION['despacho']=0;
            in_array(10,$valores) ? $_SESSION['averia']=1 : $_SESSION['averia']=0;
            in_array(11,$valores) ? $_SESSION['pago']=1 : $_SESSION['pago']=0;
            in_array(12,$valores) ? $_SESSION['adicional']=1 : $_SESSION['adicional']=0;
            in_array(13,$valores) ? $_SESSION['registro']=1 : $_SESSION['registro']=0;
            in_array(14,$valores) ? $_SESSION['ingreso']=1 : $_SESSION['ingreso']=0;
            in_array(15,$valores) ? $_SESSION['cliente']=1 : $_SESSION['cliente']=0;
            in_array(16,$valores) ? $_SESSION['torre']=1 : $_SESSION['torre']=0;
            in_array(17,$valores) ? $_SESSION['mikrotik']=1 : $_SESSION['mikrotik']=0;
            in_array(18,$valores) ? $_SESSION['movimiento']=1 : $_SESSION['movimiento']=0;
            in_array(19,$valores) ? $_SESSION['finanzas']=1 : $_SESSION['finanzas']=0;
            in_array(20,$valores) ? $_SESSION['contratos']=1 : $_SESSION['contratos']=0;
            in_array(21,$valores) ? $_SESSION['facturacion']=1 : $_SESSION['facturacion']=0;
            in_array(22,$valores) ? $_SESSION['cobertura']=1 : $_SESSION['cobertura']=0;
        }

        echo json_encode($fetch);

break;

case 'salir':
	//limpiamos las variables de session
	session_unset();
	//destruimos la sesion
	session_destroy();
	//redireccionamos al login
	header("Location: ../login/login.php");

	break;

    case 'selectCargo': 
        $rspta = $usuario->selectCargo();
        if ($rspta) {
            while ($reg = $rspta->fetch_object()) {
                echo "<option value='" . htmlspecialchars($reg->idcargo, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
            }
        } else {
            echo "<option value=''>No hay cargos disponibles</option>";
        }
        break;

    case 'selectTecnico': 
        $rspta = $usuario->selectTecnico();
        if ($rspta) {
            while ($reg = $rspta->fetch_object()) {
                echo "<option value='" . htmlspecialchars($reg->idusuario, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
            }
        } else {
            echo "<option value=''>No hay tecnico disponibles</option>";
        }
        break;

        case 'selectUsuario': 
            $rspta = $usuario->selectUsuario();
            if ($rspta) {
                while ($reg = $rspta->fetch_object()) {
                    echo "<option value='" . htmlspecialchars($reg->idusuario, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
                }
            } else {
                echo "<option value=''>No hay usuario disponibles</option>";
            }
            break;

            case 'selectUsuarioCuadrilla': 
                $rspta = $usuario->selectUsuarioCuadrilla();
                if ($rspta) {
                    while ($reg = $rspta->fetch_object()) {
                        echo "<option value='" . htmlspecialchars($reg->idusuario, ENT_QUOTES, 'UTF-8') . "'>" . htmlspecialchars($reg->nombre, ENT_QUOTES, 'UTF-8') . "</option>";
                    }
                } else {
                    echo "<option value=''>No hay usuario disponibles</option>";
                }
                break;

            

}


?>