<?php 
if(strlen(session_id()) < 1)
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
if (strlen(session_id()) < 1) session_start();

// Verifica que la sesión esté iniciada correctamente
if (!isset($_SESSION["idusuario"])) {
    echo json_encode(["error" => "Sesión no válida o no iniciada."]);
    exit;
}
require_once('../modelos/Venta.php');

$venta=new Venta();

$idventa=isset($_POST["idventa"])? limpiarCadena($_POST["idventa"]):"";
$idusuario=$_SESSION["idusuario"];
$idalmacen=$_SESSION["idalmacen"];
$idcaja=$_SESSION["idcaja"];
$fecha_hora=isset($_POST["fecha_hora"])? limpiarCadena($_POST["fecha_hora"]):"";
$nrocorrelativo=isset($_POST["nrocorrelativo"])? limpiarCadena($_POST["nrocorrelativo"]):"";
$tipo_comprobante=isset($_POST["tipo_comprobante"])? limpiarCadena($_POST["tipo_comprobante"]):"";
$idpersona=isset($_POST["idpersona"])? limpiarCadena($_POST["idpersona"]):"";
$total_venta=isset($_POST["total_venta"])? limpiarCadena($_POST["total_venta"]):"";
$total_igv=isset($_POST["total_igv"])? limpiarCadena($_POST["total_igv"]):"";
$subtotal_total=isset($_POST["subtotal_total"])? limpiarCadena($_POST["subtotal_total"]):"";
$tipoventa=isset($_POST["tipoventa"])? limpiarCadena($_POST["tipoventa"]):"";
$tipopago=isset($_POST["tipopago"])? limpiarCadena($_POST["tipopago"]):"";
$idbanco=isset($_POST["idbanco"])? limpiarCadena($_POST["idbanco"]):"";
$nroperacion=isset($_POST["nroperacion"])? limpiarCadena($_POST["nroperacion"]):"";

switch ($_GET["op"])
{
    case 'guardaryeditar':
        require_once "../reportes/numeroALetras.php";
        $letras = NumeroALetras::convertir($total_venta);
        list($num,$cen)=explode('.',$total_venta);
        $leyenda = $letras.'Y '.$cen.'/100 SOLES';
         if(empty($idventa))
      {
        $rspta=$venta->insertar($idpersona,$idusuario,$idalmacen,$idcaja,$nrocorrelativo,$fecha_hora,$tipo_comprobante,$total_venta,$total_igv,$subtotal_total,$tipopago,$idbanco,$leyenda,$nroperacion,$_POST["idarticulo"],$_POST["cantidad"],$_POST["precio_compra"],$_POST["precio_venta"],$_POST["idinventario_ingreso"]);
        echo $rspta ? "Venta Registrado" : "Venta no se pudo registrar";
      }
      else {
          //$rspta=$venta->editar($idingreso,$idproveedor,$tipo_comprobante,$serie_comprobante,$numero_comprobante,$fecha_hora);
          //echo $rspta ? "Compra Actualizada" : "Compra no se pudo actualizar";
      }
    break;

    case 'mostrar':
        $rspta = $venta->mostrar($idventa);
        echo json_encode($rspta);
    break;


    case 'eliminar':
      $rspta=$venta->eliminar($idventa);
       //Codificar el resultado utilizando json
       echo json_encode($rspta);
    break;

    case 'listar':
      $rspta=$venta->listar();
      //Vamos a declarar un array
      $data=Array();
      while($reg=$rspta->fetch_object())
      {
          $estado = ($reg->estado_venta == 1) 
          ? '<button class="btn btn-success btn-xs btn-flat">Registrado</button>' 
          : '<button class="btn btn-danger btn-xs btn-flat">Eliminado</button>';

          $url='../venta/ticket_boleta.php?id=';
          if($reg->tipo_pago == '2'){
          $pago ='<button class="btn btn-success btn-xs btn-flat"> Efectivo </button>';
          }else{
            $pago ='<button class="btn btn-danger btn-xs btn-flat"> Deposito </button>';
          }

        $data[]=array(
            "0"=>$reg->fecha_hora,
            "1"=>$reg->usuario,
            "2"=>$reg->cliente,
            "3"=>$reg->codigotipo_comprobante,
            "4"=>$reg->nrocorrelativo,
            "5"=>number_format($reg->total_venta,2),
            "6"=>$pago,
            "7"=>$estado,
            "8"=>'<a href="create.php?idventa=' . $reg->idventa . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-eye"></i></a>'.
                  '<a target="_blank" href="'.$url.$reg->idventa.'"> <button class="btn btn-info btn-xs btn-flat"><i class="fa fa-file"></i> </button></a>'.
                  ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idventa . ')"><i class="fas fa-trash-alt"></i></button>'
        );
      }
      $results= array(
        "sEcho"=>1, //Informacion para el datatable
        "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
        "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);

    break;

    case 'listar_usuario':
      $rspta=$venta->listar_usuario($idusuario);
      //Vamos a declarar un array
      $data=Array();
      while($reg=$rspta->fetch_object())
      {
          $estado = ($reg->estado_venta == 1) 
          ? '<button class="btn btn-success btn-xs btn-flat">Registrado</button>' 
          : '<button class="btn btn-danger btn-xs btn-flat">Eliminado</button>';

          $url='../venta/boleta.php?id=';
          if($reg->tipo_pago == '2'){
          $pago ='<button class="btn btn-success btn-xs btn-flat"> Efectivo </button>';
          }else{
            $pago ='<button class="btn btn-danger btn-xs btn-flat"> Deposito </button>';
          }

        $data[]=array(
            "0"=>$reg->fecha_hora,
            "1"=>$reg->usuario,
            "2"=>$reg->cliente,
            "3"=>$reg->codigotipo_comprobante,
            "4"=>$reg->nrocorrelativo,
            "5"=>number_format($reg->total_venta,2),
            "6"=>$pago,
            "7"=>$estado,
            "8"=>'<a href="create.php?idventa=' . $reg->idventa . '" class="btn btn-warning btn-xs btn-flat"><i class="fa fa-eye"></i></a>'.
                  '<a target="_blank" href="'.$url.$reg->idventa.'"> <button class="btn btn-info btn-xs btn-flat"><i class="fa fa-file"></i> </button></a>'.
                  ' <button class="btn btn-danger btn-xs btn-flat" onclick="eliminar(' . $reg->idventa . ')"><i class="fas fa-trash-alt"></i></button>'
        );
      }
      $results= array(
        "sEcho"=>1, //Informacion para el datatable
        "iTotalRecords"=>count($data),//Enviamos el total de registtros en el datatable
        "iTotalDisplayRecords"=>count($data),//enviamos el total de registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);

    break;


    case 'listarproducto':
      $rspta=$venta->listarproducto($idalmacen);
      $data= Array();
      while ($reg=$rspta->fetch_object()){
      if($reg->estadomaterial==1){

        $mat='<button class="btn btn-success btn-xs btn-flat">Nuevo</button>';
        }else if($reg->estadomaterial==2){
        $mat='<button class="btn btn-danger btn-xs btn-flat">Usado</button>';
        }else if($reg->estadomaterial==3){
        $mat='<button class="btn btn-primary btn-xs btn-flat">Reparado</button>';
        }else if($reg->estadomaterial==4){
        $mat='<button class="btn btn-danger btn-xs btn-flat">Malogrado</button>';
        }
        $st='<button class="btn btn-success btn-xs btn-flat">'.$reg->stock.'</button>';
        $data[]=array(
          "0"=>$reg->nombre,
          "1"=>$reg->codigo,
          "2"=>$reg->marca,        
          "3"=>$reg->mac,
          "4"=>$reg->serie,
          "5"=>number_format($reg->precio_compra,2),
          "6"=>number_format($reg->precio_venta,2),
          "7"=>$mat,
          "8"=>$st,
          "9"=>'<button class="btn btn-warning btn-xs btn-flat" onclick="agregarDetalle('.$reg->idarticulo.',\''.$reg->nombre.'\',\''.$reg->marca.'\',\''.$reg->mac.'\',\''.$reg->serie.'\','.$reg->precio_compra.',\''.$reg->codigo.'\','.$reg->precio_venta.','. $reg->idinventario_ingreso .',' . $reg->idalmacen . ','.$reg->stock.', this)" data-id="'.$reg->idarticulo.'"><span class="fa fa-plus"></span></button>'
          
          // "6"=>"<img src='../files/articulos/".$reg->imagen."' height='50px' width='50px' >"
          );
      }
      $results = array(
        "sEcho"=>1, //Información para el datatables
        "iTotalRecords"=>count($data), //enviamos el total registros al datatable
        "iTotalDisplayRecords"=>count($data), //enviamos el total registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);
     break;

     case 'listarbuscar':
      $rspta=$venta->listarbuscar();
      $data= Array();
      while ($reg=$rspta->fetch_object()){
      if($reg->estadomaterial==1){

        $mat='<button class="btn btn-success btn-xs btn-flat">Nuevo</button>';
        }else if($reg->estadomaterial==2){
        $mat='<button class="btn btn-danger btn-xs btn-flat">Usado</button>';
        }else if($reg->estadomaterial==3){
        $mat='<button class="btn btn-primary btn-xs btn-flat">Reparado</button>';
        }else if($reg->estadomaterial==4){
        $mat='<button class="btn btn-danger btn-xs btn-flat">Malogrado</button>';
        }
        $st='<button class="btn btn-success btn-xs btn-flat">'.$reg->stock.'</button>';
        $data[]=array(
          "0"=>$reg->almacen,
          "1"=>$reg->nombre,
          "2"=>$reg->codigo,
          "3"=>$reg->marca,        
          "4"=>$reg->mac,
          "5"=>$reg->serie,
          "6"=>number_format($reg->precio_compra,2),
          "7"=>number_format($reg->precio_venta,2),
          "8"=>$mat,
          "9"=>$st
          );
      }
      $results = array(
        "sEcho"=>1, //Información para el datatables
        "iTotalRecords"=>count($data), //enviamos el total registros al datatable
        "iTotalDisplayRecords"=>count($data), //enviamos el total registros a visualizar
        "aaData"=>$data);
      echo json_encode($results);
     break;

    

    
}
?>