<?php
header('Content-Type: application/json');
require_once('../config/Conexion.php');

$fecha_inicio = "2025/05/01";
$fecha_fin = "2025/05/16";

$sql = "SELECT c.idcontrato, p.nombre as cliente, o.paga,p.celular,p.telefono,p.whatsapp
        FROM cuota c 
        JOIN contrato o ON c.idcontrato=o.idcontrato
        JOIN persona p ON o.idcliente=p.idpersona
        WHERE date(c.fecha_pago) BETWEEN '$fecha_inicio' and '$fecha_fin' 
        AND c.estado_contrato='1' AND c.estado_cuota='1' AND o.sit_contrato!='baja' 
        GROUP BY o.idcontrato 
        ORDER BY c.idcuota DESC";

$resultCabecera = ejecutarConsulta($sql);

$data = [];

while ($row = $resultCabecera->fetch_assoc()) {
    $idcontrato = $row['idcontrato'];

    // Consulta de detalles
    $sqldetalle = "SELECT month(c.fechainicial) as mes, c.fechainicial, c.fechavencimiento, c.fecha_pago, c.monto, o.sit_contrato, c.idcontrato
                   FROM cuota c 
                   JOIN contrato o ON c.idcontrato=o.idcontrato
                   WHERE date(c.fecha_pago) BETWEEN '$fecha_inicio' and '$fecha_fin' 
                   AND c.idcontrato='$idcontrato' AND c.estado_contrato='1' AND c.estado_cuota='1'";

    $resultDetalles = ejecutarConsulta($sqldetalle);
    $detallesContrato = [];

    while ($detalle = $resultDetalles->fetch_assoc()) {
        // Obtener cantidad de movimientos
        $sqlmovimiento = "SELECT count(idmovimiento_llamada) as cantidad 
                          FROM movimiento_llamada 
                          WHERE idcontrato = '$idcontrato' AND tipo = '4' 
                          GROUP BY idcontrato";

        $resultMovimiento = ejecutarConsulta($sqlmovimiento);
        $cantidad = 0;

        if ($rowMovimiento = $resultMovimiento->fetch_assoc()) {
            $cantidad = $rowMovimiento['cantidad'];
        }

        $detalle['cantidad_movimientos'] = $cantidad;
        $detallesContrato[] = $detalle;
    }

    // Agregar detalles dentro de la cabecera
    $row['detalles'] = $detallesContrato;

    // Añadir al array principal
    $data[] = $row;
}

// Devolver la estructura con cabecera + detalles integrados
echo json_encode($data);