document.addEventListener('DOMContentLoaded', function (e) {
    const fv = FormValidation.formValidation(document.getElementById('frmAcceso'), {
            locale: 'es_ES',
            localization: FormValidation.locales.es_ES,
            plugins: {
                trigger: new FormValidation.plugins.Trigger(),
                submitButton: new FormValidation.plugins.SubmitButton(),
                bootstrap: new FormValidation.plugins.Bootstrap(),
                icon: new FormValidation.plugins.Icon({
                    valid: 'fa fa-check',
                    invalid: 'fa fa-times',
                    validating: 'fa fa-refresh',
                }),
            },
            fields: {
                username: {
                    validators: {
                        notEmpty: {},
                        stringLength: {
                            min: 2
                        }
                    }
                },
                password: {
                    validators: {
                        notEmpty: {},
                        stringLength: {
                            min: 2
                        }
                    }
                }
            },
        }
    )
        .on('core.element.validated', function (e) {
            if (e.valid) {
                const groupEle = FormValidation.utils.closest(e.element, '.form-group');
                if (groupEle) {
                    FormValidation.utils.classSet(groupEle, {
                        'has-success': false,
                    });
                }
                FormValidation.utils.classSet(e.element, {
                    'is-valid': false,
                });
            }
            const iconPlugin = fv.getPlugin('icon');
            const iconElement = iconPlugin && iconPlugin.icons.has(e.element) ? iconPlugin.icons.get(e.element) : null;
            iconElement && (iconElement.style.display = 'none');
        })
        .on('core.validator.validated', function (e) {
            if (!e.result.valid) {
                const messages = [].slice.call(fv.form.querySelectorAll('[data-field="' + e.field + '"][data-validator]'));
                messages.forEach((messageEle) => {
                    const validator = messageEle.getAttribute('data-validator');
                    messageEle.style.display = validator === e.validator ? 'block' : 'none';
                });
            }
        })
        .on('core.form.valid', function () {
            const logina = document.getElementById('username').value;
            const clavea = document.getElementById('password').value;

            $.post("../ajax/usuario.php?op=verificar", { "logina": logina, "clavea": clavea }, function (data) {
                if (data != "null") {
                    // Mostrar alerta de éxito
                    Swal.fire({
                        position: 'center',
                        title: "¡Bienvenido!",
                        text: "Credenciales correctas. Redirigiendo al panel..",
                        icon: "success",
                        timer: 2000,
                        timerProgressBar: true,
                        allowOutsideClick: false, // Desactiva interacciones externas
                        backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                        customClass: {
                            popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
                        },
                        didOpen: () => {
                            Swal.showLoading();
                        },
                        willClose: () => {
                            $(location).attr("href", "../views/index.php");
                        }
                    });
                } else {
                    // Mostrar alerta con temporizador en caso de error
                    let timerInterval;
                    Swal.fire({
                        position: 'center',
                        title: "Error",
                        html: "Usuario y/o contraseña incorrectos.<br>Cerrando en <b></b> ms.",
                        icon: "error",
                        timer: 2000,
                        timerProgressBar: true,
                        allowOutsideClick: false, // Desactiva interacciones externas
                        backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                        customClass: {
                            popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
                        },
                        didOpen: () => {
                            Swal.showLoading();
                            const timer = Swal.getPopup().querySelector("b");
                            timerInterval = setInterval(() => {
                                timer.textContent = `${Swal.getTimerLeft()}`;
                            }, 100);
                        },
                        willClose: () => {
                            clearInterval(timerInterval);
                        }
                    });
                }
            });
        });

    // Prevenimos el desplazamiento hacia arriba al mostrar alertas o validar
    $('#frmAcceso').on('submit', function (e) {
        e.preventDefault();
        e.stopPropagation(); // Previene el comportamiento por defecto
    });
});



$(function () {

    $('.btnShowPassword').on('click', function () {
        var i = $(this).find('i');
        var input = $(this).parent().parent().find('input');
        if (i.hasClass('fa fa-eye-slash')) {
            i.removeClass();
            i.addClass('fa fa-eye');
            input.attr('type', 'password');
        } else {
            i.removeClass();
            i.addClass('fa fa-eye-slash');
            input.attr('type', 'text');
        }
    });

    $('i[data-field="password"]').hide();
});
