<?php
//Incluimos conexion a la base de trader_cdlrisefall3methods
date_default_timezone_set('America/Lima');
require "../config/Conexion.php";

Class Averia
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }
      public function insertar($idusuario,$idpersona,$idcontrato,$fecha_hora,$direccion,$referencia,$distrito,$celular1,$celular2,$detalle,$observacion,$idcategoria_ingreso,$idconcepto_ingreso,$prioridad,$idtecnico,$estado,$title1,$color1,$start1,$end1,$iddireccion,$idtecnologia,$idincidencia,$latitud,$longitud) {

      $fecha_dia = date("d");
      $fecha_año = date("Y");
      $fecha_mes = date("m");
      $variable = $fecha_dia.$fecha_mes.$fecha_año;

      $contador="SELECT count(nroservicio)+1 as contador FROM orden";
      $result= ejecutarConsultaSimpleFila($contador);
      $con= $result['contador'];

      $correlativo = $variable."-"."00".$con;

      $insercorrelativo="INSERT INTO orden (nroservicio) VALUES('$correlativo')";
        ejecutarConsulta($insercorrelativo);

      $sql = "INSERT INTO averia (idcontrato,idcliente,idusuario,direccion,referencia,distrito,celular1,celular2,detalle_problema,observaciones,idcategoria,idtrabajo,prioridad,idtecnico,estado_averia,nroservicio,tecnologia,iddireccion,fecha_hora,fecha_programacion,idincidencia,latitud,longitud) 
                VALUES ('$idcontrato', '$idpersona', '$idusuario', '$direccion', '$referencia', '$distrito' ,'$celular1' ,'$celular2' ,'$detalle' ,'$observacion', '$idcategoria_ingreso' ,'$idconcepto_ingreso' ,'$prioridad', '$idtecnico','$estado','$correlativo','$idtecnologia','$iddireccion','$fecha_hora','$start1','$idincidencia','$latitud','$longitud')";
      $idnroaveria = ejecutarConsulta_retornarID($sql);

      $sqlupdate="UPDATE persona set celular='$celular1',whatsapp='$celular2' where idpersona='$idpersona'  ";
       ejecutarConsulta($sqlupdate);

       $sqlupdate_direccion="UPDATE detalle_direccion set description='$referencia',address='$direccion',fiscal='$direccion',distrito='$distrito' where iddireccion='$iddireccion'  ";
       ejecutarConsulta($sqlupdate_direccion);

      $sqlagenda="INSERT INTO agenda(title,color,start,end,idtecnico,idcontrato,idusuario,idaveria,estado) 
         VALUES('$title1','$color1','$start1','$end1','$idtecnico','$idcontrato','$idusuario','$idnroaveria',0)";
     return ejecutarConsulta($sqlagenda);
    }
    
    public function editar_averia($idaveria,$idusuario,$idpersona,$idcontrato,$fecha_hora,$direccion,$referencia,$distrito,$celular1,$celular2,$detalle,$observacion,$idcategoria_ingreso,$idconcepto_ingreso,$prioridad,$idtecnico,$estado,$title1,$color1,$start1,$end1,$iddireccion,$idtecnologia) {

      $sql = "UPDATE averia 
                    SET idcontrato='$idcontrato',
                    idcliente='$idpersona',
                    idusuario='$idusuario',
                    direccion='$direccion',
                    referencia='$referencia',
                    distrito='$distrito',
                    celular1='$celular1',
                    celular2='$celular2',
                    detalle_problema='$detalle',
                    observaciones='$observacion',
                    idcategoria='$idcategoria_ingreso',
                    idtrabajo='$idconcepto_ingreso',
                    prioridad='$prioridad',
                    idtecnico='$idtecnico',
                    estado_averia='$estado',
                    tecnologia='$idtecnologia',
                    iddireccion='$iddireccion',
                    fecha_hora='$fecha_hora',
                    fecha_programacion='$start1'  
              WHERE idaveria='$idaveria'";
             ejecutarConsulta($sql);
          

      $sqlupdate="UPDATE persona set celular='$celular1',whatsapp='$celular2' where idpersona='$idpersona'  ";
       ejecutarConsulta($sqlupdate);

       $sqlupdate_direccion="UPDATE detalle_direccion set description='$referencia',address='$direccion',fiscal='$direccion' where iddireccion='$iddireccion'  ";
       ejecutarConsulta($sqlupdate_direccion);

      $sqlagenda="UPDATE agenda SET 
                  title='$title1',
                  color='$color1',
                  start='$start1',
                  end='$end1',
                  idtecnico='$idtecnico',
                  idcontrato='$idcontrato',
                  idusuario='$idusuario',
                  estado='0' 
                WHERE idaveria='$idaveria'";
     return ejecutarConsulta($sqlagenda);
    }


    public function guardaryeditar_visita($idusuario,$idpersona,$idcontrato,$fecha_hora,$direccion,$referencia,$distrito,$celular1,$celular2,$detalle,$observacion,$idcategoria_ingreso,$idconcepto_ingreso,$prioridad,$idtecnico,$estado,$title1,$color1,$start1,$end1,$iddireccion,$idtecnologia) {

      $fecha_dia = date("d");
      $fecha_año = date("Y");
      $fecha_mes = date("m");
      $variable = $fecha_dia.$fecha_mes.$fecha_año;

      $contador="SELECT count(nroservicio)+1 as contador FROM orden";
      $result= ejecutarConsultaSimpleFila($contador);
      $con= $result['contador'];

      $correlativo = $variable."-"."00".$con;

      $insercorrelativo="INSERT INTO orden (nroservicio) VALUES('$correlativo')";
        ejecutarConsulta($insercorrelativo);

      $sql = "INSERT INTO averia (idcontrato,idcliente,idusuario,direccion,referencia,distrito,celular1,celular2,detalle_problema,observaciones,idcategoria,idtrabajo,prioridad,idtecnico,estado_averia,nroservicio,tecnologia,iddireccion,fecha_hora,fecha_programacion) 
                VALUES ('$idcontrato', '$idpersona', '$idusuario', '$direccion', '$referencia', '$distrito' ,'$celular1' ,'$celular2' ,'$detalle' ,'$observacion', '$idcategoria_ingreso' ,'$idconcepto_ingreso' ,'$prioridad', '$idtecnico','$estado','$correlativo','$idtecnologia','$iddireccion','$fecha_hora','$start1')";
      $idnroaveria = ejecutarConsulta_retornarID($sql);

      $sqlupdate="UPDATE persona set celular='$celular1',whatsapp='$celular2' where idpersona='$idpersona'  ";
       ejecutarConsulta($sqlupdate);

       $sqlupdate_direccion="UPDATE detalle_direccion set description='$referencia',address='$direccion',fiscal='$direccion' where iddireccion='$iddireccion'  ";
       ejecutarConsulta($sqlupdate_direccion);

      $sqlagenda="INSERT INTO agenda(title,color,start,end,idtecnico,idcontrato,idusuario,idaveria,estado) 
         VALUES('$title1','$color1','$start1','$end1','$idtecnico','$idcontrato','$idusuario','$idnroaveria',0)";
     return ejecutarConsulta($sqlagenda);
    }

    // Método para editar
    public function editar($idcaja, $descripcion,$idusuario) {
        $sql = "UPDATE caja SET 
                descripcion = '$descripcion', 
                idusuario = '$idusuario'                 
                WHERE idcaja = '$idcaja'";
        return ejecutarConsulta($sql);
    }

    public function listardetalle()
    {
      $sql="SELECT a.start,u.nombre as usuario,d.address as direccion,v.detalle_problema,c.tipo_trabajo  FROM agenda a JOIN averia v ON a.idaveria=v.idaveria JOIN usuario u ON a.idtecnico=u.idusuario JOIN detalle_direccion d ON v.iddireccion=d.iddireccion JOIN concepto_ingreso c ON v.idtrabajo=c.idconcepto_ingreso";
      return ejecutarConsulta($sql);

    }

    public function listaraveriaPorCategoria($idcategoria_ingreso)
    {
      // Verificar si $idestado está vacío o no
      if (!empty($idcategoria_ingreso)) {
        // Si $idestado tiene un valor, incluirlo en la consulta
        $sql = "SELECT a.idaveria, a.idcliente, a.estado_averia, a.idcategoria, 
                      c.color, p.nombre as cliente, u.nombre as tecnico, 
                      c.tipo_trabajo, t.nombre as tecnologia, a.prioridad, 
                      a.fecha_programacion, o.nombre as usuario, d.address, 
                      d.latitude, d.longitude, d.iddireccion, a.tecnologia as idtecnologia,t.idservicio
                FROM averia a
                JOIN persona p ON a.idcliente = p.idpersona
                JOIN usuario u ON a.idtecnico = u.idusuario
                JOIN usuario o ON a.idusuario = o.idusuario
                JOIN concepto_ingreso c ON a.idtrabajo = c.idconcepto_ingreso
                JOIN tecnologia t ON a.tecnologia = t.idtecnologia
                LEFT JOIN detalle_direccion d ON a.iddireccion = d.iddireccion
                WHERE  c.idcategoria_ingreso = '$idcategoria_ingreso' and c.condicion='1' ";
        }
      return ejecutarConsulta($sql);
    }

    public function listaraveria()
    {
      // Verificar si $idestado está vacío o no
            $sql = "SELECT a.idaveria, a.idcliente, a.estado_averia, a.idcategoria, 
                          c.color, p.nombre as cliente, u.nombre as tecnico, 
                          c.tipo_trabajo, t.nombre as tecnologia, a.prioridad, 
                          a.fecha_programacion, o.nombre as usuario, d.address, 
                          d.latitude, d.longitude, d.iddireccion, a.tecnologia as idtecnologia , t.idservicio 
                    FROM averia a
                    JOIN persona p ON a.idcliente = p.idpersona
                    JOIN usuario u ON a.idtecnico = u.idusuario
                    JOIN usuario o ON a.idusuario = o.idusuario
                    JOIN concepto_ingreso c ON a.idtrabajo = c.idconcepto_ingreso
                    JOIN tecnologia t ON a.tecnologia = t.idtecnologia
                    LEFT JOIN detalle_direccion d ON a.iddireccion = d.iddireccion
                    WHERE a.estado_averia < '7' and c.condicion='1'";
              return ejecutarConsulta($sql);
    }

    public function listaraveriaPorCuadrilla($idcuadrilla)
    {
      // Verificar si $idestado está vacío o no
            $sql = "SELECT a.idaveria, a.idcliente, a.estado_averia, a.idcategoria, 
                          c.color, p.nombre as cliente, u.nombre as tecnico, 
                          c.tipo_trabajo, t.nombre as tecnologia, a.prioridad, 
                          a.fecha_programacion, o.nombre as usuario, d.address, 
                          d.latitude, d.longitude, d.iddireccion, a.tecnologia as idtecnologia , t.idservicio 
                    FROM averia a
                    JOIN persona p ON a.idcliente = p.idpersona
                    JOIN usuario u ON a.idtecnico = u.idusuario
                    JOIN usuario o ON a.idusuario = o.idusuario
                    JOIN concepto_ingreso c ON a.idtrabajo = c.idconcepto_ingreso
                    JOIN tecnologia t ON a.tecnologia = t.idtecnologia
                    LEFT JOIN detalle_direccion d ON a.iddireccion = d.iddireccion
                    WHERE a.estado_averia < '7' and a.idtecnico='$idcuadrilla' ";
              return ejecutarConsulta($sql);
    }

    public function cantidadPuntos($idcuadrilla)
    {
          $sql = "SELECT sum(c.equivalencia) as punto FROM averia a
                  JOIN categoria_ingreso c ON c.idcategoria_ingreso=a.idcategoria
                  WHERE a.idtecnico='$idcuadrilla' and a.estado_averia < '3' ";
            return ejecutarConsultaSimpleFila($sql);
    }

    public function listartecnico($idusuario)
    {
      $sql="SELECT a.nro_acta,a.idaveria,a.idcliente,a.estado_averia,a.idcategoria,c.color,p.nombre as cliente, u.nombre as tecnico,c.tipo_trabajo,t.nombre as tecnologia,a.prioridad, a.fecha_programacion,o.nombre as usuario,d.address,d.latitude,d.longitude 
            FROM averia a
            JOIN persona p ON a.idcliente=p.idpersona
            JOIN usuario u ON a.idtecnico=u.idusuario
            JOIN usuario o ON a.idusuario=o.idusuario
            JOIN concepto_ingreso c ON a.idtrabajo=c.idconcepto_ingreso
            JOIN tecnologia t ON a.tecnologia=t.idtecnologia
            LEFT JOIN detalle_direccion d ON a.iddireccion=d.iddireccion 
            WHERE a.estado_averia<'3' and a.idtecnico='$idusuario' and c.condicion='1' ";
      return ejecutarConsulta($sql);
    }



    public function listaraveria_terminado()
    {
      $sql="SELECT a.idaveria,a.nro_acta,a.idaveria,a.idcliente,a.estado_averia,a.idcategoria,c.color,p.nombre as cliente, u.nombre as tecnico,c.tipo_trabajo,t.nombre as tecnologia,a.prioridad, a.fecha_programacion,o.nombre as usuario,d.address,d.latitude,d.longitude 
            FROM averia a
            JOIN persona p ON a.idcliente=p.idpersona
            JOIN usuario u ON a.idtecnico=u.idusuario
            JOIN usuario o ON a.idusuario=o.idusuario
            JOIN concepto_ingreso c ON a.idtrabajo=c.idconcepto_ingreso
            JOIN tecnologia t ON a.tecnologia=t.idtecnologia
            LEFT JOIN detalle_direccion d ON a.iddireccion=d.iddireccion 
            WHERE a.estado_averia='7' order by a.idaveria asc";
      return ejecutarConsulta($sql);
    }

    public function listarcalificacion()
    {
      $sql="SELECT date(a.created_at)as fecha, a.comentario,a.calificacion,u.nombre as usuario,p.nombre as cliente 
            FROM calificacion a
            JOIN usuario u ON a.idresponsable=u.idusuario
            JOIN contrato c ON a.idcontrato=c.idcontrato
            JOIN persona p ON c.idcliente=p.idpersona";
      return ejecutarConsulta($sql);
    }

    public function mostrar_contrato($idaveria)
    {
      $queryContratos="SELECT a.idaveria,a.nroservicio,p.nombre as cliente, u.nombre as tecnico,c.tipo_trabajo,c.idconcepto_ingreso,idcategoria_ingreso,a.prioridad,t.nombre as tecnologia,co.idcontrato,co.paga,co.modalidad,co.descripcion,d.description,d.address,p.idpersona,p.celular,p.whatsapp,a.detalle_problema,a.observaciones,
                     DATE(a.fecha_programacion) AS fecha_programacion,TIME(a.fecha_programacion) AS hora_programacion,
                     DATE(a.created_at) AS fecha_emision,TIME(a.created_at) AS hora_emision,a.nro_acta,a.descripcion_averia,a.tipoventa,a.inicial,a.numeroletra,a.montoletra,a.tipo_pago,a.idbanco,a.nro_operacion,a.nro_recibo,
                     o.nombre as usuario,d.latitude,d.longitude,d.distrito,s.nombre as servicio,pl.nombre_plan,co.nrocontrato,co.iddireccion 
            FROM averia a
            JOIN persona p ON a.idcliente=p.idpersona
            JOIN usuario u ON a.idtecnico=u.idusuario
            JOIN usuario o ON a.idusuario=o.idusuario
            JOIN concepto_ingreso c ON a.idtrabajo=c.idconcepto_ingreso
            JOIN tecnologia t ON a.tecnologia=t.idtecnologia
            JOIN contrato co ON a.idcontrato=co.idcontrato
            JOIN servicio s ON co.idservicio=s.idservicio
            JOIN planes pl ON co.idplan=pl.idplan
            LEFT JOIN detalle_direccion d ON a.iddireccion=d.iddireccion 
            WHERE a.idaveria='$idaveria'";
      $resultContratos = ejecutarConsulta($queryContratos);

      $contratos = [];
      while ($row = $resultContratos->fetch_assoc()) {
      $contratos[] = $row;
      }

      $queryDetalles="SELECT d.idaveria,d.inicio,d.fin,d.cantidad,d.codigo,d.costo,a.nombre FROM detalle_averia d JOIN articulo a ON d.idarticulo=a.idarticulo WHERE d.idaveria='$idaveria' ";
      $resulDetalles= ejecutarConsulta($queryDetalles);

      $detalles = [];
      while ($row = $resulDetalles->fetch_assoc()) {
      $detalles[] = $row;
      }
      // Respuesta JSON
    return [
      "contratos" => $contratos,
      "detalles" => $detalles
      ];
    }

    public function mostrar_averia($idaveria)
    {
      $queryContratos="SELECT a.idaveria,a.nroservicio,p.nombre as cliente, u.nombre as tecnico,c.tipo_trabajo,c.idconcepto_ingreso,idcategoria_ingreso,a.prioridad,t.nombre as tecnologia,co.idcontrato,co.paga,co.modalidad,co.descripcion,d.description,d.address,p.idpersona,p.celular,p.whatsapp,a.detalle_problema,a.observaciones,
                     DATE(a.fecha_programacion) AS fecha_programacion,TIME(a.fecha_programacion) AS hora_programacion,
                     DATE(a.created_at) AS fecha_emision,TIME(a.created_at) AS hora_emision,a.nro_acta,a.descripcion_averia,a.tipoventa,a.inicial,a.numeroletra,a.montoletra,a.tipo_pago,a.idbanco,a.nro_operacion,a.nro_recibo,
                     o.nombre as usuario,d.latitude,d.longitude,d.distrito,s.nombre as servicio,pl.nombre_plan,co.nrocontrato,co.idplan,co.iddireccion 
            FROM averia a
            JOIN persona p ON a.idcliente=p.idpersona
            JOIN usuario u ON a.idtecnico=u.idusuario
            JOIN usuario o ON a.idusuario=o.idusuario
            JOIN concepto_ingreso c ON a.idtrabajo=c.idconcepto_ingreso
            JOIN tecnologia t ON a.tecnologia=t.idtecnologia
            JOIN contrato co ON a.idcontrato=co.idcontrato
            JOIN servicio s ON co.idservicio=s.idservicio
            JOIN planes pl ON co.idplan=pl.idplan
            LEFT JOIN detalle_direccion d ON a.iddireccion=d.iddireccion 
            WHERE a.idaveria='$idaveria'";
      $resultContratos = ejecutarConsulta($queryContratos);

      $contratos = [];
      while ($row = $resultContratos->fetch_assoc()) {
      $contratos[] = $row;
      $idcontrato = $row['idcontrato'];

      $querycontrato="SELECT idaveria FROM averia WHERE idcontrato='$idcontrato' order by idaveria LIMIT 1";
      $resultCo = ejecutarConsultaSimpleFila($querycontrato);
      $idaveria_contrato = $resultCo['idaveria'];
      
      }

      $queryDetalles="SELECT d.idaveria,d.inicio,d.fin,d.cantidad,d.codigo,d.costo,a.nombre FROM detalle_averia d JOIN articulo a ON d.idarticulo=a.idarticulo WHERE d.idaveria='$idaveria' ";
      $resulDetalles= ejecutarConsulta($queryDetalles);

      $detalles = [];
      while ($row = $resulDetalles->fetch_assoc()) {
      $detalles[] = $row;
      }
      
      $queryImagenesContrato="SELECT idimagen,imagen,idaveria FROM imagen WHERE idaveria='$idaveria_contrato' ";
      $resulImagenesContrato= ejecutarConsulta($queryImagenesContrato);
      $imagen_contratos = [];
      while ($row = $resulImagenesContrato->fetch_assoc()) {
        $imagen_contratos[] = $row;
      }

      $queryImagenes="SELECT idimagen,imagen FROM imagen WHERE idaveria='$idaveria' ";
      $resulImagenes= ejecutarConsulta($queryImagenes);

      $imagenes = [];
      while ($row = $resulImagenes->fetch_assoc()) {
        $imagenes[] = $row;
      }

      $queryMikrotiks="SELECT * FROM mikrotik WHERE idcontrato='$idcontrato' ";
      $resulMikrotiks= ejecutarConsulta($queryMikrotiks);

      $mikrotiks = [];
      while ($row = $resulMikrotiks->fetch_assoc()) {
        $mikrotiks[] = $row;
      }
      // Respuesta JSON
    return [
      "contratos" => $contratos,
      "detalles" => $detalles,
      "imagenes"=> $imagenes,
      "imagen_contratos" => $imagen_contratos,
      "mikrotiks" => $mikrotiks
      ];
    }

    public function mostrar_recojo($idaveria)
    {
      $queryContratos="SELECT a.idaveria,a.nroservicio,p.nombre as cliente, u.nombre as tecnico,c.tipo_trabajo,c.idconcepto_ingreso,idcategoria_ingreso,a.prioridad,t.nombre as tecnologia,co.idcontrato,co.paga,co.modalidad,co.descripcion,d.description,d.address,p.idpersona,p.celular,p.whatsapp,a.detalle_problema,a.observaciones,
                     DATE(a.fecha_programacion) AS fecha_programacion,TIME(a.fecha_programacion) AS hora_programacion,
                     DATE(a.created_at) AS fecha_emision,TIME(a.created_at) AS hora_emision,a.nro_acta,a.descripcion_averia,a.tipoventa,a.inicial,a.numeroletra,a.montoletra,a.tipo_pago,a.idbanco,a.nro_operacion,a.nro_recibo,
                     o.nombre as usuario,d.latitude,d.longitude,d.distrito,s.nombre as servicio,pl.nombre_plan,co.nrocontrato,co.idplan,a.monto_atencion 
            FROM averia a
            JOIN persona p ON a.idcliente=p.idpersona
            JOIN usuario u ON a.idtecnico=u.idusuario
            JOIN usuario o ON a.idusuario=o.idusuario
            JOIN concepto_ingreso c ON a.idtrabajo=c.idconcepto_ingreso
            JOIN tecnologia t ON a.tecnologia=t.idtecnologia
            JOIN contrato co ON a.idcontrato=co.idcontrato
            JOIN servicio s ON co.idservicio=s.idservicio
            JOIN planes pl ON co.idplan=pl.idplan
            LEFT JOIN detalle_direccion d ON a.iddireccion=d.iddireccion 
            WHERE a.idaveria='$idaveria'";
      $resultContratos = ejecutarConsulta($queryContratos);

      $contratos = [];
      while ($row = $resultContratos->fetch_assoc()) {
      $contratos[] = $row;
      $idcontrato = $row['idcontrato'];

      $querycontrato="SELECT idaveria FROM averia WHERE idcontrato='$idcontrato' order by idaveria LIMIT 1";
      $resultCo = ejecutarConsultaSimpleFila($querycontrato);
      $idaveria_contrato = $resultCo['idaveria'];
      
      }

      $queryDetalles="SELECT d.idaveria,d.inicio,d.fin,d.cantidad,d.codigo,d.costo,a.nombre FROM detalle_averia d JOIN articulo a ON d.idarticulo=a.idarticulo WHERE d.idcontrato='$idcontrato' ";
      $resulDetalles= ejecutarConsulta($queryDetalles);

      $detalles = [];
      while ($row = $resulDetalles->fetch_assoc()) {
      $detalles[] = $row;
      }
      
      $queryImagenesContrato="SELECT idimagen,imagen FROM imagen WHERE idaveria='$idaveria_contrato' ";
      $resulImagenesContrato= ejecutarConsulta($queryImagenesContrato);
      $imagen_contratos = [];
      while ($row = $resulImagenesContrato->fetch_assoc()) {
        $imagen_contratos[] = $row;
      }

      $queryImagenes="SELECT idimagen,imagen FROM imagen WHERE idaveria='$idaveria' ";
      $resulImagenes= ejecutarConsulta($queryImagenes);

      $imagenes = [];
      while ($row = $resulImagenes->fetch_assoc()) {
        $imagenes[] = $row;
      }

      $queryLlamadas="SELECT m.created_at,m.descripcion,u.nombre FROM movimiento_llamada m join usuario u on m.idusuario=u.idusuario WHERE m.idcontrato='$idcontrato' ";
      $resulLlamadas= ejecutarConsulta($queryLlamadas);

      $llamadas = [];
      while ($row = $resulLlamadas->fetch_assoc()) {
        $llamadas[] = $row;
      }

      // Respuesta JSON
    return [
      "contratos" => $contratos,
      "detalles" => $detalles,
      "imagenes"=> $imagenes,
      "imagen_contratos" => $imagen_contratos,
      "llamadas" => $llamadas
      ];
    }

    public function mostrar_visita($idaveria)
    {
      $queryContratos="SELECT a.idaveria,a.nroservicio,p.nombre as cliente, u.nombre as tecnico,c.tipo_trabajo,c.idconcepto_ingreso,idcategoria_ingreso,a.prioridad,t.nombre as tecnologia,co.idcontrato,co.paga,co.modalidad,co.descripcion,d.description,d.address,p.idpersona,p.celular,p.whatsapp,a.detalle_problema,a.observaciones,
                     DATE(a.fecha_programacion) AS fecha_programacion,TIME(a.fecha_programacion) AS hora_programacion,
                     DATE(a.created_at) AS fecha_emision,TIME(a.created_at) AS hora_emision,a.nro_acta,a.descripcion_averia,a.tipoventa,a.inicial,a.numeroletra,a.montoletra,a.tipo_pago,a.idbanco,a.nro_operacion,a.nro_recibo,
                     o.nombre as usuario,d.latitude,d.longitude,d.distrito,s.nombre as servicio,pl.nombre_plan,co.nrocontrato,co.idplan 
            FROM averia a
            JOIN persona p ON a.idcliente=p.idpersona
            JOIN usuario u ON a.idtecnico=u.idusuario
            JOIN usuario o ON a.idusuario=o.idusuario
            JOIN concepto_ingreso c ON a.idtrabajo=c.idconcepto_ingreso
            JOIN tecnologia t ON a.tecnologia=t.idtecnologia
            JOIN contrato co ON a.idcontrato=co.idcontrato
            JOIN servicio s ON co.idservicio=s.idservicio
            JOIN planes pl ON co.idplan=pl.idplan
            LEFT JOIN detalle_direccion d ON a.iddireccion=d.iddireccion 
            WHERE a.idaveria='$idaveria'";
      $resultContratos = ejecutarConsulta($queryContratos);

      $contratos = [];
      while ($row = $resultContratos->fetch_assoc()) {
      $contratos[] = $row;
      $idcontrato = $row['idcontrato'];

      $querycontrato="SELECT idaveria FROM averia WHERE idcontrato='$idcontrato' order by idaveria LIMIT 1";
      $resultCo = ejecutarConsultaSimpleFila($querycontrato);
      $idaveria_contrato = $resultCo['idaveria'];
      
      }


      $queryImagenes="SELECT idimagen,imagen FROM imagen WHERE idaveria='$idaveria' ";
      $resulImagenes= ejecutarConsulta($queryImagenes);

      $imagenes = [];
      while ($row = $resulImagenes->fetch_assoc()) {
        $imagenes[] = $row;
      }

      
      // Respuesta JSON
    return [
      "contratos" => $contratos,
      "imagenes"=> $imagenes
      ];
    }

    public function listar_material($idusuario)
    {
      $sql="SELECT m.idmovimiento_materiales, 
       a.idarticulo,
       m.idalmacen, 
       a.nombre, 
       a.descripcion,
       a.unidad_medida, 
       m.precio_venta, 
       m.cantidadsalida, 
       m.cantidaddevuelto, 
       m.cantidadusado, 
       m.codigo, 
       m.estadomaterial,
       (m.cantidadsalida - m.cantidaddevuelto - m.cantidadusado) AS stock_disponible
      FROM movimiento_materiales m
      JOIN articulo a ON a.idarticulo = m.idarticulo
      WHERE m.idtecnico = '$idusuario' 
        AND m.estado = '0'
        AND (m.cantidadsalida - m.cantidaddevuelto - m.cantidadusado) > 0";
      return ejecutarConsulta($sql);
    }

    //Implementamos un metodo para eliminar registro
    public function eliminar($idaveria)
    {
      $sql_averia = "SELECT a.estado_averia,a.idtecnico,a.tipoventa FROM averia a WHERE a.idaveria = '$idaveria'";
      $resultado = ejecutarConsultaSimpleFila($sql_averia);
      $estado_averia = $resultado['estado_averia'];
      $idtecnico = $resultado['idtecnico'];
      $tipoventa = $resultado['tipoventa'];

    $sql_detalle = "SELECT * FROM detalle_averia WHERE idaveria='$idaveria'";
              $resultado_detalle = ejecutarConsulta($sql_detalle);
          
                  // Verificar si hay resultados
                  if ($resultado_detalle) {
                      while ($fila_detalle = $resultado_detalle->fetch_assoc()) {
                          $idarticulo = $fila_detalle['idarticulo'];
                          $cantidad = $fila_detalle['cantidad'];
                          $codigo = $fila_detalle['codigo'];
                          $idmovimiento_materiales = $fila_detalle['idmovimiento_materiales'];
                          $idalmacen = $fila_detalle['idalmacen']; 

                          $actualizar_movimiento = "UPDATE movimiento_materiales SET cantidadusado = cantidadusado - '$cantidad', estado='0', estadofinal='0' WHERE idarticulo='$idarticulo' and idtecnico='$idtecnico' and codigo='$codigo' and idmovimiento_materiales='$idmovimiento_materiales'  ";
                          ejecutarConsulta($actualizar_movimiento);
                          $actualizar_inventario="UPDATE inventario_almacen SET stock_salida = stock_salida - '$cantidad' WHERE idarticulo = '$idarticulo' 
                          AND idalmacen = '$idalmacen'";
                          ejecutarConsulta($actualizar_inventario);
                        
                      }
                  
                  }else{

                    $sql_detalle_averia="DELETE FROM detalle_averia where idaveria='$idaveria'";
                    ejecutarConsulta($sql_detalle_averia);

                    $sql_agenda="DELETE FROM agenda WHERE idaveria='$idaveria'";
                    ejecutarConsulta($sql_agenda);

                    $sql="DELETE FROM averia where idaveria='$idaveria'";
                    return ejecutarConsulta($sql);

                    
                  }

                      $sql_pago="DELETE FROM pago where idaveria='$idaveria'";
                      ejecutarConsulta($sql_pago);

                      $sql_de="DELETE FROM detalle_averia where idaveria='$idaveria'";
                      ejecutarConsulta($sql_de);

                      $sql_agenda="DELETE FROM agenda WHERE idaveria='$idaveria'";
                      ejecutarConsulta($sql_agenda);

                      $sql_imagen="DELETE FROM imagen where idaveria='$idaveria'";
                      ejecutarConsulta($sql_imagen);

                      $sql_ave="DELETE FROM averia where idaveria='$idaveria'";
                      return  ejecutarConsulta($sql_ave);
  }

    public function mostrarchat($idaveria)
    {
      $sql="SELECT u.nombre,m.descripcion,m.created_at as fecharegistro  FROM chataveria m join usuario u on m.idusuario=u.idusuario WHERE m.idaveria='$idaveria'";
      $resultChat = ejecutarConsulta($sql);

      $chats = [];
      while ($row = $resultChat->fetch_assoc()) {
      $chats[] = $row;
    }
      // Respuesta JSON
    return [
        "chats" => $chats
        ];

    }

    public function guardar_chat($descripcion,$fecha,$estado,$idusuario,$idaveria_chat)
    {
      

      if (!empty($fecha) && empty($estado)) {
        // Caso: fecha no está vacía y estado está vacío
        $sqlChat = "INSERT INTO chataveria (descripcion, fechareprogramacion, idaveria, idusuario)
                    VALUES ('$descripcion', '$fecha', '$idaveria_chat', '$idusuario')";
        ejecutarConsulta($sqlChat);

        // Actualiza la agenda
        $sqlAgenda = "UPDATE agenda SET start='$fecha' WHERE idaveria='$idaveria_chat'";
        ejecutarConsulta($sqlAgenda);

        // Actualiza averia
        $sqlAveria = "UPDATE averia SET fecha_programacion='$fecha', estado_averia='2' WHERE idaveria='$idaveria_chat'";
        return ejecutarConsulta($sqlAveria);

    } elseif (!empty($estado)) {
        // Caso: estado no está vacío
        $sqlChat = "INSERT INTO chataveria (descripcion, idaveria, idusuario)
                    VALUES ('$descripcion', '$idaveria_chat', '$idusuario')";
        ejecutarConsulta($sqlChat);

        // Actualiza averia
        $sqlAveria = "UPDATE averia SET estado_averia='4' WHERE idaveria='$idaveria_chat'";
        return ejecutarConsulta($sqlAveria);
    } else {
        // Caso por defecto
        $sqlChat = "INSERT INTO chataveria (descripcion, idaveria, idusuario)
                    VALUES ('$descripcion', '$idaveria_chat', '$idusuario')";
          ejecutarConsulta($sqlChat);

        // Actualiza averia
        $sqlAveria = "UPDATE averia SET estado_averia='2' WHERE idaveria='$idaveria_chat'";
        return ejecutarConsulta($sqlAveria);
    }

    }

    public function guardaryeditar_fichacontrato($idaveria,$idpersona,$idusuario,$radioTipoVenta,$costocontado,$adelanto,$totalequipo,$adelanto_letra,$cantidad_letra,$monto_letra,$tipo_pago,$idbanco,$nroperacion,$recibo,$descripcion_tecnico,$nroacta,$servicio,$tipo_trabajo,$idcaja,$total_importe,$tipotrabajo,$categoriaingreso,$idcontrato,$longitud,$latitud,$iddireccion,$direccion_capturada,$idarticulo,$codigo,$inicio,$fin,$cantidad,$precio_venta,$idmovimiento_materiales,$estadomaterial,$idalmacen){

      $hoy=date("Y-m-d H:i:s");

      if (isset($direccion_capturada) && trim($direccion_capturada) !== '') {
      $sql_ubicacion="UPDATE detalle_direccion SET latitude='$latitud',longitude='$longitud',address='$direccion_capturada' WHERE iddireccion='$iddireccion' ";
      ejecutarConsulta($sql_ubicacion);
      }

      $sql_averia="UPDATE averia SET nro_acta='$nroacta',descripcion_averia='$descripcion_tecnico',
      inicial='$adelanto_letra',numeroletra='$cantidad_letra',
      montoletra='$monto_letra',tipoventa='$radioTipoVenta',tipo_pago='$tipo_pago',
      idbanco='$idbanco',monto_atencion='$costocontado',nro_operacion='$nroperacion',nro_recibo='$recibo',fecha_atencion='$hoy' 
      WHERE idaveria='$idaveria'";
      ejecutarConsulta($sql_averia);

      $num_elementos1 = 0;
      
        // Insertar y actualizar en las tablas `movimiento_materiales` e `inventario_almacen`
        while ($num_elementos1 < count($idarticulo)) {

            // Insertar en la tabla `detalle_averia`
                  $sql_detalle = "INSERT INTO detalle_averia (
                    idaveria, idalmacen, idmovimiento_materiales, idcontrato, idarticulo, inicio, fin, cantidad, codigo, costo, tipotrabajo, 
                    nroacta, idcliente, servicio, estado, costosalida, estadomaterial, 
                    estadomovimiento, estadoventa, fecha_hora
                ) VALUES (
                    '$idaveria',
                    '$idalmacen[$num_elementos1]', 
                    '$idmovimiento_materiales[$num_elementos1]', 
                    '$idcontrato',
                    '$idarticulo[$num_elementos1]', 
                    '$inicio[$num_elementos1]',
                    '$fin[$num_elementos1]',
                    '$cantidad[$num_elementos1]',
                    '$codigo[$num_elementos1]', 
                    '$precio_venta[$num_elementos1]', 
                    '$tipo_trabajo', 
                    '$nroacta', 
                    '$idpersona', 
                    '$servicio', 
                    '0', 
                    '0', 
                    '$estadomaterial[$num_elementos1]', 
                    '4', 
                    '3',
                    NOW()
                )";

              if (!ejecutarConsulta($sql_detalle)) {
              throw new Exception("Error al insertar en detalle_averia");
              }
            // Actualizar `cantidadusado` en la tabla `movimiento_materiales`
            $sql_detalle_update = "UPDATE movimiento_materiales 
                                  SET cantidadusado = cantidadusado + '$cantidad[$num_elementos1]' 
                                  WHERE idmovimiento_materiales = '$idmovimiento_materiales[$num_elementos1]' 
                                  AND idtecnico = '$idusuario'";
            
            if (!ejecutarConsulta($sql_detalle_update)) {
                throw new Exception("Error al actualizar cantidadusado en movimiento_materiales");
            }

            // Obtener los valores actuales de cantidadsalida, cantidadusado y cantidaddevuelto
            $sql_validar = "SELECT cantidadsalida, cantidadusado, cantidaddevuelto 
                            FROM movimiento_materiales 
                            WHERE idmovimiento_materiales = '$idmovimiento_materiales[$num_elementos1]' 
                            AND idtecnico = '$idusuario'";
            
            $resultado = ejecutarConsultaSimpleFila($sql_validar);
            
            if ($resultado) {
                $cantidadsalida = $resultado['cantidadsalida'];
                $cantidadusado = $resultado['cantidadusado'];
                $cantidadevuelto = $resultado['cantidaddevuelto'];

                // Validar si cantidadsalida es igual a cantidadusado + cantidaddevuelto
                if ($cantidadsalida == ($cantidadusado + $cantidadevuelto)) {
                    $sql_actualizar_estado = "UPDATE movimiento_materiales 
                                              SET estado = 1 
                                              WHERE idmovimiento_materiales = '$idmovimiento_materiales[$num_elementos1]' 
                                              AND idtecnico = '$idusuario'";
                    
                    if (!ejecutarConsulta($sql_actualizar_estado)) {
                        throw new Exception("Error al actualizar el estado en movimiento_materiales");
                    }
                }
            } else {
                throw new Exception("Error al obtener los valores de movimiento_materiales");
            }

            // Actualizar el stock en la tabla `inventario_almacen`
            $sql_detalle_update_almacen = "UPDATE inventario_almacen 
                                          SET stock_salida = stock_salida + '$cantidad[$num_elementos1]' 
                                          WHERE idarticulo = '$idarticulo[$num_elementos1]' 
                                          AND idalmacen = '$idalmacen[$num_elementos1]'";
            
            if (!ejecutarConsulta($sql_detalle_update_almacen)) {
                throw new Exception("Error al actualizar stock_salida en inventario_almacen");
            }

            $num_elementos1++;
        }


      if($radioTipoVenta == 'Contado'){

       // Obtener los valores actuales idcuota
        $sql_validar_cuota = "SELECT c.idcuota  FROM cuota c
        WHERE c.idcontrato = '$idcontrato' ORDER BY c.idcuota ";

        $resultado = ejecutarConsultaSimpleFila($sql_validar_cuota);

        if ($resultado) {
          $idcuota = $resultado['idcuota'];

              $sql_actualizar_cuota = "UPDATE cuota 
                                        SET monto = '$total_importe', montopagado='$total_importe',nrorecibo='$recibo',fecha_cancelacion='$hoy',comentario_mensualidad='$descripcion_tecnico',estado_cuota='2',idaveria='$idaveria' 
                                        WHERE idcuota = '$idcuota'";
              
              if (!ejecutarConsulta($sql_actualizar_cuota)) {
                  throw new Exception("Error al actualizar cuota");
              }
        
      } else {
          throw new Exception("Error al obtener los valores de cuota");
      }
       if($total_importe >0){
                $sqlinsert ="INSERT INTO pago(idcontrato,idaveria,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                VALUES('$idcontrato',
                      '$idaveria',
                      '$idbanco',
                      '$idusuario',
                      '$idpersona',
                      '$tipo_pago',
                      '$idcaja',
                      '$total_importe',
                      '$hoy',
                      '$descripcion_tecnico',
                      '$recibo',
                      '$nroperacion',
                      '$categoriaingreso',
                      '$tipotrabajo')";
        return  ejecutarConsulta($sqlinsert);
       }else{

        return true;

       }

      }else if($radioTipoVenta == 'Cuota'){

       // Obtener los valores actuales idcuota
       $sql_validar_cuota = "SELECT c.idcuota  FROM cuota c
       WHERE c.idcontrato = '$idcontrato' ORDER BY c.idcuota ";
       $resultado = ejecutarConsultaSimpleFila($sql_validar_cuota);

       if ($resultado) {
         $idcuota = $resultado['idcuota'];

             $sql_actualizar_cuota = "UPDATE cuota 
                                       SET monto = '$total_importe', montopagado='$adelanto_letra',nrorecibo='$recibo',fecha_cancelacion='$hoy',comentario_mensualidad='$descripcion_tecnico',estado_cuota='2',idaveria='$idaveria' 
                                       WHERE idcuota = '$idcuota'";
             
             if (!ejecutarConsulta($sql_actualizar_cuota)) {
                 throw new Exception("Error al actualizar cuota");
             }
       
     } else {
         throw new Exception("Error al obtener los valores de cuota");
     } 

        $sql_cuota="SELECT c.idcuota  FROM cuota c
        WHERE c.idcontrato = '$idcontrato' and c.estado_cuota='1' ORDER BY c.idcuota ";
        $luna3 = ejecutarConsulta($sql_cuota);
        $j=1;
        while ($sol3 = mysqli_fetch_array($luna3)){
        $idv = $sol3["idcuota"];
                   // if($j==0){
                    $cuotajorge=$monto_letra;
                   if($j<=$cantidad_letra && $j>0){
                      $cuotajorge=$monto_letra;
                      $averia=$idaveria;
                      $cuoave='Cuota de Equipo';
                      $descricuota=$cuoave." ".$j."/".$cantidad_letra ;
                    } else{
                      $cuotajorge=0.00;
                      $averia=0;
                      $descricuota='';
                    }
                  
                    $updsql="UPDATE cuota set montocuota='$cuotajorge',descripcion_cuota='$descricuota',idaveria='$averia' where idcontrato='$idcontrato' and idcuota='$idv' and estado_cuota='1' and montocuota='0'";
                    ejecutarConsulta($updsql); 
                    $j=$j+1;
          } 

        $sqlinsert ="INSERT INTO pago(idcontrato,idaveria,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                    VALUES('$idcontrato',
                          '$idaveria',
                          '$idbanco',
                          '$idusuario',
                          '$idpersona',
                          '$tipo_pago',
                          '$idcaja',
                          '$adelanto_letra',
                          '$hoy',
                          '$descripcion_tecnico',
                          '$recibo',
                          '$nroperacion',
                          '$categoriaingreso',
                          '$tipotrabajo')";
        return  ejecutarConsulta($sqlinsert);

      }else if($radioTipoVenta == 'Prestado'){

        // Obtener los valores actuales idcuota
        $sql_validar_cuota = "SELECT c.idcuota  FROM cuota c
        WHERE c.idcontrato = '$idcontrato' ORDER BY c.idcuota ";

        $resultado = ejecutarConsultaSimpleFila($sql_validar_cuota);

        if ($resultado) {
          $idcuota = $resultado['idcuota'];

              $sql_actualizar_cuota = "UPDATE cuota 
                                        SET monto = '0', montopagado='0',nrorecibo='$nroacta',fecha_cancelacion='$hoy',comentario_mensualidad='$descripcion_tecnico',estado_cuota='2',idaveria='$idaveria' 
                                        WHERE idcuota = '$idcuota'";
              
              if (!ejecutarConsulta($sql_actualizar_cuota)) {
                  throw new Exception("Error al actualizar cuota");
              }
        
      } else {
          throw new Exception("Error al obtener los valores de cuota");
      }
      //  if($total_importe >0){
      //           $sqlinsert ="INSERT INTO pago(idcontrato,idaveria,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
      //           VALUES('$idcontrato',
      //                 '$idaveria',
      //                 '$idbanco',
      //                 '$idusuario',
      //                 '$idpersona',
      //                 '$tipo_pago',
      //                 '$idcaja',
      //                 '$total_importe',
      //                 '$hoy',
      //                 '$descripcion_tecnico',
      //                 '$recibo',
      //                 '$nroperacion',
      //                 '$categoriaingreso',
      //                 '$tipotrabajo')";
      //   return  ejecutarConsulta($sqlinsert);
      //  }else{
        return true; 
       //}
      }
    }

    public function guardarImagen($idaveriac,$imagenes)
    {
      $sqlupdate="UPDATE averia set estado_averia='3' WHERE idaveria='$idaveriac'";
      ejecutarConsulta($sqlupdate);
      foreach ($imagenes as $imagen) {
        $sql = "INSERT INTO imagen (idaveria, imagen) VALUES ('$idaveriac', '$imagen')";
        $resultado = ejecutarConsulta($sql);

        // Verificar si la consulta falló
        if (!$resultado) {
            return false; // Si alguna falla, detén el proceso y devuelve false
        }
    }
    // Si todas las imágenes se registraron correctamente
    return true;
    }

    public function guardarImagenAveria($idaveriacc,$imagenes)
    {
      $sqlupdate="UPDATE averia set estado_averia='3' WHERE idaveria='$idaveriacc'";
      ejecutarConsulta($sqlupdate);
      foreach ($imagenes as $imagen) {
        $sql = "INSERT INTO imagen (idaveria, imagen) VALUES ('$idaveriacc', '$imagen')";
        $resultado = ejecutarConsulta($sql);
        // Verificar si la consulta falló
        if (!$resultado) {
            return false; // Si alguna falla, detén el proceso y devuelve false
        }
    }
    // Si todas las imágenes se registraron correctamente
    return true;
    }

    public function guardarCalificar($idaveria,$descripcion,$calificacion,$idusuario,$adicional){

      $sql_averia = "SELECT a.idcontrato,a.idtecnico  FROM averia a WHERE a.idaveria = '$idaveria'";
      $resultado = ejecutarConsultaSimpleFila($sql_averia);
      $idcontrato = $resultado['idcontrato'];
      $idtecnico = $resultado['idtecnico'];

      $insert_calificacion="INSERT INTO calificacion (idaveria,idcontrato,idresponsable,idusuario,comentario,calificacion) VALUES('$idaveria','$idcontrato','$idtecnico','$idusuario','$descripcion','$calificacion')";
      ejecutarConsulta($insert_calificacion);

      $update_averia="UPDATE averia set estado_averia='7',adicional='$adicional' WHERE idaveria='$idaveria'";
      ejecutarConsulta($update_averia);
      $update_agenda="UPDATE agenda set estado='2' WHERE idaveria='$idaveria'";
      return ejecutarConsulta($update_agenda);
     
    }

    public function selectEstado()
    {
      $sql="SELECT * FROM estado_averia WHERE idestado<7";
            return ejecutarConsulta($sql);
    }

    public function selectCuadrilla()
    {
      $sql="SELECT * FROM usuario WHERE cargo='4' and condicion='1'";
            return ejecutarConsulta($sql);
    }

    public function guardaryeditar_fichaveria($idaveria,$idpersona,$idusuario,$radioTipoVenta,$costocontado,$adelanto,$totalequipo,$adelanto_letra,$cantidad_letra,$monto_letra,$tipo_pago,$idbanco,$nroperacion,$recibo,$descripcion_tecnico,$nroacta,$servicio,$tipo_trabajo,$idcaja,$total_importe,$tipotrabajo,$categoriaingreso,$idcontrato,$imagen, $imagen_medidor, $imagen_anterior, $imagen_anterior_medidor,$latitud,$longitud,$iddireccion,$direccion_capturada,$idarticulo,$codigo,$inicio,$fin,$cantidad,$precio_venta,$idmovimiento_materiales,$estadomaterial,$idalmacen){

      $hoy=date("Y-m-d H:i:s");

       if (isset($direccion_capturada) && trim($direccion_capturada) !== '') {
      $sql_ubicacion="UPDATE detalle_direccion SET latitude='$latitud',longitude='$longitud',address='$direccion_capturada' WHERE iddireccion='$iddireccion' ";
      ejecutarConsulta($sql_ubicacion);
      }

       if (!empty($imagen_anterior)) {
        $sqlimagen = "UPDATE imagen SET imagen='$imagen' WHERE imagen='$imagen_anterior'";
        ejecutarConsulta($sqlimagen);
      }

       
     $existeImagen = ejecutarConsultaSimpleFila("SELECT COUNT(idimagen) as contador FROM imagen WHERE imagen = '$imagen_anterior_medidor'");
      if (intval($existeImagen['contador']) > 0) {
        ejecutarConsulta("UPDATE imagen SET imagen='$imagen_medidor' WHERE imagen='$imagen_anterior_medidor'");
      } else {
        ejecutarConsulta("INSERT INTO imagen (idaveria, imagen) VALUES ('$idcontrato', '$imagen_medidor')");
      }

      $sql_averia="UPDATE averia SET nro_acta='$nroacta',descripcion_averia='$descripcion_tecnico',
      inicial='$adelanto_letra',numeroletra='$cantidad_letra',
      montoletra='$monto_letra',tipoventa='$radioTipoVenta',tipo_pago='$tipo_pago',
      idbanco='$idbanco',monto_atencion='$costocontado',nro_operacion='$nroperacion',nro_recibo='$recibo',fecha_atencion='$hoy' 
      WHERE idaveria='$idaveria'";
      ejecutarConsulta($sql_averia);

      $num_elementos1 = 0;

      // Validar si `idarticulo` está vacío
      if (empty($idarticulo) || count($idarticulo) == 0) {
        return true; // Retorna normalmente sin hacer nada
      }
      
        // Insertar y actualizar en las tablas `movimiento_materiales` e `inventario_almacen`
        while ($num_elementos1 < count($idarticulo)) {

            // Insertar en la tabla `detalle_averia`
                  $sql_detalle = "INSERT INTO detalle_averia (
                    idaveria, idalmacen ,idmovimiento_materiales,idcontrato, idarticulo, inicio, fin, cantidad, codigo, costo, tipotrabajo, 
                    nroacta, idcliente, servicio, estado, costosalida, estadomaterial, 
                    estadomovimiento, estadoventa, fecha_hora
                ) VALUES (
                    '$idaveria',
                    '$idalmacen[$num_elementos1]',
                    '$idmovimiento_materiales[$num_elementos1]',
                    '$idcontrato',
                    '$idarticulo[$num_elementos1]', 
                    '$inicio[$num_elementos1]',
                    '$fin[$num_elementos1]',
                    '$cantidad[$num_elementos1]',
                    '$codigo[$num_elementos1]', 
                    '$precio_venta[$num_elementos1]', 
                    '$tipo_trabajo', 
                    '$nroacta', 
                    '$idpersona', 
                    '$servicio', 
                    '0', 
                    '0', 
                    '$estadomaterial[$num_elementos1]', 
                    '4', 
                    '3',
                    NOW()
                )";

              if (!ejecutarConsulta($sql_detalle)) {
              throw new Exception("Error al insertar en detalle_averia");
              }
            // Actualizar `cantidadusado` en la tabla `movimiento_materiales`
            $sql_detalle_update = "UPDATE movimiento_materiales 
                                  SET cantidadusado = cantidadusado + '$cantidad[$num_elementos1]' 
                                  WHERE idmovimiento_materiales = '$idmovimiento_materiales[$num_elementos1]' 
                                  AND idtecnico = '$idusuario'";
            
            if (!ejecutarConsulta($sql_detalle_update)) {
                throw new Exception("Error al actualizar cantidadusado en movimiento_materiales");
            }

            // Obtener los valores actuales de cantidadsalida, cantidadusado y cantidaddevuelto
            $sql_validar = "SELECT cantidadsalida, cantidadusado, cantidaddevuelto 
                            FROM movimiento_materiales 
                            WHERE idmovimiento_materiales = '$idmovimiento_materiales[$num_elementos1]' 
                            AND idtecnico = '$idusuario'";
            
            $resultado = ejecutarConsultaSimpleFila($sql_validar);
            
            if ($resultado) {
                $cantidadsalida = $resultado['cantidadsalida'];
                $cantidadusado = $resultado['cantidadusado'];
                $cantidadevuelto = $resultado['cantidaddevuelto'];

                // Validar si cantidadsalida es igual a cantidadusado + cantidaddevuelto
                if ($cantidadsalida == ($cantidadusado + $cantidadevuelto)) {
                    $sql_actualizar_estado = "UPDATE movimiento_materiales 
                                              SET estado = 1 
                                              WHERE idmovimiento_materiales = '$idmovimiento_materiales[$num_elementos1]' 
                                              AND idtecnico = '$idusuario'";
                    
                    if (!ejecutarConsulta($sql_actualizar_estado)) {
                        throw new Exception("Error al actualizar el estado en movimiento_materiales");
                    }
                }
            } else {
                throw new Exception("Error al obtener los valores de movimiento_materiales");
            }

            // Actualizar el stock en la tabla `inventario_almacen`
            $sql_detalle_update_almacen = "UPDATE inventario_almacen 
                                          SET stock_salida = stock_salida + '$cantidad[$num_elementos1]' 
                                          WHERE idarticulo = '$idarticulo[$num_elementos1]' 
                                          AND idalmacen = '$idalmacen[$num_elementos1]'";
            
            if (!ejecutarConsulta($sql_detalle_update_almacen)) {
                throw new Exception("Error al actualizar stock_salida en inventario_almacen");
            }

            $num_elementos1++;
        }

      if($radioTipoVenta == 'Contado'){
       
       if($total_importe >0){
                $sqlinsert ="INSERT INTO pago(idcontrato,idaveria,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                VALUES('$idcontrato',
                      '$idaveria',
                      '$idbanco',
                      '$idusuario',
                      '$idpersona',
                      '$tipo_pago',
                      '$idcaja',
                      '$total_importe',
                      '$hoy',
                      '$descripcion_tecnico',
                      '$recibo',
                      '$nroperacion',
                      '$categoriaingreso',
                      '$tipotrabajo')";
        return  ejecutarConsulta($sqlinsert);
       }else{
        return true;
       }

      }else if($radioTipoVenta == 'Cuota'){

       // Obtener los valores actuales idcuota
       $sql_validar_cuota = "SELECT c.idcuota  FROM cuota c
       WHERE c.idcontrato = '$idcontrato' ORDER BY c.idcuota ";
       $resultado = ejecutarConsultaSimpleFila($sql_validar_cuota);

       if ($resultado) {
         $idcuota = $resultado['idcuota'];

             $sql_actualizar_cuota = "UPDATE cuota 
                                       SET monto = '$total_importe', montopagado='$adelanto_letra',nrorecibo='$recibo',fecha_cancelacion='$hoy',comentario_mensualidad='$descripcion_tecnico',estado_cuota='2',idaveria='$idaveria' 
                                       WHERE idcuota = '$idcuota'";
             
             if (!ejecutarConsulta($sql_actualizar_cuota)) {
                 throw new Exception("Error al actualizar cuota");
             }
       
     } else {
         throw new Exception("Error al obtener los valores de cuota");
     } 

        $sql_cuota="SELECT c.idcuota  FROM cuota c
        WHERE c.idcontrato = '$idcontrato' and c.estado_cuota='1' ORDER BY c.idcuota ";
        $luna3 = ejecutarConsulta($sql_cuota);
        $j=1;
        while ($sol3 = mysqli_fetch_array($luna3)){
        $idv = $sol3["idcuota"];
                   // if($j==0){
                    $cuotajorge=$monto_letra;
                   if($j<=$cantidad_letra && $j>0){
                      $cuotajorge=$monto_letra;
                      $averia=$idaveria;
                      $cuoave='Cuota de Equipo';
                      $descricuota=$cuoave." ".$j."/".$cantidad_letra ;
                    } else{
                      $cuotajorge=0.00;
                      $averia=0;
                      $descricuota='';
                    }
                  
                    $updsql="UPDATE cuota set montocuota='$cuotajorge',descripcion_cuota='$descricuota',idaveria='$averia' where idcontrato='$idcontrato' and idcuota='$idv' and estado_cuota='1' and montocuota='0'";
                    ejecutarConsulta($updsql); 
                    $j=$j+1;
          } 

        $sqlinsert ="INSERT INTO pago(idcontrato,idaveria,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                    VALUES('$idcontrato',
                          '$idaveria',
                          '$idbanco',
                          '$idusuario',
                          '$idpersona',
                          '$tipo_pago',
                          '$idcaja',
                          '$adelanto_letra',
                          '$hoy',
                          '$descripcion_tecnico',
                          '$recibo',
                          '$nroperacion',
                          '$categoriaingreso',
                          '$tipotrabajo')";
        return  ejecutarConsulta($sqlinsert);

      }else if($radioTipoVenta == 'Prestado'){
        
       //  if($total_importe >0){
      //           $sqlinsert ="INSERT INTO pago(idcontrato,idaveria,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
      //           VALUES('$idcontrato',
      //                 '$idaveria',
      //                 '$idbanco',
      //                 '$idusuario',
      //                 '$idpersona',
      //                 '$tipo_pago',
      //                 '$idcaja',
      //                 '$total_importe',
      //                 '$hoy',
      //                 '$descripcion_tecnico',
      //                 '$recibo',
      //                 '$nroperacion',
      //                 '$categoriaingreso',
      //                 '$tipotrabajo')";
      //   return  ejecutarConsulta($sqlinsert);
       //}else{
        return true;
       //}
      }
    }

    public function guardaryeditar_ficharecojo($idaveria,$idpersona,$idusuario,$radioTipoVenta,$costocontado,$adelanto,$totalequipo,$adelanto_letra,$cantidad_letra,$monto_letra,$tipo_pago,$idbanco,$nroperacion,$recibo,$descripcion_tecnico,$nroacta,$servicio,$tipo_trabajo,$idcaja,$total_importe,$tipotrabajo,$categoriaingreso,$idcontrato,$imagen,$imagen_anterior){

      $hoy=date("Y-m-d H:i:s");

      $sqlimagen="UPDATE imagen SET imagen='$imagen' WHERE imagen='$imagen_anterior'";
      ejecutarConsulta($sqlimagen);

      $sql_averia="UPDATE averia SET nro_acta='$nroacta',descripcion_averia='$descripcion_tecnico',
      inicial='$adelanto_letra',numeroletra='$cantidad_letra',
      montoletra='$monto_letra',tipoventa='$radioTipoVenta',tipo_pago='$tipo_pago',
      idbanco='$idbanco',monto_atencion='$costocontado',nro_operacion='$nroperacion',nro_recibo='$recibo',fecha_atencion='$hoy' 
      WHERE idaveria='$idaveria'";
      ejecutarConsulta($sql_averia);


      if($radioTipoVenta == 'Contado'){
       
       if($costocontado >0){
                $sqlinsert ="INSERT INTO pago(idcontrato,idaveria,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                VALUES('$idcontrato',
                      '$idaveria',
                      '$idbanco',
                      '$idusuario',
                      '$idpersona',
                      '$tipo_pago',
                      '$idcaja',
                      '$costocontado',
                      '$hoy',
                      '$descripcion_tecnico',
                      '$recibo',
                      '$nroperacion',
                      '$categoriaingreso',
                      '$tipotrabajo')";
        return  ejecutarConsulta($sqlinsert);
       }else{
        return true;
       }

      }
    }

    public function guardaryeditar_fichavisita($idaveria,$idpersona,$idusuario,$descripcion_tecnico,$nroacta,$estado_averia){

      $hoy=date("Y-m-d H:i:s");

      $sql_chat="INSERT INTO chataveria(idaveria,idusuario,descripcion) VALUES('$idaveria','$idusuario','$descripcion_tecnico')";
      ejecutarConsulta($sql_chat); 

      $sql_averia="UPDATE averia SET nro_acta='$nroacta',descripcion_averia='$descripcion_tecnico',inicial='0',numeroletra='0',idbanco='0',monto_atencion='0',nro_operacion='0',
       nro_recibo='0',tipoventa='Visita',fecha_atencion='$hoy',estado_averia='$estado_averia' 
      WHERE idaveria='$idaveria'";
      return ejecutarConsulta($sql_averia);
    }

       function procesarImagen($origen, $destino, $max_width, $max_height, $calidad, $extension) {
          list($ancho, $alto) = getimagesize($origen);
          $ratio = $ancho / $alto;
      
          if ($max_width / $max_height > $ratio) {
              $max_width = $max_height * $ratio;
          } else {
              $max_height = $max_width / $ratio;
          }
      
          $nuevaImagen = imagecreatetruecolor($max_width, $max_height);
      
          // Cargar imagen según su formato
          if ($extension == "jpg" || $extension == "jpeg") {
              $imagenOrigen = imagecreatefromjpeg($origen);
          } elseif ($extension == "png") {
              $imagenOrigen = imagecreatefrompng($origen);
              imagealphablending($nuevaImagen, false);
              imagesavealpha($nuevaImagen, true);
          } else {
              return false;
          }
      
          // Redimensionar la imagen
          imagecopyresampled($nuevaImagen, $imagenOrigen, 0, 0, 0, 0, $max_width, $max_height, $ancho, $alto);
      
          // Guardar la imagen comprimida
          if ($extension == "jpg" || $extension == "jpeg") {
              imagejpeg($nuevaImagen, $destino, $calidad);
          } elseif ($extension == "png") {
              imagepng($nuevaImagen, $destino, 8); // Compresión PNG (0-9)
          }
      
          imagedestroy($imagenOrigen);
          imagedestroy($nuevaImagen);
          
          return true;
      }
      
        public function mostrar_trabajo_averia($idaveria)
      {
        $sql="SELECT * FROM averia a
              JOIN agenda g on a.idaveria=g.idaveria
              where a.idaveria='$idaveria'";
        $resultAveria = ejecutarConsulta($sql);

        $averias = [];
        while ($row = $resultAveria->fetch_assoc()) {
        $averias[] = $row;
      }
        // Respuesta JSON
      return [
          "averias" => $averias
          ];
      }
      
         public function actualizarImagenContrato($idcontrato, $imagenes){
    foreach ($imagenes as $imagen) {
        $anterior = $imagen['anterior'];
        $nueva = $imagen['nueva'];

            if ($anterior !== $nueva) {
                if (!empty($anterior)) {
                    // Si hay imagen anterior, hacer UPDATE
                    $sql = "UPDATE imagen 
                            SET imagen = '$nueva' 
                            WHERE idaveria = '$idcontrato' AND imagen = '$anterior'";
                } else {
                    // Si no hay imagen anterior, hacer INSERT
                    $sql = "INSERT INTO imagen (idaveria, imagen) 
                            VALUES ('$idcontrato', '$nueva')";
                }
                $resultado = ejecutarConsulta($sql);
                if (!$resultado) {
                    return false;
                }
            }
        }
        return true;
    }
    
     public function actualizarImagenAveria($idcontrato_averia, $idaveria, $imagenes, $imagenes2) {
    // Procesar las primeras imágenes con idcontrato_averia
    foreach ($imagenes as $imagen) {
        $anterior = $imagen['anterior'];
        $nueva = $imagen['nueva'];

        if ($anterior !== $nueva) {
            if (!empty($anterior)) {
                // UPDATE cuando existe imagen anterior
                $sql = "UPDATE imagen 
                        SET imagen = '$nueva' 
                        WHERE idaveria = '$idcontrato_averia' AND imagen = '$anterior'";
            } else {
                // INSERT si no hay imagen anterior
                $sql = "INSERT INTO imagen (idaveria, imagen) 
                        VALUES ('$idcontrato_averia', '$nueva')";
            }

            $resultado = ejecutarConsulta($sql);
            if (!$resultado) {
                return false;
            }
        }
    }

    // Procesar las segundas imágenes con idaveria
    foreach ($imagenes2 as $imagen) {
        $anterior = $imagen['anterior'];
        $nueva = $imagen['nueva'];

        if ($anterior !== $nueva) {
            if (!empty($anterior)) {
                $sql = "UPDATE imagen 
                        SET imagen = '$nueva' 
                        WHERE idaveria = '$idaveria' AND imagen = '$anterior'";
            } else {
                $sql = "INSERT INTO imagen (idaveria, imagen) 
                        VALUES ('$idaveria', '$nueva')";
            }

            $resultado = ejecutarConsulta($sql);
            if (!$resultado) {
                return false;
            }
        }
    }

    return true;
}

  }

 ?>