<?php
//Incluimos conexion a la base de trader_cdlrisefall3methods
require "../config/Conexion.php";

Class Consulta
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }
    
    public function insert($idusuario,$idverificar,$nroperacion,$idbanco,$fecha,$hora,$motivo)
    {
      $fecha_hora = $fecha . ' ' . $hora;
      $sql="UPDATE  verificar_cuota SET banco='$idbanco', nroperacion='$nroperacion', fecha='$fecha_hora',comentario='$motivo',idusuario='$idusuario' WHERE idverificar='$idverificar'  ";
      return ejecutarConsulta($sql);
    }

    public function pagar_cuota($idverificar,$idcaja)
    {
      $traer_datos="SELECT v.idcuota,v.nroperacion,v.montopagado,v.fecha,v.banco,v.idusuario,b.nombre,v.idcontrato,c.idtecnologia,c.idcliente 
                    FROM verificar_cuota v 
                    JOIN banco b ON b.idbanco=v.banco 
                    JOIN contrato c ON c.idcontrato=v.idcontrato
                    WHERE v.idverificar='$idverificar'";
      $resultado = ejecutarConsultaSimpleFila($traer_datos);
      $idcuota = $resultado['idcuota'];
      $nroperacion = $resultado['nroperacion'];
      $montopagado = $resultado['montopagado'];
      $fecha_cancelacion = $resultado['fecha'];
      $idbanco = $resultado['banco'];
      $idusuario = $resultado['idusuario'];
      $nombre_banco = $resultado['nombre'];
      $idtecnologia_cancelacion = $resultado['idtecnologia'];
      $idcliente = $resultado['idcliente'];
      $idcontrato_cancelacion = $resultado['idcontrato'];

      $sql_pago="SELECT COUNT(*) as count FROM pago WHERE nro_operacion = '$nroperacion'";
      $resultado_pago=ejecutarConsultaSimpleFila($sql_pago);

      $contador=$resultado_pago['count'];
      if($contador >= 1){
        return "Error Nroperacion Duplicado";
      }else{
       
      }

      $comentario_total="Pago Cancelacion";
      $comentario_anidado = $comentario_total."-".$nombre_banco. "-".$nroperacion."-".$fecha_cancelacion;

      $validar_cuota="SELECT estado_cuota FROM cuota WHERE idcuota='$idcuota'";
      $resultado_cuota = ejecutarConsultaSimpleFila($validar_cuota);
      $estado_cuota = $resultado_cuota['estado_cuota'];


      if($idtecnologia_cancelacion == 1){
        $categoriaingreso='14';
        $tipotrabajo='38';
      }else if($idtecnologia_cancelacion == 2){
        $categoriaingreso='14';
        $tipotrabajo='0';
      }else if($idtecnologia_cancelacion == 3){
        $categoriaingreso='14';
       $tipotrabajo='37';   
       }else if($idtecnologia_cancelacion == 4){
        $categoriaingreso='14';
        $tipotrabajo='40';
       }else if($idtecnologia_cancelacion == 5){
       $categoriaingreso='14';
       $tipotrabajo='41';
       }else if($idtecnologia_cancelacion == 6){
       $categoriaingreso='14';
       $tipotrabajo='39';
       }

      if($estado_cuota == 1){

        $fecha_año = date("Y");
        $fecha_mes = date("m");
        $variable = $fecha_mes . $fecha_año;

        $ultimoCorrelativo = "SELECT count(nrorecibo) as ultimocorrelativo FROM correlativo_facturacion ";
        $ultimo = ejecutarConsultaSimpleFila($ultimoCorrelativo);
        $corre = $ultimo["ultimocorrelativo"] + 1;

        $correlativo= "F".$variable."-"."00".$corre;

        $insercorrelativo="INSERT INTO correlativo_facturacion (nrorecibo) VALUES('$correlativo')";
        ejecutarConsulta($insercorrelativo);

        $sql="UPDATE  cuota SET idbanco='$idbanco', montopagado='$montopagado', numero_operacion='$nroperacion', nrorecibo='$correlativo', fecha_cancelacion='$fecha_cancelacion', 
        comentario_mensualidad='$comentario_anidado', idusuario='$idusuario',estado_cuota='2',formapago='3'  WHERE idcuota='$idcuota'";
        ejecutarConsulta($sql);

        $sqlinsert ="INSERT INTO pago(idcontrato,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                    VALUES('$idcontrato_cancelacion',
                          '$idbanco',
                          '$idusuario',
                          '$idcliente',
                          '3',
                          '$idcaja',
                          '$montopagado',
                          '$fecha_cancelacion',
                          '$comentario_anidado',
                          '$correlativo',
                          '$nroperacion',
                          '$categoriaingreso',
                          '$tipotrabajo')";
         ejecutarConsulta($sqlinsert); 
         
         $resultado_actualizacion = $this->actualizar_linea($idcontrato_cancelacion);
          if ($resultado_actualizacion !== true) {
              return $resultado_actualizacion; // Aquí se retorna el error si lo hubo
          }

         $this->enviar_mikrotik($idtecnologia, $idtorre);

        $sql="UPDATE verificar_cuota SET estado='2'
        WHERE idverificar='$idverificar'";
        return ejecutarConsulta($sql) ? "Cuota Cancelada" : "Error al registrar.";
        
      }else{
        return "No puedes volver a pagar la misma cuota!!";
      }

         
    }

    public function listar_incidencia()
    {
      $sql="SELECT i.idincidencia,i.descripcion,i.estado,i.created_at as fecha,c.nrocontrato,c.sit_contrato,p.nombre as persona,
                    i.direccion,c.idcliente,c.idcontrato,i.celular,d.iddireccion,i.latitud,i.longitud,i.referencia   
            FROM incidencia i 
            JOIN contrato c ON c.idcontrato=i.idcontrato
            JOIN persona p ON p.idpersona=c.idcliente
            JOIN detalle_direccion d ON d.iddireccion=c.iddireccion
            ";
      return ejecutarConsulta($sql);
    }

    public function listarkardex($idalmacen)
    {
      $sql="SELECT i.idalmacen,i.stock_ingreso,i.stock_salida,a.codigo,a.nombre as producto, c.nombre as categoria,n.nombre  FROM inventario_almacen i join articulo a on i.idarticulo=a.idarticulo join categoria c on a.idcategoria=c.idcategoria join almacen n on i.idalmacen=n.idalmacen where i.idalmacen='$idalmacen' ";
      return ejecutarConsulta($sql);
    }

    public function kardex(){
        $sql="SELECT i.idalmacen,i.stock_ingreso,i.stock_salida,a.codigo,a.nombre as producto, c.nombre as categoria  FROM inventario_almacen i join articulo a on i.idarticulo=a.idarticulo join categoria c on a.idcategoria=c.idcategoria where a.condicion='1' ";
        return ejecutarConsulta($sql);
      }
   
    public function listaMovimiento($idtecnico){

    $sql="SELECT m.idmovimiento_materiales,a.nombre,m.marca,m.mac,m.cantidadsalida,m.cantidaddevuelto,m.cantidadusado,m.codigo,m.estado FROM movimiento_materiales m join articulo a on m.idarticulo=a.idarticulo where m.idtecnico='$idtecnico' and m.estado<2";
    return ejecutarConsulta($sql);
    }


    public function listarIngreso(){
      $sql="SELECT p.tipoingreso,p.monto,p.fecha_pago,p.descripcion,p.correlativo_pago,p.nro_operacion,e.nombre as cliente, u.nombre as usuario 
      FROM pago p join persona e on p.idcliente=e.idpersona join usuario u on p.idusuario=u.idusuario
      WHERE DATE(p.fecha_pago)=CURDATE() order by p.idpago desc ";
      return ejecutarConsulta($sql);
    }

    public function listar_usuario($idusuario){
      $sql="SELECT p.tipoingreso,p.monto,p.fecha_pago,p.descripcion,p.correlativo_pago,p.nro_operacion,e.nombre as cliente, u.nombre as usuario 
      FROM pago p join persona e on p.idcliente=e.idpersona join usuario u on p.idusuario=u.idusuario 
      where p.idusuario='$idusuario' and DATE(p.fecha_pago)=CURDATE() order by p.idpago desc";
      return ejecutarConsulta($sql);
    }

    public function listar_administrador($fecha_inicio,$fecha_fin){
      $sql="SELECT p.tipoingreso,p.monto,p.fecha_pago,p.descripcion,p.correlativo_pago,p.nro_operacion,e.nombre as cliente, u.nombre as usuario 
      FROM pago p join persona e on p.idcliente=e.idpersona join usuario u on p.idusuario=u.idusuario 
      where date(p.fecha_pago) BETWEEN '$fecha_inicio' AND '$fecha_fin' order by p.idpago desc";
      return ejecutarConsulta($sql);
    }

     public function listar_fecha_usuario($fecha_inicio,$fecha_fin,$idusuario){
      $sql="SELECT p.tipoingreso,p.monto,p.fecha_pago,p.descripcion,p.correlativo_pago,p.nro_operacion,e.nombre as cliente, u.nombre as usuario 
      FROM pago p join persona e on p.idcliente=e.idpersona join usuario u on p.idusuario=u.idusuario 
      where date(p.fecha_pago) BETWEEN '$fecha_inicio' AND '$fecha_fin' and p.idusuario='$idusuario' order by p.idpago desc";
      return ejecutarConsulta($sql);
    }

    public function listar_caja(){
      $sql="SELECT c.fecha_cierre,c.nrocorrelativo,a.descripcion as caja,c.monto_apertura,c.monto_efectivo,c.monto_deposito,c.imagen,c.descripcion,c.estado_caja,c.idcierre,c.idmovimientocaja 
            FROM movimiento_caja c 
            JOIN caja a ON a.idcaja=c.idcaja  
            WHERE c.estado_caja='2'";
      return ejecutarConsulta($sql);
    }

    public function listar_pago(){
      $sql="SELECT v.idverificar,v.idcuota,v.nroperacion,v.fecha,v.montoapagar,v.montopagado,v.comentario,v.idcontrato,v.estado,v.imagen,p.nombre,v.banco,b.nombre as banco
            FROM  verificar_cuota v
            JOIN contrato c ON c.idcontrato=v.idcontrato
            JOIN banco b ON b.idbanco=v.banco
            JOIN persona p ON p.idpersona=c.idcliente";
      return ejecutarConsulta($sql);
    }

    public function listarEgreso(){
      $sql="SELECT e.idtipo,c.concepto,e.monto,b.nombre as banco,e.nroperacion,e.descripcion,e.tipo_comprobante,e.nrorecibo,e.pago,e.hora  
            FROM egreso e 
            JOIN concepto_egreso c ON c.idconcepto_egreso=e.idconcepto_egreso
            LEFT JOIN banco b ON e.idbanco=b.idbanco";
      return ejecutarConsulta($sql);
    }
    
      public function listarEgreso_usuario($idusuario){
      $sql="SELECT e.idtipo,c.concepto,e.monto,b.nombre as banco,e.nroperacion,e.descripcion,e.tipo_comprobante,e.nrorecibo,e.pago,e.hora,u.nombre as usuario  
            FROM egreso e 
            JOIN concepto_egreso c ON c.idconcepto_egreso=e.idconcepto_egreso
            LEFT JOIN banco b ON e.idbanco=b.idbanco
            JOIN usuario u ON e.idusuario=u.idusuario
            where e.idusuario='$idusuario' ORDER BY e.pago desc";
      return ejecutarConsulta($sql);
    }

    public function mostrar_imagen($idverificar){
          $sql="SELECT idverificar,imagen,banco,nroperacion,date(fecha)as fecha,time(fecha)as hora
            FROM verificar_cuota
            WHERE idverificar='$idverificar' ";
            $resultCabecera = ejecutarConsulta($sql);

          $cabeceras = [];
          while ($row = $resultCabecera->fetch_assoc()) {
          $cabeceras[] = $row; // Almacenamos las cabeceras
          }

          return [
            "cabeceras" => $cabeceras
            ];

    
    }
     public function eliminar($idverificar){

      $sql="DELETE verificar_cuota WHERE idverificar='$idverificar'";
      return ejecutarConsulta($sql);

     }

    public function listar_recaudo($fecha_inicio,$fecha_fin){
      $sql="SELECT c.idcuota,p.nombre as cliente,o.nrocontrato,p.num_documento,d.description,c.monto,c.fecha_pago,c.montocuota,c.fechainicial
            FROM cuota c 
            JOIN contrato o ON c.idcontrato=o.idcontrato 
            JOIN persona p ON o.idcliente=p.idpersona
            LEFT JOIN detalle_direccion d ON o.iddireccion=d.iddireccion 
            WHERE date(c.fecha_pago) BETWEEN '$fecha_inicio' AND '$fecha_fin' and c.estado_cuota='1' and c.estado_contrato='1'";
      return ejecutarConsulta($sql);
    }

    public function mostrar_pendiente($fecha_inicio,$fecha_fin)
    {
      $sql = "SELECT c.idcontrato, p.nombre as cliente, o.paga
      FROM cuota c 
      JOIN contrato o ON c.idcontrato=o.idcontrato
      JOIN persona p ON o.idcliente=p.idpersona
      WHERE date(c.fecha_pago) BETWEEN '$fecha_inicio' and '$fecha_fin' 
      AND c.estado_contrato='1' AND c.estado_cuota='1' AND o.sit_contrato!='baja' 
      GROUP BY o.idcontrato ORDER BY c.idcuota DESC";
        $resultCabecera = ejecutarConsulta($sql);

        $cabeceras = [];
        while ($row = $resultCabecera->fetch_assoc()) {
        $cabeceras[] = $row; // Almacenamos las cabeceras
        }

        // Array donde almacenaremos los detalles para cada idcontrato
        $detalles = [];

        foreach ($cabeceras as $cabecera) {
        $idcontrato = $cabecera['idcontrato'];

        // Consulta para obtener los detalles de cada contrato
        $sqldetalle = "SELECT month(c.fechainicial) as mes, c.fechainicial, c.fechavencimiento, c.fecha_pago, c.monto, o.sit_contrato,c.idcontrato
                    FROM cuota c 
                    JOIN contrato o ON c.idcontrato=o.idcontrato
                    WHERE date(c.fecha_pago) BETWEEN '$fecha_inicio' and '$fecha_fin' 
                    AND c.idcontrato='$idcontrato' AND c.estado_contrato='1' AND c.estado_cuota='1'";

        $resultDetalles = ejecutarConsulta($sqldetalle);
        $detallesContrato = []; // Array para almacenar los detalles de este contrato

        while ($detalle = $resultDetalles->fetch_assoc()) {
          // Consulta para obtener la cantidad de movimientos
          $sqlmovimiento = "SELECT count(idmovimiento_llamada) as cantidad 
                            FROM movimiento_llamada 
                            WHERE idcontrato = '$idcontrato' AND tipo = '4' 
                            GROUP BY idcontrato";
          $resultMovimiento = ejecutarConsulta($sqlmovimiento);

          // Obtener la cantidad de movimientos
          $cantidad = 0; // Valor predeterminado si no hay resultados
          if ($rowMovimiento = $resultMovimiento->fetch_assoc()) {
              $cantidad = $rowMovimiento['cantidad'];
          }

          // Agregar la cantidad de movimientos al detalle
          $detalle['cantidad_movimientos'] = $cantidad;

          // Almacenamos los detalles de este contrato en el array de detalles
          $detallesContrato[] = $detalle;
        }

        // Asociamos los detalles a la cabecera correspondiente
        $detalles[$idcontrato] = $detallesContrato;
        }

        // Respuesta JSON: tenemos dos arrays, uno para las cabeceras y otro para los detalles
        return [
        "cabeceras" => $cabeceras,
        "detalles" => $detalles
        ];
    }

    public function mostrar_finanza($anio,$mes)
    {
        // Obtener todas las categorías de ingreso
        $sql_ingreso = "SELECT idcategoria_ingreso, nombre as categoria FROM categoria_ingreso ORDER BY nombre ASC";
        $resultCabecerai = ejecutarConsulta($sql_ingreso);

        $cabeceras_ingreso = [];
        $detalles_ingreso = [];

        while ($row = $resultCabecerai->fetch_assoc()) {
            $row['total_monto'] = 0; // Inicializamos el monto total en 0
            $cabeceras_ingreso[$row['idcategoria_ingreso']] = $row;
        }

        foreach ($cabeceras_ingreso as $idcategoria_ingreso => &$cabecera_ingreso) {
            // Consulta para obtener los detalles de cada categoría
            $sqldetalle_ingreso = "SELECT c.idconcepto_ingreso, c.tipo_trabajo, SUM(p.monto) AS monto 
                                  FROM concepto_ingreso c 
                                  LEFT JOIN pago p ON p.idconcepto_ingreso = c.idconcepto_ingreso 
                                  AND YEAR(p.fecha_pago)='$anio' 
                                  AND MONTH(p.fecha_pago)='$mes'
                                  WHERE c.idcategoria_ingreso = '$idcategoria_ingreso' 
                                  GROUP BY c.idconcepto_ingreso";
            $resultDetalles_ingreso = ejecutarConsulta($sqldetalle_ingreso);

            $detallesIngreso = [];
            $totalMonto = 0; // Variable para almacenar la suma total por categoría

            while ($rowDetalle = $resultDetalles_ingreso->fetch_assoc()) {
                // Si el monto es NULL, lo establecemos en 0
                $rowDetalle['monto'] = $rowDetalle['monto'] ?? 0;
                $detallesIngreso[] = $rowDetalle;
                $totalMonto += $rowDetalle['monto']; // Sumamos el monto total
            }

            // Guardamos los detalles en la categoría
            $detalles_ingreso[$idcategoria_ingreso] = $detallesIngreso;
            // Guardamos el monto total en la cabecera de la categoría
            $cabecera_ingreso['total_monto'] = $totalMonto;
        }

        // Obtener todas las categorías de egreso
        $sql_egreso = "SELECT idcategoria_egreso, nombre as categoria FROM categoria_egreso ORDER BY nombre ASC";
        $resultCabecerae = ejecutarConsulta($sql_egreso);

        $cabeceras_egreso = [];
        $detalles_egreso = [];

        while ($rowe = $resultCabecerae->fetch_assoc()) {
            $rowe['total_monto'] = 0; // Inicializamos el monto total en 0
            $cabeceras_egreso[$rowe['idcategoria_egreso']] = $rowe;
        }

        foreach ($cabeceras_egreso as $idcategoria_egreso => &$cabecera_egreso) {
          // Consulta para obtener los detalles de cada categoría
          $sqldetalle_egreso = "SELECT c.idconcepto_egreso, c.concepto, SUM(e.monto) AS monto 
                                FROM concepto_egreso c 
                                LEFT JOIN egreso e ON e.idconcepto_egreso = c.idconcepto_egreso
                                AND year(e.fechapago)='$anio'
                                AND month(e.fechapago)='$mes'
                                WHERE c.idcategoria_egreso = '$idcategoria_egreso' 
                                GROUP BY c.idconcepto_egreso";
          $resultDetalles_egreso = ejecutarConsulta($sqldetalle_egreso);

          $detallesEgreso = [];
          $totalMontoo = 0; // Variable para almacenar la suma total por categoría

          while ($rowDetallee = $resultDetalles_egreso->fetch_assoc()) {
              // Si el monto es NULL, lo establecemos en 0
              $rowDetallee['monto'] = $rowDetallee['monto'] ?? 0;
              $detallesEgreso[] = $rowDetallee;
              $totalMontoo += $rowDetallee['monto']; // Sumamos el monto total
          }

          // Guardamos los detalles en la categoría
          $detalles_egreso[$idcategoria_egreso] = $detallesEgreso;
          // Guardamos el monto total en la cabecera de la categoría
          $cabecera_egreso['total_monto'] = $totalMontoo;
      }

        // Respuesta JSON
        return [
            "cabeceras_ingreso" => array_values($cabeceras_ingreso), // Convertir en array numérico
            "detalles_ingreso" => $detalles_ingreso,
            "cabeceras_egreso" => array_values($cabeceras_egreso), 
            "detalles_egreso" => $detalles_egreso
        ];
    }
    
    
    public function mostrar_llamada($fecha_inicio,$fecha_fin)
    {
      $sql = "SELECT u.nombre as usuario,m.idusuario
                FROM movimiento_llamada m 
                JOIN usuario u ON u.idusuario=m.idusuario
                WHERE date(m.created_at) BETWEEN '$fecha_inicio' and '$fecha_fin' AND m.tipo='4'  
                GROUP BY u.nombre";
                $resultCabecera = ejecutarConsulta($sql);

        $cabeceras = [];
        while ($row = $resultCabecera->fetch_assoc()) {
        $cabeceras[] = $row; // Almacenamos las cabeceras
        }

        // Array donde almacenaremos los detalles para cada idcontrato
        $detalles = [];

        foreach ($cabeceras as $cabecera) {
        $idusuario = $cabecera['idusuario'];

        // Consulta para obtener los detalles de cada contrato
        $sqldetalle = "SELECT date(m.created_at) as fecha,o.nrocontrato,p.nombre as cliente,s.nombre as servicio,t.nombre as tecnologia,m.descripcion
                    FROM movimiento_llamada m 
                    LEFT JOIN contrato o ON o.idcontrato=m.idcontrato
                    JOIN persona p ON p.idpersona=m.idcliente
                    JOIN servicio s ON s.idservicio=o.idservicio
                    JOIN tecnologia t ON t.idtecnologia=o.idtecnologia
                    WHERE date(m.created_at) BETWEEN '$fecha_inicio' and '$fecha_fin' and  m.idusuario='$idusuario'
                    AND m.tipo='4'";

        $resultDetalles = ejecutarConsulta($sqldetalle);
        $detallesContrato = []; // Array para almacenar los detalles de este contrato

        while ($detalle = $resultDetalles->fetch_assoc()) {
          // Almacenamos los detalles de este contrato en el array de detalles
          $detallesContrato[] = $detalle;
        }

        // Asociamos los detalles a la cabecera correspondiente
        $detalles[$idusuario] = $detallesContrato;
        }

        // Respuesta JSON: tenemos dos arrays, uno para las cabeceras y otro para los detalles
        return [
        "cabeceras" => $cabeceras,
        "detalles" => $detalles
        ];
    }



    public function grafico_venta()
    {
      $queryVentas="SELECT MONTH(v.fecha_pago) AS mes,SUM(v.monto) AS total_ventas
      FROM pago v 
      WHERE YEAR(v.fecha_pago) = YEAR(CURDATE())
      GROUP BY MONTH(v.fecha_pago) ORDER BY mes";
      $resultVentas = ejecutarConsulta($queryVentas);

      $ventas = array_fill(0, 12, 0);

      // Recorremos los resultados y asignamos los valores al mes correspondiente
      while ($row = $resultVentas->fetch_assoc()) {
          $mes = (int)$row['mes']; // Obtenemos el número de mes (1-12)
          $ventas[$mes - 1] = (float)$row['total_ventas']; // Restamos 1 porque el array es 0-indexado
      }

      $queryEgresos="SELECT MONTH(pago) AS mes_egreso,SUM(monto) AS total_egresos
      FROM egreso e 
      WHERE YEAR(e.pago) = YEAR(CURDATE())
      GROUP BY MONTH(pago) ORDER BY mes_egreso";
      $resultEgresos = ejecutarConsulta($queryEgresos);

      $egresos = array_fill(0, 12, 0);

      // Recorremos los resultados y asignamos los valores al mes correspondiente
      while ($row = $resultEgresos->fetch_assoc()) {
          $mes_egreso = (int)$row['mes_egreso']; // Obtenemos el número de mes (1-12)
          $egresos[$mes_egreso - 1] = (float)$row['total_egresos']; // Restamos 1 porque el array es 0-indexado
      }
        // Respuesta JSON
        return [
        "ventas" => $ventas,
        "egresos" => $egresos
        ];
    }

    public function actualizar_incidencia($idincidencia){

      $sql_update="UPDATE incidencia SET estado='2' WHERE idincidencia='$idincidencia'";
      return ejecutarConsulta($sql_update) ? "Incidencia Cerrada" : "No puedes cerrar la Incidencia.";
    }
    public function listar_acta(){
      $sql="SELECT d.iddetalle,a.nombre as producto,d.cantidad,d.codigo,d.costo,d.tipotrabajo,d.nroacta,p.nombre as cliente,date(d.fecha_hora)as fecha_hora,u.nombre as tecnico
            FROM  detalle_averia d
            JOIN averia v on v.idaveria=d.idaveria
            JOIN usuario u on u.idusuario=v.idtecnico
            JOIN articulo a ON a.idarticulo=d.idarticulo 
            JOIN persona p ON p.idpersona=d.idcliente
            order by d.iddetalle asc";
      return ejecutarConsulta($sql);
    }
    
    public function actualizar_linea($idcontrato_cancelacion)
    {
      $consulta_linea = "SELECT k.idmkrotik, k.idcontrato, k.sit_linea, c.sit_contrato 
                        FROM mikrotik k 
                        JOIN contrato c ON c.idcontrato = k.idcontrato WHERE k.idcontrato='$idcontrato_cancelacion'";

      $resultado_linea = ejecutarConsulta($consulta_linea);
      if (!$resultado_linea) {
          echo "Error al ejecutar la consulta.";
          return;
      }

      $contador_actualizados = 0;
      $contador_procesados = 0;

      while ($fila_linea = $resultado_linea->fetch_assoc()) {
          $sit_linea = $fila_linea["sit_linea"];
          $id_contrato = $fila_linea["idcontrato"];

          if (!in_array($sit_linea, ['pendiente', 'listo' ,'baja', 'suspende'])) {
              $contador_procesados++;

              $accion = 'activa';
              $esnotifica = 0;
              $escorte = 0;

              $consulta_cuotas = "SELECT fecha_pago FROM cuota 
                                  WHERE idcontrato = '$id_contrato' AND estado_cuota = '1' AND estado_contrato = '1'  
                                  ORDER BY idcuota ASC LIMIT 1";

              $fila_cuotas = ejecutarConsultaSimpleFila($consulta_cuotas);

              if ($fila_cuotas) {
                  $fecha_actual = date("Y-m-d");
                  $fechavence_cuota = $fila_cuotas["fecha_pago"];
                  $fechavence_cuota2 = date("Y-m-d", strtotime("$fechavence_cuota + 3 days"));

                  if ($fecha_actual > $fechavence_cuota && $fecha_actual <= $fechavence_cuota2) {
                      $esnotifica = 1;
                  }
                  if ($fecha_actual > $fechavence_cuota2) {
                      $escorte = 1;
                  }
              }

              if ($esnotifica == 1) $accion = 'notifica';
              if ($escorte == 1) $accion = 'corte';

              $actualizado = false;

              switch ($accion) {
                  case 'notifica':
                      if ($sit_linea != 'notifica') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'corte':
                      if ($sit_linea != 'corte') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte',estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'activa':
                      if ($sit_linea != 'activa') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa',estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
              }

              if ($actualizado) {
                  $contador_actualizados++;
              }
          }
      }

      if ($contador_procesados == 0) {
        return "No se procesaron líneas para el contrato.";
    }

    return true; // Todo bien
    }

    public function enviar_mikrotik($idtecnologia, $idtorre) {

      $sql_torre = "SELECT * FROM torre WHERE idtorre='$idtorre'";
      $resultado_torre = ejecutarConsultaSimpleFila($sql_torre);
  
      // Validamos si la consulta falló o no devolvió resultados
      if (!$resultado_torre || empty($resultado_torre)) {
          echo json_encode(["status" => "error", "message" => "Error al obtener los datos de la Torre."]);
          return;
      }
  
      $servidor_torre = $resultado_torre['servidor_torre'] ?? null;
      $usuario_torre = $resultado_torre['usuario_torre'] ?? null;
      $pass_torre = $resultado_torre['pass_torre'] ?? null;
  
      // Validamos que los datos esenciales no sean nulos
      if (!$servidor_torre || !$usuario_torre || !$pass_torre) {
          echo json_encode(["status" => "error", "message" => "Faltan datos esenciales de la Torre."]);
          return;
      }
     
      require_once '../config/api_mt_include2.php';
      $API = new routeros_api();
      $API->debug = false;

      // Credenciales de conexión a MikroTik
     // $servidor_torre = '209.45.52.2';
     // $usuario_torre = 'radhyo1';
     // $pass_torre = 'c4b3rl456#$';

      // Conectar a MikroTik
      if (!$API->connect($servidor_torre, $usuario_torre, $pass_torre, '8728')) {
          echo json_encode(["status" => "error", "message" => "Error al conectar con MikroTik."]);
          return;
      }
      // Contadores por estado
      $contador_listo = 0;
      $contador_activa = 0;
      $contador_notifica = 0;
      $contador_corte = 0;
      $contador_suspende = 0;
      $contador_baja = 0;
      $contador_existentes = 0;

// Consulta para obtener usuarios en cualquier estado relevante
  $consulta_usuarios = "
      SELECT m.idcontrato, m.usuario, m.password, p.nombre_plan, m.comentario_linea, m.sit_linea, m.mac_linea, m.ip_linea, p.upload_servicio, p.download_servicio
      FROM mikrotik m
      JOIN contrato c ON c.idcontrato = m.idcontrato
      JOIN planes p ON p.idplan = c.idplan
      WHERE m.idtorre = '$idtorre' 
      AND m.idtecnologia = '$idtecnologia' 
      AND m.cambio_linea='si'
      AND m.sit_linea IN ('listo', 'activa', 'notifica', 'corte', 'suspende', 'baja')";

  $resultado_usuarios = ejecutarConsulta($consulta_usuarios);

  if (!$resultado_usuarios) {
      echo json_encode(["status" => "error", "message" => "Error al ejecutar la consulta de usuarios."]);
      $API->disconnect();
      return;
  }

          if($idtecnologia == 1 ){

              while ($fila = $resultado_usuarios->fetch_assoc()) {

                  $comentario_linea = trim($fila["comentario_linea"]);
                  $id_linea = $fila["idcontrato"];
                  $estado_actual = trim($fila["sit_linea"]);
                  $mac_linea = trim($fila["mac_linea"]);
                  $velocidad_linea = trim($fila["upload_servicio"]);
                  $velocidad2_linea = trim($fila["download_servicio"]);
                  $ip_linea = trim($fila["ip_linea"]);

                  $API->write("/ip/hotspot/ip-binding/print", false);
                  $API->write("?mac-address=" . $mac_linea, true);
                  $usuarios_existente = $API->read();
              
                  // 🔹 Filtrar y obtener el ID del usuario correcto en MikroTik
                  $id_usuario = null;
                  if (!empty($usuarios_existente) && is_array($usuarios_existente)) {
                      foreach ($usuarios_existente as $usr) {
                          if (isset($usr['mac-address']) && strtolower(trim($usr['mac-address'])) === strtolower(trim($mac_linea))) {
                              $id_usuario = $usr[".id"];
                              break;
                          }
                      }
                  }

                   // Verificar si el usuario ya existe en MikroTik
                      $API->write("/ip/hotspot/user/print", false);
                      $API->write("?name=" . $mac_linea, true);
                      $usuarios_mac = $API->read();

                      $id_usuario_mac = null;
                      if (!empty($usuarios_mac) && is_array($usuarios_mac)) {
                          foreach ($usuarios_mac as $usr) {
                              if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                  $id_usuario_mac = $usr[".id"];
                                  break;
                              }
                          }
                      }

                      $API->write("/queue/simple/print", false);
                      $API->write("?name=" . $mac_linea, true);
                      $usuarios_queue = $API->read();

                      $id_usuario_queue = null;
                      if (!empty($usuarios_queue) && is_array($usuarios_queue)) {
                          foreach ($usuarios_queue as $usr) {
                              if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                  $id_usuario_queue = $usr[".id"];
                                  break;
                              }
                          }
                      }

                  switch ($estado_actual) {
                      case 'listo':
                          if (empty($id_usuario_mac) || empty($id_usuario) || empty($id_usuario_queue)) { 

                              // Agregar usuario a MikroTik
                               $API->write("/ip/hotspot/ip-binding/add",false);	
                               $API->write("=address=$ip_linea",false);
                               $API->write("=type=bypassed",false);
                               $API->write("=comment=$comentario_linea",false);
                               $API->write("=mac-address=$mac_linea",true);
                               $API->read();

                               $API->write("/queue/simple/add",false);	
                               $API->write("=name=$mac_linea",false);
                               $API->write("=comment=$comentario_linea",false);
                               $API->write("=max-limit=$velocidad2_linea/$velocidad_linea",false);
                               $API->write("=queue=default-small/default-small",false);
                               $API->write("=target=$ip_linea",true);
                               $API->read();


                              $API->write("/ip/hotspot/user/add", false);
                              $API->write("=profile=Notice", false);
                              $API->write("=comment=$comentario_linea(activa)", false);
                              $API->write("=name=$mac_linea", true);
                              $API->read();

                              //sleep(1);
                              // Asegurar que la consulta devuelve un array válido
                              $API->write("/ip/hotspot/user/print", false);
                              $API->write("?name=" . $mac_linea, true);
                              $usuarios_mac = $API->read();
          
                              if (!empty($usuarios_mac) && is_array($usuarios_mac)) {
                                  foreach ($usuarios_mac as $usr) {
                                      if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                          $id_usuario_mac = $usr[".id"];
                                          break;
                                      }
                                  }
                              }
          
                              if (!empty($id_usuario_mac)) {
                                  // Si el usuario se creó correctamente, lo deshabilitamos
                                  $API->write("/ip/hotspot/user/disable", false);
                                  $API->write("=.id=" . $id_usuario_mac, true);
                                  $API->read();
                          
                              }
                              // Actualizar estado en la base de datos
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '2' WHERE idcontrato = '$id_linea'");
              
                              $contador_listo++;
                          } else {
                              $contador_existentes++;
                          }
                          break;

                          case 'activa':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                   // 🔹 Actualizar el perfil y comentario del usuario en Hotspot
                                  if (!empty($id_usuario)) {
                                      $API->write("/ip/hotspot/ip-binding/enable", false);
                                      $API->write("=.id=" . $id_usuario, true);
                                      $API->read();
                                  }
                                  // 🔹 Habilitar el usuario en Hotspot si existe
                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/set", false);	
                                      $API->write("=profile=Notice", false);
                                      $API->write("=comment=$comentario_linea(activa)", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();

                                      $API->write("/ip/hotspot/user/enable", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }

                                  // 🔹 Actualizar la cola de velocidad si existe
                                  if (!empty($id_usuario_queue)) {
                                      $API->write("/queue/simple/set", false);	
                                      $API->write("=comment=$comentario_linea", false);
                                      $API->write("=max-limit=$velocidad2_linea/$velocidad_linea", false);
                                      $API->write("=.id=" . $id_usuario_queue, true);
                                      $API->read();
                                  }

                                  ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                  ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                                  $contador_activa++;
                              }
                          break;

                          case 'notifica':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/set", false);	
                                      $API->write("=profile=Notice", false);
                                      $API->write("=comment=$comentario_linea(notifica)", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }

                                  ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                  ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                                  $contador_notifica++;
                              }
                          break;

                          case 'corte':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/set", false);	
                                      $API->write("=profile=bill", false);
                                      $API->write("=comment=$comentario_linea(corte)", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();

                                      $API->write("/ip/hotspot/host/remove", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }
                                  if (!empty($id_usuario)) {
                                      $API->write("/ip/hotspot/ip-binding/disable", false);
                                      $API->write("=.id=" . $id_usuario, true);
                                      $API->read();
                                  }

                                  ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                  ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                              }
                              $contador_corte++;
                          break;

                          case 'suspende':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                  if (!empty($id_usuario)) {
                                      $API->write("/ip/hotspot/ip-binding/disable", false);
                                      $API->write("=.id=" . $id_usuario, true);
                                      $API->read();
                                  }

                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/set", false);	
                                      $API->write("=profile=Notice", false);
                                      $API->write("=comment=$comentario_linea(suspende)", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();

                                      $API->write("/ip/hotspot/user/disable", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }

                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'suspende', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'suspende', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                              }
                              $contador_suspende++;
                          break;

                          case 'baja':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                  if (!empty($id_usuario)) {
                                      $API->write("/ip/hotspot/ip-binding/remove", false);
                                      $API->write("=.id=" . $id_usuario, true);
                                      $API->read();
                                  }
                                  if (!empty($id_usuario_queue)) {
                                      $API->write("/queue/simple/remove", false);	
                                      $API->write("=.id=" . $id_usuario_queue, true);
                                      $API->read();
                                  }
                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/remove", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }
                              }

                               ejecutarConsulta("DELETE mikrotik  WHERE idcontrato = '$id_linea'");
                               ejecutarConsulta("UPDATE contrato SET sit_contrato = 'baja', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                              $contador_baja++;
                          break;
                  }
              }
              $API->disconnect();

           }else if ($idtecnologia == 3){

              while ($fila = $resultado_usuarios->fetch_assoc()) {
                  $usuario = trim($fila["usuario"]);
                  $password = trim($fila["password"]);
                  $planes = trim($fila["nombre_plan"]);
                  $comentario_linea = trim($fila["comentario_linea"]);
                  $id_linea = $fila["idcontrato"];
                  $estado_actual = trim($fila["sit_linea"]);
              
                  // Verificar si el usuario ya existe en MikroTik
                  $API->write("/ppp/secret/print", false);
                  $API->write("?name=" . $usuario, true);
                  $usuarios_existente = $API->read();
              
                  // 🔹 Filtrar y obtener el ID del usuario correcto en MikroTik
                  $id_usuario = null;
                  foreach ($usuarios_existente as $usr) {
                      if ($usr['name'] === $usuario) {
                          $id_usuario = $usr[".id"];
                          break;
                      }
                  }
              
                  switch ($estado_actual) {
                      case 'listo':
                          if (empty($usuarios_existente)) {
                              // Agregar usuario a MikroTik
                              $API->write("/ppp/secret/add", false);
                              $API->write("=name=" . $usuario, false);
                              $API->write("=password=" . $password, false);
                              $API->write("=service=pppoe", false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $comentario_linea . "(activa)", true);
                              $API->read();
              
                              // Obtener el ID del usuario agregado
                              $API->write("/ppp/secret/print", false);
                              $API->write("?name=" . $usuario, true);
                              $usuario_creado = $API->read();
              
                              if (!empty($usuario_creado)) {
                                  $id_usuario = $usuario_creado[0][".id"];
              
                                  // 🔹 Deshabilitar usuario
                                  $API->write("/ppp/secret/disable", false);
                                  $API->write("=.id=" . $id_usuario, true);
                                  $API->read();
                              }
              
                              // Actualizar estado en la base de datos
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '2' WHERE idcontrato = '$id_linea'");
              
                              $contador_listo++;
                          } else {
                              $contador_existentes++;
                          }
                          break;
              
                      case 'activa':
                          if ($id_usuario !== null) {
                              $nuevo_comentario = $comentario_linea . "(activa)";
              
                              $API->write("/ppp/secret/set", false);
                              $API->write("=.id=" . $id_usuario, false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $nuevo_comentario, true);
                              $API->read();
              
                              // Habilitar usuario
                              $API->write("/ppp/secret/enable", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();
              
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_activa++;
                          }
                          break;
              
                      case 'notifica':
                          if ($id_usuario !== null) {
                              $nuevo_comentario = $comentario_linea . "(notifica)";
              
                              $API->write("/ppp/secret/set", false);
                              $API->write("=.id=" . $id_usuario, false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $nuevo_comentario, true);
                              $API->read();
              
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_notifica++;
                          }
                          break;
              
                      case 'corte':
                          if ($id_usuario !== null) {
                              $nuevo_comentario = $comentario_linea . "(corte)";
              
                              $API->write("/ppp/secret/set", false);
                              $API->write("=.id=" . $id_usuario, false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $nuevo_comentario, true);
                              $API->read();

                              $API->write("/ppp/active/remove", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();
              
                              // Deshabilitar usuario
                              $API->write("/ppp/secret/disable", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();
              
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_corte++;
                          }
                          break;
              
                      case 'suspende':
                          if ($id_usuario !== null) {
                              $nuevo_comentario = $comentario_linea . "(suspende)";
              
                              $API->write("/ppp/secret/set", false);
                              $API->write("=.id=" . $id_usuario, false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $nuevo_comentario, true);
                              $API->read();
              
                              // Deshabilitar usuario
                              $API->write("/ppp/secret/disable", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();
              
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'suspende', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'suspende', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_suspende++;
                          }
                          break;
              
                      case 'baja':
                          if ($id_usuario !== null) {
                              $API->write("/ppp/secret/remove", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();

                              ejecutarConsulta("DELETE mikrotik  WHERE idcontrato = '$id_linea'");
                               ejecutarConsulta("UPDATE contrato SET sit_contrato = 'baja', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_baja++;
                          }
                          break;
                  }
              }
              $API->disconnect();
          } 
  }
  
  public function actualizar_linea_pendiente($fecha_inicio,$fecha_fin)
    {
        $consulta_linea = "SELECT k.idmkrotik, k.idcontrato, k.sit_linea, c.sit_contrato 
                            FROM mikrotik k 
                            JOIN contrato c ON c.idcontrato = k.idcontrato
                            WHERE k.idcontrato IN (SELECT c.idcontrato
                                                    FROM cuota c 
                                                    JOIN contrato o ON c.idcontrato=o.idcontrato
                                                    WHERE date(c.fecha_pago) BETWEEN '$fecha_inicio' and '$fecha_fin' 
                                                    AND c.estado_contrato='1' AND c.estado_cuota='1' AND o.sit_contrato!='baja' 
                                                    GROUP BY o.idcontrato ORDER BY c.idcuota DESC)";

      $resultado_linea = ejecutarConsulta($consulta_linea);
      if (!$resultado_linea) {
          echo "Error al ejecutar la consulta.";
          return;
      }

      $contador_actualizados = 0;
      $contador_procesados = 0;

      while ($fila_linea = $resultado_linea->fetch_assoc()) {
          $sit_linea = $fila_linea["sit_linea"];
          $id_contrato = $fila_linea["idcontrato"];

          if (!in_array($sit_linea, ['pendiente', 'listo' ,'baja', 'suspende'])) {
              $contador_procesados++;

              $accion = 'activa';
              $esnotifica = 0;
              $escorte = 0;

              $consulta_cuotas = "SELECT fecha_pago FROM cuota 
                                  WHERE idcontrato = '$id_contrato' AND estado_cuota = '1' AND estado_contrato = '1'  
                                  ORDER BY idcuota ASC LIMIT 1";

              $fila_cuotas = ejecutarConsultaSimpleFila($consulta_cuotas);

              if ($fila_cuotas) {
                  $fecha_actual = date("Y-m-d");
                  $fechavence_cuota = $fila_cuotas["fecha_pago"];
                  $fechavence_cuota2 = date("Y-m-d", strtotime("$fechavence_cuota + 3 days"));

                  if ($fecha_actual > $fechavence_cuota && $fecha_actual <= $fechavence_cuota2) {
                      $esnotifica = 1;
                  }
                  if ($fecha_actual > $fechavence_cuota2) {
                      $escorte = 1;
                  }
              }

              if ($esnotifica == 1) $accion = 'notifica';
              if ($escorte == 1) $accion = 'corte';

              $actualizado = false;

              switch ($accion) {
                  case 'notifica':
                      if ($sit_linea != 'notifica') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'corte':
                      if ($sit_linea != 'corte') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte',estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'activa':
                      if ($sit_linea != 'activa') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa',estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
              }

              if ($actualizado) {
                  $contador_actualizados++;
              }
          }
      }

      // Enviar respuesta JSON
        echo json_encode([
            "status" => "success",
            "procesados" => $contador_procesados,
            "actualizados" => $contador_actualizados
        ]);
    }
    
    public function listar_pendiente_actualizar()
     {
      $sql="SELECT p.nombre,c.nrocontrato,c.sit_contrato,c.montomensualidad   
            FROM contrato c 
            JOIN persona p ON c.idcliente=p.idpersona
            WHERE c.estado_actualizar='2' and c.estado_contrato='Activo'";
      return ejecutarConsulta($sql);
    }

      public function actualizar_procesados()
    {
        $consulta_linea = "SELECT k.idmkrotik, k.idcontrato, k.sit_linea, c.sit_contrato 
                            FROM mikrotik k 
                            JOIN contrato c ON c.idcontrato = k.idcontrato
                            WHERE c.estado_actualizar='2' ";

      $resultado_linea = ejecutarConsulta($consulta_linea);
      if (!$resultado_linea) {
          echo "Error al ejecutar la consulta.";
          return;
      }

      $contador_actualizados = 0;
      $contador_procesados = 0;

      while ($fila_linea = $resultado_linea->fetch_assoc()) {
          $sit_linea = $fila_linea["sit_linea"];
          $id_contrato = $fila_linea["idcontrato"];

          if (!in_array($sit_linea, ['pendiente', 'listo' ,'baja', 'suspende'])) {
              $contador_procesados++;

              $accion = 'activa';
              $esnotifica = 0;
              $escorte = 0;

              $consulta_cuotas = "SELECT fecha_pago FROM cuota 
                                  WHERE idcontrato = '$id_contrato' AND estado_cuota = '1' AND estado_contrato = '1'  
                                  ORDER BY idcuota ASC LIMIT 1";

              $fila_cuotas = ejecutarConsultaSimpleFila($consulta_cuotas);

              if ($fila_cuotas) {
                  $fecha_actual = date("Y-m-d");
                  $fechavence_cuota = $fila_cuotas["fecha_pago"];
                  $fechavence_cuota2 = date("Y-m-d", strtotime("$fechavence_cuota + 3 days"));

                  if ($fecha_actual > $fechavence_cuota && $fecha_actual <= $fechavence_cuota2) {
                      $esnotifica = 1;
                  }
                  if ($fecha_actual > $fechavence_cuota2) {
                      $escorte = 1;
                  }
              }

              if ($esnotifica == 1) $accion = 'notifica';
              if ($escorte == 1) $accion = 'corte';

              $actualizado = false;

              switch ($accion) {
                  case 'notifica':
                      if ($sit_linea != 'notifica') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar='1' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'corte':
                      if ($sit_linea != 'corte') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte',estado_actualizar='1' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'activa':
                      if ($sit_linea != 'activa') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa',estado_actualizar='1' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                      
              
              }
                ejecutarConsulta("UPDATE contrato SET estado_actualizar='1' WHERE idcontrato = '$id_contrato'");
              if ($actualizado) {
                  $contador_actualizados++;
              }
          }
      }

      // Enviar respuesta JSON
        echo json_encode([
            "status" => "success",
            "procesados" => $contador_procesados,
            "actualizados" => $contador_actualizados
        ]);
    }
    
     public function mostrar_pendiente_egreso($fecha_inicio,$fecha_fin){
          $sql="SELECT c.idconcepto_egreso,c.idcategoria_egreso,c.tipo,c.concepto,c.descripcion,c.nombre_pago,c.descripcion_pago,c.mes_anterior,c.precio_luz,c.monto,d.fechavencimiento,d.numero_cuota 
                FROM concepto_egreso c JOIN detalle_egreso d ON c.idconcepto_egreso=d.idconcepto_egreso
                WHERE d.fechavencimiento BETWEEN '$fecha_inicio' and '$fecha_fin' and d.estado='1' order by d.fechavencimiento asc";
            $resultCabecera = ejecutarConsulta($sql);

          $cabeceras = [];
          while ($row = $resultCabecera->fetch_assoc()) {
          $cabeceras[] = $row; // Almacenamos las cabeceras
          }

          return [
            "cabeceras" => $cabeceras
            ];
    }
    
     public function lista_sorteo(){

    $sql="SELECT * FROM sorteo";
    return ejecutarConsulta($sql);
    }



  }

 ?>