<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('America/Lima');
require "../config/Conexion.php";
Class Contrato
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }
  public function insertar($idusuario,$idpersona,$iddireccion,$fecha_hora,$idservicio,$idtecnologia,$idolt,$idplan,$desplan,$mensualidad,$idtorre,$idrepetidor,$tipo,$fechapago,$paga,$modalidad,$fechainstalacion,$descripcion,$idcategoria_ingreso,$idconcepto_ingreso,$codigotipo_comprobante,$nombre_cliente,$upload_servicio,$download_servicio,$radioComision,$idpersona_comision) {
    $sw = true;

    try {
        $saber = "SELECT serie, count(correlativo)+1 as correlativo FROM contrato";
        $saberExiste = ejecutarConsultaSimpleFila($saber);

        if ($saberExiste["serie"] == null) {
            $fecha_año = date("Y");
            $fecha_mes = date("m");
            $serie = $fecha_mes . $fecha_año;
            $correlativo = '0001';
        } else {
            $cero = '000';  
            $correlativo = $cero . $saberExiste["correlativo"];
            $fecha_año = date("Y");
            $fecha_mes = date("m");
            $serie = $fecha_mes . $fecha_año;
        }

        $final = $serie . "-" . $correlativo;

        $sql = "INSERT INTO contrato (idcliente, idusuario, idservicio, idtecnologia, idplan, idtorre, idrepetidor, idolt, iddireccion, user_id, serie, correlativo, tipo, fechapago, fecha_hora, fechainstalacion, paga, modalidad, nrocontrato, estado_contrato, sit_contrato, descripcion, desplan, codigotipo_comprobante, montomensualidad, comision, idpersona_comision) 
                VALUES ('$idpersona', $idusuario, '$idservicio', '$idtecnologia', '$idplan', '$idtorre' , '$idrepetidor' , '$idolt', '$iddireccion', '$idusuario', '$serie', '$correlativo', '$tipo', '$fechapago', '$fecha_hora', '$fechainstalacion', '$paga', '$modalidad', '$final', 'Activo', 'pendiente', '$descripcion', '$desplan', '$codigotipo_comprobante', '$mensualidad','$radioComision','$idpersona_comision')";
        $idcontrato = ejecutarConsulta_retornarID($sql);

        $linea="INSERT INTO mikrotik (idcontrato,sit_linea,idtorre,idtecnologia,idolt,idrepetidor,comentario_linea,estado,velocidad2_linea,velocidad_linea)
                 VALUES('$idcontrato','pendiente', '$idtorre' ,'$idtecnologia','$idolt','$idrepetidor','$nombre_cliente',1,'$upload_servicio','$download_servicio')";
                 ejecutarConsulta($linea);

        $movimiento_contrato="INSERT INTO movimiento_contrato (idcontrato,idusuario,idplan,sit_contrato)
        VALUES('$idcontrato','$idusuario', '$idplan' ,'pendiente')";
        ejecutarConsulta($movimiento_contrato);

        if (!$idcontrato) {
            $sw = false;
            return $sw;
        }

        if($paga == 'Mes Adelantado'){
            $diai = date('d', strtotime($fechainstalacion));
            $mes = date('m', strtotime($fechainstalacion));
            $anio = date('Y', strtotime($fechainstalacion));
            $mes1 = $mes - 1;
    
            $fechav = $anio . "-" . $mes1 . "-" . $diai;
            $fechap = $anio . "-" . $mes1 . "-" . $fechapago;
        }else if($paga == 'Mes Cumplido'){
            $diai = date('d', strtotime($fechainstalacion));
            $mes = date('m', strtotime($fechainstalacion));
            $anio = date('Y', strtotime($fechainstalacion));
            $mes1 = $mes - 1;

            $fechav = $anio . "-" . $mes1 . "-" . $diai;
            $fechap = $anio . "-" . $mes . "-" . $fechapago;
        }

        $pago = $mensualidad; // Valor inicial
        $j = 0;
        for ($contador = 1; $contador <= $tipo; $contador++) {
            if ($diai == 31 || $diai == 30 || $diai==29 || $diai==28  ) {
                $fechai = date("Y-m-d", strtotime("last day of this month" . $fechav . "+" . $contador . " month"));
                $fechavi = date("Y-m-d", strtotime("last day of this month" . $fechainstalacion . "+" . $contador . " month"));
                $fechapa = date("Y-m-d", strtotime("last day of this month" . $fechap . "+" . $contador . " month"));
            } else {
                $fechai = date("Y-m-d", strtotime($fechav . "+" . $contador . " month"));
                $fechavi = date("Y-m-d", strtotime($fechainstalacion . "+" . $contador . " month"));
                $fechapa = date("Y-m-d", strtotime($fechap . "+" . $contador . " month"));
            }
            // Debug: Mostrar fechas generadas
            error_log("Fechai: $fechai, Fechavi: $fechavi, Fechapa: $fechapa");

            if ($j == 0) {
                $cone = "INSERT INTO cuota (idcontrato, fechainicial, fechavencimiento, monto, montopagado, estado_contrato, fecha_cuota, montocuota, fecha_pago, estado_facturacion, descripcion, comentario_mensualidad, numero_operacion, estado_cuota)
                         VALUES ('$idcontrato', '$fechai', '$fechavi', '0', '0', '1', NOW(), '0', '$fechapa', '1',  'Cuota del Equipo', '$descripcion', '0' ,'1')";
                if (!ejecutarConsulta($cone)) {
                    $sw = false;
                    error_log("Error al insertar la primera cuota: $cone");
                    break;
                }
            } else {
                
            }
            $cone = "INSERT INTO cuota (idcontrato, fechainicial, fechavencimiento, monto, montopagado, estado_contrato, fecha_cuota, montocuota, fecha_pago, estado_facturacion, descripcion, estado_cuota)
                     VALUES ('$idcontrato', '$fechai', '$fechavi', '$pago', '0', '1', NOW(), '0', '$fechapa', '1', 'Monto Mensualidad','1')";
            if (!ejecutarConsulta($cone)) {
                $sw = false;
                break;
            }
            $j++;
        }
    } catch (Exception $e) {
       // error_log("Excepción: " . $e->getMessage());
        $sw = false;
        echo "Error: " . $e->getMessage();
    }

    return $sw;
}

    public function listarcontrato()
    {
      $sql="SELECT c.idcontrato,
                    c.nrocontrato,
                    date(fecha_hora)as fecha_hora,
                    c.sit_contrato,
                    c.modalidad,
                    c.idtecnologia,
                     c.estado_contrato,
                    c.codigotipo_comprobante,
                    p.nombre as cliente,
                    p.num_documento,
                    s.nombre as servicio, 
                    a.nombre_plan,
                    c.estado_actualizar
                    FROM contrato c 
                    join persona p on c.idcliente=p.idpersona 
                    join servicio s on c.idservicio=s.idservicio 
                    LEFT JOIN planes a on c.idplan=a.idplan WHERE c.sit_contrato!='negra'
                    ORDER BY c.idcontrato desc";
      return ejecutarConsulta($sql);
    }

    public function mostrar($idcontrato)
    {
      $sql="SELECT * FROM contrato where idcontrato='$idcontrato'";
      $resultContratos = ejecutarConsulta($sql);

      $contratos = [];
      while ($row = $resultContratos->fetch_assoc()) {
      $contratos[] = $row;
    }

      $sqlcuota="SELECT * FROM cuota where idcontrato='$idcontrato'";
      $resultCuotas = ejecutarConsulta($sqlcuota);

      $cuotas = [];
      while ($row = $resultCuotas->fetch_assoc()) {
      $cuotas[] = $row;
    }
      // Respuesta JSON
    return [
        "contratos" => $contratos,
        "cuotas" => $cuotas
        ];
    }

    public function editar_contrato($idcontrato,$situ_contrato,$estado_contrato,$idusuario,$idpersona,$iddireccion,$idservicio,$idtecnologia,$idolt,$idplan,$desplan,$mensualidad,$idtorre,$idrepetidor,$descripcion,$upload_servicio,$download_servicio,$paga)
    {

              if(trim(strtolower($estado_contrato)) == 'Cancelado' || trim(strtolower($situ_contrato)) == 'baja'){
            
              $update_cuota="UPDATE cuota  SET monto='0',comentario_mensualidad='CONTRATO EN ESTADO DE BAJA', estado_cuota='2', estado_contrato='2'   
              WHERE idcontrato='$idcontrato' and estado_cuota='1' and estado_contrato='1'";
              ejecutarConsulta($update_cuota);

              $sql = "UPDATE  contrato  SET idusuario='$idusuario',idtecnologia='$idtecnologia',idplan='$idplan',idtorre='$idtorre',idrepetidor='$idrepetidor',paga='$paga',
                          idolt='$idolt',iddireccion='$iddireccion',user_id='$idusuario', estado_contrato='Cancelado',sit_contrato='$situ_contrato',estado_actualizar = '2',
                            descripcion='$descripcion', desplan='$desplan', montomensualidad='$mensualidad' WHERE idcontrato='$idcontrato'"; 
            ejecutarConsulta($sql);

              $linea="UPDATE mikrotik SET sit_linea='$situ_contrato',idtorre='$idtorre',idtecnologia='$idtecnologia',idolt='$idolt',idrepetidor='$idrepetidor',
                          estado='1',velocidad2_linea='$upload_servicio',velocidad_linea='$download_servicio',cambio_linea='si' WHERE idcontrato='$idcontrato'";
              ejecutarConsulta($linea);
              
              $sql_eliminar="DELETE FROM mikrotik WHERE idcontrato='$idcontrato'";
              ejecutarConsulta($sql_eliminar);
                       

              $movimiento_contrato="INSERT INTO movimiento_contrato (idcontrato,idusuario,idplan,sit_contrato)
                                  VALUES('$idcontrato','$idusuario', '$idplan' ,'$situ_contrato')";
                                $result= ejecutarConsulta($movimiento_contrato);
                                if ($result) {
                                  echo json_encode(["status" => "success", "message" => "Contrato dado de Baja."]);
                                  return;
                              } else {
                                  echo json_encode(["status" => "error", "message" => "Error al actualizar Contrato."]);
                                  return;
                              }
             }else if(trim(strtolower($estado_contrato)) == 'Activo' || trim(strtolower($situ_contrato)) == 'suspende'){

               $update_cuota="UPDATE cuota  SET monto='0',comentario_mensualidad='CONTRATO EN ESTADO DE SUSPENSION', estado_cuota='2', estado_contrato='2'   
              WHERE idcontrato='$idcontrato' and estado_cuota='1' and estado_contrato='1'";
              ejecutarConsulta($update_cuota);

              $sql = "UPDATE  contrato  SET idusuario='$idusuario',idtecnologia='$idtecnologia',idplan='$idplan',idtorre='$idtorre',idrepetidor='$idrepetidor',paga='$paga',
                          idolt='$idolt',iddireccion='$iddireccion',user_id='$idusuario', estado_contrato='Activo',sit_contrato='$situ_contrato',estado_actualizar = '2',
                            descripcion='$descripcion', desplan='$desplan', montomensualidad='$mensualidad' WHERE idcontrato='$idcontrato'"; 
            ejecutarConsulta($sql);

              $linea="UPDATE mikrotik SET sit_linea='$situ_contrato',idtorre='$idtorre',idtecnologia='$idtecnologia',idolt='$idolt',idrepetidor='$idrepetidor',
                          estado='1',velocidad2_linea='$upload_servicio',velocidad_linea='$download_servicio',cambio_linea='si' WHERE idcontrato='$idcontrato'";
              ejecutarConsulta($linea);

              $movimiento_contrato="INSERT INTO movimiento_contrato (idcontrato,idusuario,idplan,sit_contrato)
                                  VALUES('$idcontrato','$idusuario', '$idplan' ,'$situ_contrato')";
                                $result= ejecutarConsulta($movimiento_contrato);
                                if ($result) {
                                  echo json_encode(["status" => "success", "message" => "Contrato Suspendido"]);
                                  return;
                              } else {
                                  echo json_encode(["status" => "error", "message" => "Error al actualizar Contrato."]);
                                  return;
                              }                 
                              
            }else if(trim(strtolower($estado_contrato)) == 'Activo' || trim(strtolower($situ_contrato)) == 'listo'){

              $validar_mikrotik="SELECT count(idcontrato)as contador FROM mikrotik WHERE idcontrato='$idcontrato'";
              $consulta_mikrotik = ejecutarConsultaSimpleFila($validar_mikrotik);
              $contador=$consulta_mikrotik['contador'];

              if ($contador >0) {

                    $sql_traer_nombre = "SELECT p.nombre FROM contrato c join persona p ON c.idcliente=p.idpersona";
	                $comentario_linea = ejecutarConsultaSimpleFila($sql_traer_nombre);
        	        $comentario=$comentario_linea['nombre'];

                      $sql = "UPDATE  contrato  SET idusuario='$idusuario',idtecnologia='$idtecnologia',idplan='$idplan',idtorre='$idtorre',idrepetidor='$idrepetidor',paga='$paga',
                                  idolt='$idolt',iddireccion='$iddireccion',user_id='$idusuario', estado_contrato='Activo',sit_contrato='$situ_contrato',estado_actualizar = '2',
                                    descripcion='$descripcion', desplan='$desplan', montomensualidad='$mensualidad' WHERE idcontrato='$idcontrato'"; 
                    ejecutarConsulta($sql);
                    
                    $sql_update="UPDATE mikrotik set sit_linea='$situ_contrato',idtecnologia='$idtecnologia',idtorre='$idtorre',idolt='$idolt',idrepetidor='$idrepetidor',
                                  cambio_linea='si' WHERE idcontrato='$idcontrato'";
                    ejecutarConsulta($sql_update);

                    $movimiento_contrato="INSERT INTO movimiento_contrato (idcontrato,idusuario,idplan,sit_contrato)
                                          VALUES('$idcontrato','$idusuario', '$idplan' ,'$situ_contrato')";
                                        $result= ejecutarConsulta($movimiento_contrato);
                        // Si ya existe un usuario con otro contrato, no actualizar y devolver error
                        echo json_encode(["status" => "error", "message" => "El contrato ya está registrado en Mikrotik."]);
                        return;
              }else{
              
              		$sql_traer_nombre = "SELECT p.nombre FROM contrato c join persona p ON c.idcliente=p.idpersona";
	                $comentario_linea = ejecutarConsultaSimpleFila($sql_traer_nombre);
        	        $comentario=$comentario_linea['nombre'];

                      $sql = "UPDATE  contrato  SET idusuario='$idusuario',idtecnologia='$idtecnologia',idplan='$idplan',idtorre='$idtorre',idrepetidor='$idrepetidor',paga='$paga',
                                  idolt='$idolt',iddireccion='$iddireccion',user_id='$idusuario', estado_contrato='Activo',sit_contrato='$situ_contrato',estado_actualizar = '2',
                                    descripcion='$descripcion', desplan='$desplan', montomensualidad='$mensualidad' WHERE idcontrato='$idcontrato'"; 
                    ejecutarConsulta($sql);

                      $linea="INSERT INTO mikrotik (idcontrato,sit_linea,idtorre,idtecnologia,idolt,idrepetidor,velocidad_linea,velocidad2_linea,comentario_linea,cambio_linea,estado)
                        VALUES('$idcontrato','$situ_contrato','$idtorre','$idtecnologia','$idolt','$idrepetidor','$upload_servicio','$download_servicio','$comentario','si','1')";
                      ejecutarConsulta($linea);
                      
                     // $update_cuota="UPDATE cuota  SET monto='$mensualidad',comentario_mensualidad='', estado_cuota='1', estado_contrato='1'   
              	    //WHERE idcontrato='$idcontrato'  and estado_contrato='2'";
              			//ejecutarConsulta($update_cuota);

                      $movimiento_contrato="INSERT INTO movimiento_contrato (idcontrato,idusuario,idplan,sit_contrato)
                                          VALUES('$idcontrato','$idusuario', '$idplan' ,'$situ_contrato')";
                                        $result= ejecutarConsulta($movimiento_contrato);
                                        if ($result) {
                                          echo json_encode(["status" => "success", "message" => "Contrato dado de Alta."]);
                                          return;
                                      } else {
                                          echo json_encode(["status" => "error", "message" => "Error al actualizar Contrato."]);
                                          return;
                                      }
                  }

            }else{

            $sql = "UPDATE  contrato  SET idusuario='$idusuario',idtecnologia='$idtecnologia',idplan='$idplan',idtorre='$idtorre',idrepetidor='$idrepetidor',paga='$paga',
                          idolt='$idolt',iddireccion='$iddireccion',user_id='$idusuario', estado_contrato='$estado_contrato',sit_contrato='$situ_contrato',estado_actualizar = '2',
                            descripcion='$descripcion', desplan='$desplan', montomensualidad='$mensualidad' WHERE idcontrato='$idcontrato'"; 
            ejecutarConsulta($sql);

            $linea="UPDATE mikrotik SET sit_linea='$situ_contrato',idtorre='$idtorre',idtecnologia='$idtecnologia',idolt='$idolt',idrepetidor='$idrepetidor',
                          estado='1',velocidad2_linea='$upload_servicio',velocidad_linea='$download_servicio',cambio_linea='si' WHERE idcontrato='$idcontrato'";
                      ejecutarConsulta($linea);

            $update_cuota="UPDATE cuota  SET monto='$mensualidad'  WHERE idcontrato='$idcontrato' and monto>0 and estado_cuota='1'";
            ejecutarConsulta($update_cuota);

              $movimiento_contrato="INSERT INTO movimiento_contrato (idcontrato,idusuario,idplan,sit_contrato)
                                    VALUES('$idcontrato','$idusuario', '$idplan' ,'$situ_contrato')";
                                  $result= ejecutarConsulta($movimiento_contrato);
                                  if ($result) {
                                    echo json_encode(["status" => "success", "message" => "Campos Actualizado del Contrato."]);
                                    return;
                                } else {
                                    echo json_encode(["status" => "error", "message" => "Error al actualizar Contrato."]);
                                    return;
                                }
              }
      
    }

    public function mostrar_fibra($idcontrato)
    {
      $sql="SELECT c.idcontrato,c.sit_contrato,p.num_documento,p.nombre,c.idtorre,c.idolt,c.idplan,m.password,m.usuario  FROM contrato c JOIN persona p on c.idcliente=p.idpersona JOIN mikrotik m on c.idcontrato=m.idcontrato where c.idcontrato='$idcontrato'";
      return  ejecutarConsultaSimpleFila($sql);
    }

    public function mostrar_internet($idcontrato)
    {
      $sql="SELECT c.idcontrato,c.sit_contrato,p.num_documento,p.nombre,c.idtorre,c.idolt,c.idplan,m.idrepetidor,m.mac_linea,m.velocidad_linea,m.velocidad2_linea,m.ip_linea FROM contrato c JOIN persona p on c.idcliente=p.idpersona JOIN mikrotik m on c.idcontrato=m.idcontrato where c.idcontrato='$idcontrato'";
      return  ejecutarConsultaSimpleFila($sql);
    }

    //Implementamos un metodo para eliminar registro
    public function eliminar($idcontrato)
    {
      $sql1="DELETE FROM cuota where idcontrato='$idcontrato'";
      ejecutarConsulta($sql1);
      $sql2="DELETE FROM mikrotik where idcontrato='$idcontrato'";
      ejecutarConsulta($sql2);
      $sql3="DELETE FROM pago where idcontrato='$idcontrato'";
      ejecutarConsulta($sql3);
      $sql4="DELETE FROM contrato where idcontrato='$idcontrato'";
      return ejecutarConsulta($sql4);
    }

    public function getCuota($idcuota)
    {
      $sql="SELECT c.idcuota,c.fechainicial,c.fechavencimiento,date(c.fecha_pago)as fecha_pago,c.monto,c.descripcion,o.sit_contrato,c.montoacuenta,o.idtecnologia,o.idcontrato,o.idtecnologia,o.idcliente,c.comentario_mensualidad FROM cuota c JOIN contrato o on c.idcontrato=o.idcontrato where idcuota='$idcuota' and c.estado_cuota='1'";
      return ejecutarConsultaSimpleFila($sql);
    }

    public function getContrato($contrato_refacturacion)
    {
    //  $sql="SELECT c.idcuota,c.fechainicial,c.fechavencimiento,c.fecha_pago,c.monto,c.descripcion,o.sit_contrato FROM cuota c JOIN contrato o on c.idcontrato=o.idcontrato where o.idcontrato='$contrato_refacturacion' and c.estado_cuota='1' order by c.idcuota asc;";
    //  return ejecutarConsultaSimpleFila($sql);
    }

    public function editar($idcuota,$monto,$comentario_mensualidad,$montocuota,$descripcion_cuota,$fecha_pago,$estado_cuota,$nrorecibo)
    {
      if($estado_cuota == 1){
        
        if($nrorecibo >0){
          $sql="UPDATE cuota SET monto='$monto',comentario_mensualidad='',montocuota='$montocuota',descripcion_cuota='$descripcion_cuota',fecha_pago='$fecha_pago',estado_cuota='$estado_cuota',nrorecibo='',montopagado='',montoacuenta='',idbanco='',numero_operacion='' 
          WHERE idcuota='$idcuota'";
          ejecutarConsulta($sql);
  
          $sql_eliminar="DELETE FROM pago where correlativo_pago='$nrorecibo'";
          return ejecutarConsulta($sql_eliminar);

        }else{
          $sql="UPDATE cuota SET monto='$monto',comentario_mensualidad='$comentario_mensualidad',montocuota='$montocuota',descripcion_cuota='$descripcion_cuota',fecha_pago='$fecha_pago',estado_cuota='$estado_cuota',nrorecibo='',montopagado='',montoacuenta='',idbanco='',numero_operacion='' 
          WHERE idcuota='$idcuota'";
          return ejecutarConsulta($sql);
        }

        
      }else{
        // para el estado pagado

      }
      
    }

    public function editar_fibra($idusuario,$idcontrato, $idtorre, $idolt, $sit_linea, $usuario_cliente, $password, $idplan, $upload_servicio, $download_servicio,$cliente_nombre)
{
   // Si el estado es 'pendiente', cambiarlo a 'listo'
    if ($sit_linea == 'pendiente') {
        $sit_linea = "listo";
    }

    // Verificar si el usuario ya existe en otro contrato
    $sql_verificar = "SELECT idcontrato FROM mikrotik WHERE usuario = '$usuario_cliente' AND idcontrato != '$idcontrato'";
    $consulta = ejecutarConsulta($sql_verificar);
    $resultado = $consulta->fetch_assoc();

    if ($resultado) {
        // Si ya existe un usuario con otro contrato, no actualizar y devolver error
        echo json_encode(["status" => "error", "message" => "El usuario ya existe en otro contrato."]);
        return;
    }

    // Actualizar la tabla contrato
    $sql = "UPDATE contrato SET idtorre='$idtorre', idolt='$idolt', sit_contrato='$sit_linea', idplan='$idplan',estado_actualizar='2' 
            WHERE idcontrato='$idcontrato'";
    ejecutarConsulta($sql);
    
    
      $movimiento_contrato="INSERT INTO movimiento_contrato (idcontrato,idusuario,idplan,sit_contrato)
                                  VALUES('$idcontrato','$idusuario', '$idplan' ,'$sit_linea')";
                             ejecutarConsulta($movimiento_contrato);   

    // Actualizar la tabla mikrotik
    $sql_mikrotik = "UPDATE mikrotik SET idtorre='$idtorre', idolt='$idolt', sit_linea='$sit_linea', cambio_linea='si', 
                     usuario='$usuario_cliente', password='$password', velocidad_linea='$download_servicio', comentario_linea='$cliente_nombre',
                     velocidad2_linea='$upload_servicio' 
                     WHERE idcontrato='$idcontrato'";
    
    $result = ejecutarConsulta($sql_mikrotik);

    if ($result) {
        echo json_encode(["status" => "success", "message" => "Fibra actualizada correctamente."]);
    } else {
        echo json_encode(["status" => "error", "message" => "Error al actualizar Mikrotik."]);
    }
}


    public function editar_internet($idusuario,$idcontrato,$idtorre,$idrepetidor,$sit_linea,$mac_linea,$ip_linea,$idplan,$upload_servicio,$download_servicio,$cliente_nombre)
    {
        if($sit_linea = 'pendiente'){
        $sit_linea = "listo";
       }

      $sql="UPDATE contrato SET idtorre='$idtorre',sit_contrato='$sit_linea',idplan='$idplan',idrepetidor='$idrepetidor',estado_actualizar='2'  
            WHERE idcontrato='$idcontrato'";
      ejecutarConsulta($sql);
      
        $movimiento_contrato="INSERT INTO movimiento_contrato (idcontrato,idusuario,idplan,sit_contrato)
                                  VALUES('$idcontrato','$idusuario', '$idplan' ,'$sit_linea')";
                             ejecutarConsulta($movimiento_contrato);   

      $sql_mikrotik="UPDATE mikrotik SET idtorre='$idtorre',idrepetidor='$idrepetidor',sit_linea='$sit_linea',mac_linea='$mac_linea',ip_linea='$ip_linea',cambio_linea='si',velocidad_linea='$download_servicio',velocidad2_linea='$upload_servicio',comentario_linea='$cliente_nombre' 
            WHERE idcontrato='$idcontrato'";
      return ejecutarConsulta($sql_mikrotik);
    }

    public function mostrardetallecontrato($idcontrato)
    {
      $sql="SELECT c.nrocontrato,c.sit_contrato,c.idplan,p.precio,d.address,p.nombre_plan as nombre,a.nombre as cliente,d.description FROM contrato c JOIN detalle_direccion d on c.iddireccion=d.iddireccion join planes p on c.idplan=p.idplan join persona a on c.idcliente=a.idpersona where c.idcontrato='$idcontrato'";
      return  ejecutarConsultaSimpleFila($sql);
    }

    public function guardarfacturacion($idcuota_cancelacion,$tipo_pago,$forma_pago,$idbanco,$nro_operacion,$fecha_cancelacion,$monto_acuenta,$pago_cancelacion,$comentario_cancelacion,$idusuario,$idcontrato_cancelacion,$idtecnologia_cancelacion,$idcliente,$idcaja,$nombre_banco,$monto_pagar)
    {
        
        $ultimoCuota = "SELECT count(idcuota) as cantidad,fechavencimiento FROM cuota WHERE idcontrato='$idcontrato_cancelacion' and estado_cuota='1' ";
        $ultimo_cuo = ejecutarConsultaSimpleFila($ultimoCuota);
        $cantidad = $ultimo_cuo["cantidad"];
        $fechainstalacion = $ultimo_cuo["fechavencimiento"];

        if($cantidad == 1){

          $mostra_contrato = "SELECT * FROM contrato WHERE idcontrato='$idcontrato_cancelacion'";
          $result_contrato = ejecutarConsultaSimpleFila($mostra_contrato);
          $mensualidad = $result_contrato['montomensualidad'];
          $paga = $result_contrato['paga'];
          $fechapago = $result_contrato['fechapago'];
          $tipo = $result_contrato['tipo'];
          $idtecnologia = $result_contrato['idtecnologia'];
          $idtorre = $result_contrato['idtorre'];

          if($paga == 'Mes Adelantado'){
            $diai = date('d', strtotime($fechainstalacion));
            $mes = date('m', strtotime($fechainstalacion));
            $anio = date('Y', strtotime($fechainstalacion));
            $mes1 = $mes - 1;
    
            $fechav = $anio . "-" . $mes1 . "-" . $diai;
            $fechap = $anio . "-" . $mes1 . "-" . $fechapago;
        }else if($paga == 'Mes Cumplido'){
            $diai = date('d', strtotime($fechainstalacion));
            $mes = date('m', strtotime($fechainstalacion));
            $anio = date('Y', strtotime($fechainstalacion));
            $mes1 = $mes - 1;

            $fechav = $anio . "-" . $mes1 . "-" . $diai;
            $fechap = $anio . "-" . $mes . "-" . $fechapago;
        }
        
        $pago = $mensualidad; // Valor inicial
        $j = 0;
        for ($contador = 1; $contador <= $tipo; $contador++) {
            if ($diai == 31 || $diai == 30 || $diai==29 || $diai==28  ) {
                $fechai = date("Y-m-d", strtotime("last day of this month" . $fechav . "+" . $contador . " month"));
                $fechavi = date("Y-m-d", strtotime("last day of this month" . $fechainstalacion . "+" . $contador . " month"));
                $fechapa = date("Y-m-d", strtotime("last day of this month" . $fechap . "+" . $contador . " month"));
            } else {
                $fechai = date("Y-m-d", strtotime($fechav . "+" . $contador . " month"));
                $fechavi = date("Y-m-d", strtotime($fechainstalacion . "+" . $contador . " month"));
                $fechapa = date("Y-m-d", strtotime($fechap . "+" . $contador . " month"));
            }
            // Debug: Mostrar fechas generadas
            error_log("Fechai: $fechai, Fechavi: $fechavi, Fechapa: $fechapa");

            $cone = "INSERT INTO cuota (idcontrato, fechainicial, fechavencimiento, monto, montopagado, estado_contrato, fecha_cuota, montocuota, fecha_pago, estado_facturacion, descripcion, estado_cuota)
                     VALUES ('$idcontrato_cancelacion', '$fechai', '$fechavi', '$pago', '0', '1', NOW(), '0', '$fechapa', '1', 'Monto Mensualidad','1')";
            if (!ejecutarConsulta($cone)) {
                $sw = false;
                break;
            }
            $j++;
        }

        $fecha_año = date("Y");
        $fecha_mes = date("m");
        $variable = $fecha_mes . $fecha_año;

        $ultimoCorrelativo = "SELECT count(nrorecibo) as ultimocorrelativo FROM correlativo_facturacion ";
        $ultimo = ejecutarConsultaSimpleFila($ultimoCorrelativo);
        $corre = $ultimo["ultimocorrelativo"] + 1;

        $correlativo= "F".$variable."-"."00".$corre;

        $insercorrelativo="INSERT INTO correlativo_facturacion (nrorecibo) VALUES('$correlativo')";
        ejecutarConsulta($insercorrelativo);

        if($idtecnologia_cancelacion == 1){
          $categoriaingreso='14';
          $tipotrabajo='38';
        }else if($idtecnologia_cancelacion == 2){
          $categoriaingreso='14';
          $tipotrabajo='0';
        }else if($idtecnologia_cancelacion == 3){
          $categoriaingreso='14';
         $tipotrabajo='37';   
         }else if($idtecnologia_cancelacion == 4){
          $categoriaingreso='14';
          $tipotrabajo='40';
         }else if($idtecnologia_cancelacion == 5){
         $categoriaingreso='14';
         $tipotrabajo='41';
         }else if($idtecnologia_cancelacion == 6){
         $categoriaingreso='14';
         $tipotrabajo='39';
         }

         $comentario_acuenta="Acuenta ";
         $comentario_total="Pago Cancelacion";
         

       if($tipo_pago == 1){


        ///FORMA DE PAGO
        if($forma_pago == 3){
          //DEPOSITO
          $comentario_anidado = $comentario_cancelacion. "-" .$comentario_acuenta."-".$nombre_banco. "-".$nro_operacion."-".$fecha_cancelacion;
         }else{
          //EFECTIVO
          $comentario_anidado = $comentario_cancelacion. "-" .$comentario_acuenta."-".$fecha_cancelacion;
         }
        
        $sqlupdate="UPDATE cuota SET 
                         montopagado=montopagado+'$pago_cancelacion',
                         montoacuenta=montoacuenta+'$pago_cancelacion', 
                         idbanco='$idbanco',
                         idusuario='$idusuario',
                         nrorecibo='$correlativo',
                         numero_operacion='$nro_operacion',
                         formapago='$forma_pago',   
                         comentario_mensualidad='$comentario_anidado',
                         fecha_cancelacion='$fecha_cancelacion'                      
                         WHERE idcuota='$idcuota_cancelacion'";
        ejecutarConsulta($sqlupdate);

        $sqlinsert ="INSERT INTO pago(idcontrato,idcuota,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                    VALUES('$idcontrato_cancelacion',
                          '$idcuota_cancelacion',
                          '$idbanco',
                          '$idusuario',
                          '$idcliente',
                          '$forma_pago',
                          '$idcaja',
                          '$pago_cancelacion',
                          '$fecha_cancelacion',
                          '$comentario_anidado',
                          '$correlativo',
                          '$nro_operacion',
                          '$categoriaingreso',
                          '$tipotrabajo')";
          ejecutarConsulta($sqlinsert);   
        
        $validar ="SELECT monto,montopagado FROM cuota WHERE idcuota='$idcuota_cancelacion'";
        $fila = ejecutarConsultaSimpleFila($validar);
        
        if ($fila) {
          if ($fila['monto'] == $fila['montopagado']) {
              // El monto ha sido completamente pagado
             $update_cuota="UPDATE cuota SET 
                            estado_cuota='2'
                            WHERE idcuota='$idcuota_cancelacion'";
              ejecutarConsulta($update_cuota);
              $update_contrato="UPDATE contrato SET estado_actualizar='2' WHERE idcontrato='$idcontrato_cancelacion'";
                      ejecutarConsulta($update_contrato);
              $resultado_actualizacion = $this->actualizar_linea($idcontrato_cancelacion);
                      if ($resultado_actualizacion !== true) {
                      return $resultado_actualizacion; // Aquí se retorna el error si lo hubo
                      }
                      //$this->enviar_mikrotik($idtecnologia, $idtorre);
                      return true; // <- Esto asegura que se retorne después de enviar a mikrotik
          } else {
              // El monto no ha sido completamente pagado
              return;
          }
        } else {
            return;
        }          

       }else{

        ///COMPROBAR EL COMENTARIO VACIO
         if(!empty($comentario_cancelacion)){
          if($forma_pago == 3){
            //DEPOSITO
            $comentario_anidado = $comentario_cancelacion. "-" .$comentario_total."-".$nombre_banco. "-".$nro_operacion."-".$fecha_cancelacion;
           }else{
            //EFECTIVO
            $comentario_anidado = $comentario_cancelacion. "-" .$comentario_total."-".$fecha_cancelacion;
           }

         }else{
          if($forma_pago == 3){
            //DEPOSITO
            $comentario_anidado = $comentario_total."-".$nombre_banco. "-".$nro_operacion."-".$fecha_cancelacion;
           }else{
            //EFECTIVO
            $comentario_anidado = $comentario_total."-".$fecha_cancelacion;
           }

         }
        $sqlupdate="UPDATE cuota SET 
                    montopagado=montopagado+'$monto_pagar',
                    montoacuenta=montoacuenta+'$monto_pagar', 
                    idbanco='$idbanco',
                    idusuario='$idusuario',
                    nrorecibo='$correlativo',
                    numero_operacion='$nro_operacion',
                    formapago='$forma_pago',   
                    fecha_cancelacion='$fecha_cancelacion',
                    comentario_mensualidad='$comentario_anidado',
                    estado_cuota='2'
                    WHERE idcuota='$idcuota_cancelacion'";
                    ejecutarConsulta($sqlupdate);

        $sqlinsert ="INSERT INTO pago(idcontrato,idcuota,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                    VALUES('$idcontrato_cancelacion',
                          '$idcuota_cancelacion',
                          '$idbanco',
                          '$idusuario',
                          '$idcliente',
                          '$forma_pago',
                          '$idcaja',
                          '$monto_pagar',
                          '$fecha_cancelacion',
                          '$comentario_anidado',
                          '$correlativo',
                          '$nro_operacion',
                          '$categoriaingreso',
                          '$tipotrabajo')";
          ejecutarConsulta($sqlinsert); 
          $update_contrato="UPDATE contrato SET estado_actualizar='2' WHERE idcontrato='$idcontrato_cancelacion'";
                      ejecutarConsulta($update_contrato);
          $resultado_actualizacion = $this->actualizar_linea($idcontrato_cancelacion);
                      if ($resultado_actualizacion !== true) {
                      return $resultado_actualizacion; // Aquí se retorna el error si lo hubo
                      }
                     //$this->enviar_mikrotik($idtecnologia, $idtorre);
                      return true; // <- Esto asegura que se retorne después de enviar a mikrotik
       }
        ///AQUI EMPIEZA EL SEGUNDA VALIDACION
        }else{
        
        $mostra_contrato = "SELECT * FROM contrato WHERE idcontrato='$idcontrato_cancelacion'";
            $result_contrato = ejecutarConsultaSimpleFila($mostra_contrato);
            $idtecnologia = $result_contrato['idtecnologia'];
            $idtorre = $result_contrato['idtorre'];

        $fecha_año = date("Y");
        $fecha_mes = date("m");
        $variable = $fecha_mes . $fecha_año;

        $ultimoCorrelativo = "SELECT count(nrorecibo) as ultimocorrelativo FROM correlativo_facturacion ";
        $ultimo = ejecutarConsultaSimpleFila($ultimoCorrelativo);
        $corre = $ultimo["ultimocorrelativo"] + 1;

        $correlativo= "F".$variable."-"."00".$corre;

        $insercorrelativo="INSERT INTO correlativo_facturacion (nrorecibo) VALUES('$correlativo')";
        ejecutarConsulta($insercorrelativo);

        if($idtecnologia_cancelacion == 1){
          $categoriaingreso='14';
          $tipotrabajo='38';
        }else if($idtecnologia_cancelacion == 2){
          $categoriaingreso='14';
          $tipotrabajo='0';
        }else if($idtecnologia_cancelacion == 3){
          $categoriaingreso='14';
         $tipotrabajo='37';   
         }else if($idtecnologia_cancelacion == 4){
          $categoriaingreso='14';
          $tipotrabajo='40';
         }else if($idtecnologia_cancelacion == 5){
         $categoriaingreso='14';
         $tipotrabajo='41';
         }else if($idtecnologia_cancelacion == 6){
         $categoriaingreso='14';
         $tipotrabajo='39';
         }

         $comentario_acuenta="Acuenta ";
         $comentario_total="Pago Cancelacion";
         

       if($tipo_pago == 1){


        ///FORMA DE PAGO
        if($forma_pago == 3){
          //DEPOSITO
          $comentario_anidado = $comentario_cancelacion. "-" .$comentario_acuenta."-".$nombre_banco. "-".$nro_operacion."-".$fecha_cancelacion;
         }else{
          //EFECTIVO
          $comentario_anidado = $comentario_cancelacion. "-" .$comentario_acuenta."-".$fecha_cancelacion;
         }
        
        $sqlupdate="UPDATE cuota SET 
                         montopagado=montopagado+'$pago_cancelacion',
                         montoacuenta=montoacuenta+'$pago_cancelacion', 
                         idbanco='$idbanco',
                         idusuario='$idusuario',
                         nrorecibo='$correlativo',
                         numero_operacion='$nro_operacion',
                         formapago='$forma_pago',   
                         comentario_mensualidad='$comentario_anidado',
                         fecha_cancelacion='$fecha_cancelacion'                      
                         WHERE idcuota='$idcuota_cancelacion'";
        ejecutarConsulta($sqlupdate);

        $sqlinsert ="INSERT INTO pago(idcontrato,idcuota,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                    VALUES('$idcontrato_cancelacion',
                          '$idcuota_cancelacion',
                          '$idbanco',
                          '$idusuario',
                          '$idcliente',
                          '$forma_pago',
                          '$idcaja',
                          '$pago_cancelacion',
                          '$fecha_cancelacion',
                          '$comentario_anidado',
                          '$correlativo',
                          '$nro_operacion',
                          '$categoriaingreso',
                          '$tipotrabajo')";
          ejecutarConsulta($sqlinsert);   
        
        $validar ="SELECT monto,montopagado FROM cuota WHERE idcuota='$idcuota_cancelacion'";
                $fila = ejecutarConsultaSimpleFila($validar);
                
                if ($fila) {
                  if ($fila['monto'] == $fila['montopagado']) {
                      // El monto ha sido completamente pagado
                    $update_cuota="UPDATE cuota SET 
                                    estado_cuota='2'
                                    WHERE idcuota='$idcuota_cancelacion'";
                       ejecutarConsulta($update_cuota);
                       $update_contrato="UPDATE contrato SET estado_actualizar='2' WHERE idcontrato='$idcontrato_cancelacion'";
                      ejecutarConsulta($update_contrato);
	                       $resultado_actualizacion = $this->actualizar_linea($idcontrato_cancelacion);
                              if ($resultado_actualizacion !== true) {
                              return $resultado_actualizacion; // Aquí se retorna el error si lo hubo
                              }
                             ///$this->enviar_mikrotik($idtecnologia, $idtorre);
                              return true; // <- Esto asegura que se retorne después de enviar a mikrotik
                  } else {
                      // El monto no ha sido completamente pagado
                      return;
                  }
                } else {
                    return;
                }         

       }else{

        ///COMPROBAR EL COMENTARIO VACIO
         if(!empty($comentario_cancelacion)){
          if($forma_pago == 3){
            //DEPOSITO
            $comentario_anidado = $comentario_cancelacion. "-" .$comentario_total."-".$nombre_banco. "-".$nro_operacion."-".$fecha_cancelacion;
           }else{
            //EFECTIVO
            $comentario_anidado = $comentario_cancelacion. "-" .$comentario_total."-".$fecha_cancelacion;
           }

         }else{
          if($forma_pago == 3){
            //DEPOSITO
            $comentario_anidado = $comentario_total."-".$nombre_banco. "-".$nro_operacion."-".$fecha_cancelacion;
           }else{
            //EFECTIVO
            $comentario_anidado = $comentario_total."-".$fecha_cancelacion;
           }

         }
        $sqlupdate="UPDATE cuota SET 
                    montopagado=montopagado+'$monto_pagar',
                    montoacuenta=montoacuenta+'$monto_pagar', 
                    idbanco='$idbanco',
                    idusuario='$idusuario',
                    nrorecibo='$correlativo',
                    numero_operacion='$nro_operacion',
                    formapago='$forma_pago',   
                    fecha_cancelacion='$fecha_cancelacion',
                    comentario_mensualidad='$comentario_anidado',
                    estado_cuota='2'
                    WHERE idcuota='$idcuota_cancelacion'";
                    ejecutarConsulta($sqlupdate);

        $sqlinsert ="INSERT INTO pago(idcontrato,idcuota,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso) 
                    VALUES('$idcontrato_cancelacion',
                          '$idcuota_cancelacion',
                          '$idbanco',
                          '$idusuario',
                          '$idcliente',
                          '$forma_pago',
                          '$idcaja',
                          '$monto_pagar',
                          '$fecha_cancelacion',
                          '$comentario_anidado',
                          '$correlativo',
                          '$nro_operacion',
                          '$categoriaingreso',
                          '$tipotrabajo')";
         ejecutarConsulta($sqlinsert); 
         $resultado_actualizacion = $this->actualizar_linea($idcontrato_cancelacion);
         $update_contrato="UPDATE contrato SET estado_actualizar='2' WHERE idcontrato='$idcontrato_cancelacion'";
                      ejecutarConsulta($update_contrato);
                              if ($resultado_actualizacion !== true) {
                              return $resultado_actualizacion; // Aquí se retorna el error si lo hubo
                              }
                             //$this->enviar_mikrotik($idtecnologia, $idtorre);
                              return true; // <- Esto asegura que se retorne después de enviar a mikrotik
         }
      }
    }

    public function mostrarLlamada($id_llamada)
    {
      $sql="SELECT u.nombre,m.descripcion,m.created_at as fecharegistro  FROM movimiento_llamada m join usuario u on m.idusuario=u.idusuario WHERE m.idcontrato='$id_llamada' and m.tipo='4'";
      $resultLlamadas = ejecutarConsulta($sql);

      $llamadas = [];
      while ($row = $resultLlamadas->fetch_assoc()) {
      $llamadas[] = $row;
    }
      // Respuesta JSON
    return [
        "llamadas" => $llamadas
        ];
    }

    public function guardarllamada($idcontrato,$descripcion,$monto_equipo,$monto_mensualidad,$estado_llamada,$idusuario)
    {
        $datosContrato = "SELECT c.idcliente,c.nrocontrato  FROM contrato c  WHERE c.idcontrato='$idcontrato'";
        $datos= ejecutarConsultaSimpleFila($datosContrato);
        $cliente = $datos["idcliente"];
        $nrocontrato = $datos["nrocontrato"];
        
        if(!empty($estado_llamada)){

          $insertllamada="INSERT INTO movimiento_llamada (idcontrato,idcliente,idusuario,nrocontrato,tipo,descripcion,montoequipo,montomensualidad) 
                        values('$idcontrato',
                               '$cliente',
                               '$idusuario',
                               '$nrocontrato',
                               '4',
                               '$descripcion',
                               '$monto_equipo',
                               '$monto_mensualidad'
                               )";
           ejecutarConsulta($insertllamada);

           $updatecontrato="UPDATE contrato SET estado_contrato ='Cancelado', sit_contrato='negra', monto_equipo='$monto_equipo', monto_mensualidad='$monto_mensualidad' 
            WHERE idcontrato='$idcontrato' ";
           return ejecutarConsulta($updatecontrato);
        }else{

          $insertllamada="INSERT INTO movimiento_llamada (idcontrato,idcliente,idusuario,nrocontrato,tipo,descripcion) 
                        values('$idcontrato',
                               '$cliente',
                               '$idusuario',
                               '$nrocontrato',
                               '4',
                               '$descripcion'
                               )";
            ejecutarConsulta($insertllamada);
           $updatecontrato="UPDATE contrato SET  monto_equipo='$monto_equipo', monto_mensualidad='$monto_mensualidad' 
            WHERE idcontrato='$idcontrato' ";
           return ejecutarConsulta($updatecontrato);

        }
        
     }

     public function selectContrato($idpersona)
    {
      $sql="SELECT c.idcontrato,c.nrocontrato,g.nombre 
            FROM contrato c 
            JOIN tecnologia g ON c.idtecnologia=g.idtecnologia
            WHERE c.idcliente='$idpersona'";
            return ejecutarConsulta($sql);
    }

    public function obtenerDatosContrato($idcontrato)
    {
       $sql="SELECT c.idcontrato,c.nrocontrato,p.celular,p.telefono,p.whatsapp,d.address,d.description,c.sit_contrato,c.idtecnologia,d.iddireccion
            FROM contrato c 
             JOIN persona p ON c.idcliente=p.idpersona 
             JOIN tecnologia g ON c.idtecnologia=g.idtecnologia
             LEFT JOIN detalle_direccion d ON c.iddireccion=d.iddireccion
             WHERE c.idcontrato='$idcontrato'";
      return ejecutarConsultaSimpleFila($sql);
    }

    public function obtenerDatosPersona($idpersona)
    {
       $sql="SELECT p.celular,p.telefono,p.whatsapp,d.address,d.description,d.iddireccion
            FROM  persona p 
            JOIN detalle_direccion d ON p.idpersona=d.idpersona
            WHERE p.idpersona='$idpersona'";
      return ejecutarConsultaSimpleFila($sql);
    }

    public function validarNroOperacion($operacion)
    {
       $sql="SELECT COUNT(*) as count FROM pago WHERE nro_operacion = '$operacion'";
      return ejecutarConsultaSimpleFila($sql);
    }

    public function guardarextencion($idcontrato,$tipo,$fecha_hora,$fechapago,$idusuario){
      $sw = true;
      try {
              $mostra_contrato = "SELECT * FROM contrato WHERE idcontrato='$idcontrato'";
              $result_contrato = ejecutarConsultaSimpleFila($mostra_contrato);
              $mensualidad = $result_contrato['montomensualidad'];
              $paga = $result_contrato['paga'];
              $fechainstalacion = $fecha_hora;

              if($paga == 'Mes Adelantado'){
                $diai = date('d', strtotime($fechainstalacion));
                $mes = date('m', strtotime($fechainstalacion));
                $anio = date('Y', strtotime($fechainstalacion));
                $mes1 = $mes - 1;
        
                $fechav = $anio . "-" . $mes1 . "-" . $diai;
                $fechap = $anio . "-" . $mes1 . "-" . $fechapago;
                }else if($paga == 'Mes Cumplido'){
                    $diai = date('d', strtotime($fechainstalacion));
                    $mes = date('m', strtotime($fechainstalacion));
                    $anio = date('Y', strtotime($fechainstalacion));
                    $mes1 = $mes - 1;

                    $fechav = $anio . "-" . $mes1 . "-" . $diai;
                    $fechap = $anio . "-" . $mes . "-" . $fechapago;
                }
            
                $pago = $mensualidad; // Valor inicial
                $j = 0;
                for ($contador = 1; $contador <= $tipo; $contador++) {
                    if ($diai == 31 || $diai == 30 || $diai==29 || $diai==28  ) {
                        $fechai = date("Y-m-d", strtotime("last day of this month" . $fechav . "+" . $contador . " month"));
                        $fechavi = date("Y-m-d", strtotime("last day of this month" . $fechainstalacion . "+" . $contador . " month"));
                        $fechapa = date("Y-m-d", strtotime("last day of this month" . $fechap . "+" . $contador . " month"));
                    } else {
                        $fechai = date("Y-m-d", strtotime($fechav . "+" . $contador . " month"));
                        $fechavi = date("Y-m-d", strtotime($fechainstalacion . "+" . $contador . " month"));
                        $fechapa = date("Y-m-d", strtotime($fechap . "+" . $contador . " month"));
                    }
                    // Debug: Mostrar fechas generadas
                    error_log("Fechai: $fechai, Fechavi: $fechavi, Fechapa: $fechapa");

                    $cone = "INSERT INTO cuota (idcontrato, fechainicial, fechavencimiento, monto, montopagado, estado_contrato, fecha_cuota, montocuota, fecha_pago, estado_facturacion, descripcion, estado_cuota)
                            VALUES ('$idcontrato', '$fechai', '$fechavi', '$pago', '0', '1', NOW(), '0', '$fechapa', '1', 'Monto Mensualidad','1')";
                    if (!ejecutarConsulta($cone)) {
                        $sw = false;
                        break;
                      }
                      $j++;
                    }
          } catch (Exception $e) {
            // error_log("Excepción: " . $e->getMessage());
            $sw = false;
            echo "Error: " . $e->getMessage();
        }
     
         return $sw;
      }

      public function lista_negra()
      {
        $sql="SELECT c.idcontrato,
                      c.nrocontrato,
                      date(fecha_hora)as fecha_hora,
                      c.sit_contrato,
                      c.modalidad,
                      c.idtecnologia,
                       c.estado_contrato,
                      c.codigotipo_comprobante,
                      p.nombre as cliente,
                      p.num_documento,
                      s.nombre as servicio, 
                      a.nombre_plan,
                      c.monto_equipo,
                      c.monto_mensualidad
                      FROM contrato c 
                      join persona p on c.idcliente=p.idpersona 
                      join servicio s on c.idservicio=s.idservicio 
                      join planes a on c.idplan=a.idplan WHERE c.sit_contrato='negra'";
        return ejecutarConsulta($sql);
      }
    
      public function selectContratoPersona()
      {
        $sql="SELECT c.idcontrato,c.nrocontrato,p.nombre 
              FROM contrato c 
              JOIN persona p ON c.idcliente=p.idpersona";
              return ejecutarConsulta($sql);
      }

      public function mostrar_contrato_llamada($idcontrato)
    {
      $sql="SELECT c.idcontrato,c.idcliente,c.iddireccion,c.idservicio,c.idtecnologia,c.idplan,c.idrepetidor,c.idolt,c.tipo,c.fecha_hora,c.nrocontrato,c.paga,c.modalidad,c.estado_contrato,c.sit_contrato,p.celular,p.telefono,p.whatsapp 
            FROM contrato c 
            JOIN persona p ON c.idcliente=p.idpersona
            WHERE c.idcontrato='$idcontrato'";
      $resultContratos = ejecutarConsulta($sql);

      $contratos = [];
      while ($row = $resultContratos->fetch_assoc()) {
      $contratos[] = $row;
    }

      $sqllamada="SELECT m.nrocontrato,m.descripcion,p.nombre as usuario,m.created_at FROM movimiento_llamada m JOIN usuario p ON m.idusuario=p.idusuario WHERE m.idcontrato='$idcontrato' and m.tipo='4'";
      $resultLlamadas = ejecutarConsulta($sqllamada);

      $llamadas = [];
      while ($row = $resultLlamadas->fetch_assoc()) {
      $llamadas[] = $row;
    }
      // Respuesta JSON
    return [
        "contratos" => $contratos,
        "llamadas" => $llamadas
        ];
    }
    public function guardar_movimiento_llamada($idcontrato,$idpersona,$descripcion,$celular,$telefono,$whatsapp,$idusuario,$nrocontrato)
    {

      $datosCuota = "SELECT c.idcuota  FROM cuota c WHERE c.idcontrato='$idcontrato' AND estado_cuota='1' ORDER BY c.idcuota ASC";
      $datos= ejecutarConsultaSimpleFila($datosCuota);
      $idcuota = $datos["idcuota"];

      $update_cuota="UPDATE cuota SET notificado='1' WHERE idcuota='$idcuota' ";  
      ejecutarConsulta($update_cuota);

      $update_persona="UPDATE persona SET celular='$celular',telefono='$telefono',whatsapp='$whatsapp' WHERE idpersona='$idpersona'";
         ejecutarConsulta($update_persona);

      $sql="INSERT INTO movimiento_llamada(idcontrato,idcliente,idusuario,tipo,nrocontrato,descripcion) VALUES('$idcontrato','$idpersona','$idusuario','4','$nrocontrato','$descripcion')";
         return ejecutarConsulta($sql);

    }
    
    public function actualizar_linea($idcontrato_cancelacion)
    {
      $consulta_linea = "SELECT k.idmkrotik, k.idcontrato, k.sit_linea, c.sit_contrato 
                        FROM mikrotik k 
                        JOIN contrato c ON c.idcontrato = k.idcontrato WHERE k.idcontrato='$idcontrato_cancelacion'";

      $resultado_linea = ejecutarConsulta($consulta_linea);
      if (!$resultado_linea) {
          echo "Error al ejecutar la consulta.";
          return;
      }

      $contador_actualizados = 0;
      $contador_procesados = 0;

      while ($fila_linea = $resultado_linea->fetch_assoc()) {
          $sit_linea = $fila_linea["sit_linea"];
          $id_contrato = $fila_linea["idcontrato"];

          if (!in_array($sit_linea, ['pendiente', 'listo' ,'baja', 'suspende'])) {
              $contador_procesados++;

              $accion = 'activa';
              $esnotifica = 0;
              $escorte = 0;

              $consulta_cuotas = "SELECT fecha_pago FROM cuota 
                                  WHERE idcontrato = '$id_contrato' AND estado_cuota = '1' AND estado_contrato = '1'  
                                  ORDER BY idcuota ASC LIMIT 1";

              $fila_cuotas = ejecutarConsultaSimpleFila($consulta_cuotas);

              if ($fila_cuotas) {
                  $fecha_actual = date("Y-m-d");
                  $fechavence_cuota = $fila_cuotas["fecha_pago"];
                  $fechavence_cuota2 = date("Y-m-d", strtotime("$fechavence_cuota + 3 days"));

                  if ($fecha_actual > $fechavence_cuota && $fecha_actual <= $fechavence_cuota2) {
                      $esnotifica = 1;
                  }
                  if ($fecha_actual > $fechavence_cuota2) {
                      $escorte = 1;
                  }
              }

              if ($esnotifica == 1) $accion = 'notifica';
              if ($escorte == 1) $accion = 'corte';

              $actualizado = false;

              switch ($accion) {
                  case 'notifica':
                      if ($sit_linea != 'notifica') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'corte':
                      if ($sit_linea != 'corte') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte',estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'activa':
                      if ($sit_linea != 'activa') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa',estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
              }

              if ($actualizado) {
                  $contador_actualizados++;
              }
          }
      }

      if ($contador_procesados == 0) {
        return "No se procesaron líneas para el contrato.";
    }

    return true; // Todo bien
    }

    public function enviar_mikrotik($idtecnologia, $idtorre) {

      $sql_torre = "SELECT * FROM torre WHERE idtorre='$idtorre'";
      $resultado_torre = ejecutarConsultaSimpleFila($sql_torre);
  
      // Validamos si la consulta falló o no devolvió resultados
      if (!$resultado_torre || empty($resultado_torre)) {
          echo json_encode(["status" => "error", "message" => "Error al obtener los datos de la Torre."]);
          return;
      }
  
      $servidor_torre = $resultado_torre['servidor_torre'] ?? null;
      $usuario_torre = $resultado_torre['usuario_torre'] ?? null;
      $pass_torre = $resultado_torre['pass_torre'] ?? null;
  
      // Validamos que los datos esenciales no sean nulos
      if (!$servidor_torre || !$usuario_torre || !$pass_torre) {
          echo json_encode(["status" => "error", "message" => "Faltan datos esenciales de la Torre."]);
          return;
      }
     
      require_once '../config/api_mt_include2.php';
      $API = new routeros_api();
      $API->debug = false;

      // Credenciales de conexión a MikroTik
     // $servidor_torre = '209.45.52.2';
     // $usuario_torre = 'radhyo1';
     // $pass_torre = 'c4b3rl456#$';

      // Conectar a MikroTik
      if (!$API->connect($servidor_torre, $usuario_torre, $pass_torre, '8728')) {
          echo json_encode(["status" => "error", "message" => "Error al conectar con MikroTik."]);
          return;
      }
      // Contadores por estado
      $contador_listo = 0;
      $contador_activa = 0;
      $contador_notifica = 0;
      $contador_corte = 0;
      $contador_suspende = 0;
      $contador_baja = 0;
      $contador_existentes = 0;

// Consulta para obtener usuarios en cualquier estado relevante
  $consulta_usuarios = "
      SELECT m.idcontrato, m.usuario, m.password, p.nombre_plan, m.comentario_linea, m.sit_linea, m.mac_linea, m.ip_linea, p.upload_servicio, p.download_servicio
      FROM mikrotik m
      JOIN contrato c ON c.idcontrato = m.idcontrato
      JOIN planes p ON p.idplan = c.idplan
      WHERE m.idtorre = '$idtorre' 
      AND m.idtecnologia = '$idtecnologia' 
      AND m.cambio_linea='si'
      AND m.sit_linea IN ('listo', 'activa', 'notifica', 'corte', 'suspende', 'baja')";

  $resultado_usuarios = ejecutarConsulta($consulta_usuarios);

  if (!$resultado_usuarios) {
      echo json_encode(["status" => "error", "message" => "Error al ejecutar la consulta de usuarios."]);
      $API->disconnect();
      return;
  }

          if($idtecnologia == 1 ){

              while ($fila = $resultado_usuarios->fetch_assoc()) {

                  $comentario_linea = trim($fila["comentario_linea"]);
                  $id_linea = $fila["idcontrato"];
                  $estado_actual = trim($fila["sit_linea"]);
                  $mac_linea = trim($fila["mac_linea"]);
                  $velocidad_linea = trim($fila["upload_servicio"]);
                  $velocidad2_linea = trim($fila["download_servicio"]);
                  $ip_linea = trim($fila["ip_linea"]);

                  $API->write("/ip/hotspot/ip-binding/print", false);
                  $API->write("?mac-address=" . $mac_linea, true);
                  $usuarios_existente = $API->read();
              
                  // 🔹 Filtrar y obtener el ID del usuario correcto en MikroTik
                  $id_usuario = null;
                  if (!empty($usuarios_existente) && is_array($usuarios_existente)) {
                      foreach ($usuarios_existente as $usr) {
                          if (isset($usr['mac-address']) && strtolower(trim($usr['mac-address'])) === strtolower(trim($mac_linea))) {
                              $id_usuario = $usr[".id"];
                              break;
                          }
                      }
                  }

                   // Verificar si el usuario ya existe en MikroTik
                      $API->write("/ip/hotspot/user/print", false);
                      $API->write("?name=" . $mac_linea, true);
                      $usuarios_mac = $API->read();

                      $id_usuario_mac = null;
                      if (!empty($usuarios_mac) && is_array($usuarios_mac)) {
                          foreach ($usuarios_mac as $usr) {
                              if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                  $id_usuario_mac = $usr[".id"];
                                  break;
                              }
                          }
                      }

                      $API->write("/queue/simple/print", false);
                      $API->write("?name=" . $mac_linea, true);
                      $usuarios_queue = $API->read();

                      $id_usuario_queue = null;
                      if (!empty($usuarios_queue) && is_array($usuarios_queue)) {
                          foreach ($usuarios_queue as $usr) {
                              if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                  $id_usuario_queue = $usr[".id"];
                                  break;
                              }
                          }
                      }

                  switch ($estado_actual) {
                      case 'listo':
                          if (empty($id_usuario_mac) || empty($id_usuario) || empty($id_usuario_queue)) { 

                              // Agregar usuario a MikroTik
                               $API->write("/ip/hotspot/ip-binding/add",false);	
                               $API->write("=address=$ip_linea",false);
                               $API->write("=type=bypassed",false);
                               $API->write("=comment=$comentario_linea",false);
                               $API->write("=mac-address=$mac_linea",true);
                               $API->read();

                               $API->write("/queue/simple/add",false);	
                               $API->write("=name=$mac_linea",false);
                               $API->write("=comment=$comentario_linea",false);
                               $API->write("=max-limit=$velocidad2_linea/$velocidad_linea",false);
                               $API->write("=queue=default-small/default-small",false);
                               $API->write("=target=$ip_linea",true);
                               $API->read();


                              $API->write("/ip/hotspot/user/add", false);
                              $API->write("=profile=Notice", false);
                              $API->write("=comment=$comentario_linea(activa)", false);
                              $API->write("=name=$mac_linea", true);
                              $API->read();

                              //sleep(1);
                              // Asegurar que la consulta devuelve un array válido
                              $API->write("/ip/hotspot/user/print", false);
                              $API->write("?name=" . $mac_linea, true);
                              $usuarios_mac = $API->read();
          
                              if (!empty($usuarios_mac) && is_array($usuarios_mac)) {
                                  foreach ($usuarios_mac as $usr) {
                                      if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                          $id_usuario_mac = $usr[".id"];
                                          break;
                                      }
                                  }
                              }
          
                              if (!empty($id_usuario_mac)) {
                                  // Si el usuario se creó correctamente, lo deshabilitamos
                                  $API->write("/ip/hotspot/user/disable", false);
                                  $API->write("=.id=" . $id_usuario_mac, true);
                                  $API->read();
                          
                              }
                              // Actualizar estado en la base de datos
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '2' WHERE idcontrato = '$id_linea'");
              
                              $contador_listo++;
                          } else {
                              $contador_existentes++;
                          }
                          break;

                          case 'activa':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                   // 🔹 Actualizar el perfil y comentario del usuario en Hotspot
                                  if (!empty($id_usuario)) {
                                      $API->write("/ip/hotspot/ip-binding/enable", false);
                                      $API->write("=.id=" . $id_usuario, true);
                                      $API->read();
                                  }
                                  // 🔹 Habilitar el usuario en Hotspot si existe
                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/set", false);	
                                      $API->write("=profile=Notice", false);
                                      $API->write("=comment=$comentario_linea(activa)", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();

                                      $API->write("/ip/hotspot/user/enable", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }

                                  // 🔹 Actualizar la cola de velocidad si existe
                                  if (!empty($id_usuario_queue)) {
                                      $API->write("/queue/simple/set", false);	
                                      $API->write("=comment=$comentario_linea", false);
                                      $API->write("=max-limit=$velocidad2_linea/$velocidad_linea", false);
                                      $API->write("=.id=" . $id_usuario_queue, true);
                                      $API->read();
                                  }

                                  ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                  ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                                  $contador_activa++;
                              }
                          break;

                          case 'notifica':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/set", false);	
                                      $API->write("=profile=Notice", false);
                                      $API->write("=comment=$comentario_linea(notifica)", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }

                                  ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                  ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                                  $contador_notifica++;
                              }
                          break;

                          case 'corte':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/set", false);	
                                      $API->write("=profile=bill", false);
                                      $API->write("=comment=$comentario_linea(corte)", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();

                                      $API->write("/ip/hotspot/host/remove", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }
                                  if (!empty($id_usuario)) {
                                      $API->write("/ip/hotspot/ip-binding/disable", false);
                                      $API->write("=.id=" . $id_usuario, true);
                                      $API->read();
                                  }

                                  ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                  ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                              }
                              $contador_corte++;
                          break;

                          case 'suspende':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                  if (!empty($id_usuario)) {
                                      $API->write("/ip/hotspot/ip-binding/disable", false);
                                      $API->write("=.id=" . $id_usuario, true);
                                      $API->read();
                                  }

                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/set", false);	
                                      $API->write("=profile=Notice", false);
                                      $API->write("=comment=$comentario_linea(suspende)", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();

                                      $API->write("/ip/hotspot/user/disable", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }

                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'suspende', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'suspende', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                              }
                              $contador_suspende++;
                          break;

                          case 'baja':
                              if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                  if (!empty($id_usuario)) {
                                      $API->write("/ip/hotspot/ip-binding/remove", false);
                                      $API->write("=.id=" . $id_usuario, true);
                                      $API->read();
                                  }
                                  if (!empty($id_usuario_queue)) {
                                      $API->write("/queue/simple/remove", false);	
                                      $API->write("=.id=" . $id_usuario_queue, true);
                                      $API->read();
                                  }
                                  if (!empty($id_usuario_mac)) {
                                      $API->write("/ip/hotspot/user/remove", false);
                                      $API->write("=.id=" . $id_usuario_mac, true);
                                      $API->read();
                                  }
                              }

                               ejecutarConsulta("DELETE mikrotik  WHERE idcontrato = '$id_linea'");
                               ejecutarConsulta("UPDATE contrato SET sit_contrato = 'baja', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                              $contador_baja++;
                          break;
                  }
              }
              $API->disconnect();

           }else if ($idtecnologia == 3){

              while ($fila = $resultado_usuarios->fetch_assoc()) {
                  $usuario = trim($fila["usuario"]);
                  $password = trim($fila["password"]);
                  $planes = trim($fila["nombre_plan"]);
                  $comentario_linea = trim($fila["comentario_linea"]);
                  $id_linea = $fila["idcontrato"];
                  $estado_actual = trim($fila["sit_linea"]);
              
                  // Verificar si el usuario ya existe en MikroTik
                  $API->write("/ppp/secret/print", false);
                  $API->write("?name=" . $usuario, true);
                  $usuarios_existente = $API->read();
              
                  // 🔹 Filtrar y obtener el ID del usuario correcto en MikroTik
                  $id_usuario = null;
                  foreach ($usuarios_existente as $usr) {
                      if ($usr['name'] === $usuario) {
                          $id_usuario = $usr[".id"];
                          break;
                      }
                  }
              
                  switch ($estado_actual) {
                      case 'listo':
                          if (empty($usuarios_existente)) {
                              // Agregar usuario a MikroTik
                              $API->write("/ppp/secret/add", false);
                              $API->write("=name=" . $usuario, false);
                              $API->write("=password=" . $password, false);
                              $API->write("=service=pppoe", false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $comentario_linea . "(activa)", true);
                              $API->read();
              
                              // Obtener el ID del usuario agregado
                              $API->write("/ppp/secret/print", false);
                              $API->write("?name=" . $usuario, true);
                              $usuario_creado = $API->read();
              
                              if (!empty($usuario_creado)) {
                                  $id_usuario = $usuario_creado[0][".id"];
              
                                  // 🔹 Deshabilitar usuario
                                  $API->write("/ppp/secret/disable", false);
                                  $API->write("=.id=" . $id_usuario, true);
                                  $API->read();
                              }
              
                              // Actualizar estado en la base de datos
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '2' WHERE idcontrato = '$id_linea'");
              
                              $contador_listo++;
                          } else {
                              $contador_existentes++;
                          }
                          break;
              
                      case 'activa':
                          if ($id_usuario !== null) {
                              $nuevo_comentario = $comentario_linea . "(activa)";
              
                              $API->write("/ppp/secret/set", false);
                              $API->write("=.id=" . $id_usuario, false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $nuevo_comentario, true);
                              $API->read();
              
                              // Habilitar usuario
                              $API->write("/ppp/secret/enable", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();
              
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_activa++;
                          }
                          break;
              
                      case 'notifica':
                          if ($id_usuario !== null) {
                              $nuevo_comentario = $comentario_linea . "(notifica)";
              
                              $API->write("/ppp/secret/set", false);
                              $API->write("=.id=" . $id_usuario, false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $nuevo_comentario, true);
                              $API->read();
              
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_notifica++;
                          }
                          break;
              
                      case 'corte':
                          if ($id_usuario !== null) {
                              $nuevo_comentario = $comentario_linea . "(corte)";
              
                              $API->write("/ppp/secret/set", false);
                              $API->write("=.id=" . $id_usuario, false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $nuevo_comentario, true);
                              $API->read();

                              $API->write("/ppp/active/remove", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();
              
                              // Deshabilitar usuario
                              $API->write("/ppp/secret/disable", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();
              
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_corte++;
                          }
                          break;
              
                      case 'suspende':
                          if ($id_usuario !== null) {
                              $nuevo_comentario = $comentario_linea . "(suspende)";
              
                              $API->write("/ppp/secret/set", false);
                              $API->write("=.id=" . $id_usuario, false);
                              $API->write("=profile=" . $planes, false);
                              $API->write("=comment=" . $nuevo_comentario, true);
                              $API->read();
              
                              // Deshabilitar usuario
                              $API->write("/ppp/secret/disable", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();
              
                              ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'suspende', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                              ejecutarConsulta("UPDATE contrato SET sit_contrato = 'suspende', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_suspende++;
                          }
                          break;
              
                      case 'baja':
                          if ($id_usuario !== null) {
                              $API->write("/ppp/secret/remove", false);
                              $API->write("=.id=" . $id_usuario, true);
                              $API->read();

                              ejecutarConsulta("DELETE mikrotik  WHERE idcontrato = '$id_linea'");
                               ejecutarConsulta("UPDATE contrato SET sit_contrato = 'baja', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
              
                              $contador_baja++;
                          }
                          break;
                  }
              }
              $API->disconnect();
          } 
  }
  
  

  }