<?php
//Incluimos conexion a la base de trader_cdlrisefall3methods
date_default_timezone_set('America/Lima');
require "../config/Conexion.php";

Class Facturacion
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }
  
	    public function procesar_facturas($ids) {
	    $procesados = 0;
	    $errores = [];
	    $indice = 1;
	    foreach ($ids as $idpago) {
	        $idpago = intval($idpago);
	        
	       	     $segundos_extra = $indice * 1; // o 5 si prefieres más intervalo
	             $fecha_base = new DateTime();
	             $fecha_base->modify("+$segundos_extra seconds");
	             
	             $fechaEmision = $fecha_base->format('Y-m-d');
	             $horaEmision = $fecha_base->format('H:i:s');
	
	        try {
	            // 1. Obtener datos del pago
	            $sql = "SELECT e.nombre AS cliente, t.tipo, e.num_documento, p.monto, p.idpago,
	                           p.codigotipo_comprobante, p.serie, p.correlativo, p.estado_facturacion,
	                           c.descripcion, t.idtipo_documento
	                    FROM pago p
	                    JOIN persona e ON p.idcliente = e.idpersona
	                    JOIN tipo_documento t ON t.idtipo_documento = e.idtipo_documento
	                    JOIN concepto_ingreso c ON c.idconcepto_ingreso = p.idconcepto_ingreso
	                    WHERE p.idpago = '$idpago' AND p.estado_facturacion = '1'";
	            $datos = ejecutarConsultaSimpleFila($sql);
	
	            if (!$datos) {
	                $errores[] = "❌ ID $idpago: Este comprobante ya ha sido enviado.";
	                continue;
	            }
	
	            // 2. Validaciones de documento
	            $tipoDoc = $datos['tipo'];
	            $numDoc = trim($datos['num_documento']);
	            $descripcion = trim($datos['descripcion']);
	
	            if (($tipoDoc == 1 && strlen($numDoc) != 8) || ($tipoDoc == 6 && strlen($numDoc) != 11)) {
	                $errores[] = "❌ ID $idpago: Documento inválido ($tipoDoc - $numDoc).";
	                continue;
	            }
	
	            if ($descripcion === '') {
	                $errores[] = "❌ ID $idpago: Descripción vacía.";
	                continue;
	            }
	
		     // 3. Insertar comprobante
	            $idtipo_documento = $datos['idtipo_documento'];
	            $tabla = ($idtipo_documento == 1) ? 'boleta' : 'factura';
	            $campo = ($idtipo_documento == 1) ? 'nro_boleta' : 'nro_factura';
	            $serie = ($idtipo_documento == 1) ? 'B001' : 'F001';
	            $codigo = ($idtipo_documento == 1) ? '03' : '01';
	            $id_tabla = ($idtipo_documento == 1) ? 'idboleta' : 'idfactura';
	
	            // 1. Insertar una fila vacía, dejando que el ID (auto_increment) se genere
	            $insertComprobante = "INSERT INTO $tabla () VALUES ()";
	            $id_generado = ejecutarConsulta_retornarID($insertComprobante);
	                if (!$id_generado) {
	                    $errores[] = "❌ ID $idpago: No se pudo obtener el ID generado en $tabla.";
	                    continue;
	                }
	            
	
	            // 3. Formatear el número con 8 dígitos y ceros a la izquierda
	            $nro_formateado = str_pad($id_generado, 8, '0', STR_PAD_LEFT);
	
	            // 4. Hacer el update para asignar el número formateado
	            $updateComprobante = "UPDATE $tabla SET $campo = '$nro_formateado' WHERE $id_tabla = $id_generado";
	            if (!ejecutarConsulta($updateComprobante)) {
	                $errores[] = "❌ ID $idpago: No se pudo actualizar $campo con valor $nro_formateado en $tabla.";
	                continue;
	            }
	
	            // 4. Actualizar tabla pago
	            $sqlUpdate = "UPDATE pago
	                          SET codigotipo_comprobante = '$codigo',
	                              serie = '$serie',
	                              correlativo = '$nro_formateado'
	                          WHERE idpago = '$idpago'";
	            if (!ejecutarConsulta($sqlUpdate)) {
	                $errores[] = "❌ ID $idpago: Falló la actualización del pago.";
	                continue;
	            }
	            
	                  
	
	            // 5. Enviar comprobante
	            $resultado = $this->enviar_facturacion_proceso($idpago,null,null,$indice);
	            if ($resultado === true || (is_array($resultado) && !isset($resultado['error']))) {
	                $procesados++;
	            } else {
	                if (is_array($resultado)) {
	                    $errorMensaje = 
	                        $resultado['message'] ?? 
	                        $resultado['error'] ?? 
	                        $resultado['detalle'] ?? 
	                        $resultado['description'] ?? 
	                        'Error desconocido';
	                } else {
	                    $errorMensaje = 'Error en envío.';
	                }
	                $errores[] = "❌ ID $idpago: Fallo en el envío. $errorMensaje";
	            }
	
	        } catch (Exception $e) {
	            $errores[] = "❌ ID $idpago: Excepción - " . $e->getMessage();
	        }
	        sleep(1); // 🔁 Espera real de 2 segundos antes del siguiente comprobante
	        $indice++;
	    }
	
	    return [
	        'procesados' => $procesados,
	        'errores' => $errores
	    ];
	}
    public function listarIngreso(){
        $sql="SELECT p.idpago,p.tipoingreso,p.monto,p.fecha_pago,p.descripcion,p.correlativo_pago,p.nro_operacion,e.nombre as cliente,e.idtipo_documento, u.nombre as usuario,p.estado_facturacion,p.codigotipo_comprobante,p.serie,p.correlativo,e.num_documento,p.sMesajeRespuesta 
                FROM pago p join persona e on p.idcliente=e.idpersona 
                join usuario u on p.idusuario=u.idusuario 
                WHERE p.monto >0 order by p.idpago desc";
        return ejecutarConsulta($sql);
    }

    public function listar_facturacion(){
        $sql="SELECT p.idpago,p.tipoingreso,p.monto,p.fecha_pago,p.descripcion,p.correlativo_pago,p.nro_operacion,e.nombre as cliente,e.idtipo_documento, u.nombre as usuario,p.estado_facturacion,p.codigotipo_comprobante,p.serie,p.correlativo,e.num_documento,p.sMesajeRespuesta,f.idfacturacion 
                FROM facturacion f
                JOIN pago p ON p.idpago=f.idpago 
                join persona e on p.idcliente=e.idpersona 
                join usuario u on p.idusuario=u.idusuario order by f.idfacturacion desc  ";
        return ejecutarConsulta($sql);
    }

    public function update($idpago,$codigotipo_comprobante,$serie,$correlativo){

        if($codigotipo_comprobante == 01){
          $sql_insert="INSERT INTO factura (nro_factura) VALUES('$correlativo')";
          ejecutarConsulta($sql_insert);
        }else{
            $sql_insert="INSERT INTO boleta (nro_boleta) VALUES('$correlativo')";
            ejecutarConsulta($sql_insert);
        }

        $sql="UPDATE pago set codigotipo_comprobante='$codigotipo_comprobante',serie='$serie',correlativo='$correlativo' WHERE idpago='$idpago' ";
        return ejecutarConsulta($sql);
      }

      public function mostrar($idpago,$idtipo_documento){

       $sql="SELECT e.nombre as cliente,e.idtipo_documento,e.num_documento,p.monto,p.fecha_pago,t.nombre as documento,p.idpago,p.codigotipo_comprobante,p.serie,p.correlativo,p.estado_facturacion
             FROM pago p 
             JOIN persona e ON p.idcliente=e.idpersona 
             JOIN tipo_documento t ON t.idtipo_documento=e.idtipo_documento
             WHERE p.idpago='$idpago'";
       $resultCliente = ejecutarConsulta($sql);
 
       $clientes = [];
       while ($row = $resultCliente->fetch_assoc()) {
       $clientes[] = $row;
     }
 
     $sqlFactura = "SELECT p.serie,p.correlativo,p.fecha_pago,p.monto,e.nombre as cliente, e.num_documento,t.tipo,p.codigotipo_comprobante 
                   FROM pago p 
                   JOIN persona e ON p.idcliente=e.idpersona 
                   JOIN tipo_documento t ON t.idtipo_documento =e.idtipo_documento 
                   WHERE p.idpago = $idpago";
     $resultFactura = ejecutarConsulta($sqlFactura);
     $factura = $resultFactura->fetch_assoc();
 
     $sqlDetalles = "SELECT p.idpago,p.monto,p.fecha_pago,c.descripcion 
                     FROM pago p 
                     JOIN concepto_ingreso c ON c.idconcepto_ingreso=p.idconcepto_ingreso
                     WHERE p.idpago = $idpago";
     $resultDetalles = ejecutarConsulta($sqlDetalles);
     $detalles = [];
 
     $montoTotal = floatval($factura['monto']);
     $gravadas = round($montoTotal / 1.18, 2); // Base imponible (sin IGV)
     $totalIgv = round($montoTotal - $gravadas, 2); // IGV calculado
 
     while ($fila = $resultDetalles->fetch_assoc()) {
         $detalles[] = [
             "idDocumentoElectronico" => 0,
             "secuencia" => 0,
             "Id" => 1,
             "Cantidad" => "01",
             "PrecioReferencial" => number_format($fila['monto'], 2, '.', ''),
             "PrecioUnitario" => number_format($gravadas, 2, '.', ''),
             "TipoPrecio" => "01",
             "CodigoItem" => "01",
             "Descripcion" => $fila['descripcion'],
             "UnidadMedida" => "NIU",
             "Impuesto" => number_format($totalIgv, 2, '.', ''),
             "TipoImpuesto" => "10",
             "TotalVenta" =>number_format($gravadas, 2, '.', ''),
             "tasaIgv" => 18.00,
             "TotalIcbper" => 0.0,
             "ImpuestoIcbper" => 0.0,
             "CantidadBolsa" => 0
         ];
     }
 
     $facturaElectronica = [
         "idDocumentoElectronico" => 0,
         "idEmpresa" => 39845, 
         "IdDocumento" => $factura['serie']."-".$factura['correlativo'],
         "FechaEmision" => date("c"),
         "HoraEmision" => date("H:i:s"),
         "Moneda" => "PEN",
         "TipoDocumento" => $factura['codigotipo_comprobante'],
         "TipoOperacion" => "0101",
         "Gravadas" => number_format($gravadas, 2, '.', ''),
         "TotalIgv" => number_format($totalIgv, 2, '.', ''),
         "TotalVenta" => number_format($montoTotal, 2, '.', ''),
         "TipoDocumentoRec" => $factura['tipo'],
         "NroDocumentoRec" => $factura['num_documento'],
         "NombreLegalRec" => $factura['cliente'],
         "FechaVencimiento" => date("c", strtotime($factura['fecha_pago'])),
         "EnvioSunat" => "NO",
         "Contribuyente_id" => "20608971689",
         "TipoPago" => "Contado",
         "tasaIgv" => 18.00,
         "DocumentoElectronicoDetalle" => $detalles
     ];
       // Respuesta JSON
     return [
         "clientes" => $clientes,
         "facturaElectronica" =>$facturaElectronica
         ];
   }

  public function mostrar_facturacion($idpago,$idtipo_documento){

       if($idtipo_documento == 1){
        $traer_boleta="SELECT count(nro_boleta)+1 as boleta FROM boleta";
        $resultboleta= ejecutarConsultaSimpleFila($traer_boleta);
        $nro_comprobante = $resultboleta['boleta'];
        $nombre_comprobante = "BOLETA";
        $codigotipo_comprobante = "03";
        $serie_comprobante = "B001";
       }else{
        $traer_factura="SELECT count(nro_factura)+1 as factura FROM factura";
        $resultfactura= ejecutarConsultaSimpleFila($traer_factura);
        $nro_comprobante = $resultfactura['factura'];
        $nombre_comprobante = "FACTURA";
        $codigotipo_comprobante = "01";
        $serie_comprobante = "F001";
       }

      $sql="SELECT e.nombre as cliente,e.idtipo_documento,e.num_documento,p.monto,p.fecha_pago,t.nombre as documento,p.idpago 
            FROM pago p 
            JOIN persona e ON p.idcliente=e.idpersona 
            JOIN tipo_documento t ON t.idtipo_documento=e.idtipo_documento
            WHERE p.idpago='$idpago'";
      $resultCliente = ejecutarConsulta($sql);

      $clientes = [];
      while ($row = $resultCliente->fetch_assoc()) {
        $row['nro_comprobante'] = $nro_comprobante;
        $row['nombre_comprobante'] = $nombre_comprobante;
        $row['serie_comprobante'] = $serie_comprobante;
        $row['codigotipo_comprobante'] = $codigotipo_comprobante;
      $clientes[] = $row;
    }

    $sqlFactura = "SELECT p.serie,p.correlativo,p.fecha_pago,p.monto,e.nombre as cliente, e.num_documento,t.tipo 
                  FROM pago p 
                  JOIN persona e ON p.idcliente=e.idpersona 
                  JOIN tipo_documento t ON t.idtipo_documento =e.idtipo_documento 
                  WHERE p.idpago = $idpago";
    $resultFactura = ejecutarConsulta($sqlFactura);
    $factura = $resultFactura->fetch_assoc();

    $sqlDetalles = "SELECT p.idpago,p.monto,p.fecha_pago,c.descripcion 
                    FROM pago p 
                    JOIN concepto_ingreso c ON c.idconcepto_ingreso=p.idconcepto_ingreso
                    WHERE p.idpago = $idpago";
    $resultDetalles = ejecutarConsulta($sqlDetalles);
    $detalles = [];

    $montoTotal = floatval($factura['monto']);
    $gravadas = round($montoTotal / 1.18, 2); // Base imponible (sin IGV)
    $totalIgv = round($montoTotal - $gravadas, 2); // IGV calculado
    
   
    
    $tipoDocumentoRec = $factura['tipo'];
        $nroDocumentoRec = $factura['num_documento'];

        // Validar longitud del número de documento
        if (($tipoDocumentoRec == 1 && strlen($nroDocumentoRec) != 8) || 
            ($tipoDocumentoRec == 6 && strlen($nroDocumentoRec) != 11)) {
            echo json_encode([
                "status" => "error",
                "message" => "❌ El número de documento no tiene la cantidad correcta de dígitos para el tipo de documento."
            ]);
            exit;
        }

    while ($fila = $resultDetalles->fetch_assoc()) {
     if ($fila['descripcion'] === null || trim($fila['descripcion']) === '') {
                echo json_encode([
                    "status" => "error",
                    "message" => "❌ La descripción no puede estar vacía."
                ]);
                exit;
        }
        $detalles[] = [
            "idDocumentoElectronico" => 0,
            "secuencia" => 0,
            "Id" => 1,
            "Cantidad" => "01",
            "PrecioReferencial" => number_format($fila['monto'], 2, '.', ''),
            "PrecioUnitario" => number_format($gravadas, 2, '.', ''),
            "TipoPrecio" => "01",
            "CodigoItem" => "01",
            "Descripcion" => $fila['descripcion'],
            "UnidadMedida" => "NIU",
            "Impuesto" => number_format($totalIgv, 2, '.', ''),
            "TipoImpuesto" => "10",
            "TotalVenta" =>number_format($gravadas, 2, '.', ''),
            "tasaIgv" => 18.00,
            "TotalIcbper" => 0.0,
            "ImpuestoIcbper" => 0.0,
            "CantidadBolsa" => 0
        ];
    }

    //$igvPorcentaje = floatval($rowPro['afectacion'] == "Gravado" ? 0.18 : 0);
     // Cálculo del IGV y Gravadas
     

    $facturaElectronica = [
        "idDocumentoElectronico" => 0,
        "idEmpresa" => 39845,
        "IdDocumento" => $factura['serie']."-".$factura['correlativo'],
        "FechaEmision" => date("c"),
        "HoraEmision" => date("H:i:s"),
        "Moneda" => "PEN",
        "TipoDocumento" => $codigotipo_comprobante,
        "TipoOperacion" => "0101",
        "Gravadas" => number_format($gravadas, 2, '.', ''),
        "TotalIgv" => number_format($totalIgv, 2, '.', ''),
        "TotalVenta" => number_format($montoTotal, 2, '.', ''),
        "TipoDocumentoRec" => $tipoDocumentoRec,
        "NroDocumentoRec" => $nroDocumentoRec,
        "NombreLegalRec" => $factura['cliente'],
        "FechaVencimiento" => date("c", strtotime($factura['fecha_pago'])),
        "EnvioSunat" => "NO",
         "Contribuyente_id" => "20608971689",
        "TipoPago" => "Contado",
        "tasaIgv" => 18.00,
        "DocumentoElectronicoDetalle" => $detalles
    ];
      // Respuesta JSON
    return [
        "clientes" => $clientes,
        "facturaElectronica" =>$facturaElectronica
        ];
  }

  public function enviar_facturacion($idpago) {
    try {
        // 🔹 Obtener datos de la factura
        $sqlFactura = "SELECT p.serie,p.correlativo,p.fecha_pago,p.monto,e.nombre as cliente, e.num_documento,t.tipo,p.idcontrato,p.codigotipo_comprobante 
                        FROM pago p 
                        JOIN persona e ON p.idcliente=e.idpersona 
                        JOIN tipo_documento t ON t.idtipo_documento =e.idtipo_documento 
                       WHERE p.idpago = $idpago";
        $resultFactura = ejecutarConsulta($sqlFactura);
        $factura = $resultFactura->fetch_assoc();

        if (!$factura) {
            throw new Exception("❌ No se encontró información de la factura con ID: $idpago.");
        }

        // 🔹 Obtener detalles de la factura
        $sqlDetalles = "SELECT p.idpago, p.monto, p.fecha_pago, c.descripcion 
                        FROM pago p 
                        JOIN concepto_ingreso c ON c.idconcepto_ingreso = p.idconcepto_ingreso
                        WHERE p.idpago = $idpago";
        $resultDetalles = ejecutarConsulta($sqlDetalles);
        $detalles = [];

        // 🔹 Cálculo de IGV y base imponible
        $montoTotal = floatval($factura['monto']);
        $gravadas = round($montoTotal / 1.18, 2); 
        $totalIgv = round($montoTotal - $gravadas, 2);
        
        

        $tipoDocumentoRec = $factura['tipo'];
        $nroDocumentoRec = $factura['num_documento'];

        // Validar longitud del número de documento
        if (($tipoDocumentoRec == 1 && strlen($nroDocumentoRec) != 8) || 
            ($tipoDocumentoRec == 6 && strlen($nroDocumentoRec) != 11)) {
            echo json_encode([
                "status" => "error",
                "message" => "❌ El número de documento no tiene la cantidad correcta de dígitos para el tipo de documento."
            ]);
            exit;
        }

        while ($fila = $resultDetalles->fetch_assoc()) {
        if ($fila['descripcion'] === null || trim($fila['descripcion']) === '') {
                echo json_encode([
                    "status" => "error",
                    "message" => "❌ La descripción no puede estar vacía."
                ]);
                exit;
        }
            $detalles[] = [
                "idDocumentoElectronico" => 0,
                "secuencia" => 0,
                "Id" => 1,
                "Cantidad" => "1",
                "PrecioReferencial" => number_format($fila['monto'], 2, '.', ''),
                "PrecioUnitario" => number_format($gravadas, 2, '.', ''),
                "TipoPrecio" => "01",
                "CodigoItem" => "01",
                "Descripcion" => $fila['descripcion'],
                "UnidadMedida" => "NIU",
                "Impuesto" => number_format($totalIgv, 2, '.', ''),
             	"TipoImpuesto" => "10",
             	"TotalVenta" =>number_format($gravadas, 2, '.', ''),
                "tasaIgv" => 18.00,
                "TotalIcbper" => 0.0,
                "ImpuestoIcbper" => 0.0,
                "CantidadBolsa" => 0
            ];
        }
        $tipoComprobante = ($factura['codigotipo_comprobante'] == '01') ? 'Factura' : 'Boleta';
        // 🔹 Crear JSON de la factura
        $facturaElectronica = [
            "idDocumentoElectronico" => 0,
            "idEmpresa" => 39845, 
            "IdDocumento" => "{$factura['serie']}-{$factura['correlativo']}",
            "FechaEmision" => date("c"),
            "HoraEmision" => date("H:i:s"),
            "Moneda" => "PEN",
            "TipoDocumento" => $factura['codigotipo_comprobante'],
            "TipoOperacion" => "0101",
            "Gravadas" => number_format($gravadas, 2, '.', ''),
            "TotalIgv" => number_format($totalIgv, 2, '.', ''),
            "TotalVenta" => number_format($montoTotal, 2, '.', ''),
            "TipoDocumentoRec" => $tipoDocumentoRec,
            "NroDocumentoRec" => $nroDocumentoRec,
            "NombreLegalRec" => $factura['cliente'],
            "FechaVencimiento" => date("c", strtotime($factura['fecha_pago'])),
            "EnvioSunat" => "NO",
            "Contribuyente_id" => "20608971689",
            "TipoPago" => "Contado",
            "tasaIgv" => 18.00,
            "DocumentoElectronicoDetalle" => $detalles
        ];

        // 🔹 Convertir a JSON
        $jsonData = json_encode($facturaElectronica, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

        // 🔹 Configuración de cURL
        //$url = "https://cpeapidemo.spk.com.pe/api/DocumentoElectronico/save-invoice";
        $url = "https://20608971689innovacpe.spk.com.pe/api/DocumentoElectronico/save-invoice";

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Bearer TU_TOKEN_AQUI'
        ]);
        
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

        // 🔹 Enviar solicitud a la API
        $respuesta = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("❌ Error en cURL: " . curl_error($ch));
        }
        curl_close($ch);

        // 🔹 Decodificar respuesta de la API
        $respuestaApi = json_decode($respuesta, true);
        //$respuesta = curl_exec($ch);
        //$info = curl_getinfo($ch);
       // echo "Código de respuesta HTTP: " . $info['http_code'];
       // var_dump($respuesta);
        if (!$respuestaApi) {
            throw new Exception("⚠️ La API no devolvió una respuesta válida.");
        }

        // 🔹 Obtener el CDR/XML
        if (isset($respuestaApi['xml'])) {
            $xmlBase64 = $respuestaApi['xml'];
            $rutaXML = "../files/cdr/{$factura['serie']}-{$factura['correlativo']}.xml";
            file_put_contents($rutaXML, base64_decode($xmlBase64));
        }

        // 🔹 Mostrar resultado
        echo json_encode([
            "success" => true,
            "message" => "✅ {$tipoComprobante} enviada con éxito.",
            "idDocumento" => $respuestaApi['idDocumentoElectronico'] ?? 'N/A',
            "estado" => $respuestaApi['stateInvoice'] ?? 'N/A',
            "mensaje" => $respuestaApi['reponseServer'] ?? 'N/A',
            "rutaXML" => $rutaXML ?? ''
        ]);

        $idDocumentoElectronico = isset($respuestaApi['idDocumentoElectronico']) ? $respuestaApi['idDocumentoElectronico'] : null; 
        $estado = isset($respuestaApi['stateInvoice']) ? $respuestaApi['stateInvoice'] : 'N/A'; 
        $mensaje = isset($respuestaApi['reponseServer']) ? $respuestaApi['reponseServer'] : 'N/A'; 
         $fechaEnvioSUNAT_mysql = null;
        if (preg_match('/(\d{2}\/\d{2}\/\d{4} \d{2}:\d{2}:\d{2})/', $mensaje, $coincidencias)) {
            $fechaStr = $coincidencias[1]; // Ejemplo: "19/06/2025 11:13:06"
            $dt = DateTime::createFromFormat('d/m/Y H:i:s', $fechaStr);
            if ($dt) {
                $fechaEnvioSUNAT_mysql = $dt->format('Y-m-d H:i:s'); // Ejemplo: "2025-06-19 11:13:06"
            }
        }

         if ($idDocumentoElectronico) {
             // Insertar los datos en la base de datos
             $insert_facturacion = "INSERT INTO facturacion (idcontrato,codigotipo_comprobante,serie,correlativo,impuesto,op_gravadas,op_inafectas,op_exoneradas,op_gratuitas,isc,total_igv,total_venta,estado,iddocumentoelectronico,idpago,sMesajeRespuesta,idAnulacion,fecha_envio)
                                    VALUES ('{$factura['idcontrato']}',
                                            '{$factura['codigotipo_comprobante']}',
                                            '{$factura['serie']}',
                                            '{$factura['correlativo']}',
                                            '18',
                                            '{$gravadas}',
                                            '0',
                                            '0',
                                            '0',
                                            '0',
                                            '{$totalIgv}',
                                            '{$montoTotal}',
                                            '{$estado}',
                                            '{$idDocumentoElectronico}',
                                            '$idpago',
                                            '{$mensaje}',
                                            '0',
                                            " . ($fechaEnvioSUNAT_mysql ? "'$fechaEnvioSUNAT_mysql'" : "NULL") . "
                                            )";
        
             ejecutarConsulta($insert_facturacion);
             // 🔹 Actualizar la tabla pagos con el idDocumentoElectronico
             $update_pagos = "UPDATE pago SET iddocumentoelectronico = '{$idDocumentoElectronico}', idAnulacion='0', estado_facturacion='2',sMesajeRespuesta='{$mensaje}' WHERE idpago = '$idpago'";
             ejecutarConsulta($update_pagos);
         } else {
             throw new Exception("⚠️ No se pudo PROCESAR el comprobante electrónico.");
         }

    } catch (Exception $e) {
        echo json_encode(["success" => false, "message" => $e->getMessage()]);
    }
}

    public function anular_documento($idpago) {
            try {
                // 🔹 Obtener datos del documento a anular
                $sqlDocumento = "SELECT p.serie,p.correlativo,p.fecha_pago,p.monto,e.nombre as cliente, e.num_documento,t.tipo,p.idcontrato,p.codigotipo_comprobante 
                                FROM pago p 
                                JOIN persona e ON p.idcliente=e.idpersona 
                                JOIN tipo_documento t ON t.idtipo_documento =e.idtipo_documento 
                                    WHERE p.idpago = $idpago";
                $resultDocumento = ejecutarConsulta($sqlDocumento);
                $documento = $resultDocumento->fetch_assoc();

                if (!$documento) {
                    throw new Exception("❌ No se encontró el documento con ID: $idpago.");
                }

                $tipoComprobante = ($documento['codigotipo_comprobante'] == '01') ? 'Factura' : 'Boleta';

                $tipoDocumentoRec = $documento['tipo'];
                $nroDocumentoRec = $documento['num_documento'];
        
                // Validar longitud del número de documento
                if (($tipoDocumentoRec == 1 && strlen($nroDocumentoRec) != 8) || 
                    ($tipoDocumentoRec == 6 && strlen($nroDocumentoRec) != 11)) {
                    throw new Exception("❌ El número de documento no tiene la cantidad correcta de dígitos para el tipo de documento.");
                }

                // 🔹 Construir JSON para la anulación
                $anulacion = [
                    "idAnulacion" => 0,
                    "idEmpresa" => 39845, // ID de la empresa en el sistema
                    "Contribuyente_id" => $nroDocumentoRec,
                    "TipoDocumento" => $documento['codigotipo_comprobante'],
                    "IdDocumento" => "{$documento['serie']}-{$documento['correlativo']}",
                    "FechaEmision" => date("c", strtotime($documento['fecha_pago'])),
                    "FechaEnvio" => null,
                    "EnvioSunat" => "NO",
                    "idResumen" => null,
                    "idComunicacion" => null,
                    "idDocumentoElectronico" => null,
                    "modalidadEnvio" => null,
                    "fechaRecepcion" => date("c", strtotime($documento['fecha_pago'])),
                    "fechaAnulacion" => null,
                    "documentoComunicacion" => null,
                    "NroTicket" => null,
                    "estadoEnvio" => "PE",
                    "IdDocumentoBaja" => null,
                    "TipoDocumentoBaja" => null,
                    "mensaje" => "Solicitud de anulación enviada",
                    "codigo" => null,
                    "TipoEnvioSunat" => null,
                    "RazonSocial" => null,
                    "UsuarioSol" => null,
                    "ClaveSol" => null,
                    "token" => null,
                    "usuarioSecundario" => null,
                    "claveUsuarioSecundario" => null,
                    "nombreCertificado" => null,
                    "claveCertificado" => null,
                    "ApiTokenSunat" => null,
                    "userApiSunat" => null,
                    "claveApiSunat" => null,
                    "Action" => 0,
                    "CustomID" => 0
                ];

                // 🔹 Convertir a JSON
                $jsonData = json_encode($anulacion, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

                // 🔹 Configuración de cURL para enviar la solicitud a la API de anulación
                //$url = "https://cpeapidemo.spk.com.pe/api/RecepcionComunicacionBaja/save-comunicationLow";
                $url = "https://20608971689innovacpe.spk.com.pe/api/RecepcionComunicacionBaja/save-comunicationLow";

                $ch = curl_init($url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    'Content-Type: application/json',
                    'Authorization: Bearer TU_TOKEN_AQUI'
                ]);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

                 // 🔹 Enviar solicitud
                $respuesta = curl_exec($ch);
                if ($respuesta === false) {
                    throw new Exception("❌ Error en cURL: " . curl_error($ch));
                }
                curl_close($ch);

                if (empty($respuesta)) {
                    throw new Exception("⚠️ La API no devolvió una respuesta válida.");
                }

                $respuestaApi = json_decode($respuesta, true);
                if (!$respuestaApi) {
                    throw new Exception("⚠️ La API devolvió un JSON inválido.");
                }

                // 🔹 Obtener datos de la API
                $idAnulacion = $respuestaApi['idAnulacion'] ?? null;
                $estado = $respuestaApi['estadoEnvio'] ?? 'N/A';
                $mensaje = $respuestaApi['mensaje'] ?? 'N/A';

                if (!$idAnulacion) {
                    throw new Exception("⚠️ No se pudo PROCESAR el comprobante electrónico.");
                }

                // 🔹 Actualizar en la tabla `pago`
                $update_pagos = "UPDATE pago SET idAnulacion = '{$idAnulacion}', sMesajeRespuesta='{$mensaje}',estado_facturacion='3' WHERE idpago = '$idpago'";
                ejecutarConsulta($update_pagos);

                $update_facturacion = "UPDATE facturacion SET idAnulacion = '{$idAnulacion}', estado='{$estado}',sMesajeRespuesta='{$mensaje}' WHERE idpago = '$idpago'";
                ejecutarConsulta($update_facturacion);

                // 🔹 Enviar respuesta final
                echo json_encode([
                    "success" => true,
                    "message" => "✅ {$tipoComprobante} ya se comunico de baja.",
                    "idAnulacion" => $idAnulacion,
                    "estado" => $estado,
                    "mensaje" => $respuestaApi['mensaje'] ?? 'N/A'
                ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
                exit;

            } catch (Exception $e) {
                echo json_encode(["success" => false, "message" => $e->getMessage()], JSON_UNESCAPED_UNICODE);
                exit;
            }
        }

            public function cantidadTotales()
            {
                // 🔹 Obtener el ingreso total
                $mesActual = date('m'); 
                $sql_ingreso = "SELECT sum(total_venta) AS ingreso FROM facturacion
                                WHERE month(created_at) = '$mesActual' AND idAnulacion = 0";
                $ingreso = ejecutarConsultaSimpleFila($sql_ingreso);
            
                // 🔹 Obtener el egreso total
                $sql_egreso = "SELECT sum(monto) AS egreso FROM egreso
                               WHERE month(fechapago) = '$mesActual'";
                $egreso = ejecutarConsultaSimpleFila($sql_egreso);
            
                // 🔹 Retornar ambos resultados en un array
                return [
                    "ingreso" => $ingreso['ingreso'] ?? 0,  // Si es null, retorna 0
                    "egreso" => $egreso['egreso'] ?? 0      // Si es null, retorna 0
                ];
            }
            
           public function enviar_facturacion_proceso($idpago, $fechaEmisionManual = null, $horaEmisionManual = null, $indice = 0) {
    try {
        // 🔹 Obtener datos de la factura
        $sqlFactura = "
            SELECT p.serie, p.correlativo, p.fecha_pago, p.monto, e.nombre AS cliente, 
                   e.num_documento, t.tipo, p.idcontrato, p.codigotipo_comprobante
            FROM pago p
            JOIN persona e ON p.idcliente = e.idpersona
            JOIN tipo_documento t ON t.idtipo_documento = e.idtipo_documento
            WHERE p.idpago = $idpago
        ";
        $factura = ejecutarConsulta($sqlFactura)->fetch_assoc();

        if (!$factura) {
             return ['error' => '❌ No se encontró información de la factura con ID: $idpago.'];
        }

        // 🔹 Validación del número de documento según tipo
        $tipoDocumentoRec = $factura['tipo'];
        $nroDocumentoRec = $factura['num_documento'];

        if (
            ($tipoDocumentoRec == 1 && strlen($nroDocumentoRec) != 8) ||
            ($tipoDocumentoRec == 6 && strlen($nroDocumentoRec) != 11)
        ) {
            return [
                "status" => false,
                "message" => "❌ El número de documento no tiene la cantidad correcta de dígitos para el tipo de documento."
            ];
        }

        // 🔹 Obtener detalles del pago
        $sqlDetalles = "
            SELECT p.monto, c.descripcion
            FROM pago p
            JOIN concepto_ingreso c ON c.idconcepto_ingreso = p.idconcepto_ingreso
            WHERE p.idpago = $idpago
        ";
        $resultDetalles = ejecutarConsulta($sqlDetalles);

        $detalles = [];
        $montoTotal = (float)$factura['monto'];
        $gravadas = round($montoTotal / 1.18, 2);
        $totalIgv = round($montoTotal - $gravadas, 2);

        while ($fila = $resultDetalles->fetch_assoc()) {
            if (empty(trim($fila['descripcion']))) {
                return [
                    "status" => false,
                    "message" => "❌ La descripción no puede estar vacía."
                ];
            }

            $detalles[] = [
                "idDocumentoElectronico" => 0,
                "secuencia" => 0,
                "Id" => 1,
                "Cantidad" => "1",
                "PrecioReferencial" => number_format($fila['monto'], 2, '.', ''),
                "PrecioUnitario" => number_format($gravadas, 2, '.', ''),
                "TipoPrecio" => "01",
                "CodigoItem" => "01",
                "Descripcion" => $fila['descripcion'],
                "UnidadMedida" => "NIU",
                "Impuesto" => number_format($totalIgv, 2, '.', ''),
                "TipoImpuesto" => "10",
                "TotalVenta" => number_format($gravadas, 2, '.', ''),
                "tasaIgv" => 18.00,
                "TotalIcbper" => 0.0,
                "ImpuestoIcbper" => 0.0,
                "CantidadBolsa" => 0
            ];
        }
        
        // Si no te mandaron hora manual, la generas escalonadamente
        if (!$fechaEmisionManual || !$horaEmisionManual) {
            $segundos_extra = 1;
            $dt = new DateTime();
            $dt->modify("+{$segundos_extra} seconds");
            $fechaEmisionManual = $dt->format("Y-m-d");
            $horaEmisionManual = $dt->format("H:i:s");
        }

        // 🔹 Preparar JSON de la factura
        $facturaElectronica = [
            "idDocumentoElectronico" => 0,
            "idEmpresa" => 39845,
            "IdDocumento" => "{$factura['serie']}-{$factura['correlativo']}",
            "FechaEmision" => "{$fechaEmisionManual}T{$horaEmisionManual}",
            "HoraEmision"  => $horaEmisionManual,
            "Moneda" => "PEN",
            "TipoDocumento" => $factura['codigotipo_comprobante'],
            "TipoOperacion" => "0101",
            "Gravadas" => number_format($gravadas, 2, '.', ''),
            "TotalIgv" => number_format($totalIgv, 2, '.', ''),
            "TotalVenta" => number_format($montoTotal, 2, '.', ''),
            "TipoDocumentoRec" => $tipoDocumentoRec,
            "NroDocumentoRec" => $nroDocumentoRec,
            "NombreLegalRec" => $factura['cliente'],
            "FechaVencimiento" => date("c", strtotime($factura['fecha_pago'])),
            "EnvioSunat" => "NO",
            "Contribuyente_id" => "20608971689",
            "TipoPago" => "Contado",
            "tasaIgv" => 18.00,
            "DocumentoElectronicoDetalle" => $detalles
        ];

        // 🔹 Enviar la solicitud a la API (sin token)
        $jsonData = json_encode($facturaElectronica, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        //$url = "https://cpeapidemo.spk.com.pe/api/DocumentoElectronico/save-invoice";
        $url = "https://20608971689innovacpe.spk.com.pe/api/DocumentoElectronico/save-invoice";

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            CURLOPT_POSTFIELDS => $jsonData
        ]);

        $respuesta = curl_exec($ch);
        if (curl_errno($ch)) {
            throw new Exception("❌ Error en cURL: " . curl_error($ch));
        }
        curl_close($ch);

        $respuestaApi = json_decode($respuesta, true);
        if (!$respuestaApi) {
             return ['error' => '⚠️ La API no devolvió una respuesta válida.'];
        }

        // 🔹 Guardar XML si existe
        if (!empty($respuestaApi['xml'])) {
            $rutaXML = "../files/cdr/{$factura['serie']}-{$factura['correlativo']}.xml";
            file_put_contents($rutaXML, base64_decode($respuestaApi['xml']));
        }

        // 🔹 Guardar resultados en BD
        $idDoc = $respuestaApi['idDocumentoElectronico'] ?? null;
        $estado = $respuestaApi['stateInvoice'] ?? 'N/A';
        $mensaje = $respuestaApi['reponseServer'] ?? 'N/A';
        
        $fechaEnvioSUNAT_mysql = null;
        if (preg_match('/(\d{2}\/\d{2}\/\d{4} \d{2}:\d{2}:\d{2})/', $mensaje, $coincidencias)) {
            $fechaStr = $coincidencias[1]; // Ejemplo: "19/06/2025 11:13:06"
            $dt = DateTime::createFromFormat('d/m/Y H:i:s', $fechaStr);
            if ($dt) {
                $fechaEnvioSUNAT_mysql = $dt->format('Y-m-d H:i:s'); // Ejemplo: "2025-06-19 11:13:06"
            }
        }
        

        if ($idDoc) {
            $insert = "
                INSERT INTO facturacion (
                    idcontrato, codigotipo_comprobante, serie, correlativo, impuesto,
                    op_gravadas, op_inafectas, op_exoneradas, op_gratuitas, isc,
                    total_igv, total_venta, estado, iddocumentoelectronico, idpago, sMesajeRespuesta, idAnulacion, fecha_envio
                ) VALUES (
                    '{$factura['idcontrato']}', '{$factura['codigotipo_comprobante']}', '{$factura['serie']}', '{$factura['correlativo']}', '18',
                    '{$gravadas}', '0', '0', '0', '0',
                    '{$totalIgv}', '{$montoTotal}', '{$estado}', '{$idDoc}', '$idpago', '{$mensaje}', '0', " . ($fechaEnvioSUNAT_mysql ? "'$fechaEnvioSUNAT_mysql'" : "NULL") . "
                )
            ";
            ejecutarConsulta($insert);

            $update = "
                UPDATE pago 
                SET iddocumentoelectronico = '{$idDoc}', 
                    idAnulacion = '0', 
                    estado_facturacion = '2', 
                    sMesajeRespuesta = '{$mensaje}' 
                WHERE idpago = '$idpago'
            ";
            ejecutarConsulta($update);

            return [
                "success" => true,
                "message" => "✅ " . (($factura['codigotipo_comprobante'] == '01') ? 'Boleta' : 'Factura') . " enviada con éxito.",
                "idDocumento" => $idDoc,
                "estado" => $estado,
                "mensaje" => $mensaje,
                "rutaXML" => $rutaXML ?? ''
            ];
        }

        throw new Exception("⚠️ No se pudo PROCESAR el comprobante electrónico.");

    } catch (Exception $e) {
        return [
            "success" => false,
            "message" => $e->getMessage()
        ];
    }
}

      

}