<?php
//Incluimos conexion a la base de 
require_once('../config/Conexion.php');

Class Finanza
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }

  public function mostrar_finanzas($idcierre,$tipo_pago)
    {
      $queryIngresos="SELECT p.tipoingreso,date(p.fecha_pago)as fecha_pago,e.nombre as cliente,c.nombre as categoria_ingreso,b.nombre as banco,p.nro_operacion,p.correlativo_pago,p.monto 
                      FROM pago p
                      JOIN persona e ON p.idcliente=e.idpersona
                      LEFT JOIN categoria_ingreso c ON p.idcategoria_ingreso=c.idcategoria_ingreso
                      LEFT JOIN banco b on p.idbanco=b.idbanco
                      WHERE p.idcierre='$idcierre' and p.tipoingreso='$tipo_pago' ";
      $resultIngresos = ejecutarConsulta($queryIngresos);

      $ingresos = [];
      while ($row = $resultIngresos->fetch_assoc()) {
      $ingresos[] = $row;
      }

      $queryEgresos="SELECT e.tipopago,e.fechapago,e.idtipo,c.concepto,e.descripcion,e.tipo_comprobante,e.nrorecibo,e.monto FROM egreso e
                     LEFT JOIN concepto_egreso c ON e.idconcepto_egreso=c.idconcepto_egreso
                     WHERE e.idcierre='$idcierre' and tipopago='$tipo_pago'";
      $resulEgresos= ejecutarConsulta($queryEgresos);

      $egresos = [];
      while ($row = $resulEgresos->fetch_assoc()) {
      $egresos[] = $row;
      }

      $queryMovimiento="SELECT m.monto_apertura,m.estado_caja,m.idcierre,m.nrocorrelativo,m.fecha_apertura,m.fecha_cierre,u.nombre as usuario,year(fecha_cierre)as ano, LPAD(MONTH(fecha_cierre), 2, '0') AS mes 
                        FROM movimiento_caja m 
                        JOIN caja c ON m.idcaja=c.idcaja
                        JOIN usuario u ON c.idusuario=u.idusuario
                        WHERE m.idcierre='$idcierre' GROUP BY m.estado_caja ";
      $resultMovimiento = ejecutarConsulta($queryMovimiento);

      $movimientos = [];
      while ($row = $resultMovimiento->fetch_assoc()) {
      $movimientos[] = $row;
      }
      // Respuesta JSON
    return [
      "ingresos" => $ingresos,
      "egresos" => $egresos,
      "movimientos" => $movimientos
      ];
    }
    
    public function mostrar_finanzas_total($tipo_pago,$fecha_inicio,$fecha_fin,$tipo_usuario)
{
  $queryMovimiento = "SELECT 
                            m.idmovimientocaja,
                            m.monto_apertura,
                            m.estado_caja,
                            m.idcierre,
                            m.nrocorrelativo,
                            m.fecha_apertura,
                            m.fecha_cierre,
                            u.nombre AS usuario,
                            YEAR(m.fecha_cierre) AS ano,
                            LPAD(MONTH(m.fecha_cierre), 2, '0') AS mes,
                            (
                              SELECT m1.monto_apertura
                              FROM movimiento_caja m1
                              JOIN caja c1 ON m1.idcaja = c1.idcaja
                              JOIN usuario u1 ON c1.idusuario = u1.idusuario
                              WHERE m1.idcaja = m.idcaja
                                AND m1.estado_caja = '1'
                                AND DATE(m1.fecha_apertura) BETWEEN '$fecha_inicio' AND '$fecha_fin' AND u1.estadocaja='$tipo_usuario'
                                LIMIT 1
                            ) AS apertura_inicial
                          FROM movimiento_caja m
                          JOIN caja c ON m.idcaja = c.idcaja
                          JOIN usuario u ON c.idusuario = u.idusuario
                          WHERE DATE(m.fecha_apertura) BETWEEN '$fecha_inicio' AND '$fecha_fin' AND u.estadocaja='$tipo_usuario'
                            AND m.estado_caja = '2'";
  $resultMovimiento = ejecutarConsulta($queryMovimiento);

   $queryMovimiento_apertura = "SELECT m1.monto_apertura,u1.nombre as usuario,date(m1.fecha_apertura)as fecha_apertura,m1.nrocorrelativo
                                FROM movimiento_caja m1
                                JOIN caja c1 ON m1.idcaja = c1.idcaja
                                JOIN usuario u1 ON c1.idusuario = u1.idusuario
                                WHERE m1.estado_caja = '1'
                                  AND DATE(m1.fecha_apertura) BETWEEN '$fecha_inicio' AND '$fecha_fin' AND u1.estadocaja='$tipo_usuario'
                                ";
  $resultMovimiento_apertura = ejecutarConsulta($queryMovimiento_apertura);

  $movimientos = [];
  $movimientos_apertura = [];
  $todos_ingresos = [];
  $todos_egresos = [];

    while ($row = $resultMovimiento_apertura->fetch_assoc()) {
    $movimientos_apertura[] = $row;
    }

  while ($row = $resultMovimiento->fetch_assoc()) {
    $movimientos[] = $row;
    $idmovimiento = $row['idmovimientocaja'];

    // Ingresos para este movimiento
    $queryIngresos = "SELECT p.tipoingreso, date(p.fecha_pago) as fecha_pago, e.nombre as cliente, c.nombre as categoria_ingreso, b.nombre as banco, p.nro_operacion, p.correlativo_pago, p.monto, u.nombre as usuario 
                      FROM pago p
                      JOIN persona e ON p.idcliente = e.idpersona
                      LEFT JOIN categoria_ingreso c ON p.idcategoria_ingreso = c.idcategoria_ingreso
                      LEFT JOIN banco b ON p.idbanco = b.idbanco
                      JOIN usuario u ON p.idusuario = u.idusuario
                      WHERE p.idcierre = '$idmovimiento' AND p.tipoingreso = '$tipo_pago'";
    $resultIngresos = ejecutarConsulta($queryIngresos);
    while ($ing = $resultIngresos->fetch_assoc()) {
      $ing['idmovimiento'] = $idmovimiento; // opcional: para saber a qué movimiento pertenece
      $todos_ingresos[] = $ing;
    }

    // Egresos para este movimiento
    $queryEgresos = "SELECT e.tipopago, e.fechapago, e.idtipo, c.concepto, e.descripcion, e.tipo_comprobante, e.nrorecibo, e.monto, u.nombre as usuario  
                     FROM egreso e
                     LEFT JOIN concepto_egreso c ON e.idconcepto_egreso = c.idconcepto_egreso
                     JOIN usuario u ON e.idusuario = u.idusuario
                     WHERE e.idcierre = '$idmovimiento' AND e.tipopago = '$tipo_pago'";
    $resultEgresos = ejecutarConsulta($queryEgresos);
    while ($egr = $resultEgresos->fetch_assoc()) {
      $egr['idmovimiento'] = $idmovimiento; // opcional: para saber a qué movimiento pertenece
      $todos_egresos[] = $egr;
    }
  }

  // Respuesta JSON
  return [
    "movimientos" => $movimientos,
    "movimientos_apertura" => $movimientos_apertura,
    "ingresos" => $todos_ingresos,
    "egresos" => $todos_egresos
  ];
}




}