<?php
//Incluimos conexion a la base de 
require_once('../config/Conexion.php');

Class Ingreso
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }
    
  public function insertar($idproveedor, $idusuario, $tipo_comprobante, $serie_comprobante, $numero_comprobante,$fecha_hora, $total_compra, $nrorecibo, $idarticulo, $nroproducto, $marca, $cantidad,$precio_compra, $precio_venta, $garantia, $idarticuloCant, $codigoCant, $cantidadCant, $macCant, $serieCant) 
  {
    $sw = true;

    // Inserción principal en la tabla `ingreso`
    $sql = "INSERT INTO ingreso(
                idproveedor, idusuario, tipo_comprobante, serie_comprobante, num_comprobante, 
                fecha_hora, total_compra, estado, estado_ingreso
            ) 
            VALUES (
                '$idproveedor', '$idusuario', '$tipo_comprobante', '$serie_comprobante', 
                '$numero_comprobante', '$fecha_hora', '$total_compra', 'Aceptado', '1'
            )";
    $idingresonew = ejecutarConsulta_retornarID($sql);

    if (!$idingresonew) {
        return false; // Fallo en la inserción principal
    }

    // Inserción en la tabla `detalle_ingreso`
    $sw = $this->insertarDetalleIngreso($idingresonew, $idarticulo, $nroproducto, $marca, $cantidad, $precio_compra, $precio_venta, $garantia, $nrorecibo);

    // Inserción en la tabla `inventario_ingreso`
    if ($sw) {
        $sw = $this->insertarInventarioIngreso($idingresonew, $idarticuloCant, $codigoCant, $cantidadCant, $macCant, $serieCant, $idproveedor, $fecha_hora, $nrorecibo, $idusuario);
    }

    // Actualización de `tb_detalleingreso` si las inserciones previas son exitosas
    if ($sw) {
        $sw = $this->actualizarDetalleIngreso($idingresonew);
    }

    return $sw;
}

// Función para insertar en `detalle_ingreso`
private function insertarDetalleIngreso($idingresonew, $idarticulo, $nroproducto, $marca, $cantidad, $precio_compra, $precio_venta, $garantia, $nrorecibo) {
    $sw = true;

    for ($i = 0; $i < count($idarticulo); $i++) {
        $sql_detalle = "INSERT INTO detalle_ingreso(
                            idingreso, idarticulo, cantidad, precio_compra, precio_venta, 
                            marca, garantia, nrofactura
                        ) 
                        VALUES (
                            '$idingresonew', '$idarticulo[$i]', '$cantidad[$i]', 
                            '$precio_compra[$i]', '$precio_venta[$i]', 
                            '$marca[$i]', '$garantia[$i]', '$nrorecibo'
                        )";
        if (!ejecutarConsulta($sql_detalle)) {
            $sw = false;
            break;
        }
    }
    
     for ($e = 0; $e < count($idarticulo); $e++) {
            $sql_detalle2 = "UPDATE inventario_almacen set stock_ingreso=stock_ingreso+'$cantidad[$e]' WHERE idarticulo='$idarticulo[$e]' and idalmacen='1'";
         if (!ejecutarConsulta($sql_detalle2)) {
             $sw = false;
             break;
         }
     }

    return $sw;
}

// Función para insertar en `inventario_ingreso`
private function insertarInventarioIngreso($idingresonew, $idarticuloCant, $codigoCant, $cantidadCant, $macCant, $serieCant, $idproveedor, $fecha_hora, $nrorecibo, $idusuario) {
    $sw = true;

    for ($i = 0; $i < count($idarticuloCant); $i++) {
        $sql_detalle1 = "INSERT INTO inventario_ingreso(
                             iddetalle_ingreso, idalmacen, codigo, idarticulo, cantidad, mac, serie, 
                             idprovedor, fecha, nrofactura, stock, estadomaterial, estadomovimiento, 
                             fechaingreso, idusuario
                         ) 
                         VALUES (
                             '$idingresonew', '1', '$codigoCant[$i]', '$idarticuloCant[$i]', 
                             '$cantidadCant[$i]', '$macCant[$i]', '$serieCant[$i]', 
                             '$idproveedor', NOW(), '$nrorecibo', '$cantidadCant[$i]', 
                             1, 1, '$fecha_hora', '$idusuario'
                         )";
        if (!ejecutarConsulta($sql_detalle1)) {
            $sw = false;
            break;
        }
    }

    $sqltraerdatos = "SELECT COUNT(idinventario_ingreso) AS cant, idarticulo 
                    FROM inventario_ingreso 
                    WHERE iddetalle_ingreso = '$idingresonew' 
                    GROUP BY idarticulo";

                $resultado = ejecutarConsulta($sqltraerdatos);

                while ($fila = mysqli_fetch_assoc($resultado)) {
                    $cant = $fila['cant'];
                    $idarti = $fila['idarticulo'];

                    // Aquí actualizamos el campo 'nroproducto' en la tabla 'articulo' sumando la cantidad 'cant'
                    $sql_detalle2 = "
                        UPDATE articulo 
                        SET nroproducto = nroproducto + $cant 
                        WHERE idarticulo = '$idarti'
                    ";
                    ejecutarConsulta($sql_detalle2);
                }

    return $sw;
}


private function actualizarDetalleIngreso($idingresonew) {
    $sw = true;

    $sql = "SELECT * FROM detalle_ingreso WHERE idingreso='$idingresonew'";
    $resultado = ejecutarConsulta($sql);

    if (!$resultado) {
        return false; // Fallo en la consulta inicial
    }

    while ($fila = mysqli_fetch_assoc($resultado)) {
        $arti = $fila['idarticulo'];
        $mar = $fila['marca'];
        $gar = $fila['garantia'];
        $prec = $fila['precio_compra'];
        $prev = $fila['precio_venta'];
        $nro = $fila['nrofactura'];

        $actualizar = "UPDATE inventario_ingreso 
                       SET marca='$mar', garantia='$gar', precio_compra='$prec', precio_venta='$prev' 
                       WHERE idarticulo='$arti' AND nrofactura='$nro'";
        if (!ejecutarConsulta($actualizar)) {
            $sw = false;
            break;
        }
    }

    return $sw;
}

    // Método para editar
    public function editar($idpersona,$nombre,$idtipo_documento,$num_documento,$celular,$telefono,$whatsapp,$email,$estado) {
        $sql = "UPDATE persona SET 
                nombre = '$nombre', 
                idtipo_documento = '$idtipo_documento', 
                num_documento = '$num_documento', 
                celular = '$celular', 
                telefono = '$telefono', 
                whatsapp = '$whatsapp',
                email = '$email', 
                estado = '$estado'                 
                WHERE idpersona = '$idpersona'";
        return ejecutarConsulta($sql);
    }

    public function listaringreso()
    {
      $sql="SELECT i.idingreso,DATE(i.fecha_hora) as fecha, i.idproveedor,p.nombre as proveedor, u.idusuario, u.nombre as usuario, i.tipo_comprobante,i.serie_comprobante,i.num_comprobante,i.total_compra,i.estado,i.estado_ingreso FROM ingreso i inner join persona p on i.idproveedor=p.idpersona inner join usuario u on i.idusuario=u.idusuario order by i.idingreso desc";
      return ejecutarConsulta($sql);

    }

    public function mostrar($idingreso)
    {
      $sql="SELECT * FROM persona where idpersona='$idpersona'";
      return ejecutarConsultaSimpleFila($sql);

    }

    //Implementamos un metodo para eliminar registro
    public function eliminar($idingreso)
    {
        $sqldetalle="SELECT * FROM detalle_ingreso WHERE idingreso='$idingreso'";
        $resultado=ejecutarConsulta($sqldetalle);
        while($fila = mysqli_fetch_assoc($resultado)){
        
        $arti=$fila['idarticulo'];
        $cant=$fila['cantidad'];
        
        $actualizar="UPDATE articulo set nroproducto=nroproducto-'".$cant."'  WHERE  idarticulo='$arti' ";
            ejecutarConsulta($actualizar);
        } 

        $sql1="DELETE FROM inventario_ingreso where iddetalle_ingreso='$idingreso'";
         ejecutarConsulta($sql1);

        $sql="DELETE FROM detalle_ingreso where idingreso='$idingreso'";
        ejecutarConsulta($sql);

        $sql2="DELETE FROM ingreso  where idingreso='$idingreso'";
        return ejecutarConsulta($sql2);
        
    }

    public function selectTipoDocumento()
    {
      $sql="SELECT * FROM tipo_documento";
      return ejecutarConsulta($sql);

    }

    public function mostrardetalle($idingreso)
    {
     // Consulta para la tabla ingreso
     $queryIngresos = "SELECT d.cantidad, d.precio_venta, d.precio_compra, a.nombre 
     FROM detalle_ingreso d 
     JOIN articulo a ON d.idarticulo = a.idarticulo 
     WHERE d.idingreso = $idingreso";
    $resultIngresos = ejecutarConsulta($queryIngresos);

    $ingresos = [];
    while ($row = $resultIngresos->fetch_assoc()) {
    $ingresos[] = $row;
    }

    // Consulta para la tabla detalle_ingreso
    $queryDetalles = "SELECT d.fecha, a.codigo, a.nombre, d.mac, d.precio_compra, d.codigo as codi, c.codigo as cat, d.cantidad 
        FROM inventario_ingreso d 
        JOIN articulo a ON d.idarticulo = a.idarticulo 
        JOIN categoria c ON a.idcategoria = c.idcategoria 
        WHERE d.iddetalle_ingreso = '$idingreso' 
        ORDER BY d.idinventario_ingreso DESC";
    $resultDetalles = ejecutarConsulta($queryDetalles);

    $detalles = [];
    while ($row = $resultDetalles->fetch_assoc()) {
    $detalles[] = $row;
    }

    // Respuesta JSON
    return [
    "ingresos" => $ingresos,
    "detalles" => $detalles
    ];

    }

    public function validarRegistro($valor)
    {
      $sql="SELECT COUNT(*) AS cantidad FROM inventario_ingreso WHERE mac = '$valor' OR serie = '$valor'";
     
      return ejecutarConsultaSimpleFila($sql);

    }

}


?>