<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once('../config/Conexion.php');

Class Inventario
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }

     
public function insertar($idtecnico, $idusuario, $fecha_hora, $idalmacen, $idarticulo, $codigo, $marca, $cantidad, $mac, $serie, $unidadmedida, $precio_compra, $nrofactura, $idprovedor, $garantia, $estadomaterial, $precio_venta)
{
    global $conexion; // Para usar la conexión global

    $hoy = date("Y-m-d H:i:s");

    try {
        // Iniciar transacción
        $conexion->begin_transaction();

        // Insertar en la tabla `salida`
        $sql = "INSERT INTO salida (fechasalida, idtecnico, idusuario) 
                VALUES ('$fecha_hora', '$idtecnico', '$idusuario')";
        $idsalida = ejecutarConsulta_retornarID($sql);

        $num_elementos = 0;

        // Insertar en la tabla `tb_detallesalida`
        while ($num_elementos < count($idarticulo)) {
            $sql_detalle = "INSERT INTO inventario_salida (idalmacen, idarticulo, codigo, marca, cantidad, stock, mac, serie, idtecnico, unidadmedida, precio_compra, fechaingreso, fechasalida, idprovedor, nrofactura, garantia, idusuario, estadomaterial, estadomovimiento, precio_venta, idsalida, idaveria)
                            VALUES (
                                '$idalmacen',
                                '$idarticulo[$num_elementos]', 
                                '$codigo[$num_elementos]', 
                                '$marca[$num_elementos]', 
                                '$cantidad[$num_elementos]', 
                                '$cantidad[$num_elementos]', 
                                '$mac[$num_elementos]', 
                                '$serie[$num_elementos]', 
                                '$idtecnico', 
                                '$unidadmedida[$num_elementos]', 
                                '$precio_compra[$num_elementos]', 
                                '$hoy', 
                                '$fecha_hora', 
                                '$idprovedor[$num_elementos]', 
                                '$nrofactura[$num_elementos]', 
                                '$garantia[$num_elementos]', 
                                '$idusuario', 
                                '$estadomaterial[$num_elementos]', 
                                '3', 
                                '$precio_venta[$num_elementos]', 
                                '$idsalida','0'
                            )";
            if (!ejecutarConsulta($sql_detalle)) {
                throw new Exception("Error al insertar en tb_detallesalida");
            }
            $num_elementos++;
        }

         $num_elementos1 = 0;
        // Insertar en la tabla `movimientomateriales`
         while ($num_elementos1 < count($idarticulo)) {
             $sql_detallee = "INSERT INTO movimiento_materiales (idalmacen, idarticulo, idsalida, codigo, marca, mac, cantidadsalida, cantidaddevuelto, cantidadusado, idtecnico, precio_venta, estadomaterial, estadomovimiento, precio_compra, estado, idaveria)
                              VALUES (
                                  '$idalmacen',
                                  '$idarticulo[$num_elementos1]',
                                  '$idsalida', 
                                  '$codigo[$num_elementos1]', 
                                  '$marca[$num_elementos1]', 
                                  '$mac[$num_elementos1]', 
                                  '$cantidad[$num_elementos1]',
                                  '0','0', 
                                  '$idtecnico', 
                                  '$precio_venta[$num_elementos1]', 
                                  '$estadomaterial[$num_elementos1]', 
                                  '3', 
                                  '$precio_compra[$num_elementos1]',
                                  '0','0'
                              )";
             if (!ejecutarConsulta($sql_detallee)) {
                 throw new Exception("Error al insertar en movimientomateriales");
            }
             $num_elementos1++;
         }

            $num_elementos2 = 0;
            $agrupadoo = [];
            
            // Agrupar cantidades por idarticulo y código
            while ($num_elementos2 < count($idarticulo)) {
                $clave = $idarticulo[$num_elementos2] . '|' . $codigo[$num_elementos2]; // Clave única idarticulo|codigo
                $cantidad_actual = $cantidad[$num_elementos2];
            
                if (!isset($agrupadoo[$clave])) {
                    $agrupadoo[$clave] = 0;
                }
                $agrupadoo[$clave] += $cantidad_actual; // Sumar cantidades agrupadas
            
                $num_elementos2++;
            }
            
            // Ejecutar un único UPDATE por cada idarticulo + código
            foreach ($agrupadoo as $clave => $cantidad_total) {
                list($articulo, $codigo_articulo) = explode('|', $clave);
            
                $sql_detalle3 = "UPDATE inventario_ingreso 
                                SET stock = stock - '$cantidad_total', 
                                    fechasalida = '$fecha_hora', 
                                    estadomovimiento = '1' 
                                WHERE idarticulo = '$articulo' 
                                AND codigo = '$codigo_articulo' 
                                AND idalmacen = '$idalmacen'";
            
                if (!ejecutarConsulta($sql_detalle3)) {
                    throw new Exception("Error al actualizar inventario_ingreso");
                }
            }

            $num_elementos3 = 0;
            $agrupado = [];

            // Agrupar cantidades por idarticulo
            while ($num_elementos3 < count($idarticulo)) {
                $articulo = $idarticulo[$num_elementos3];
                $cantidad_actual = $cantidad[$num_elementos3];

                if (!isset($agrupado[$articulo])) {
                    $agrupado[$articulo] = 0;
                }
                $agrupado[$articulo] += $cantidad_actual;

                $num_elementos3++;
            }

            // Ejecutar un único UPDATE por cada idarticulo
            foreach ($agrupado as $articulo => $cantidad_total) {
                $sql_detalle4 = "UPDATE inventario_almacen 
                                SET stock_salida = stock_salida + '$cantidad_total'
                                WHERE idarticulo = '$articulo' AND idalmacen = '$idalmacen'";

                if (!ejecutarConsulta($sql_detalle4)) {
                    throw new Exception("Error al actualizar inventario_almacen");
                }
            }


        // Confirmar transacción
        $conexion->commit();
        return true;
    } catch (Exception $e) {
        // Revertir la transacción en caso de error
        $conexion->rollback();
        error_log("Error en insertar: " . $e->getMessage());
        return false;
    }
}
    
    public function listarinventario()
    {
      $sql=" SELECT i.idingreso,date(i.fecha_hora) as fecha_hora, i.idproveedor,p.nombre as proveedor, u.idusuario, u.nombre as usuario, i.tipo_comprobante,i.serie_comprobante,i.num_comprobante,i.num_cuotas,i.valor_cuota,i.total_compra,i.impuesto,i.estado FROM ingreso i inner join persona p on i.idproveedor=p.idpersona inner join usuario u on i.idusuario=u.idusuario where i.estado='Aceptado' order by i.idingreso desc";
      return ejecutarConsulta($sql);

    }

    public function listarsalida()
    {
      $sql="SELECT s.idsalida,date(s.fechasalida) as fechasalida,o.nombre as responsable,p.nombre as usuario, year(s.created_at) as ano FROM salida s join usuario o on s.idtecnico=o.idusuario join usuario p on s.idusuario=p.idusuario order by s.idsalida desc";
      return ejecutarConsulta($sql);

    }
    //// LISTA LOS PRODUCTOS QUE TENGA >0 EL STOCK Y ESTADO MATERIAL DIFERENTE DE !4
    public function listarproducto($idalmacen)
    {
   $sql="SELECT d.idinventario_ingreso,d.codigo,d.idarticulo,d.cantidad,d.mac,d.serie,d.marca,a.nombre,d.precio_compra,d.precio_venta,d.stock,a.unidad_medida,d.nrofactura,d.idprovedor,d.garantia,d.estadomaterial 
       FROM inventario_ingreso d 
       join articulo a on d.idarticulo=a.idarticulo 
       WHERE d.stock>0 and d.estadomaterial!=4 and d.condicion='1' and d.idalmacen='$idalmacen' order by d.codigo desc";
      return ejecutarConsulta($sql);
    }

    public function mostrardetalle($idingreso)
    {
     // Consulta para la tabla ingreso
     $queryIngresos = "SELECT d.cantidad, d.precio_venta, d.precio_compra, a.nombre 
     FROM detalle_ingreso d 
     JOIN articulo a ON d.idarticulo = a.idarticulo 
     WHERE d.idingreso = $idingreso";
    $resultIngresos = ejecutarConsulta($queryIngresos);

    $ingresos = [];
    while ($row = $resultIngresos->fetch_assoc()) {
    $ingresos[] = $row;
    }

    // Consulta para la tabla detalle_ingreso
    $queryDetalles = "SELECT d.fecha, a.codigo, a.nombre, d.mac, d.precio_compra, d.codigo as codi, c.codigo as cat, d.cantidad 
        FROM inventario_ingreso d 
        JOIN articulo a ON d.idarticulo = a.idarticulo 
        JOIN categoria c ON a.idcategoria = c.idcategoria 
        WHERE d.iddetalle_ingreso = '$idingreso' 
        ORDER BY d.idinventario_ingreso DESC";
    $resultDetalles = ejecutarConsulta($queryDetalles);

    $detalles = [];
    while ($row = $resultDetalles->fetch_assoc()) {
    $detalles[] = $row;
    }

    // Respuesta JSON
    return [
    "ingresos" => $ingresos,
    "detalles" => $detalles
    ];

    }


    public function mostrardetallesalida($idsalida)
    {

    // Consulta para la tabla detalle_ingreso
    $queryDetalles = "SELECT d.fechasalida,u.nombre as tecnico,a.nombre as producto,d.codigo,d.cantidad,d.precio_compra,d.estadomaterial,d.estadomovimiento,c.codigo as madre,d.unidadmedida
        FROM inventario_salida d 
        JOIN articulo a ON d.idarticulo = a.idarticulo 
        JOIN usuario u ON d.idtecnico = u.idusuario 
        JOIN categoria c on a.idcategoria=c.idcategoria
        WHERE d.idsalida = '$idsalida' 
        ORDER BY d.idinventario_salida DESC";
    $resultDetalles = ejecutarConsulta($queryDetalles);

    $detalles = [];
    while ($row = $resultDetalles->fetch_assoc()) {
    $detalles[] = $row;
    }

    // Respuesta JSON
    return [
    "detalles" => $detalles
    ];

    }

}


?>