<?php
//Incluimos conexion a la base de trader_cdlrisefall3methods
require "../config/Conexion.php";

date_default_timezone_set('America/Lima');
Class Mikrotik
{
  //Implementando nuestro constructor
  public function __construct()
  {


  }

    //Implementar metodo para listar los registros

    public function enviar_mikrotik($idtecnologia, $idtorre) {

            $sql_torre = "SELECT * FROM torre WHERE idtorre='$idtorre'";
            $resultado_torre = ejecutarConsultaSimpleFila($sql_torre);
        
            // Validamos si la consulta falló o no devolvió resultados
            if (!$resultado_torre || empty($resultado_torre)) {
                echo json_encode(["status" => "error", "message" => "Error al obtener los datos de la Torre."]);
                return;
            }
        
            $servidor_torre = $resultado_torre['servidor_torre'] ?? null;
            $usuario_torre = $resultado_torre['usuario_torre'] ?? null;
            $pass_torre = $resultado_torre['pass_torre'] ?? null;
        
            // Validamos que los datos esenciales no sean nulos
            if (!$servidor_torre || !$usuario_torre || !$pass_torre) {
                echo json_encode(["status" => "error", "message" => "Faltan datos esenciales de la Torre."]);
                return;
            }
           
            require_once '../config/api_mt_include2.php';
            $API = new routeros_api();
            $API->debug = false;

            // Credenciales de conexión a MikroTik
           // $servidor_torre = '209.45.52.2';
           // $usuario_torre = 'radhyo1';
           // $pass_torre = 'c4b3rl456#$';

            // Conectar a MikroTik
            if (!$API->connect($servidor_torre, $usuario_torre, $pass_torre, '8728')) {
                echo json_encode(["status" => "error", "message" => "Error al conectar con MikroTik."]);
                return;
            }
            // Contadores por estado
            $contador_listo = 0;
            $contador_activa = 0;
            $contador_notifica = 0;
            $contador_corte = 0;
            $contador_suspende = 0;
            $contador_baja = 0;
            $contador_existentes = 0;

    // Consulta para obtener usuarios en cualquier estado relevante
        $consulta_usuarios = "
            SELECT m.idcontrato, m.usuario, m.password, p.nombre_plan, m.comentario_linea, m.sit_linea, m.mac_linea, m.ip_linea, p.upload_servicio, p.download_servicio
            FROM mikrotik m
            JOIN contrato c ON c.idcontrato = m.idcontrato
            JOIN planes p ON p.idplan = c.idplan
            WHERE m.idtorre = '$idtorre' 
            AND m.idtecnologia = '$idtecnologia' 
            AND m.cambio_linea='si'
            AND m.estado='1'
            AND m.sit_linea IN ('listo', 'activa', 'notifica', 'corte', 'suspende', 'baja', 'negra')";

        $resultado_usuarios = ejecutarConsulta($consulta_usuarios);

        if (!$resultado_usuarios) {
            echo json_encode(["status" => "error", "message" => "Error al ejecutar la consulta de usuarios."]);
            $API->disconnect();
            return;
        }

                if($idtecnologia == 1 ){

                    while ($fila = $resultado_usuarios->fetch_assoc()) {
                        
                        $comentario_linea = trim($fila["comentario_linea"]);
                        $id_linea = $fila["idcontrato"];
                        $estado_actual = trim($fila["sit_linea"]);
                        $mac_linea = trim($fila["mac_linea"]);
                        $velocidad_linea = trim($fila["upload_servicio"]);
                        $velocidad2_linea = trim($fila["download_servicio"]);
                        $ip_linea = trim($fila["ip_linea"]);

                        $API->write("/ip/hotspot/ip-binding/print", false);
                        $API->write("?mac-address=" . $mac_linea, true);
                        $usuarios_existente = $API->read();
                    
                        // 🔹 Filtrar y obtener el ID del usuario correcto en MikroTik
                        $id_usuario = null;
                        if (!empty($usuarios_existente) && is_array($usuarios_existente)) {
                            foreach ($usuarios_existente as $usr) {
                                if (isset($usr['mac-address']) && strtolower(trim($usr['mac-address'])) === strtolower(trim($mac_linea))) {
                                    $id_usuario = $usr[".id"];
                                    break;
                                }
                            }
                        }

                         // Verificar si el usuario ya existe en MikroTik
                            $API->write("/ip/hotspot/user/print", false);
                            $API->write("?name=" . $mac_linea, true);
                            $usuarios_mac = $API->read();

                            $id_usuario_mac = null;
                            if (!empty($usuarios_mac) && is_array($usuarios_mac)) {
                                foreach ($usuarios_mac as $usr) {
                                    if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                        $id_usuario_mac = $usr[".id"];
                                        break;
                                    }
                                }
                            }

                            $API->write("/queue/simple/print", false);
                            $API->write("?name=" . $mac_linea, true);
                            $usuarios_queue = $API->read();

                            $id_usuario_queue = null;
                            if (!empty($usuarios_queue) && is_array($usuarios_queue)) {
                                foreach ($usuarios_queue as $usr) {
                                    if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                        $id_usuario_queue = $usr[".id"];
                                        break;
                                    }
                                }
                            }

                        switch ($estado_actual) {
                            case 'listo':
                                if (empty($id_usuario_mac) || empty($id_usuario) || empty($id_usuario_queue)) { 

                                    // Agregar usuario a MikroTik
                                     $API->write("/ip/hotspot/ip-binding/add",false);	
                                     $API->write("=address=$ip_linea",false);
                                     $API->write("=type=bypassed",false);
                                     $API->write("=comment=$comentario_linea",false);
                                     $API->write("=mac-address=$mac_linea",true);
                                     $API->read();

                                     $API->write("/queue/simple/add",false);	
                                     $API->write("=name=$mac_linea",false);
                                     $API->write("=comment=$comentario_linea",false);
                                     $API->write("=max-limit=$velocidad2_linea/$velocidad_linea",false);
                                     $API->write("=queue=default-small/default-small",false);
                                     $API->write("=target=$ip_linea",true);
                                     $API->read();


                                    $API->write("/ip/hotspot/user/add", false);
                                    $API->write("=profile=Notice", false);
                                    $API->write("=comment=$comentario_linea(activa)", false);
                                    $API->write("=name=$mac_linea", true);
                                    $API->read();

                                    //sleep(1);
                                    // Asegurar que la consulta devuelve un array válido
                                    $API->write("/ip/hotspot/user/print", false);
                                    $API->write("?name=" . $mac_linea, true);
                                    $usuarios_mac = $API->read();
                
                                    if (!empty($usuarios_mac) && is_array($usuarios_mac)) {
                                        foreach ($usuarios_mac as $usr) {
                                            if (isset($usr['name']) && strtolower(trim($usr['name'])) === strtolower(trim($mac_linea))) {
                                                $id_usuario_mac = $usr[".id"];
                                                break;
                                            }
                                        }
                                    }
                
                                    if (!empty($id_usuario_mac)) {
                                        // Si el usuario se creó correctamente, lo deshabilitamos
                                        $API->write("/ip/hotspot/user/disable", false);
                                        $API->write("=.id=" . $id_usuario_mac, true);
                                        $API->read();
                                
                                    }
                                    // Actualizar estado en la base de datos
                                    ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                    ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
                    
                                    $contador_listo++;
                                } else {
                                    $contador_existentes++;
                                }
                                break;

                                case 'activa':
                                    if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                         // 🔹 Actualizar el perfil y comentario del usuario en Hotspot
                                        if (!empty($id_usuario)) {
                                            $API->write("/ip/hotspot/ip-binding/enable", false);
                                            $API->write("=.id=" . $id_usuario, true);
                                            $API->read();
                                        }
                                        // 🔹 Habilitar el usuario en Hotspot si existe
                                        if (!empty($id_usuario_mac)) {
                                            $API->write("/ip/hotspot/user/set", false);	
                                            $API->write("=profile=Notice", false);
                                            $API->write("=comment=$comentario_linea(activa)", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();

                                            $API->write("/ip/hotspot/user/disable", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();
                                        }

                                        // 🔹 Actualizar la cola de velocidad si existe
                                        if (!empty($id_usuario_queue)) {
                                            $API->write("/queue/simple/set", false);	
                                            $API->write("=comment=$comentario_linea", false);
                                            $API->write("=max-limit=$velocidad2_linea/$velocidad_linea", false);
                                            $API->write("=.id=" . $id_usuario_queue, true);
                                            $API->read();
                                        }

                                        ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                        ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
                    
                                        $contador_activa++;
                                    }
                                break;

                                case 'notifica':
                                    if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                        if (!empty($id_usuario_mac)) {
                                            $API->write("/ip/hotspot/user/set", false);	
                                            $API->write("=profile=Notice", false);
                                            $API->write("=comment=$comentario_linea(notifica)", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();
                                            
                                            $API->write("/ip/hotspot/user/enable", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();
                                        }
                                        
                                        if (!empty($id_usuario)) {
                                            $API->write("/ip/hotspot/ip-binding/disable", false);
                                            $API->write("=.id=" . $id_usuario, true);
                                            $API->read();
                                        }

                                        ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                        ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                                        $contador_notifica++;
                                    }
                                break;

                                case 'corte':
                                    if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                        if (!empty($id_usuario_mac)) {
                                            $API->write("/ip/hotspot/user/set", false);	
                                            $API->write("=profile=bill", false);
                                            $API->write("=comment=$comentario_linea(corte)", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();
                                            
                                            $API->write("/ip/hotspot/host/remove", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();
                                            
                                            $API->write("/ip/hotspot/user/enable", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();
                                                                                        
                                        }
                                        if (!empty($id_usuario)) {
                                            $API->write("/ip/hotspot/ip-binding/disable", false);
                                            $API->write("=.id=" . $id_usuario, true);
                                            $API->read();
                                        }

                                        ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                        ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                                    }
                                    $contador_corte++;
                                break;

                                case 'suspende':
                                    if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                        if (!empty($id_usuario)) {
                                            $API->write("/ip/hotspot/ip-binding/disable", false);
                                            $API->write("=.id=" . $id_usuario, true);
                                            $API->read();
                                        }

                                        if (!empty($id_usuario_mac)) {
                                            $API->write("/ip/hotspot/user/set", false);	
                                            $API->write("=profile=Notice", false);
                                            $API->write("=comment=$comentario_linea(suspende)", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();

                                            $API->write("/ip/hotspot/user/disable", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();
                                        }

                                    ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'suspende', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                    ejecutarConsulta("UPDATE contrato SET sit_contrato = 'suspende', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                                    }
                                    $contador_suspende++;
                                break;

                                case 'baja':
                                    if (!empty($id_usuario) || !empty($id_usuario_mac) || !empty($id_usuario_queue)) {

                                        if (!empty($id_usuario)) {
                                            $API->write("/ip/hotspot/ip-binding/remove", false);
                                            $API->write("=.id=" . $id_usuario, true);
                                            $API->read();
                                        }
                                        if (!empty($id_usuario_queue)) {
                                            $API->write("/queue/simple/remove", false);	
                                            $API->write("=.id=" . $id_usuario_queue, true);
                                            $API->read();
                                        }
                                        if (!empty($id_usuario_mac)) {
                                            $API->write("/ip/hotspot/user/remove", false);
                                            $API->write("=.id=" . $id_usuario_mac, true);
                                            $API->read();
                                        }
                                    }

                                     ejecutarConsulta("DELETE mikrotik  WHERE idcontrato = '$id_linea'");
                                     ejecutarConsulta("UPDATE contrato SET sit_contrato = 'baja', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");

                                    $contador_baja++;
                                break;
                        }
                    }
                    
                    echo json_encode([
                        "status" => "success",
                        "message" => "Usuarios procesados correctamente.",
                        "listo" => $contador_listo,
                        "activa" => $contador_activa,
                        "notifica" => $contador_notifica,
                        "corte" => $contador_corte,
                        "suspende" => $contador_suspende,
                        "baja" => $contador_baja,
                        "existentes" => $contador_existentes
                    ]);

                    $API->disconnect();


                 }else if ($idtecnologia == 3){
			//$usuario_p='123456789';
                    while ($fila = $resultado_usuarios->fetch_assoc()) {
                        $usuario = trim($fila["usuario"]);
                        $password = trim($fila["password"]);
                        $planes = trim($fila["nombre_plan"]);
                        $comentario_linea = trim($fila["comentario_linea"]);
                        $id_linea = $fila["idcontrato"];
                        $estado_actual = trim($fila["sit_linea"]);
                    
                        // Verificar si el usuario ya existe en MikroTik
                        $API->write("/ppp/secret/print", false);
                        $API->write("?name=" . $usuario, true);
                        $usuarios_existente = $API->read();
                    
                        // 🔹 Filtrar y obtener el ID del usuario correcto en MikroTik
                        $id_usuario = null;
                        foreach ($usuarios_existente as $usr) {
                            if ($usr['name'] === $usuario) {
                                $id_usuario = $usr[".id"];
                                break;
                            }
                        }
                    
                        switch ($estado_actual) {
                            case 'listo':
                                if (empty($usuarios_existente)) {
                                    // Agregar usuario a MikroTik
                                    $API->write("/ppp/secret/add", false);
                                    $API->write("=name=" . $usuario, false);
                                    $API->write("=password=" . $password, false);
                                    $API->write("=service=pppoe", false);
                                    $API->write("=profile=" . $planes, false);
                                    $API->write("=comment=" . $comentario_linea . "(activa)", true);
                                    $API->read();
                    
                                    // Obtener el ID del usuario agregado
                                    $API->write("/ppp/secret/print", false);
                                    $API->write("?name=" . $usuario, true);
                                    $usuario_creado = $API->read();
                    
                                    if (!empty($usuario_creado)) {
                                        $id_usuario = $usuario_creado[0][".id"];
                    
                                        // 🔹 Habilitar usuario
                                        $API->write("/ppp/secret/enable", false);
                                        $API->write("=.id=" . $id_usuario, true);
                                        $API->read();
                                    }
                    
                                    // Actualizar estado en la base de datos
                                    ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                    ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
                    
                                    $contador_listo++;
                                } else {
                                    $contador_existentes++;
                                }
                                break;
                    
                            case 'activa':
                                if ($id_usuario !== null) {
                                    $nuevo_comentario = $comentario_linea . "(activa)";
                    
                                    $API->write("/ppp/secret/set", false);
                                    $API->write("=.id=" . $id_usuario, false);
                                    $API->write("=profile=" . $planes, false);
                                    $API->write("=comment=" . $nuevo_comentario, true);
                                    $API->read();
                    
                                    // Habilitar usuario
                                    $API->write("/ppp/secret/enable", false);
                                    $API->write("=.id=" . $id_usuario, true);
                                    $API->read();
                    
                                    ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                    ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
                    
                                    $contador_activa++;
                                }
                                break;
                    
                            case 'notifica':
                                if ($id_usuario !== null) {
                                    $nuevo_comentario = $comentario_linea . "(notifica)";
                    
                                    $API->write("/ppp/secret/set", false);
                                    $API->write("=.id=" . $id_usuario, false);
                                    $API->write("=profile=" . $planes, false);
                                    $API->write("=comment=" . $nuevo_comentario, true);
                                    $API->read();
                                    
                                    // Habilitar usuario
                                    $API->write("/ppp/secret/enable", false);
                                    $API->write("=.id=" . $id_usuario, true);
                                    $API->read();
                    
                                    ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                    ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
                    
                                    $contador_notifica++;
                                }
                                break;
                    
                            case 'corte':
					    if ($id_usuario !== null) {
					        $nuevo_comentario = $comentario_linea . "(corte)";
					
					        // Actualizar perfil y comentario
					        $API->write("/ppp/secret/set", false);
					        $API->write("=.id=" . $id_usuario, false);
					        $API->write("=profile=" . $planes, false);
					        $API->write("=comment=" . $nuevo_comentario, true);
					        $API->read();
					
					        // 🔍 Buscar el ID de la sesión activa del usuario
					        $API->write("/ppp/active/print", false);
					        $API->write("?name=" . $usuario, true);
					        $activos = $API->read();
					
					        if (!empty($activos)) {
					            $id_sesion_activa = $activos[0][".id"];
					
					            // ❌ Remover sesión activa usando ID correcto
					            $API->write("/ppp/active/remove", false);
					            $API->write("=.id=" . $id_sesion_activa, true);
					            $API->read();
					        }
					
					        // 🚫 Deshabilitar usuario
					        $API->write("/ppp/secret/disable", false);
					        $API->write("=.id=" . $id_usuario, true);
					        $API->read();
					
					        // 📥 Actualizar base de datos
					        ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = '' WHERE idcontrato = '$id_linea'");
					        ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
					
					        $contador_corte++;
					    }
					    break;
                    
                            case 'suspende':
                                if ($id_usuario !== null) {
                                    $nuevo_comentario = $comentario_linea . "(suspende)";
                    
                                    $API->write("/ppp/secret/set", false);
                                    $API->write("=.id=" . $id_usuario, false);
                                    $API->write("=profile=" . $planes, false);
                                    $API->write("=comment=" . $nuevo_comentario, true);
                                    $API->read();
                    
                                    // Deshabilitar usuario
                                    $API->write("/ppp/secret/disable", false);
                                    $API->write("=.id=" . $id_usuario, true);
                                    $API->read();
                    
                                    ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'suspende', cambio_linea = '' WHERE idcontrato = '$id_linea'");
                                    ejecutarConsulta("UPDATE contrato SET sit_contrato = 'suspende', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
                    
                                    $contador_suspende++;
                                }
                                break;
                    
                            case 'baja':
                                if ($id_usuario !== null) {
                                    $API->write("/ppp/secret/remove", false);
                                    $API->write("=.id=" . $id_usuario, true);
                                    $API->read();

                                    ejecutarConsulta("DELETE mikrotik  WHERE idcontrato = '$id_linea'");
                                     ejecutarConsulta("UPDATE contrato SET sit_contrato = 'baja', estado_actualizar = '1' WHERE idcontrato = '$id_linea'");
                    
                                    $contador_baja++;
                                }
                                break;
                        }
                    }

                    echo json_encode([
                        "status" => "success",
                        "message" => "Usuarios procesados correctamente.",
                        "listo" => $contador_listo,
                        "activa" => $contador_activa,
                        "notifica" => $contador_notifica,
                        "corte" => $contador_corte,
                        "suspende" => $contador_suspende,
                        "baja" => $contador_baja,
                        "existentes" => $contador_existentes
                    ]);

                    $API->disconnect();
                } 
        }

    public function listarmikrotik()
    {
      $sql="SELECT * FROM torre";
      return ejecutarConsulta($sql);
    }

    public function actualizar_linea()
    {
      $consulta_linea = "SELECT k.idmkrotik, k.idcontrato, k.sit_linea, c.sit_contrato 
                        FROM mikrotik k 
                        JOIN contrato c ON c.idcontrato = k.idcontrato
                        WHERE k.estado='1' and  c.estado_contrato='Activo'";

      $resultado_linea = ejecutarConsulta($consulta_linea);
      if (!$resultado_linea) {
          echo "Error al ejecutar la consulta.";
          return;
      }

      $contador_actualizados = 0;
      $contador_procesados = 0;

      while ($fila_linea = $resultado_linea->fetch_assoc()) {
          $sit_linea = $fila_linea["sit_linea"];
          $id_contrato = $fila_linea["idcontrato"];

          if (!in_array($sit_linea, ['pendiente', 'listo' ,'baja', 'suspende', 'negra'])) {
              $contador_procesados++;

              $accion = 'activa';
              $esnotifica = 0;
              $escorte = 0;

              $consulta_cuotas = "SELECT fecha_pago FROM cuota 
                                  WHERE idcontrato = '$id_contrato' AND estado_cuota = '1' AND estado_contrato = '1'  
                                  ORDER BY idcuota ASC LIMIT 1";

              $fila_cuotas = ejecutarConsultaSimpleFila($consulta_cuotas);

              if ($fila_cuotas) {
                  $fecha_actual = date("Y-m-d");
                  $fechavence_cuota = $fila_cuotas["fecha_pago"];
                  $fechavence_cuota2 = date("Y-m-d", strtotime("$fechavence_cuota + 3 days"));

                  if ($fecha_actual > $fechavence_cuota && $fecha_actual <= $fechavence_cuota2) {
                      $esnotifica = 1;
                  }
                  if ($fecha_actual > $fechavence_cuota2) {
                      $escorte = 1;
                  }
              }

              if ($esnotifica == 1) $accion = 'notifica';
              if ($escorte == 1) $accion = 'corte';

              $actualizado = false;

              switch ($accion) {
                  case 'notifica':
                      if ($sit_linea != 'notifica') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'notifica', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'notifica', estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'corte':
                      if ($sit_linea != 'corte') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'corte', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'corte',estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
                  case 'activa':
                      if ($sit_linea != 'activa') {
                          ejecutarConsulta("UPDATE mikrotik SET sit_linea = 'activa', cambio_linea = 'si' WHERE idcontrato = '$id_contrato'");
                          ejecutarConsulta("UPDATE contrato SET sit_contrato = 'activa',estado_actualizar='2' WHERE idcontrato = '$id_contrato'");
                          $actualizado = true;
                      }
                      break;
              }

              if ($actualizado) {
                  $contador_actualizados++;
              }
          }
      }

      // Enviar respuesta JSON
      echo json_encode([
          "status" => "success",
          "procesados" => $contador_procesados,
          "actualizados" => $contador_actualizados
      ]);
    }

  }

    //  "INSERT INTO bd_huancayo.mikrotik (idcontrato,sit_linea,idtorre,idtecnologia,comentario_linea, velocidad_linea, velocidad2_linea, password, usuario, cambio_linea)  
    // SELECT DISTINCT '1', 'listo', '3', '3', comentario_linea, velocidad_linea,velocidad2_linea, password, usuario, 'si'  
    //  FROM bd_huancayo_prueba.linea  
    //  WHERE comentario_linea IS NOT NULL 
    //  AND comentario_linea <> ''
    //  AND password <> ''
    //  AND sit_linea in('activa','corte','notifica')
    //  ORDER BY id_linea DESC ";


 ?>