<?php
//Incluimos conexion a la base de 
date_default_timezone_set('America/Lima');
require "../config/Conexion.php";

Class Plan
{
  //Implementando nuestro constructor
  public function __construct()
  {


  }
      public function insertar($nombre_plan,$idtecnologia,$idolt,$precio,$descripcion,$upload_servicio,$download_servicio,$idtorre) {
      
      $sql_torre = "SELECT * FROM torre WHERE idtorre='$idtorre'";
        $resultado_torre = ejecutarConsultaSimpleFila($sql_torre);
    
        // Validamos si la consulta falló o no devolvió resultados
        if (!$resultado_torre || empty($resultado_torre)) {
            echo json_encode(["status" => "error", "message" => "Error al obtener los datos de la Torre."]);
            return;
        }
    
        $servidor_torre = $resultado_torre['servidor_torre'] ?? null;
        $usuario_torre = $resultado_torre['usuario_torre'] ?? null;
        $pass_torre = $resultado_torre['pass_torre'] ?? null;
    
        // Validamos que los datos esenciales no sean nulos
        if (!$servidor_torre || !$usuario_torre || !$pass_torre) {
            echo json_encode(["status" => "error", "message" => "Faltan datos esenciales de la Torre."]);
            return;
        }

        require_once '../config/api_mt_include2.php';
        $API = new routeros_api();
        $API->debug = false;
    
       
    
        // Conectar a MikroTik
        if (!$API->connect($servidor_torre, $usuario_torre, $pass_torre, '8728')) {
            echo json_encode(["status" => "error", "message" => "Error al conectar con MikroTik."]);
            return;
        }
    
        $remote = 'pool_VLAN-30';
        $local = '192.168.211.1';

        $API->write("/ppp/profile/print", false);
        $API->write("?name=" . $nombre_plan, true);
        $planes_existente = $API->read();

        $API->write("/ppp/profile/print", false);
        $API->write("?name=" . $nombre_plan, true);
        $planes_existente = $API->read();
    
        if (!empty($planes_existente) && is_array($planes_existente)) {
            echo json_encode(["status" => "error", "message" => "El plan ya existe en MikroTik."]);
            $API->disconnect();
            return;
        }

          // Agregar nuevo perfil de PPP
            $API->write("/ppp/profile/add", false);
            $API->write("=name=" . $nombre_plan, false);
            $API->write("=local-address=" . $local, false);
            $API->write("=remote-address=" . $remote, false); // Corrección aquí
            $API->write("=rate-limit=" . $upload_servicio . "/" . $download_servicio, true);
            $API->read();
        
            // Cerrar conexión con MikroTik
            $API->disconnect();

            

            $sql = "INSERT INTO planes (nombre_plan, idtecnologia, idolt, precio, descripcion, upload_servicio, download_servicio) 
            VALUES ('$nombre_plan', '$idtecnologia', '$idolt', '$precio', '$descripcion', '$upload_servicio', '$download_servicio')";
            // Ejecutar consulta y validar resultado
            $result = ejecutarConsulta($sql);
                if ($result) {
                    echo json_encode(["status" => "success", "message" => "Plan registrado correctamente."]);
                } else {
                    echo json_encode(["status" => "error", "message" => "Error al registrar el plan."]);
                }
            return;
    }

    // Método para editar
    public function editar($idplan,$nombre_plan,$idtecnologia,$idolt,$precio,$descripcion,$upload_servicio,$download_servicio,$idtorre) {
    
    $sql_torre = "SELECT * FROM torre WHERE idtorre='$idtorre'";
        $resultado_torre = ejecutarConsultaSimpleFila($sql_torre);
    
        // Validamos si la consulta falló o no devolvió resultados
        if (!$resultado_torre || empty($resultado_torre)) {
            echo json_encode(["status" => "error", "message" => "Error al obtener los datos de la Torre."]);
            return;
        }
    
        $servidor_torre = $resultado_torre['servidor_torre'] ?? null;
        $usuario_torre = $resultado_torre['usuario_torre'] ?? null;
        $pass_torre = $resultado_torre['pass_torre'] ?? null;
    
        // Validamos que los datos esenciales no sean nulos
        if (!$servidor_torre || !$usuario_torre || !$pass_torre) {
            echo json_encode(["status" => "error", "message" => "Faltan datos esenciales de la Torre."]);
            return;
        }

      $sql_plan="SELECT nombre_plan FROM planes where idplan='$idplan'";
      $resultado = ejecutarConsultaSimpleFila($sql_plan);
      $nombre_plan_primero= $resultado['nombre_plan'];

      require_once '../config/api_mt_include2.php';
      $API = new routeros_api();
      $API->debug = false;
  
     
  
      // Conectar a MikroTik
      if (!$API->connect($servidor_torre, $usuario_torre, $pass_torre, '8728')) {
          echo json_encode(["status" => "error", "message" => "Error al conectar con MikroTik."]);
          return;
      }
  
      $remote = 'pool_VLAN-30';
      $local = '192.168.211.1';

      $API->write("/ppp/profile/print", false);
      $API->write("?name=" . $nombre_plan_primero, true);
      $planes_existente = $API->read();

      $id_usuario = null;
      foreach ($planes_existente as $usr) {
          if ($usr['name'] === $nombre_plan_primero) {
              $id_usuario = $usr[".id"];
              break;
          }
      }
      if ($id_usuario !== null) {

        $API->write("/ppp/profile/set", false);
        $API->write("=.id=" . $id_usuario, false);
        $API->write("=name=" . $nombre_plan, false);
        $API->write("=rate-limit=" . $upload_servicio . "/" . $download_servicio, true);
        $API->read();
      }

      $API->disconnect();

        $sql_contrato="UPDATE contrato set estado_actualizar='2' WHERE idplan='$idplan'";
        ejecutarConsulta($sql_contrato);

        $sql = "UPDATE planes SET 
                nombre_plan = '$nombre_plan', 
                idtecnologia = '$idtecnologia',
                idolt = '$idolt',
                precio = '$precio',
                descripcion = '$descripcion',
                upload_servicio = '$upload_servicio',
                download_servicio = '$download_servicio'                 
                WHERE idplan = '$idplan'";
         $result = ejecutarConsulta($sql);
         if ($result) {
             echo json_encode(["status" => "success", "message" => "Plan actualizado correctamente."]);
         } else {
             echo json_encode(["status" => "error", "message" => "Error al actualizar el plan."]);
         }
     return;
    }

    public function listarplan()
    {
      $sql="SELECT p.idplan,p.nombre_plan,p.precio,p.descripcion,p.upload_servicio,p.download_servicio,t.nombre as nombretecnologia,o.nombreolt FROM planes p join tecnologia t on p.idtecnologia=t.idtecnologia left join olt o on p.idolt=o.idolt ";
      return ejecutarConsulta($sql);

    }

    public function mostrar($idplan)
    {
      $sql="SELECT * FROM planes where idplan='$idplan'";
      return ejecutarConsultaSimpleFila($sql);

    }

    //Implementamos un metodo para eliminar registro
    public function eliminar($idplan)
    {
      $sql="DELETE FROM planes where idplan='$idplan'";
      return ejecutarConsulta($sql);
    }

    //Implementar metodo para listar los registros
    public function selectplan()
    {
      $sql="SELECT * FROM planes";
      return ejecutarConsulta($sql);
    }

    public function selectPlanTecnologia($idtecnologia)
    {
      $sql="SELECT * FROM planes where idtecnologia='$idtecnologia'";
      return ejecutarConsulta($sql);
    }

    public function selectPlanPorOlt($idolt)
    {
      $sql="SELECT * FROM planes where idolt='$idolt'";
      return ejecutarConsulta($sql);
    }

    public function obtenerDatosPlan($idplan)
    {
      $sql="SELECT * FROM planes where idplan='$idplan'";
      return ejecutarConsultaSimpleFila($sql);
    }

    public function selectPlanPorTorre()
    {
      $sql="SELECT * FROM planes where idtecnologia='1'";
      return ejecutarConsulta($sql);
    }

  }