<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('America/Lima');
require_once('../config/Conexion.php');

Class Transferencia
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }

     
public function insertar($idusuario, $fecha_hora, $idalmacen1, $idalmacen2, $observaciones, $idarticulo, $codigo, $marca, $cantidad, $mac, $serie, $unidadmedida, $precio_compra, $nrofactura, $idprovedor, $garantia, $estadomaterial, $precio_venta, $iddetalle_ingreso)
{
    global $conexion; // Para usar la conexión global

    $hoy = date("Y-m-d H:i:s");

    try {
        // Iniciar transacción
        $conexion->begin_transaction();

         // Agrupar artículos y sumar cantidades
         $articulos_agrupados = [];
         for ($i = 0; $i < count($idarticulo); $i++) {
             if (!isset($articulos_agrupados[$idarticulo[$i]])) {
                 $articulos_agrupados[$idarticulo[$i]] = 0;
             }
             $articulos_agrupados[$idarticulo[$i]] += $cantidad[$i]; // Sumar cantidades del mismo artículo
         }

         $num_elementos3 = 0;
         foreach ($articulos_agrupados as $id_articulo => $cantidad_total) {
             $comprobar_almacen = "SELECT * FROM inventario_almacen WHERE idarticulo='$id_articulo' and idalmacen='$idalmacen2'";
             $resultado_stock = ejecutarConsultaSimpleFila($comprobar_almacen);

             if (!$resultado_stock) {
                 // Insertar si no existe
                 $sql_insertar = "INSERT INTO inventario_almacen(idalmacen, idarticulo, stock_inicial, stock_ingreso, stock_salida) 
                                 VALUES ('$idalmacen2', '$id_articulo', '0', '$cantidad_total', '0')";
                 if (!ejecutarConsulta($sql_insertar)) {
                     throw new Exception("Error al actualizar inventario_almacen");
                 }
             } else {
                 // Actualizar si ya existe
                 $sql_detalle4 = "UPDATE inventario_almacen 
                                 SET stock_ingreso = stock_ingreso + '$cantidad_total'
                                 WHERE idarticulo = '$id_articulo' and idalmacen='$idalmacen2'";
                 if (!ejecutarConsulta($sql_detalle4)) {
                     throw new Exception("Error al actualizar inventario_almacen");
                 }
                
             }
                        $sql_detalle5 = "UPDATE inventario_almacen 
                                    SET stock_ingreso = stock_ingreso - '$cantidad_total'
                                    WHERE idarticulo = '$id_articulo' and idalmacen='$idalmacen1'";
                        if (!ejecutarConsulta($sql_detalle5)) {
                            throw new Exception("Error al actualizar inventario_almacen");
                        }

             $num_elementos3++;
         }
                    $sql_detalle6 = "INSERT INTO movimientos_almacen (idalmacen_origen, idalmacen_destino,fecha_movimiento, idusuario, observaciones, estado)
                    VALUES ('$idalmacen1','$idalmacen2','$fecha_hora','$idusuario','$observaciones','1')";
                     $idmovimiento = ejecutarConsulta_retornarID($sql_detalle6);


        $num_elementos = 0;

        // Insertar en la tabla `tb_detallesalida`
        while ($num_elementos < count($idarticulo)) {
            $sql_detalle = "INSERT INTO inventario_ingreso (idtransferencia, idalmacen, iddetalle_ingreso, idarticulo, codigo, marca, cantidad, stock, mac, serie,  unidadmedida, precio_compra, fechaingreso, fechasalida, idprovedor, nrofactura, garantia, idusuario, estadomaterial, estadomovimiento, precio_venta, idaveria)
                            VALUES (
                                    '$idmovimiento',
                                    '$idalmacen2',
                                    '$iddetalle_ingreso[$num_elementos]',
                                    '$idarticulo[$num_elementos]', 
                                    '$codigo[$num_elementos]', 
                                    '$marca[$num_elementos]', 
                                    '$cantidad[$num_elementos]', 
                                    '$cantidad[$num_elementos]', 
                                    '$mac[$num_elementos]', 
                                    '$serie[$num_elementos]', 
                                    '$unidadmedida[$num_elementos]', 
                                    '$precio_compra[$num_elementos]', 
                                    '$hoy', 
                                    '$fecha_hora', 
                                    '$idprovedor[$num_elementos]', 
                                    '$nrofactura[$num_elementos]', 
                                    '$garantia[$num_elementos]', 
                                    '$idusuario', 
                                    '$estadomaterial[$num_elementos]', 
                                    '1', 
                                    '$precio_venta[$num_elementos]', 
                                    '0'
                                    )";
            if (!ejecutarConsulta($sql_detalle)) {
                throw new Exception("Error al insertar en inventario_ingreso");
            }
            $num_elementos++;
        }


        $num_elementos2 = 0;
        // Actualizar en la tabla `tb_detalleingreso`
        while ($num_elementos2 < count($idarticulo)) {
            $sql_detalle3 = "UPDATE inventario_ingreso 
                             SET stock = stock - '$cantidad[$num_elementos2]', 
                                 fechasalida = '$fecha_hora', 
                                 estadomovimiento = '1' 
                             WHERE idarticulo = '$idarticulo[$num_elementos2]' 
                             AND codigo = '$codigo[$num_elementos2]' and idalmacen='$idalmacen1' and stock>0";
            if (!ejecutarConsulta($sql_detalle3)) {
                throw new Exception("Error al actualizar inventario_ingreso");
            }
            $num_elementos2++;
        }
        
        // Confirmar transacción
        $conexion->commit();
        return true;
    } catch (Exception $e) {
        // Revertir la transacción en caso de error
        $conexion->rollback();
        echo "Error: " . $e->getMessage();
        echo "Archivo: " . $e->getFile();
        echo "Línea: " . $e->getLine();
        return false;
    }
}
    
    //// LISTA LOS PRODUCTOS QUE TENGA >0 EL STOCK Y ESTADO MATERIAL DIFERENTE DE !4
    public function listarproducto($idalmacen)
    {
   $sql="SELECT d.idinventario_ingreso,d.iddetalle_ingreso,d.codigo,d.idarticulo,d.cantidad,d.mac,d.serie,d.marca,a.nombre,d.precio_compra,d.precio_venta,d.stock,a.unidad_medida,d.nrofactura,d.idprovedor,d.garantia,d.estadomaterial 
         FROM inventario_ingreso d 
         JOIN articulo a on d.idarticulo=a.idarticulo 
         WHERE d.stock>0 and d.estadomaterial!=4 and d.condicion='1' and d.idalmacen='$idalmacen'  order by d.codigo desc";
      return ejecutarConsulta($sql);
    }

    public function mostrardetalle($idmovimiento)
    {
    // Consulta para la tabla detalle_ingreso
    $queryDetalles = "SELECT d.fechaingreso,date(d.fechasalida)as fechasalida,a.nombre as producto,d.codigo,d.cantidad,d.precio_compra,d.estadomaterial,d.estadomovimiento,c.codigo as madre,d.unidadmedida
        FROM inventario_ingreso d 
        JOIN articulo a ON d.idarticulo = a.idarticulo 
        JOIN categoria c on a.idcategoria=c.idcategoria
        WHERE d.idtransferencia = '$idmovimiento' 
        ORDER BY d.idinventario_ingreso DESC";
    $resultDetalles = ejecutarConsulta($queryDetalles);

    $detalles = [];
    while ($row = $resultDetalles->fetch_assoc()) {
    $detalles[] = $row;
    }

    // Respuesta JSON
    return [
    "detalles" => $detalles
    ];

    }


    public function listar()
    {

    $listar_transferencia="SELECT a.nombre as almacen_origen,n.nombre as almacen_destino,m.fecha_movimiento,m.observaciones,m.estado,m.idmovimiento  FROM movimientos_almacen m
                           JOIN almacen a ON a.idalmacen=m.idalmacen_origen
                           JOIN almacen n ON n.idalmacen=m.idalmacen_destino ";
    return ejecutarConsulta($listar_transferencia);    

    }

}


?>