<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('America/Lima');
require_once('../config/Conexion.php');

Class Venta
{
  //Implementando nuestro constructor
  public function __construct()
  {

  }
public function insertar($idpersona,$idusuario,$idalmacen,$idcaja,$nrocorrelativo,$fecha_hora,$tipo_comprobante,$total_venta,$total_igv,$subtotal_total,$tipopago,$idbanco,$leyenda,$nroperacion,$idarticulo,$cantidad,$precio_compra,$precio_venta,$idinventario_ingreso){
    global $conexion; // Para usar la conexión global

    $hoy = date("Y-m-d H:i:s");

    try {
        // Iniciar transacción
        $conexion->begin_transaction();

        $sql = "INSERT INTO venta (idpersona,idusuario,codigotipo_comprobante,leyenda,nrocorrelativo,total_venta,total_igv,total_gravado,tipo_pago,nroperacion,idbanco,estado_venta,fecha_hora) 
        VALUES ('$idpersona', '$idusuario', '$tipo_comprobante','$leyenda','$nrocorrelativo','$total_venta','$total_igv','$subtotal_total','$tipopago','$nroperacion','$idbanco','1','$fecha_hora')";
        $idventa = ejecutarConsulta_retornarID($sql);

       $sql_pago="INSERT INTO pago(idcontrato,idbanco,idusuario,idcliente,tipoingreso,idcaja,monto,fecha_pago,descripcion,correlativo_pago,nro_operacion,idcategoria_ingreso,idconcepto_ingreso,idventa)
                    VALUES('0','$idbanco','$idusuario','$idpersona','$tipopago','$idcaja','$total_venta','$fecha_hora','Venta de Productos','$nrocorrelativo','$nroperacion','0','0','$idventa')";
       ejecutarConsulta($sql_pago);

        $num_elementos = 0;
        // Insertar en la tabla `tb_detallesalida`
        while ($num_elementos < count($idinventario_ingreso)) {
            $sql_detalle = "INSERT INTO detalle_venta (idventa, idalmacen, idinventario_ingreso, precio_compra, precio_venta, cantidad_venta)
                            VALUES (
                                    '$idventa',
                                    '$idalmacen',
                                    '$idinventario_ingreso[$num_elementos]',
                                    '$precio_compra[$num_elementos]', 
                                    '$precio_venta[$num_elementos]', 
                                    '$cantidad[$num_elementos]'
                                    )";
            if (!ejecutarConsulta($sql_detalle)) {
                throw new Exception("Error al insertar en detalle_venta");
            }
            $num_elementos++;
        }


             $num_elementos2 = 0;
            $agrupado = [];

            // Agrupar cantidades por idinventario_ingreso
            while ($num_elementos2 < count($idinventario_ingreso)) {
                $clave = $idinventario_ingreso[$num_elementos2]; // Clave única por idinventario_ingreso
                $cantidad_actual = $cantidad[$num_elementos2];

                if (!isset($agrupado[$clave])) {
                    $agrupado[$clave] = 0;
                }
                $agrupado[$clave] += $cantidad_actual; // Sumar cantidades agrupadas

                $num_elementos2++;
            }

            // Ejecutar un único UPDATE por cada idinventario_ingreso
            foreach ($agrupado as $idinventario => $cantidad_total) {
                $sql_detalle3 = "UPDATE inventario_ingreso 
                                SET stock = stock - '$cantidad_total', 
                                    fechasalida = '$fecha_hora', 
                                    estadomovimiento = '5' 
                                WHERE idinventario_ingreso = '$idinventario' 
                                AND idalmacen = '$idalmacen' 
                                AND stock > 0";

                if (!ejecutarConsulta($sql_detalle3)) {
                    throw new Exception("Error al actualizar inventario_ingreso");
                }
            }

        // Agrupar artículos y sumar cantidades
        $articulos_agrupados = [];
        for ($i = 0; $i < count($idarticulo); $i++) {
            if (!isset($articulos_agrupados[$idarticulo[$i]])) {
                $articulos_agrupados[$idarticulo[$i]] = 0;
            }
            $articulos_agrupados[$idarticulo[$i]] += $cantidad[$i]; // Sumar cantidades del mismo artículo
        }

        $num_elementos3 = 0;
        foreach ($articulos_agrupados as $id_articulo => $cantidad_total) {

            $sql_detalle5 = "UPDATE inventario_almacen 
                        SET stock_salida = stock_salida + '$cantidad_total'
                        WHERE idarticulo = '$id_articulo' and idalmacen='$idalmacen'";
            if (!ejecutarConsulta($sql_detalle5)) {
                throw new Exception("Error al actualizar inventario_almacen");
            }

            $num_elementos3++;
        }
        
        // Confirmar transacción
        $conexion->commit();
        return true;
    } catch (Exception $e) {
        // Revertir la transacción en caso de error
        $conexion->rollback();
        echo "Error: " . $e->getMessage();
        echo "Archivo: " . $e->getFile();
        echo "Línea: " . $e->getLine();
        return false;
    }
}
    
    //// LISTA LOS PRODUCTOS QUE TENGA >0 EL STOCK Y ESTADO MATERIAL DIFERENTE DE !4
    public function listarproducto($idalmacen)
    {
   $sql="SELECT d.idalmacen,d.idinventario_ingreso,d.iddetalle_ingreso,d.codigo,d.idarticulo,d.cantidad,d.mac,d.serie,d.marca,a.nombre,d.precio_compra,d.precio_venta,d.stock,a.unidad_medida,d.nrofactura,d.idprovedor,d.garantia,d.estadomaterial 
         FROM inventario_ingreso d 
         JOIN articulo a on d.idarticulo=a.idarticulo 
         WHERE d.stock>0 and d.estadomaterial!=4 and d.condicion='1' and d.idalmacen='$idalmacen'  order by d.codigo desc";
      return ejecutarConsulta($sql);
    }

    public function listarbuscar()
    {
   $sql="SELECT m.nombre as almacen,d.idalmacen,d.idinventario_ingreso,d.iddetalle_ingreso,d.codigo,d.idarticulo,d.cantidad,d.mac,d.serie,d.marca,a.nombre,d.precio_compra,d.precio_venta,d.stock,a.unidad_medida,d.nrofactura,d.idprovedor,d.garantia,d.estadomaterial 
         FROM inventario_ingreso d 
         JOIN articulo a on d.idarticulo=a.idarticulo
         JOIN almacen m ON m.idalmacen=d.idalmacen 
         WHERE d.stock>0 and d.estadomaterial!=4 and d.condicion='1'  order by d.codigo desc";
      return ejecutarConsulta($sql);
    }

    public function mostrar($idventa)
    {
    // Consulta para la tabla detalle_ingreso
     $queryVenta="SELECT * FROM venta WHERE idventa='$idventa'";
     $resultVentas = ejecutarConsulta($queryVenta);

    $ventas = [];
    while ($row = $resultVentas->fetch_assoc()) {
    $ventas[] = $row;
    }

    $queryDetalles = "SELECT v.precio_venta,v.precio_compra,v.cantidad_venta,a.nombre as articulo,i.idarticulo,v.idinventario_ingreso,i.codigo,i.marca,i.mac,v.idinventario_ingreso,i.stock
        FROM detalle_venta v 
        JOIN inventario_ingreso i ON i.idinventario_ingreso=v.idinventario_ingreso
        JOIN articulo a ON a.idarticulo=i.idarticulo
        WHERE v.idventa = '$idventa'";
    $resultDetalles = ejecutarConsulta($queryDetalles);

    $detalles = [];
    while ($row = $resultDetalles->fetch_assoc()) {
    $detalles[] = $row;
    }

    // Respuesta JSON
    return [
    "ventas" => $ventas,
    "detalles" => $detalles
    ];
    }
    public function listar() {
    $listar_venta="SELECT  u.nombre as usuario,p.nombre as cliente, v.nrocorrelativo,v.total_venta,v.idventa,v.tipo_pago,v.idbanco,v.estado_venta,v.fecha_hora,v.codigotipo_comprobante FROM venta v
                JOIN usuario u ON u.idusuario=v.idusuario
                JOIN persona p ON p.idpersona=v.idpersona ";
    return ejecutarConsulta($listar_venta);    
    }
    public function listar_usuario($idusuario){
    $listar_venta="SELECT  u.nombre as usuario,p.nombre as cliente, v.nrocorrelativo,v.total_venta,v.idventa,v.tipo_pago,v.idbanco,v.estado_venta,v.fecha_hora,v.codigotipo_comprobante FROM venta v
                JOIN usuario u ON u.idusuario=v.idusuario
                JOIN persona p ON p.idpersona=v.idpersona 
                WHERE v.idusuario='$idusuario'";
    return ejecutarConsulta($listar_venta);    

    }

}


?>