var tabla;
function init(){
    listar();

    $("#form_abricaja").on("submit", function(e) {
        guardaryeditar(e);
    });
    
}
function setFechaHoraPeruana() {
  const now = new Date(); // Fecha y hora actual en UTC
  const offset = -5; // Zona horaria de Perú (UTC-5)

  // Ajustar a la zona horaria peruana RESTANDO el offset
  const peruTime = new Date(now.getTime() + (offset * 60 * 60 * 1000));

  // Obtener componentes de la fecha y hora
  const year = peruTime.getUTCFullYear();
  const month = String(peruTime.getUTCMonth() + 1).padStart(2, '0'); // Meses comienzan en 0
  const day = String(peruTime.getUTCDate()).padStart(2, '0');
  const hours = String(peruTime.getUTCHours()).padStart(2, '0');
  const minutes = String(peruTime.getUTCMinutes()).padStart(2, '0');

  // Formatear fecha y hora en formato 'YYYY-MM-DDTHH:MM'
  const formattedDateTime = `${year}-${month}-${day}T${hours}:${minutes}`;

  // Verificar si el elemento existe antes de asignarle un valor
  const inputFecha = document.getElementById('fecha_apertura');
  if (inputFecha) {
    inputFecha.value = formattedDateTime;
  } else {
    //console.error("El elemento con id 'fecha_hora' no se encontró en el DOM.");
  }
}

// Ejecutar la función al cargar la página
document.addEventListener('DOMContentLoaded', setFechaHoraPeruana);
//Función limpiar
function limpiar()
{
	$("#idventa").val("");
  $("#fecha_hora").val("");
	$("#nroguia").val("");
  $("#nrocorrelativo").val(""); 
}
// Función para listar datos
function listar() {
    tabla=$("#caja").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/apertura.php?op=listar',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}


const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault();
  $("#btnGuardar").prop("disabled", true);
  var formData = new FormData($("#form_abricaja")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: "../../ajax/apertura.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          console.log("Respuesta del servidor:", datos); // Depuración

          // Si el mensaje indica que la caja fue registrada con éxito
          if (datos.includes("Apertura Caja Registrado")) {
            swalWithBootstrapButtons.fire({
              title: "Éxito",
              text: datos,
              icon: "success",
              confirmButtonText: "Aceptar"
            }).then(() => {
              window.location.href = "list.php";
              limpiar();
            });

          // Si el mensaje indica que la caja no se puede abrir
          } else if (datos.includes("La Caja ya esta Abierta")) {
            swalWithBootstrapButtons.fire({
              title: "Advertencia",
              text: datos,
              icon: "warning",
              confirmButtonText: "Aceptar"
            });

          // Si hubo otro error
          } else {
            swalWithBootstrapButtons.fire({
              title: "Error",
              text: datos,
              icon: "error",
              confirmButtonText: "Aceptar"
            });
          }
        },
        error: function (err) {
          swalWithBootstrapButtons.fire({
            title: "Error",
            text: "Hubo un problema con la solicitud. Intente nuevamente.",
            icon: "error",
            confirmButtonText: "Aceptar"
          }).then(() => {
            $("#btnGuardar").prop("disabled", false);
          });
        }
      });
    } else {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false);
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false);
  });
}

function eliminar(idcaja) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/caja.php?op=eliminar", { idcaja: idcaja }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "La caja ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "La caja está segura :)",
        icon: "error"
      });
    }
  });
}





init();