var tabla;
function init(){
    listar_material();
   

    $("#frmForm").on("submit", function(e) {
        guardaryeditar_fichaveria(e);
    });

    $("#chatForm").on("submit", function(e) {
      guardarChat(e); // Llamar a la función para procesar el formulario
    });

     //Llenar el select del banco
     $.post("../../ajax/banco.php?op=selectbanco", function(r){
      if ($.fn.select2 && $('#idbanco').data('select2')) {
        $('#idbanco').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idbanco").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idbanco').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un banco',
        allowClear: true,
      });
    });

}

function capturarUbicacion() {
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(
      (position) => {
        const lat = position.coords.latitude;
        const lon = position.coords.longitude;

        document.getElementById('latitud').value = lat;
        document.getElementById('longitud').value = lon;

        obtenerDireccion(lat, lon);
      },
      (error) => {
        Swal.fire("Error", "No se pudo obtener la ubicación.", "error");
      }
    );
  } else {
    Swal.fire("Error", "Tu navegador no soporta geolocalización.", "error");
  }
}

function obtenerDireccion(lat, lon) {
  const apiKey = 'AIzaSyBQLjBXPoSFnn0NSj--qoqQUtH2oSlgboA'; // <-- Reemplaza con tu API Key válida
  const url = `https://maps.googleapis.com/maps/api/geocode/json?latlng=${lat},${lon}&key=${apiKey}`;

  fetch(url)
    .then(response => response.json())
    .then(data => {
      if (data.status === "OK") {
        const address = data.results[1].formatted_address;
        document.getElementById('direccion_capturada').value = address;
      } else {
        document.getElementById('direccion_capturada').value = "Dirección no encontrada";
      }
    })
    .catch(() => {
      document.getElementById('direccion_capturada').value = "Error al obtener dirección";
    });
}
      $.post("../../ajax/torre.php?op=selectTorre", function(r) {
    // Función para actualizar un select con Select2
    function actualizarSelectTorre(selector) {
      if ($.fn.select2 && $(selector).data('select2')) {
        $(selector).select2('destroy');
      }

      $(selector).html('<option value="">Seleccione Torre</option>');
      $(selector).append(r);
      $(selector).select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione una Torre',
        allowClear: true
      });
    }

    // Aplicar a ambos selects
    actualizarSelectTorre('#idtorre');
    actualizarSelectTorre('#idtorrei');
  });
  
  $('#idtorrei').on('change', function () {
          const torreid = $(this).val(); // Obtener el ID de la torre seleccionada
              // Cargar las repetidoras relacionadas con la torre seleccionada
              $.post("../../ajax/repetidora.php?op=selectRepetidorTorre", { torreid: torreid }, function (r) {
                  if ($.fn.select2 && $('#idrepetidori').data('select2')) {
                      $('#idrepetidori').select2('destroy');
                  }
      
                  // Actualizar el contenido del select de repetidoras
                  $("#idrepetidori").html('<option value="">Seleccione Repetidor</option>');
                  $("#idrepetidori").append(r);
      
                  // Inicializar Select2 nuevamente
                  $('#idrepetidori').select2({
                      theme: 'bootstrap4',
                      placeholder: 'Seleccione un Repetidor',
                      allowClear: true,
                  });
              });
          });

      $.post("../../ajax/olt.php?op=selectOlt", function(r){
        if ($.fn.select2 && $('#idolt').data('select2')) {
          $('#idolt').select2('destroy');
        }

        // Actualizar el contenido del select
        $("#idolt").html('<option value="">Seleccione Torre</option>');
        // Actualizar el contenido del select
          $("#idolt").append(r);

        // Inicializar Select2 nuevamente
        $('#idolt').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione una olt',
          allowClear: true,
        });
      });

      $.post("../../ajax/plan.php?op=selectPlanPorTorre", function(r){
        if ($.fn.select2 && $('#idplan').data('select2')) {
          $('#idplan').select2('destroy');
        }
           // Limpiar las opciones antes de agregar las nuevas
           $("#idplan").html('<option value="">Seleccione Plan</option>'); 
           // Actualizar el contenido del select con las opciones de producto
           $("#idplan").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idplan').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un plan',
          allowClear: true,
        });
      });

    // Función para mostrar una vista específica y ocultar las demás
    function mostrarVista(vista) {
        const vistas = ["vista_1", "vista_2", "vista_3", "vista_4"];
        vistas.forEach(function (id) {
            document.getElementById(id).style.display = (id === vista) ? "block" : "none";
        });
    }

    // Agregar eventos a los botones de cada vista
    document.getElementById("btn_siguiente_1").addEventListener("click", function () {
        mostrarVista("vista_2");
    });

    document.getElementById("btn_regresar_2").addEventListener("click", function () {
        mostrarVista("vista_1");
    });

    document.getElementById("btn_siguiente_2").addEventListener("click", function () {
        mostrarVista("vista_3");
    });

    document.getElementById("btn_regresar_3").addEventListener("click", function () {
        mostrarVista("vista_2");
    });

    document.getElementById("btn_siguiente_3").addEventListener("click", function () {
        mostrarVista("vista_4");
    });

    document.getElementById("btn_regresar_4").addEventListener("click", function () {
        mostrarVista("vista_3");
    });

    document.getElementById("tipopago").addEventListener("change", function () {
      const tipoPago = this.value;

      if (tipoPago === "3") { // Depósito
          document.getElementById("deposito-fields").style.display = "block";
          document.getElementById("efectivo-fields").style.display = "none";
      } else if (tipoPago === "2") { // Efectivo
          document.getElementById("deposito-fields").style.display = "none";
          document.getElementById("efectivo-fields").style.display = "block";
      } else {
          // Por defecto oculta ambos si no hay selección válida
          document.getElementById("deposito-fields").style.display = "none";
          document.getElementById("efectivo-fields").style.display = "none";
      }
  });



//Función limpiar
function limpiar()
{
	$("#idaveria").val("");
	$("#idcliente").val("");
	$("#direccion").val("");
	$("#referencia").val("");
	$("#distrito").val("");
	$("#celular1").val("");
	$("#celular2").val("");
	$("#detalle_problema").val("");
	$("#observacion").val("");
}
// Función para listar datos
function listar_material() {
  tabla=$("#modalproducto").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/averia.php?op=listar_material',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}


// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});


// Función para guardar o editar
function guardarChat(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnChat").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#chatForm")[0]);
  

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/averia.php?op=guardarChat",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Chat Registrado") || datos.includes("Chat Actualizar") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Chat Registrado") || datos.includes("Chat Actualizar")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnChat").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnChat").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnChat").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}
// Función para guardar o editar
function guardaryeditar_fichaveria(e) {
  e.preventDefault(); // Evitar envío tradicional del formulario

  const $btnGuardar = $("#btnGuardar");
  $btnGuardar.prop("disabled", true); // Deshabilita el botón para evitar doble envío

  const form = $("#frmForm")[0];
  const formData = new FormData(form);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {

      Swal.fire({
        title: "Guardando...",
        html: "Por favor, espera mientras se procesan los datos.",
        allowOutsideClick: false,
        backdrop: true,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      $.ajax({
        url: "../../ajax/averia.php?op=guardaryeditar_fichaveria",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function (respuesta) {
          Swal.close(); // Cierra el loading

          if (respuesta && typeof respuesta === "object" && respuesta.status) {
            swalWithBootstrapButtons.fire({
              title: "Resultado",
              text: respuesta.message || "Operación completada.",
              icon: respuesta.status === "success" ? "success" : "error",
              confirmButtonText: "Aceptar"
            }).then(() => {
              if (respuesta.status === "success") {
                limpiar(); // Asegúrate de que esta función esté definida
                window.location.href = "list.php";
              } else {
                $btnGuardar.prop("disabled", false);
              }
            });
          } else {
            swalWithBootstrapButtons.fire({
              title: "Error",
              text: "La respuesta del servidor no es válida.",
              icon: "error",
              confirmButtonText: "Aceptar"
            });
            $btnGuardar.prop("disabled", false);
          }
        },
        error: function (xhr, status, error) {
          Swal.close();
          console.error("AJAX error:", status, error);

          let mensaje = "Hubo un problema con la solicitud. Intenta nuevamente.";
          
          // Detectar error de conexión (sin internet)
          if (status === "error" && xhr.status === 0) {
            mensaje = "Parece que no tienes conexión a Internet. Por favor, verifica tu conexión y vuelve a intentarlo.";
          }

          swalWithBootstrapButtons.fire({
            title: "Error",
            text: mensaje,
            icon: "error",
            confirmButtonText: "Aceptar"
          });
          $btnGuardar.prop("disabled", false);
        }
      });

    } else {
      // Usuario canceló la operación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "info",
        confirmButtonText: "Aceptar"
      });
      $btnGuardar.prop("disabled", false);
    }
  });
}

var cont = 0; // Contador de filas
var detalles=0;
function agregarDetalle(idarticulo, codigo, articulo, precio_venta, stocktotal, idmovimiento_materiales, unidad_medida, estadomaterial, idalmacen, filaBoton) {
  
  //console.log("Producto seleccionado:", codigo);
  // Validar que el código no esté repetido
  if (codigoYaExiste(idmovimiento_materiales)) {
    Swal.fire({
        icon: 'error',
        title: 'Artículo duplicado',
        text: `El artículo con idmaterial ${idmovimiento_materiales} ya está agregado.`,
        confirmButtonText: 'Aceptar',
        timer: 3000
    });
    return; // Salir de la función para evitar agregar el artículo duplicado
}

// Verificar que los datos sean válidos
   if (idarticulo != "") {
    var subtotal = 1 * precio_venta;
    var disabledInputs = unidad_medida !== 'MTR' ? 'readonly' : '';
    var inicioValue = unidad_medida === 'MTR' ? stocktotal : '';

   
    // Crear una nueva fila para agregar al detalle
    var fila = `
            <tr class="filas" id="fila${cont}">
            <td>
                <button type="button" class="btn btn-danger btn-xs btn-flat" onclick="eliminarDetalle(${cont})"><i class="fa fa-trash"></i></button> 
            </td>
            <td>
                <input type="hidden" name="idarticulo[]" value="${idarticulo}">${articulo}
                <input type="hidden" name="idmovimiento_materiales[]" value="${idmovimiento_materiales}" readonly>
                <input type="hidden" name="estadomaterial[]" value="${estadomaterial}">
                <input type="hidden" name="idalmacen[]" value="${idalmacen}">
                <input type="hidden" name="stocktotal[]" id="stocktotal${cont}" value="${stocktotal}">
            </td>
            <td>
               <input type="hidden" name="codigo[]" id="codigo${cont}" value="${codigo}">${codigo}
            </td>
            <td>
                <input class="form-control" type="number" name="inicio[]" id="inicio${cont}" value="${inicioValue}" readonly >
            </td>
            <td>
                <input class="form-control" type="number" name="fin[]" id="fin${cont}" ${unidad_medida === 'MTR' ? '' : 'readonly'} >
            </td>
            <td>
                <input type="number" name="cantidad[]" id="cantidad${cont}" min="1" value="0" class="form-control" ${unidad_medida === 'MTR' ? 'readonly' : ''}  >
            </td>
            <td>
                <input type="number" step="any" name="precio_venta[]" id="precio_venta${cont}" value="${precio_venta}" readonly="" class="form-control">
                <span class="hidden-subtotal" name="subtotal" id="subtotal${cont}">${subtotal}</span>
            </td>
        </tr>
    `;

    // Agregar la fila a la tabla "detalles"
    detalles=detalles+1;
    $('#detalles').append(fila);

    $(document).on("keyup change", "input[name='fin[]']", function () {
      var cont = $(this).attr('id').replace('fin', ''); // Obtener el índice del elemento
      var inicio = parseFloat($("#inicio" + cont).val()) || 0; // Obtener valor de inicio
      var fin = parseFloat($(this).val()) || 0; // Obtener valor de fin
      validarFin(cont, inicio, fin); // Validar y calcular cantidad
      modificarSubtotales();
  });
  
  $(document).on("keyup change", "input[name='cantidad[]']", function () {
      var cont = $(this).attr('id').replace('cantidad', ''); // Obtener el índice del elemento
      var stocktotal = parseFloat($("#stocktotal" + cont).val()) || 0; // Obtener valor del stock total
      validarCantidad(cont, stocktotal); // Validar cantidad ingresada
      modificarSubtotales();
  });
    // Agregar eventos para recalcular subtotales cuando se cambian los valores
    $("#precio_venta" + cont).keyup(modificarSubtotales);
    $("#precio_venta" + cont).change(modificarSubtotales);
    // Incrementar el contador
    cont++;
    // Llamar a la función para actualizar los subtotales
    modificarSubtotales();
    // Eliminar la fila dentro del modal después de agregar al detalle
    $(filaBoton).closest('tr').remove();  // Esto elimina la fila en el modal
} else {
    alert("Error al ingresar el detalle, revisar los datos del artículo");

}
}

function codigoYaExiste(idmovimiento_materiales) {
  let existe = false;
  const codigoCompleto = `${idmovimiento_materiales}`;
  $("input[name='idmovimiento_materiales[]']").each(function () {
      if ($(this).val() === codigoCompleto) {
          existe = true;
      }
  });
  return existe;
}


function validarFin(cont, inicio, fin) {
  if (fin > inicio) {
      Swal.fire({
          icon: 'error',
          title: 'Valor inválido',
          text: `El valor de fin no puede ser mayor que el valor de inicio (${inicio}).`,
          confirmButtonText: 'Aceptar',
          timer: 3000
      });
      $("#fin" + cont).val(inicio); // Restablecer el valor de fin
      fin = inicio;
  }

  var cantidad = inicio - fin; // Calcular cantidad
  $("#cantidad" + cont).val(cantidad); // Actualizar cantidad
}

function validarCantidad(cont, stocktotal) {
  var cantidad = parseFloat($("#cantidad" + cont).val()) || 0; // Evitar NaN

  if (cantidad > stocktotal) {
      Swal.fire({
          icon: 'error',
          title: 'Cantidad excedida',
          text: `La cantidad no puede exceder el stock disponible (${stocktotal}).`,
          confirmButtonText: 'Aceptar',
          timer: 3000
      });
      $("#cantidad" + cont).val(stocktotal); // Restablecer el valor de cantidad
  }
}



function modificarSubtotales() {
  // Lógica para actualizar los subtotales y total
      var cant=document.getElementsByName("cantidad[]");
      var prec=document.getElementsByName("precio_venta[]");
      var sub=document.getElementsByName("subtotal");

      for (var i = 0; i < cant.length; i++) {
        var inpC=cant[i];
        var inpP=prec[i];
        var inpS=sub[i];
        //var inpPorcentajeP=porcenPrecio[i];
        inpS.value=inpC.value*inpP.value;
        //precioVenta[i].value = ((1+inpPorcentajeP.value/100) * inpP.value).toFixed(2);
        document.getElementsByName("subtotal")[i].innerHTML=(inpS.value).toFixed(2);
	}
	calcularTotales();
}

function calcularTotales()
{
      var sub=document.getElementsByName("subtotal");
      var total=0.0;
      for (var i = 0; i < sub.length; i++) {
        total+= document.getElementsByName("subtotal")[i].value;
      }

      $("#total").html("S/. "+total.toFixed(2));
      $("#total_importe").val(total.toFixed(2));
      $("#iicontado_texto").val(total.toFixed(2));
      $("#iitotal_letra").val(total.toFixed(2));
      
      //evaluar();
}

function eliminarDetalle(index) {
  // Eliminar la fila especificada
  $('#fila' + index).remove();
  modificarSubtotales();
  calcularTotales(); // Actualizar los subtotales después de eliminar
}



$(document).ready(function () {
  // Obtener el parámetro idcaja de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const id = urlParams.get('id');

  if (id) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/averia.php?op=mostrar_averia", { idaveria: id }, function (data, status) {
          if (status === "success") {
            const response = JSON.parse(data);
            if (response.contratos && response.contratos.length > 0) {
              const contrato = response.contratos[0];
              let tipoVenta = contrato.tipoventa;
              $("#idaveria").val(contrato.idaveria);
              $("#idpersona").val(contrato.idpersona);
              $("#tipo_trabajo").val(contrato.tipo_trabajo);
              $("#prioridad").val(contrato.prioridad);
              $("#servicio").val(contrato.servicio);
              $("#tecnologia").val(contrato.tecnologia);
              $("#plan").val(contrato.nombre_plan);
              $("#plan1").val(contrato.nombre_plan);
              $("#plan2").val(contrato.nombre_plan);
              $("#paga").val(contrato.paga);
              $("#modalidad").val(contrato.modalidad);
              $("#distrito").val(contrato.distrito);
              $("#detallecliente").val(contrato.detalle_problema);
              $("#observacion").val(contrato.observaciones);
              $("#referencia").val(contrato.description);
              $("#direccion").val(contrato.address);
              $("#celular1").val(contrato.celular);
              $("#celular2").val(contrato.whatsapp);
              $("#categoriaingreso").val(contrato.idcategoria_ingreso);
              $("#tipotrabajo").val(contrato.idconcepto_ingreso);
              $("#idcontrato").val(contrato.idcontrato);
              $("#idcontratoi").val(contrato.idcontrato);
              $("#descripcion_oficina").val(contrato.descripcion);
              $("#nroacta").val(contrato.nro_acta);
              $("#descripcion_tecnico").val(contrato.descripcion_averia);
              $("#iddireccion").val(contrato.iddireccion);
              
              $("#idcliente").html('<strong id="idcliente">' + contrato.cliente + '</strong>');
              $("#nroservicio").html('<strong id="nroservicio">NRO SERVICIO: ' + contrato.nroservicio + '</strong>');
              $("#nrocontrato").html('<strong id="nrocontrato">NRO CONTRATO: ' + contrato.nrocontrato + '</strong>');
              $("#fecha_programacion").html('<label id="fecha_programacion"> Fecha: ' + contrato.fecha_programacion + '  </label> ');
              $("#hora_programacion").html('<label id="hora_programacion"> Hora: ' + contrato.hora_programacion + '  </label> ');
              $("#fecha_emision").html('<label id="fecha_emision"> Fecha: ' + contrato.fecha_emision + '  </label> ');
              $("#hora_emision").html('<label id="hora_emision"> Hora: ' + contrato.hora_emision + '  </label> ');
              
              $("#inalambrico").hide();
              $("#fibra").hide();

            }else{
              console.error("No se encontraron datos para el contrato.");
            }

            if (response.mikrotiks && response.mikrotiks.length > 0) {
                const mikrotik = response.mikrotiks[0];

                let idtecnologia = mikrotik.idtecnologia;

               if (idtecnologia == 1) {
                  $("#inalambrico").show();
                    $("#sit_lineai").val(mikrotik.sit_linea);
                    $("#mac_lineai").val(mikrotik.mac_linea);
                    $("#ip_lineai").val(mikrotik.ip_linea);
                    $("#upload_servicioi").val(mikrotik.velocidad2_linea);
                    $("#download_servicioi").val(mikrotik.velocidad_linea);
                    $("#usuario_clientei").val(mikrotik.usuario);
                    $("#cliente_nombrei").val(mikrotik.comentario_linea);

              setTimeout(() => {
                $("#idtorrei").val(mikrotik.idtorre).trigger('change'); // Seleccionar torre
                setTimeout(() => {
                    $("#idrepetidori").val(mikrotik.idrepetidor).trigger('change'); // Seleccionar OLT
                }, 200); // Tiempo para asegurar que la torre se ha cargado
            }, 200); // Tiempo inicial para la torre 

                } else if (idtecnologia == 3) {
                    $("#fibra").show();
                    $("#sit_linea").val(mikrotik.sit_linea);
                    $("#usuario_cliente").val(mikrotik.usuario);
                    $("#password").val(mikrotik.password);
                    $("#cliente_nombre").val(mikrotik.comentario_linea);
                    setTimeout(function() {
                    $("#idtorre").val(mikrotik.idtorre).trigger("change");
                    $("#idolt").val(mikrotik.idolt).trigger("change");
                  }, 200);
                }

            }else{
              console.error("No se encontraron datos para el mikrotiks.");
            }

            const imagenIds = ["imagenFachada", "imagenDni", "imagenContrato", "imagenOrdenTrabajo", "imagenMedidor"];
              const imagenAct = ["imagenactual1", "imagenactual2", "imagenactual3", "imagenactual4", "imagenactual5"];

              for (let i = 0; i < imagenIds.length; i++) {
                  const imageElement = document.getElementById(imagenIds[i]);
                  const inputElement = document.getElementById(imagenAct[i]);

                  const imagenObj = response.imagen_contratos[i]; // Puede ser undefined si hay menos elementos

                  if (imageElement) {
                      if (imagenObj && imagenObj.imagen) {
                          imageElement.src = "../../files/averia/" + imagenObj.imagen;
                      } else {
                          imageElement.src = "../../files/averia/no_disponible.jpg";
                      }
                  }

                  if (inputElement) {
                      inputElement.value = (imagenObj && imagenObj.imagen) ? imagenObj.imagen : "";
                  }
              }

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});

function letra1() {
  modificarSubtotales();
  const cantidad = document.getElementById('iicantidad_letra').value;
  const total = document.getElementById('iitotal_letra').value;
  const adelanto = document.getElementById('iiadelanto').value;

  if (cantidad > 0) {
      const monto = (Number(total) - Number(adelanto)) / Number(cantidad);
      document.getElementById('iimonto_letra').value = monto.toFixed(2);
  } else {
      alert('La cantidad de letras debe ser mayor a cero');
      document.getElementById('iicantidad_letra').value = '0';
      document.getElementById('iimonto_letra').value = '0';
  }
}

function letra2() {
  modificarSubtotales();
  const total = document.getElementById('iitotal_letra').value;
  const adelanto = document.getElementById('iiadelanto').value;
  const cantidad = document.getElementById('iicantidad_letra').value;
  const monto = (Number(total) - Number(adelanto)) / Number(cantidad);

  document.getElementById('iimonto_letra').value = monto.toFixed(2);
}

function letra3() {
  //modificarSubtotales();
  //const contado = document.getElementById('iicontado_texto').value;
  //document.getElementById('iicostoinstala_contrato').value = contado;
}

function ver1() {
  // Mostrar campos de "Contado"
  document.getElementById('iicontado').style.display = '';
  
  // Ocultar campos de "Cuota"
  document.getElementById('iipartes1').style.display = 'none';
  document.getElementById('iipartes2').style.display = 'none';
  document.getElementById('iipartes3').style.display = 'none';
  document.getElementById('iipartes4').style.display = 'none';
}

function ver2() {
  // Ocultar campos de "Contado"
  document.getElementById('iicontado').style.display = 'none';

  // Mostrar campos de "Cuota"
  document.getElementById('iipartes1').style.display = '';
  document.getElementById('iipartes2').style.display = '';
  document.getElementById('iipartes3').style.display = '';
  document.getElementById('iipartes4').style.display = '';
}

function mostrarchat(idaveria){   
      var idingreso = idaveria;  
      $('#idaveria1').val(idaveria);
     // console.log(idaveria);
      $.ajax({  
      url:"../../ajax/averia.php?op=mostrarchat&id=" + idaveria,  
      method:"POST",  
      data:{idaveria:idaveria},  
      dataType:"json",  
      success:function(response){  
        console.log(response);                 
    
      var cont=0;                  
        var html="<table class='table table-striped table-bordered table-condensed table-hover'>";
        html+="<thead>";
        html+="<tr style='background-color:#050505'>";
        html+="<th style='background-color:#050505; color: white;'>Fecha </th>";
        html+="<th style='background-color:#050505; color: white;'>Descripcion</th>";                
        html+="<th style='background-color:#050505; color: white;'>Responsable</th> </tr></thead>";

        html+="<tbody>";              

        for (i = 0; i < response.chats.length; i++) {             
            html += '<tr>' +
        //'<tr>'+
          '<td>' + response.chats[i].fecharegistro + '</td>' +
          '<td>' + response.chats[i].descripcion + '</td>' +
          '<td>' + response.chats[i].nombre + '</td>' +                               
          '</tr>' ;
          }
      
          html+="</tbody>";
          html+="</table>";                 
          document.getElementById("tblarticuloss").innerHTML=html;              
                      
      } 

  }); 
}




init();