var tabla;
function init(){

  $("#frmcontratoActualizar").on("submit", function(e) {
      actualizarImagenContrato(e); // Llamar a la función para procesar el formulario
    });

    //Llenar el select del banco
    $.post("../../ajax/banco.php?op=selectbanco", function(r){
      if ($.fn.select2 && $('#idbanco').data('select2')) {
        $('#idbanco').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idbanco").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idbanco').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un banco',
        allowClear: true,
      });
    });

}

  



  var cont = 1; // Contador de filas
  var detalles=0;
$(document).ready(function () {
  // Obtener el parámetro idcaja de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const id = urlParams.get('id');

  if (id) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/averia.php?op=mostrar_averia", { idaveria: id }, function (data, status) {
          if (status === "success") {
            const response = JSON.parse(data);
            if (response.contratos && response.contratos.length > 0) {
              const contrato = response.contratos[0]; 
              let tipoVenta = contrato.tipoventa;
              $("#idaveria").val(contrato.idaveria);
              $("#idpersona").val(contrato.idpersona);
              $("#tipo_trabajo").val(contrato.tipo_trabajo);
              $("#prioridad").val(contrato.prioridad);
              $("#servicio").val(contrato.servicio);
              $("#tecnologia").val(contrato.tecnologia);
              $("#plan").val(contrato.nombre_plan);
              $("#paga").val(contrato.paga);
              $("#modalidad").val(contrato.modalidad);
              $("#distrito").val(contrato.distrito);
              $("#detallecliente").val(contrato.detalle_problema);
              $("#observacion").val(contrato.observaciones);
              $("#referencia").val(contrato.description);
              $("#direccion").val(contrato.address);
              $("#celular1").val(contrato.celular);
              $("#celular2").val(contrato.whatsapp);
              $("#categoriaingreso").val(contrato.idcategoria_ingreso);
              $("#tipotrabajo").val(contrato.idconcepto_ingreso);
              $("#idcontrato").val(contrato.idcontrato);
              $("#descripcion_oficina").val(contrato.descripcion);
              $("#nroacta").val(contrato.nro_acta);
              $("#descripcion_tecnico").val(contrato.descripcion_averia);

              $("#tipopago").val(contrato.tipo_pago).trigger("change");

                document.getElementById("tipopago").addEventListener("change", function () {
                    const tipoPago = this.value;
            
                    if (tipoPago === "3") { // Depósito
                        document.getElementById("deposito-fields").style.display = "block";
                        document.getElementById("efectivo-fields").style.display = "none";
                    } else if (tipoPago === "2") { // Efectivo
                        document.getElementById("deposito-fields").style.display = "none";
                        document.getElementById("efectivo-fields").style.display = "block";
                    } else {
                        // Por defecto oculta ambos si no hay selección válida
                        document.getElementById("deposito-fields").style.display = "none";
                        document.getElementById("efectivo-fields").style.display = "none";
                    }
                    });
            
                    document.getElementById("tipopago").dispatchEvent(new Event("change"));

                    $("#idbanco").val(contrato.idbanco).trigger("change");
                    $("#nroperacion").val(contrato.nro_operacion);
                    $("#recibo").val(contrato.nro_recibo);


             
              if (tipoVenta === 'Contado') {
                $("#radioContado").prop("checked", true);
                ver1();  // Ejecutar la función asociada al radio "Contado"
            } else if (tipoVenta === 'Cuota') {
                $("#radioCuota").prop("checked", true);
                ver2();  // Ejecutar la función asociada al radio "Cuota"
                $("#iiadelanto").val(contrato.inicial);
                $("#iicantidad_letra").val(contrato.numeroletra);
                $("#iimonto_letra").val(contrato.montoletra);
            } else if (tipoVenta === 'Prestado') {
                $("#radioPrestado").prop("checked", true);
              //  ver3();  // Si es necesario, añade una función para "Prestado"
            }

              $("#idcliente").html('<strong id="idcliente">' + contrato.cliente + '</strong>');
              $("#nroservicio").html('<strong id="nroservicio">NRO SERVICIO: ' + contrato.nroservicio + '</strong>');
              $("#nrocontrato").html('<strong id="nrocontrato">NRO CONTRATO: ' + contrato.nrocontrato + '</strong>');
              $("#fecha_programacion").html('<label id="fecha_programacion"> Fecha: ' + contrato.fecha_programacion + '  </label> ');
              $("#hora_programacion").html('<label id="hora_programacion"> Hora: ' + contrato.hora_programacion + '  </label> ');
              $("#fecha_emision").html('<label id="fecha_emision"> Fecha: ' + contrato.fecha_emision + '  </label> ');
              $("#hora_emision").html('<label id="hora_emision"> Hora: ' + contrato.hora_emision + '  </label> ');

            }else{
              console.error("No se encontraron datos para el contrato.");
            }
            let suma = 0;
            for (var i = 0; i < response.detalles.length; i++) {
              const detalle = response.detalles[i];
              suma += parseFloat(detalle.costo);
              let fila = '<tr class="filas" id="fila' + cont + '">' +
                      '<td style=""></td>' +
                      '<td style="">' + detalle.nombre + ' </td>' +
                      '<td style="">' + detalle.codigo + '</td>' +
                      '<td style="">' + detalle.inicio + '</td>' +
                      '<td style="">' + detalle.fin + '</td>' +
                      '<td style="">' + detalle.cantidad + '</td>' +
                      '<td style="">' + detalle.costo + '</td>' 
        
            fila += '</tr>';
            $('#detalleaveria tbody').append(fila);
            cont++;
            detalles = detalles + 1;
            }
            // Mostrar con solo 2 decimales
		const sumaFormateada = parseFloat(suma).toFixed(2);
		
		$("#total").html('<strong id="total">' + sumaFormateada + '</strong>');
		$("#iitotal_letra").val(sumaFormateada);
		$("#iicontado_texto").val(sumaFormateada);

            const imagenIds = ["imagenFachada", "imagenDni", "imagenContrato", "imagenOrdenTrabajo", "imagenMedidor", "imagenCaja"];
            const imagenAct = ["imagenactual1", "imagenactual2", "imagenactual3", "imagenactual4", "imagenactual5","imagenactual6"];

		for (let i = 0; i < imagenIds.length; i++) {
		    const imageElement = document.getElementById(imagenIds[i]);
		    const inputElement = document.getElementById(imagenAct[i]);

                  const imagenObj = response.imagen_contratos[i]; // Puede ser undefined si hay menos elementos
		
		    if (imageElement) {
		        let imageUrl = "../../files/averia/no_disponible.jpg";
		
		        if (response.imagenes[i] && response.imagenes[i].imagen) {
		            imageUrl = "../../files/averia/" + response.imagenes[i].imagen;
		        }
		
		        // Crear el enlace y clonar la imagen
		        const link = document.createElement("a");
		        link.href = imageUrl;
		        link.target = "_blank";
		
		        const newImg = imageElement.cloneNode(true);
		        newImg.src = imageUrl;
		
		        // Reemplazar solo la imagen
		        imageElement.replaceWith(link);
		        link.appendChild(newImg);
		    }
		     if (inputElement) {
                      inputElement.value = (imagenObj && imagenObj.imagen) ? imagenObj.imagen : "";
                  }
		}
             

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});


        // Función para mostrar una vista específica y ocultar las demás
    function mostrarVista(vista) {
        const vistas = ["vista_1", "vista_2", "vista_3"];
        vistas.forEach(function (id) {
            document.getElementById(id).style.display = (id === vista) ? "block" : "none";
        });
    }

    // Agregar eventos a los botones de cada vista
    document.getElementById("btn_siguiente_1").addEventListener("click", function () {
        mostrarVista("vista_2");
    });

    document.getElementById("btn_regresar_2").addEventListener("click", function () {
        mostrarVista("vista_1");
    });

    document.getElementById("btn_siguiente_2").addEventListener("click", function () {
        mostrarVista("vista_3");
    });

    document.getElementById("btn_regresar_3").addEventListener("click", function () {
        mostrarVista("vista_2");
    });


        

function letra1() {
  modificarSubtotales();
  const cantidad = document.getElementById('iicantidad_letra').value;
  const total = document.getElementById('iitotal_letra').value;
  const adelanto = document.getElementById('iiadelanto').value;

  if (cantidad > 0) {
      const monto = (Number(total) - Number(adelanto)) / Number(cantidad);
      document.getElementById('iimonto_letra').value = monto.toFixed(2);
  } else {
      alert('La cantidad de letras debe ser mayor a cero');
      document.getElementById('iicantidad_letra').value = '0';
      document.getElementById('iimonto_letra').value = '0';
  }
}

function letra2() {
  modificarSubtotales();
  const total = document.getElementById('iitotal_letra').value;
  const adelanto = document.getElementById('iiadelanto').value;
  const cantidad = document.getElementById('iicantidad_letra').value;
  const monto = (Number(total) - Number(adelanto)) / Number(cantidad);

  document.getElementById('iimonto_letra').value = monto.toFixed(2);
}

function letra3() {
  modificarSubtotales();
  const contado = document.getElementById('iicontado_texto').value;
  document.getElementById('iicostoinstala_contrato').value = contado;
}

function ver1() {
  // Mostrar campos de "Contado"
  document.getElementById('iicontado').style.display = '';
  
  // Ocultar campos de "Cuota"
  document.getElementById('iipartes1').style.display = 'none';
  document.getElementById('iipartes2').style.display = 'none';
  document.getElementById('iipartes3').style.display = 'none';
  document.getElementById('iipartes4').style.display = 'none';
}

function ver2() {
  // Ocultar campos de "Contado"
  document.getElementById('iicontado').style.display = 'none';

  // Mostrar campos de "Cuota"
  document.getElementById('iipartes1').style.display = '';
  document.getElementById('iipartes2').style.display = '';
  document.getElementById('iipartes3').style.display = '';
  document.getElementById('iipartes4').style.display = '';
}

const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

function actualizarImagenContrato(e) {
  e.preventDefault();
  $("#btnActualizar").prop("disabled", true);
  var formData = new FormData($("#frmcontratoActualizar")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {

      // Mostrar precarga inmediatamente
      Swal.fire({
        title: "Subiendo imagen...",
        html: "Por favor, espera mientras se guarda la imagen.",
        allowOutsideClick: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      $.ajax({
        url: "../../ajax/averia.php?op=actualizarImagenContrato",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (respuesta) {
          try {
            var datos = JSON.parse(respuesta);

            if (datos.status === "success") {
              // Cerrar la precarga anterior y mostrar una confirmación antes de redirigir
              Swal.fire({
                icon: "success",
                title: "Imagen guardada",
                text: "Se ha guardado correctamente.",
                timer: 100000,
                timerProgressBar: true,
                willClose: () => {
                  $(location).attr("href", "list.php");
                }
              });
            } else {
              Swal.fire({
                icon: "error",
                title: "Error",
                text: datos.message,
                timer: 100000,
                timerProgressBar: true,
                allowOutsideClick: false,
                willClose: () => {
                  $("#btnActualizar").prop("disabled", false);
                }
              });
            }
          } catch (error) {
            console.error("Error parsing JSON:", error);
            Swal.fire({
              icon: "error",
              title: "Error de respuesta",
              text: "Respuesta inesperada del servidor.",
              confirmButtonText: "Aceptar"
            });
            $("#btnActualizar").prop("disabled", false);
          }
        },
        error: function () {
          Swal.fire({
            icon: "error",
            title: "Error",
            text: "Hubo un problema con la solicitud. Intente nuevamente.",
            confirmButtonText: "Aceptar"
          });
          $("#btnActualizar").prop("disabled", false);
        }
      });
    } else {
      $("#btnActualizar").prop("disabled", false);
    }
  });
}


init();