var tabla;
function init(){

    $("#chatForm").on("submit", function(e) {
      guardarChat(e); // Llamar a la función para procesar el formulario
    });

     //Llenar el select del banco
     $.post("../../ajax/banco.php?op=selectbanco", function(r){
      if ($.fn.select2 && $('#idbanco').data('select2')) {
        $('#idbanco').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idbanco").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idbanco').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un banco',
        allowClear: true,
      });
    });

}
      $.post("../../ajax/torre.php?op=selectTorre", function(r){
        if ($.fn.select2 && $('#idtorre').data('select2')) {
          $('#idtorre').select2('destroy');
        }

        // Actualizar el contenido del select
        $("#idtorre").html('<option value="">Seleccione Torre</option>');
        // Actualizar el contenido del select
          $("#idtorre").append(r);

        // Inicializar Select2 nuevamente
        $('#idtorre').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione una Torre',
          allowClear: true,
        });
      });

      $.post("../../ajax/olt.php?op=selectOlt", function(r){
        if ($.fn.select2 && $('#idolt').data('select2')) {
          $('#idolt').select2('destroy');
        }

        // Actualizar el contenido del select
        $("#idolt").html('<option value="">Seleccione Torre</option>');
        // Actualizar el contenido del select
          $("#idolt").append(r);

        // Inicializar Select2 nuevamente
        $('#idolt').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione una olt',
          allowClear: true,
        });
      });

      $.post("../../ajax/plan.php?op=selectPlanPorTorre", function(r){
        if ($.fn.select2 && $('#idplan').data('select2')) {
          $('#idplan').select2('destroy');
        }
           // Limpiar las opciones antes de agregar las nuevas
           $("#idplan").html('<option value="">Seleccione Plan</option>'); 
           // Actualizar el contenido del select con las opciones de producto
           $("#idplan").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idplan').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un plan',
          allowClear: true,
        });
      });

    // Función para mostrar una vista específica y ocultar las demás
    function mostrarVista(vista) {
        const vistas = ["vista_1", "vista_2", "vista_3", "vista_4"];
        vistas.forEach(function (id) {
            document.getElementById(id).style.display = (id === vista) ? "block" : "none";
        });
    }

    // Agregar eventos a los botones de cada vista
    document.getElementById("btn_siguiente_1").addEventListener("click", function () {
        mostrarVista("vista_2");
    });

    document.getElementById("btn_regresar_2").addEventListener("click", function () {
        mostrarVista("vista_1");
    });

    document.getElementById("btn_siguiente_2").addEventListener("click", function () {
        mostrarVista("vista_3");
    });

    document.getElementById("btn_regresar_3").addEventListener("click", function () {
        mostrarVista("vista_2");
    });

    document.getElementById("btn_siguiente_3").addEventListener("click", function () {
        mostrarVista("vista_4");
    });

    document.getElementById("btn_regresar_4").addEventListener("click", function () {
        mostrarVista("vista_3");
    });

    document.getElementById("tipopago").addEventListener("change", function () {
      const tipoPago = this.value;

      if (tipoPago === "3") { // Depósito
          document.getElementById("deposito-fields").style.display = "block";
          document.getElementById("efectivo-fields").style.display = "none";
      } else if (tipoPago === "2") { // Efectivo
          document.getElementById("deposito-fields").style.display = "none";
          document.getElementById("efectivo-fields").style.display = "block";
      } else {
          // Por defecto oculta ambos si no hay selección válida
          document.getElementById("deposito-fields").style.display = "none";
          document.getElementById("efectivo-fields").style.display = "none";
      }
  });




// Función para guardar o editar
function guardarChat(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnChat").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#chatForm")[0]);
  

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/averia.php?op=guardarChat",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Chat Registrado") || datos.includes("Chat Actualizar") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Chat Registrado") || datos.includes("Chat Actualizar")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnChat").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnChat").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnChat").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}
// Función para guardar o editar


var cont = 0; // Contador de filas
var detalles=0;
var llamadas=0;
var contllamada=0;


$(document).ready(function () {
  // Obtener el parámetro idcaja de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const id = urlParams.get('id');

  if (id) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/averia.php?op=mostrar_recojo", { idaveria: id }, function (data, status) {
          if (status === "success") {
            const response = JSON.parse(data);
            if (response.contratos && response.contratos.length > 0) {
              const contrato = response.contratos[0];
              let tipoVenta = contrato.tipoventa;
              $("#idaveria").val(contrato.idaveria);
              $("#idpersona").val(contrato.idpersona);
              $("#tipo_trabajo").val(contrato.tipo_trabajo);
              $("#prioridad").val(contrato.prioridad);
              $("#servicio").val(contrato.servicio);
              $("#tecnologia").val(contrato.tecnologia);
              $("#plan").val(contrato.nombre_plan);
              $("#plan1").val(contrato.nombre_plan);
              $("#paga").val(contrato.paga);
              $("#modalidad").val(contrato.modalidad);
              $("#distrito").val(contrato.distrito);
              $("#detallecliente").val(contrato.detalle_problema);
              $("#observacion").val(contrato.observaciones);
              $("#referencia").val(contrato.description);
              $("#direccion").val(contrato.address);
              $("#celular1").val(contrato.celular);
              $("#celular2").val(contrato.whatsapp);
              $("#categoriaingreso").val(contrato.idcategoria_ingreso);
              $("#tipotrabajo").val(contrato.idconcepto_ingreso);
              $("#idcontrato").val(contrato.idcontrato);
              $("#descripcion_oficina").val(contrato.descripcion);
              $("#nroacta").val(contrato.nro_acta);
              $("#descripcion_tecnico").val(contrato.descripcion_averia);

              $("#tipopago").val(contrato.tipo_pago).trigger("change");

                document.getElementById("tipopago").addEventListener("change", function () {
                    const tipoPago = this.value;
            
                    if (tipoPago === "3") { // Depósito
                        document.getElementById("deposito-fields").style.display = "block";
                        document.getElementById("efectivo-fields").style.display = "none";
                    } else if (tipoPago === "2") { // Efectivo
                        document.getElementById("deposito-fields").style.display = "none";
                        document.getElementById("efectivo-fields").style.display = "block";
                    } else {
                        // Por defecto oculta ambos si no hay selección válida
                        document.getElementById("deposito-fields").style.display = "none";
                        document.getElementById("efectivo-fields").style.display = "none";
                    }
                    });
            
                    document.getElementById("tipopago").dispatchEvent(new Event("change"));

                    $("#idbanco").val(contrato.idbanco).trigger("change");
                    $("#nroperacion").val(contrato.nro_operacion);
                    $("#recibo").val(contrato.nro_recibo);
             
                    if (tipoVenta === 'Contado') {
                        $("#radioContado").prop("checked", true);
                        $("#iicontado_texto").val(contrato.monto_atencion);
                        ver1();  // Ejecutar la función asociada al radio "Contado"
                    } else if (tipoVenta === 'Cuota') {
                        $("#radioCuota").prop("checked", true);
                        ver2();  // Ejecutar la función asociada al radio "Cuota"
                        $("#iiadelanto").val(contrato.inicial);
                        $("#iicantidad_letra").val(contrato.numeroletra);
                        $("#iimonto_letra").val(contrato.montoletra);
                    } else if (tipoVenta === 'Prestado') {
                        $("#radioPrestado").prop("checked", true);
                    //  ver3();  // Si es necesario, añade una función para "Prestado"
                    }
              
                    $("#idcliente").html('<strong id="idcliente">' + contrato.cliente + '</strong>');
                    $("#nroservicio").html('<strong id="nroservicio">NRO SERVICIO: ' + contrato.nroservicio + '</strong>');
                    $("#nrocontrato").html('<strong id="nrocontrato">NRO CONTRATO: ' + contrato.nrocontrato + '</strong>');
                    $("#fecha_programacion").html('<label id="fecha_programacion"> Fecha: ' + contrato.fecha_programacion + '  </label> ');
                    $("#hora_programacion").html('<label id="hora_programacion"> Hora: ' + contrato.hora_programacion + '  </label> ');
                    $("#fecha_emision").html('<label id="fecha_emision"> Fecha: ' + contrato.fecha_emision + '  </label> ');
                    $("#hora_emision").html('<label id="hora_emision"> Hora: ' + contrato.hora_emision + '  </label> ');

                    }else{
                    console.error("No se encontraron datos para el contrato.");
                    }

           
            for (var e = 0; e < response.llamadas.length; e++) {
              const llamada = response.llamadas[e];
             
              let fila_llamada = '<tr class="filas" id="fila' + cont + '">' +
                      '<td style="">' + llamada.created_at + ' </td>' +
                      '<td style="">' + llamada.descripcion + '</td>' +
                      '<td style="">' + llamada.nombre + '</td>' 
        
            fila_llamada += '</tr>';
            $('#historial_llamada tbody').append(fila_llamada);
            contllamada++;
            llamadas = llamadas + 1;
            }

            let suma = 0;
            for (var i = 0; i < response.detalles.length; i++) {
              const detalle = response.detalles[i];
              suma += parseFloat(detalle.costo)*parseFloat(detalle.cantidad);
              let fila = '<tr class="filas" id="fila' + cont + '">' +
                      '<td style=""></td>' +
                      '<td style="">' + detalle.nombre + ' </td>' +
                      '<td style="">' + detalle.codigo + '</td>' +
                      '<td style="">' + detalle.inicio + '</td>' +
                      '<td style="">' + detalle.fin + '</td>' +
                      '<td style="">' + detalle.cantidad + '</td>' +
                      '<td style="">' + detalle.costo + '</td>' 
        
            fila += '</tr>';
            $('#detalles_contrato tbody').append(fila);
            cont++;
            detalles = detalles + 1;
            }
            $("#total").html('<strong id="total">' + suma.toFixed(2) + '</strong>');

            const imagenIds = ["imagenFachada", "imagenDni", "imagenContrato", "imagenOrdenTrabajo", "imagenMedidor"];
            const imagenAct = ["imagenactual1", "imagenactual2", "imagenactual3", "imagenactual4", "imagenactual5"];
            const imagenDet = ["imagen1", "imagen2"];

            // Mostrar imágenes de contratos
            for (let i = 0; i < imagenIds.length; i++) {
                const imageElement = document.getElementById(imagenIds[i]);
                const inputElement = document.getElementById(imagenAct[i]);

                const imagenObj = response.imagen_contratos[i];
                const imageUrl = (imagenObj && imagenObj.imagen) ?
                    "../../files/averia/" + imagenObj.imagen :
                    "../../files/averia/no_disponible.jpg";

                if (inputElement) {
                    inputElement.value = (imagenObj && imagenObj.imagen) ? imagenObj.imagen : "";
                }

                if (imageElement) {
                    const newImg = imageElement.cloneNode(true);
                    newImg.src = imageUrl;

                   

                    const link = document.createElement("a");
                    link.href = imageUrl;
                    link.target = "_blank";
                    link.appendChild(newImg);

                    imageElement.replaceWith(link); // 👈 Reemplaza solo la imagen
                }
            }

            // Mostrar imágenes detalladas
            for (let i = 0; i < imagenDet.length; i++) {
                const imageElement = document.getElementById(imagenDet[i]);
                const inputElement = document.getElementById(imagenDet[i]); // ID compartido

                const imagenObj = response.imagenes[i];
                const imageUrl = (imagenObj && imagenObj.imagen) ?
                    "../../files/averia/" + imagenObj.imagen :
                    "../../files/averia/no_disponible.jpg";

                if (inputElement) {
                    inputElement.value = (imagenObj && imagenObj.imagen) ? imagenObj.imagen : "";
                }

                if (imageElement) {
                    const newImg = imageElement.cloneNode(true);
                    newImg.src = imageUrl;

                    

                    const link = document.createElement("a");
                    link.href = imageUrl;
                    link.target = "_blank";
                    link.appendChild(newImg);

                    imageElement.replaceWith(link); // 👈 Reemplaza solo la imagen
                }
            }

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});

function letra1() {
  modificarSubtotales();
  const cantidad = document.getElementById('iicantidad_letra').value;
  const total = document.getElementById('iitotal_letra').value;
  const adelanto = document.getElementById('iiadelanto').value;

  if (cantidad > 0) {
      const monto = (Number(total) - Number(adelanto)) / Number(cantidad);
      document.getElementById('iimonto_letra').value = monto.toFixed(2);
  } else {
      alert('La cantidad de letras debe ser mayor a cero');
      document.getElementById('iicantidad_letra').value = '0';
      document.getElementById('iimonto_letra').value = '0';
  }
}

function letra2() {
  modificarSubtotales();
  const total = document.getElementById('iitotal_letra').value;
  const adelanto = document.getElementById('iiadelanto').value;
  const cantidad = document.getElementById('iicantidad_letra').value;
  const monto = (Number(total) - Number(adelanto)) / Number(cantidad);

  document.getElementById('iimonto_letra').value = monto.toFixed(2);
}

function letra3() {
  modificarSubtotales();
  const contado = document.getElementById('iicontado_texto').value;
  document.getElementById('iicostoinstala_contrato').value = contado;
}

function ver1() {
  // Mostrar campos de "Contado"
  document.getElementById('iicontado').style.display = '';
  
  // Ocultar campos de "Cuota"
  document.getElementById('iipartes1').style.display = 'none';
  document.getElementById('iipartes2').style.display = 'none';
  document.getElementById('iipartes3').style.display = 'none';
  document.getElementById('iipartes4').style.display = 'none';
}

function ver2() {
  // Ocultar campos de "Contado"
  document.getElementById('iicontado').style.display = 'none';

  // Mostrar campos de "Cuota"
  document.getElementById('iipartes1').style.display = '';
  document.getElementById('iipartes2').style.display = '';
  document.getElementById('iipartes3').style.display = '';
  document.getElementById('iipartes4').style.display = '';
}



init();