var tabla;
function init(){

    $("#frmForm").on("submit", function(e) {
        guardaryeditar_fichavisita(e);
    });

    $("#chatForm").on("submit", function(e) {
      guardarChat(e); // Llamar a la función para procesar el formulario
    });

}
    // Función para mostrar una vista específica y ocultar las demás
    function mostrarVista(vista) {
        const vistas = ["vista_1", "vista_2"];
        vistas.forEach(function (id) {
            document.getElementById(id).style.display = (id === vista) ? "block" : "none";
        });
    }
    
    // Add event listeners for navigation buttons
    document.getElementById("btn_siguiente_1").addEventListener("click", function () {
        mostrarVista("vista_2");
    });
    
    document.getElementById("btn_regresar_2").addEventListener("click", function () {
        mostrarVista("vista_1");
    });
    



//Función limpiar
function limpiar()
{
	$("#idaveria").val("");
	$("#idcliente").val("");
	$("#direccion").val("");
	$("#referencia").val("");
	$("#distrito").val("");
	$("#celular1").val("");
	$("#celular2").val("");
	$("#detalle_problema").val("");
	$("#observacion").val("");
}

  // function mostrarOcultarActa() {
  //   const estadoAveria = document.getElementById("estado_averia").value;
  //   const campoNroActa = document.getElementById("campoNroActa");

  //   // Mostrar el campo si es "No Factible" (valor 6)
  //   if (estadoAveria === "6") {
  //       campoNroActa.style.display = "block";
  //       document.getElementById("nroacta").required = true; // Hacer obligatorio
  //   } else {
  //       campoNroActa.style.display = "none";
  //       document.getElementById("nroacta").required = false; // Quitar obligatorio
  //   }
  // }



// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});


// Función para guardar o editar
function guardarChat(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnChat").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#chatForm")[0]);
  

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/averia.php?op=guardarChat",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Chat Registrado") || datos.includes("Chat Actualizar") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Chat Registrado") || datos.includes("Chat Actualizar")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnChat").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnChat").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnChat").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}
// Función para guardar o editar
function guardaryeditar_fichavisita(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/averia.php?op=guardaryeditar_fichavisita",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Ficha Visita Registrado") || datos.includes("Ficha Visita Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Ficha Visita Registrado") || datos.includes("Ficha Visita Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}


$(document).ready(function () {
  // Obtener el parámetro idcaja de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const id = urlParams.get('id');

  if (id) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/averia.php?op=mostrar_visita", { idaveria: id }, function (data, status) {
          if (status === "success") {
            const response = JSON.parse(data);
            if (response.contratos && response.contratos.length > 0) {
              const contrato = response.contratos[0];
              let tipoVenta = contrato.tipoventa;
              $("#idaveria").val(contrato.idaveria);
              $("#idpersona").val(contrato.idpersona);
              $("#tipo_trabajo").val(contrato.tipo_trabajo);
              $("#prioridad").val(contrato.prioridad);
              $("#servicio").val(contrato.servicio);
              $("#tecnologia").val(contrato.tecnologia);
              $("#plan").val(contrato.nombre_plan);
              $("#plan1").val(contrato.nombre_plan);
              $("#paga").val(contrato.paga);
              $("#modalidad").val(contrato.modalidad);
              $("#distrito").val(contrato.distrito);
              $("#detallecliente").val(contrato.detalle_problema);
              $("#observacion").val(contrato.observaciones);
              $("#referencia").val(contrato.description);
              $("#direccion").val(contrato.address);
              $("#celular1").val(contrato.celular);
              $("#celular2").val(contrato.whatsapp);
              $("#categoriaingreso").val(contrato.idcategoria_ingreso);
              $("#tipotrabajo").val(contrato.idconcepto_ingreso);
              $("#idcontrato").val(contrato.idcontrato);
              $("#descripcion_oficina").val(contrato.descripcion);
              $("#nroacta").val(contrato.nro_acta);
              $("#descripcion_tecnico").val(contrato.descripcion_averia);
              
              $("#idcliente").html('<strong id="idcliente">' + contrato.cliente + '</strong>');
              $("#nroservicio").html('<strong id="nroservicio">NRO SERVICIO: ' + contrato.nroservicio + '</strong>');
              $("#nrocontrato").html('<strong id="nrocontrato">NRO CONTRATO: ' + contrato.nrocontrato + '</strong>');
              $("#fecha_programacion").html('<label id="fecha_programacion"> Fecha: ' + contrato.fecha_programacion + '  </label> ');
              $("#hora_programacion").html('<label id="hora_programacion"> Hora: ' + contrato.hora_programacion + '  </label> ');
              $("#fecha_emision").html('<label id="fecha_emision"> Fecha: ' + contrato.fecha_emision + '  </label> ');
              $("#hora_emision").html('<label id="hora_emision"> Hora: ' + contrato.hora_emision + '  </label> ');

            }else{
              console.error("No se encontraron datos para el contrato.");
            }


          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});

    function mostrarchat(idaveria){   
          var idingreso = idaveria;  
          $('#idaveria1').val(idaveria);
         console.log(idaveria);
          $.ajax({  
          url:"../../ajax/averia.php?op=mostrarchat&id=" + idaveria,  
          method:"POST",  
          data:{idaveria:idaveria},  
          dataType:"json",  
          success:function(response){  
            console.log(response);                 

          var cont=0;                  
            var html="<table class='table table-striped table-bordered table-condensed table-hover'>";
            html+="<thead>";
            html+="<tr style='background-color:#050505'>";
            html+="<th style='background-color:#050505; color: white;'>Fecha </th>";
            html+="<th style='background-color:#050505; color: white;'>Descripcion</th>";                
            html+="<th style='background-color:#050505; color: white;'>Responsable</th> </tr></thead>";

            html+="<tbody>";              

            for (i = 0; i < response.chats.length; i++) {             
                html += '<tr>' +
            //'<tr>'+
              '<td>' + response.chats[i].fecharegistro + '</td>' +
              '<td>' + response.chats[i].descripcion + '</td>' +
              '<td>' + response.chats[i].nombre + '</td>' +                               
              '</tr>' ;
              }
          
              html+="</tbody>";
              html+="</table>";                 
              document.getElementById("tblarticuloss").innerHTML=html;              
                          
          } 

        }); 
    }



init();