var tabla;
function init(){

 

    $("#chatForm").on("submit", function(e) {
      guardarChat(e); // Llamar a la función para procesar el formulario
    });

}
    // Función para mostrar una vista específica y ocultar las demás
    function mostrarVista(vista) {
        const vistas = ["vista_1", "vista_2", "vista_3"];
        vistas.forEach(function (id) {
            document.getElementById(id).style.display = (id === vista) ? "block" : "none";
        });
    }
    
    // Add event listeners for navigation buttons
    document.getElementById("btn_siguiente_1").addEventListener("click", function () {
        mostrarVista("vista_2");
    });
    
    document.getElementById("btn_regresar_2").addEventListener("click", function () {
        mostrarVista("vista_1");
    });
    
     document.getElementById("btn_siguiente_2").addEventListener("click", function () {
         mostrarVista("vista_3");
     });
    
     document.getElementById("btn_regresar_3").addEventListener("click", function () {
        mostrarVista("vista_2");
     });



//Función limpiar
function limpiar()
{
	$("#idaveria").val("");
	$("#idcliente").val("");
	$("#direccion").val("");
	$("#referencia").val("");
	$("#distrito").val("");
	$("#celular1").val("");
	$("#celular2").val("");
	$("#detalle_problema").val("");
	$("#observacion").val("");
}



// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});


// Función para guardar o editar
function guardarChat(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnChat").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#chatForm")[0]);
  

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/averia.php?op=guardarChat",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Chat Registrado") || datos.includes("Chat Actualizar") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Chat Registrado") || datos.includes("Chat Actualizar")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnChat").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnChat").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnChat").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}
// Función para guardar o editar

$(document).ready(function () {
  // Obtener el parámetro idcaja de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const id = urlParams.get('id');

  if (id) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/averia.php?op=mostrar_visita", { idaveria: id }, function (data, status) {
          if (status === "success") {
            const response = JSON.parse(data);
            if (response.contratos && response.contratos.length > 0) {
              const contrato = response.contratos[0];
              let tipoVenta = contrato.tipoventa;
              $("#idaveria").val(contrato.idaveria);
              $("#idpersona").val(contrato.idpersona);
              $("#tipo_trabajo").val(contrato.tipo_trabajo);
              $("#prioridad").val(contrato.prioridad);
              $("#servicio").val(contrato.servicio);
              $("#tecnologia").val(contrato.tecnologia);
              $("#plan").val(contrato.nombre_plan);
              $("#plan1").val(contrato.nombre_plan);
              $("#paga").val(contrato.paga);
              $("#modalidad").val(contrato.modalidad);
              $("#distrito").val(contrato.distrito);
              $("#detallecliente").val(contrato.detalle_problema);
              $("#observacion").val(contrato.observaciones);
              $("#referencia").val(contrato.description);
              $("#direccion").val(contrato.address);
              $("#celular1").val(contrato.celular);
              $("#celular2").val(contrato.whatsapp);
              $("#categoriaingreso").val(contrato.idcategoria_ingreso);
              $("#tipotrabajo").val(contrato.idconcepto_ingreso);
              $("#idcontrato").val(contrato.idcontrato);
              $("#descripcion_oficina").val(contrato.descripcion);
              $("#nroacta").val(contrato.nro_acta);
              $("#descripcion_tecnico").val(contrato.descripcion_averia);
              
              $("#idcliente").html('<strong id="idcliente">' + contrato.cliente + '</strong>');
              $("#nroservicio").html('<strong id="nroservicio">NRO SERVICIO: ' + contrato.nroservicio + '</strong>');
              $("#nrocontrato").html('<strong id="nrocontrato">NRO CONTRATO: ' + contrato.nrocontrato + '</strong>');
              $("#fecha_programacion").html('<label id="fecha_programacion"> Fecha: ' + contrato.fecha_programacion + '  </label> ');
              $("#hora_programacion").html('<label id="hora_programacion"> Hora: ' + contrato.hora_programacion + '  </label> ');
              $("#fecha_emision").html('<label id="fecha_emision"> Fecha: ' + contrato.fecha_emision + '  </label> ');
              $("#hora_emision").html('<label id="hora_emision"> Hora: ' + contrato.hora_emision + '  </label> ');

            }else{
              console.error("No se encontraron datos para el contrato.");
            }

            
            const imagenDet = ["imagen1", "imagen2"];

            // Validar que el número de imágenes coincida con los elementos de la vista
            if (response.imagenes.length === imagenDet.length) {
                for (let i = 0; i < response.imagenes.length; i++) {
                    const imageElement = document.getElementById(imagenDet[i]);
                    const imageUrl = "../../files/averia/" + response.imagenes[i].imagen;

                    if (imageElement) {
                        imageElement.src = imageUrl;
                        imageElement.style.cursor = "pointer"; // Cambiar el cursor al pasar el mouse

                        // Abrir la imagen en una nueva pestaña al hacer clic
                        imageElement.onclick = () => {
                            window.open(imageUrl, "_blank");
                        };
                    }

                    // Si tienes un input con el mismo ID (aunque es mejor que tenga otro ID)
                    const inputElement = document.getElementById(imagenDet[i]);
                    if (inputElement && inputElement.tagName === "INPUT") {
                        inputElement.value = response.imagenes[i].imagen;
                    }
                }
            }

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});




init();