var tabla;
function init(){
    listar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $("#frmForm_cerrar").on("submit", function(e) {
      cerrar_caja(e);
  });

    $.post("../../ajax/usuario.php?op=selectUsuario", function(r){
      if ($.fn.select2 && $('#idusuario').data('select2')) {
        $('#idusuario').select2('destroy');
      }
    
      // Actualizar el contenido del select
      $("#idusuario").html(r);
    
      // Inicializar Select2 nuevamente
      $('#idusuario').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un usuario',
        allowClear: true,
      });
    });
}

function setFechaHoraPeruana() {
  const now = new Date(); // Fecha y hora actual en UTC
  const offset = -5; // Zona horaria de Perú (UTC-5)

  // Ajustar a la zona horaria peruana RESTANDO el offset
  const peruTime = new Date(now.getTime() + (offset * 60 * 60 * 1000));

  // Obtener componentes de la fecha y hora
  const year = peruTime.getUTCFullYear();
  const month = String(peruTime.getUTCMonth() + 1).padStart(2, '0'); // Meses comienzan en 0
  const day = String(peruTime.getUTCDate()).padStart(2, '0');
  const hours = String(peruTime.getUTCHours()).padStart(2, '0');
  const minutes = String(peruTime.getUTCMinutes()).padStart(2, '0');

  // Formatear fecha y hora en formato 'YYYY-MM-DDTHH:MM'
  const formattedDateTime = `${year}-${month}-${day}T${hours}:${minutes}`;

  // Verificar si el elemento existe antes de asignarle un valor
  const inputFecha = document.getElementById('fecha_cierre');
  if (inputFecha) {
    inputFecha.value = formattedDateTime;
  } else {
    //console.error("El elemento con id 'fecha_hora' no se encontró en el DOM.");
  }
}

// Ejecutar la función al cargar la página
document.addEventListener('DOMContentLoaded', setFechaHoraPeruana);
//Función limpiar
function limpiar()
{
	$("#idusuario").val("");
	$("#idcaja").val("");
    $("#descripcion").val("");
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/caja.php?op=listarcaja',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/caja.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Caja Registrado") || datos.includes("Caja Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Caja Registrado") || datos.includes("Caja Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

function cerrar_caja(e) {
  e.preventDefault();
  $("#btnGuardar").prop("disabled", true);
  var formData = new FormData($("#frmForm_cerrar")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: "../../ajax/caja.php?op=cerrar_caja",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          console.log("Respuesta del servidor:", datos); // Depuración

          // Si el mensaje indica que la caja fue registrada con éxito
          if (datos.includes("Cierre de Caja Registrado")) {
            swalWithBootstrapButtons.fire({
              title: "Éxito",
              text: datos,
              icon: "success",
              confirmButtonText: "Aceptar"
            }).then(() => {
              window.location.href = "../abrir_caja/list.php";
              limpiar();
            });

          // Si el mensaje indica que la caja no se puede abrir
          } else if (datos.includes("La Caja no esta Abierta")) {
            swalWithBootstrapButtons.fire({
              title: "Advertencia",
              text: datos,
              icon: "warning",
              confirmButtonText: "Aceptar"
            });

          // Si hubo otro error
          } else {
            swalWithBootstrapButtons.fire({
              title: "Error",
              text: datos,
              icon: "error",
              confirmButtonText: "Aceptar"
            });
          }
        },
        error: function (err) {
          swalWithBootstrapButtons.fire({
            title: "Error",
            text: "Hubo un problema con la solicitud. Intente nuevamente.",
            icon: "error",
            confirmButtonText: "Aceptar"
          }).then(() => {
            $("#btnGuardar").prop("disabled", false);
          });
        }
      });
    } else {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false);
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false);
  });
}

function eliminar(idcaja) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/caja.php?op=eliminar", { idcaja: idcaja }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "La caja ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "La caja está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idcaja de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idcaja = urlParams.get('idcaja');

  if (idcaja) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/caja.php?op=mostrar", { idcaja: idcaja }, function (data, status) {
          if (status === "success") {
              const caja = JSON.parse(data);

              // Precargar los campos del formulario
              setTimeout(function() {
              $("#idusuario").val(caja.idusuario).trigger('change'); // Actualiza Select2
            }, 200); // Retrasar ligeramente para asegurarse de que select2 esté inicializado
              $("#idcaja").val(caja.idcaja);
              $("#descripcion").val(caja.descripcion);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar caja')

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});

init();