var tabla;
function init(){
    listar();
    listarproveedor();
    listarcomision();
    listartecnico();
    listar_validacion();
    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });


    $.post("../../ajax/cliente.php?op=selectTipoDocumento", function(r){
      if ($.fn.select2 && $('#idtipo_documento').data('select2')) {
        $('#idtipo_documento').select2('destroy');
      }
    
      // Actualizar el contenido del select
      $("#idtipo_documento").html(r);
    
      // Inicializar Select2 nuevamente
      $('#idtipo_documento').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione Tipo Documento',
        allowClear: true,
      });
      // Ejecuta la validación inicial después de cargar el select
      validarTipoDocumento();
    });


    
      // Función para validar el tipo de documento y configurar restricciones
      function validarTipoDocumento() {
        const tipoDocumento = $('#idtipo_documento').val(); // Obtiene el ID del tipo de documento seleccionado
        const numDocumentoInput = $('#num_documento');
        const numDocumentoHelp = $('#num_documento_help');

        numDocumentoInput.val(''); // Reinicia el campo de número de documento
        numDocumentoHelp.text(''); // Limpia el texto de ayuda

        // Aplica validaciones según el tipo de documento
        if (tipoDocumento === '1') { // Asume que '1' es DNI
            numDocumentoInput.attr('data-maxlength', 8); // Valor personalizado para validación
            numDocumentoHelp.text('El número de documento debe tener exactamente 8 dígitos (DNI).');
        } else if (tipoDocumento === '2') { // Asume que '2' es RUC
            numDocumentoInput.attr('data-maxlength', 11); // Valor personalizado para validación
            numDocumentoHelp.text('El número de documento debe tener exactamente 11 dígitos (RUC).');
        } else {
            numDocumentoInput.removeAttr('data-maxlength'); // Quita cualquier restricción si no aplica
            numDocumentoHelp.text('Seleccione un tipo de documento válido.');
        }
    }

    // Evento change para actualizar la validación cuando se cambia el tipo de documento
    $('#idtipo_documento').on('change', validarTipoDocumento);

    // Validación en tiempo real para restringir la longitud del número
    $('#num_documento').on('input', function () {
        const maxLength = $(this).attr('data-maxlength'); // Obtiene el valor máximo permitido
        const value = $(this).val();

        if (maxLength && value.length > maxLength) {
            $(this).val(value.slice(0, maxLength)); // Trunca el valor a la longitud máxima
        }
    });
        
}
//Función limpiar
function limpiar()
{
    $("#idpersona").val("");
    $("#nombre").val("");
    $("#idtipo_documento").val("");
    $("#num_documento").val("");
  	$("#celular").val("");
    $("#telefono").val("");
    $("#whatsapp").val("");
    $("#email").val("");
    $("#estado").val("");
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/cliente.php?op=listarcliente',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function listar_validacion() {
    tabla=$("#lista_validacion").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/cliente.php?op=listar_validacion',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function listarproveedor() {
  tabla=$("#proveedor").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/cliente.php?op=listarproveedor',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}

function listarcomision() {
  tabla=$("#comision").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/cliente.php?op=listarcomision',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}

function listartecnico() {
  tabla=$("#tecnico").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/cliente.php?op=listartecnico',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/cliente.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Persona Registrado") || datos.includes("Persona Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Persona Registrado") || datos.includes("Persona Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
  
}

function eliminar(idpersona) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/cliente.php?op=eliminar", { idpersona: idpersona }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "La Persona ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "La Persona está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idcliente de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idpersona = urlParams.get('idpersona');

  if (idpersona) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/cliente.php?op=mostrar", { idpersona: idpersona }, function (data, status) {
          if (status === "success") {
              const cliente = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idpersona").val(cliente.idpersona);
              $("#nombre").val(cliente.nombre);
              $("#idtipo_documento").val(cliente.idtipo_documento).trigger('change'); // Actualiza Select2
              $("#num_documento").val(cliente.num_documento);
              $("#celular").val(cliente.celular);
              $("#telefono").val(cliente.telefono);
              $("#whatsapp").val(cliente.whatsapp);
              $("#email").val(cliente.email);
              $("#estado").val(cliente.estado);
              $("#estado_portal").val(cliente.estado_portal);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar Registro')

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});



init();