
function init(){


    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

   
}

const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });
  
  // Función para guardar o editar
  function guardaryeditar(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
    var formData = new FormData($("#frmForm")[0]);
  
    swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¿Deseas guardar los cambios realizados?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, guardar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
    }).then((result) => {
      if (result.isConfirmed) {
        // Si el usuario confirma, realizar la solicitud AJAX
        $.ajax({
          url: "../../ajax/configuracion.php?op=guardaryeditar",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          success: function (datos) {
            // Mostrar mensaje de éxito o error según la respuesta del backend
            swalWithBootstrapButtons.fire({
              title: 'Resultado',
              text: datos, // Mostrar el mensaje devuelto por el backend
              icon: datos.includes("Configuracion Registrado") || datos.includes("Configuracion Actualizada") ? 'success' : 'error',
              confirmButtonText: 'Aceptar'
            }).then(() => {
              if (datos.includes("Configuracion Registrado") || datos.includes("Configuracion Actualizada")) {
                // Redirigir al listado si la operación fue exitosa
                window.location.href = "../index.php";
                limpiar();
              } else {
                // Si hubo un error, redirigir al formulario de creación
                window.location.href = "create.php";
              }
            });
          },
          error: function (err) {
            // Manejar errores en la solicitud AJAX
            swalWithBootstrapButtons.fire({
              title: 'Error',
              text: 'Hubo un problema con la solicitud. Intente nuevamente.',
              icon: 'error',
              confirmButtonText: 'Aceptar'
            }).then(() => {
              $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
            });
          }
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        // Si el usuario cancela, mostrar un mensaje de cancelación
        swalWithBootstrapButtons.fire({
          title: "Cancelado",
          text: "No se realizaron cambios.",
          icon: "error",
          confirmButtonText: "Aceptar"
        }).then(() => {
          $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
        });
      }
    }).finally(() => {
      $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
    });
  }
  

$(document).ready(function () {
    // Obtener el parámetro idcaja de la URL
    const urlParams = new URLSearchParams(window.location.search);
    const idconfiguracion= urlParams.get('idconfiguracion');
  
    if (idconfiguracion) {
        // Llamar a la función mostrar del backend
        $.post("../../ajax/configuracion.php?op=mostrar", { idconfiguracion: idconfiguracion }, function (data, status) {
            if (status === "success") {
                const configuracion = JSON.parse(data);
  
                
                $("#idconfiguracion").val(configuracion.idconfiguracion);
                $("#ruc_empresa").val(configuracion.ruc_empresa);
                $("#razon_social").val(configuracion.razon_social);
                $("#nombre_comercial").val(configuracion.nombre_comercial);
                $("#direccion_empresa").val(configuracion.direccion_empresa);
                $("#moneda").val(configuracion.moneda);
                $("#celular").val(configuracion.celular);
                $("#telefono").val(configuracion.telefono);
                $("#email").val(configuracion.email);
                $("#descripcion_anuncio").val(configuracion.descripcion_anuncio);
                $("#api_map").val(configuracion.api_map);
                //$("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
                //$("#idtitle").html('<i class="fas fa-plus"></i> Actualizar caja')
  
            } else {
                console.error("Error al cargar los datos");
            }
        });
    }
  });
  init();