var tabla;
function init(){
    listar();
    listar_caja();

    $.post("../../ajax/almacen.php?op=selectAlmacen", function(r){
        if ($.fn.select2 && $('#idalmacen').data('select2')) {
          $('#idalmacen').select2('destroy');
        }
      
        // Limpiar las opciones antes de agregar las nuevas
        $("#idalmacen").html('<option value="">Seleccione un Almacen</option>'); 
        // Actualizar el contenido del select con las opciones de producto
        $("#idalmacen").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idalmacen').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un Almacen',
          allowClear: true,
        });
      });

    
}

function listar_caja() {
  tabla=$("#caja_cerrada").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/consulta.php?op=listar_caja',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}

// Función para listar datos
function listar() {
    var idalmacen=$("#idalmacen").val();
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "scrollY":        "600px",
        "scrollCollapse": true,
        "paging":         false,
        buttons:[
          'copyHtml5',
          'excelHtml5',
                	],
        "ajax": {
            url: '../../ajax/consulta.php?op=listarkardex',
            data:{idalmacen:idalmacen},
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function listar_recaudo() {
  var fecha_inicio=$("#fecha_inicio").val();
	var fecha_fin=$("#fecha_fin").val();  
  tabla=$("#listar_recaudo").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/consulta.php?op=listar_recaudo',
          data:{fecha_inicio:fecha_inicio,fecha_fin:fecha_fin},
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true,
        "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
  });
}

function generarExcel() {
  // Obtener valores de las fechas
  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();
  // Validar que las fechas no estén vacías
  if (!fecha_inicio || !fecha_fin) {
      alert("Por favor, selecciona las fechas de inicio y fin.");
      return;
  }
  // Construir la URL con los parámetros
  var url = '../pago/excel_recaudo.php?fechainicio=' + encodeURIComponent(fecha_inicio) + '&fechafinal=' + encodeURIComponent(fecha_fin);
// Crear un formulario temporal para abrir la URL en una nueva pestaña
// Abrir la URL en una nueva pestaña
window.open(url, '_blank');
}

function generarExcel_Pendiente() {
  // Obtener valores de las fechas
  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();
  // Validar que las fechas no estén vacías
  if (!fecha_inicio || !fecha_fin) {
      alert("Por favor, selecciona las fechas de inicio y fin.");
      return;
  }
  // Construir la URL con los parámetros
  var url = '../pago/excel_pendiente.php?fechainicio=' + encodeURIComponent(fecha_inicio) + '&fechafinal=' + encodeURIComponent(fecha_fin);
// Crear un formulario temporal para abrir la URL en una nueva pestaña
// Abrir la URL en una nueva pestaña
window.open(url, '_blank');
}


function listar_pendiente(event) {
  event.preventDefault();

  var cont = 0; // <--- Mover aquí
  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();

  // Validar que las fechas no estén vacías
  if (!fecha_inicio || !fecha_fin) {
    alert("Por favor, selecciona las fechas de inicio y fin.");
    return;
  }

  if (fecha_inicio) {
    $.post(
      "../../ajax/consulta.php?op=mostrar_pendiente",
      { fecha_inicio: fecha_inicio, fecha_fin: fecha_fin },
      function (data, status) {
        if (status === "success") {
          const response = JSON.parse(data);

          if (response.cabeceras && response.cabeceras.length > 0) {
            if ($.fn.DataTable.isDataTable("#listar_pendiente")) {
              $("#listar_pendiente").DataTable().clear().destroy();
            }

            $("#listar_pendiente tbody").empty(); // Limpiar filas anteriores
            let total_global_pendiente = 0.00; // Reiniciar acumulador

            for (var i = 0; i < response.cabeceras.length; i++) {
              const cabecera = response.cabeceras[i];
              let cliente = cabecera.cliente || " ";
              let paga = cabecera.paga || " ";
              let grupo = "";

              // Fila principal del cliente (cabecera)
              let filaGrupo = `<tr class="filas" id="fila${cont}">
                  <td>${cliente}</td>
                  <td>${paga}</td>
                  <td></td>
                  <td></td>
                  <td></td>
                  <td></td>
                  <td></td>
                  <td>
                    <a target="_blank" href="../llamada/create.php?idcontrato=${cabecera.idcontrato}">
                      <button class="btn btn-success btn-flat btn-xs"><i class="fa-brands fa-whatsapp"></i></button>
                    </a>
                    <a target="_blank" href="../contrato/create_ver.php?idcontrato=${cabecera.idcontrato}">
                      <button class="btn btn-danger btn-flat btn-xs"><i class="fa fa-file"></i></button>
                    </a>
                  </td>
                </tr>`;

              grupo += filaGrupo;
              cont++;

              // Detalles del contrato
              const detallesCabecera = response.detalles[cabecera.idcontrato];
              const meses = [
                "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio",
                "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
              ];

              let total_pendiente = 0.00;

              if (detallesCabecera && detallesCabecera.length > 0) {
                for (var j = 0; j < detallesCabecera.length; j++) {
                  const detalle = detallesCabecera[j];
                  const mesTexto = meses[detalle.mes - 1];
                  const monto = parseFloat(detalle.monto) || 0;

                  total_pendiente += monto;

                  let filaDetalle = `<tr class="filas detalles" id="detalle${cont}">
                      <td></td>
                      <td></td>
                      <td><button class="btn btn-danger btn-flat btn-xs">${mesTexto}</button></td>
                      <td>${detalle.fecha_pago}</td>
                      <td>${detalle.sit_contrato}</td>
                      <td>${detalle.fechainicial} - ${detalle.fechavencimiento}</td>
                      <td>${detalle.monto}</td>
                      <td><button class="btn btn-warning btn-flat btn-xs">Notificado ${detalle.cantidad_movimientos}</button></td>
                    </tr>`;

                  grupo += filaDetalle;
                  cont++;
                }
              }

              total_global_pendiente += total_pendiente; // 👈 Esto ahora funciona correctamente
              $("#listar_pendiente tbody").append(grupo);
            }

            // Mostrar el total general
            $("#suma_pendiente").text("S/ " + total_global_pendiente.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
	//$("#suma_pendiente").text(total_global_pendiente.toFixed(2));

            // Inicializar DataTables
            $("#listar_pendiente").DataTable({
              destroy: true,
              paging: true,
              searching: true,
              lengthChange: true,
              info: true,
              order: [],
              language: {
                url: "https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json"
              },
            });
          } else {
            console.error("No se encontraron datos para 'cabeceras'.");
          }
        } else {
          console.error("Error en la solicitud AJAX.");
        }
      }
    );
  }
}


function actualizar_linea_pendiente(event) {
   event.preventDefault();
    var fecha_inicio = $("#fecha_inicio").val();
    var fecha_fin = $("#fecha_fin").val();

    // Validar que las fechas no estén vacías
    if (!fecha_inicio || !fecha_fin) {
        Swal.fire({
            title: "Fechas requeridas",
            text: "Por favor, selecciona las fechas de inicio y fin.",
            icon: "warning",
            confirmButtonText: "Aceptar"
        });
        return;
    }

    swalWithBootstrapButtons.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas actualizar las líneas?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, realizar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: "Procesando...",
                text: "Esto puede tardar varios minutos.",
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                backdrop: true,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: "../../ajax/consulta.php?op=actualizar_linea_pendiente",
                type: "POST",
                data: {
                    fecha_inicio: fecha_inicio,
                    fecha_fin: fecha_fin
                },
                success: function (response) {
                    try {
                        let datos = JSON.parse(response);

                        if (datos.status === "success") {
                            Swal.fire({
                                title: "Proceso completado",
                                html: `Se procesaron ${datos.procesados} líneas.<br>Se actualizaron ${datos.actualizados} líneas.`,
                                icon: "success",
                                timer: 5000,
                                timerProgressBar: true,
                                allowOutsideClick: false,
                                backdrop: false,
                                willClose: () => {
                                    $(location).attr("href", "list_pendiente_pago.php");
                                }
                            });
                        } else {
                            Swal.fire({
                                title: "Error",
                                text: "Hubo un problema en la actualización.",
                                icon: "error",
                                confirmButtonText: "Aceptar"
                            });
                        }
                    } catch (error) {
                        console.error("Error al procesar respuesta:", error);
                        Swal.fire({
                            title: "Error",
                            text: "Respuesta inesperada del servidor.",
                            icon: "error",
                            confirmButtonText: "Aceptar"
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        title: "Error",
                        text: "Hubo un problema con la solicitud. Intente nuevamente.",
                        icon: "error",
                        confirmButtonText: "Aceptar"
                    });
                }
            });
        }
    });
}

function listar_llamada(event) {
  event.preventDefault();
  var cont = 0;

  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();

  // Validar que las fechas no estén vacías
    if (!fecha_inicio || !fecha_fin) {
        Swal.fire({
            title: "Fechas requeridas",
            text: "Por favor, selecciona las fechas de inicio y fin.",
            icon: "warning",
            confirmButtonText: "Aceptar"
        });
        return;
    }

  if (fecha_inicio) {
    $.post(
      "../../ajax/consulta.php?op=mostrar_llamada",
      { fecha_inicio: fecha_inicio, fecha_fin: fecha_fin },
      function (data, status) {
        if (status === "success") {
          const response = JSON.parse(data);

          if (response.cabeceras && response.cabeceras.length > 0) {
            if ($.fn.DataTable.isDataTable("#listar_llamada")) {
              $("#listar_llamada").DataTable().clear().destroy();
            }
            $("#listar_llamada tbody").empty(); // Limpiar filas anteriores
            for (var i = 0; i < response.cabeceras.length; i++) {
              const cabecera = response.cabeceras[i];
              // Crear un contenedor para cabecera y detalles
              let grupo = "";
              // Fila principal del cliente (cabecera)
              let filaGrupo = '<tr class="filas" id="fila' + cont + '">' +
                  '<td>' + cabecera.usuario + '</td>' +
                  '<td></td>' +
                  '<td></td>' +
                  '<td></td>' +
                  '<td></td>' +
                  '<td></td>' +
                  '<td></td>' +
                  '</tr>';
          
              grupo += filaGrupo;
              cont++;
              const detallesCabecera = response.detalles[cabecera.idusuario];
              // Verificamos si hay detalles para este contrato
              if (detallesCabecera && detallesCabecera.length > 0) {
                  for (var j = 0; j < detallesCabecera.length; j++) {
                      const detalle = detallesCabecera[j];
          
                      let filaDetalle = '<tr class="filas detalles" id="detalle' + cont + '">' +
                          '<td></td>' + // Dejar la celda vacía para mantener el diseño
                          '<td>' + detalle.fecha + '</td>' +
                          '<td>' + detalle.nrocontrato + '</td>' +
                          '<td>' + detalle.cliente + '</td>' +
                          '<td>' + detalle.servicio + '</td>' +
                          '<td>' + detalle.tecnologia + '</td>' +
                          '<td>' + detalle.descripcion + '</td>' +
                          '</tr>';
                      grupo += filaDetalle;
                      cont++;
                  }
                   let filaResumen = '<tr class="resumen">' +
                      '<td colspan="6" style="text-align: right; font-weight: bold;">Total de llamadas:</td>' +
                      '<td style="font-weight: bold;">' + detallesCabecera.length + '</td>' +
                      '</tr>';

                  grupo += filaResumen;
              }
              // Agregar todo el grupo (cabecera + detalles) de una sola vez
              $("#listar_llamada tbody").append(grupo);
          }
          } else {
            console.error("No se encontraron datos para 'cabeceras'.");
          }
        } else {
          console.error("Error en la solicitud AJAX.");
        }
      }
    );
  }
}

function generarPDF_llamada() {
  const { jsPDF } = window.jspdf;
  const doc = new jsPDF();

  let y = 15; // Posición vertical inicial
  doc.setFontSize(14);
  doc.text("Reporte de llamadas filtradas", 14, y);
  y += 10;

  const filas = $("#listar_llamada tbody tr");

  if (filas.length === 0) {
    alert("No hay registros para exportar.");
    return;
  }

  let usuarioActual = "";
  let detallesUsuario = [];

  filas.each(function () {
    const $tr = $(this);
    const cols = $tr.find("td");

    if ($tr.hasClass("filas") && !$tr.hasClass("detalles")) {
      // Si ya tenemos detalles del usuario anterior, imprimimos
      if (detallesUsuario.length > 0) {
        doc.autoTable({
          head: [['Fecha', 'Contrato', 'Cliente', 'Servicio', 'Tecnología', 'Descripción']],
          body: detallesUsuario,
          startY: y,
          styles: { fontSize: 8 },
          headStyles: {
            fillColor: [41, 128, 185],
            textColor: 255,
            halign: 'center'
          }
        });
        y = doc.lastAutoTable.finalY + 2;

        // Mostrar resumen
        doc.setFontSize(10);
        doc.text(`Total de llamadas: ${detallesUsuario.length}`, 14, y);
        y += 10;

        detallesUsuario = []; // Reset
      }

      // Nueva cabecera de usuario
      usuarioActual = cols.eq(0).text().trim();
      doc.setFontSize(12);
      doc.text(`Usuario: ${usuarioActual}`, 14, y);
      y += 6;

    } else if ($tr.hasClass("detalles")) {
      // Es una fila de detalle
      detallesUsuario.push([
        cols.eq(1).text(), // Fecha
        cols.eq(2).text(), // Contrato
        cols.eq(3).text(), // Cliente
        cols.eq(4).text(), // Servicio
        cols.eq(5).text(), // Tecnología
        cols.eq(6).text(), // Descripción
      ]);
    }
  });

  // Último grupo de detalles
  if (detallesUsuario.length > 0) {
    doc.autoTable({
      head: [['Fecha', 'Contrato', 'Cliente', 'Servicio', 'Tecnología', 'Descripción']],
      body: detallesUsuario,
      startY: y,
      styles: { fontSize: 8 },
      headStyles: {
        fillColor: [41, 128, 185],
        textColor: 255,
        halign: 'center'
      }
    });
    y = doc.lastAutoTable.finalY + 2;

    doc.setFontSize(10);
    doc.text(`Total de llamadas: ${detallesUsuario.length}`, 14, y);
  }

  doc.save("llamadas_por_usuario.pdf");
}

function listar_pendiente_egreso(event) {
  event.preventDefault();
	var cont = 0;
  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();

   // Validar que las fechas no estén vacías
    if (!fecha_inicio || !fecha_fin) {
        Swal.fire({
            title: "Fechas requeridas",
            text: "Por favor, selecciona las fechas de inicio y fin.",
            icon: "warning",
            confirmButtonText: "Aceptar"
        });
        return;
    }

  if (fecha_inicio) {
    $.post(
      "../../ajax/consulta.php?op=mostrar_pendiente_egreso",
      { fecha_inicio: fecha_inicio, fecha_fin: fecha_fin },
      function (data, status) {
        if (status === "success") {
          const response = JSON.parse(data);

          if (response.cabeceras && response.cabeceras.length > 0) {
            if ($.fn.DataTable.isDataTable("#listar_egreso")) {
              $("#listar_egreso").DataTable().clear().destroy();
            }
            $("#listar_egreso tbody").empty(); // Limpiar filas anteriores
            let total_pendiente=0.00;
            for (var i = 0; i < response.cabeceras.length; i++) {
              const cabecera = response.cabeceras[i];
              const descri = cabecera.descripcion ? cabecera.descripcion : "S/D";
              let boton = '';
              const tipo_variable = cabecera.tipo;
              const idcategoria = cabecera.idcategoria_egreso;
              const idconcepto = cabecera.idconcepto_egreso;
              const fecha = cabecera.fechavencimiento;
              
              if(tipo_variable == 1){
                boton = '<button class="btn btn-danger btn-flat btn-xs">Fijo</button>';
              }else if(tipo_variable ==2){
                boton ='<button class="btn btn-success btn-flat btn-xs">Variable</button>';
              }

              const monto = parseFloat(cabecera.monto) || 0;
              total_pendiente += monto;
              
              // Crear un contenedor para cabecera y detalles
              let grupo = "";
              // Fila principal del cliente (cabecera)
              let filaGrupo = '<tr class="filas" id="fila' + cont + '">' +
                  '<td>' + boton + '</td>' +    
                  '<td>' + cabecera.concepto + '</td>' +
                  '<td>' + descri + '</td>' +
                  '<td>' + cabecera.nombre_pago + '</td>' +
                  '<td>' + cabecera.descripcion_pago + '</td>' +
                  '<td>' + cabecera.mes_anterior + '</td>' +
                  '<td>' + cabecera.precio_luz + '</td>' +
                  '<td>' + cabecera.fechavencimiento + '</td>' +
                  '<td>' + cabecera.numero_cuota + '</td>' +
                  '<td>' + monto.toFixed(2) + '</td>' +
                  '<td><a href="../pagar/create.php?tipo='+ tipo_variable +
                  '&idcategoriaegreso='+idcategoria +'&idconceptoegreso='+idconcepto+'&fechavencimiento='+encodeURIComponent(fecha)+'"class="btn btn-warning btn-flat btn-xs"target="_blank">Pagar </a></td>' +
                  '</tr>';
              grupo += filaGrupo;
              cont++;
        
              // Agregar todo el grupo (cabecera + detalles) de una sola vez
              $("#listar_egreso tbody").append(grupo);
          }
          //$("#suma_pendiente").text(total_pendiente.toFixed(2));
           $("#suma_pendiente").text("S/ " + total_pendiente.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
          } else {
            console.error("No se encontraron datos para 'cabeceras'.");
          }
        } else {
          console.error("Error en la solicitud AJAX.");
        }
      }
    );
  }
}
  



init();