var tabla;
function init(){
    listar();
    lista_negra();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $("#frmForm_contrato").on("submit", function(e) {
      editar_contrato(e);
    });

    $("#frmForm_edit").on("submit", function(e) {
      editar(e);
    });

    $("#refacturacionForm").on("submit", function(e) {
      guardarfacturacion(e); // Llamar a la función para procesar el formulario
    });

    $("#chatmodalForm").on("submit", function(e) {
      guardarllamada(e); // Llamar a la función para procesar el formulario
    });

    $("#extendermodalForm").on("submit", function(e) {
      guardarextencion(e); // Llamar a la función para procesar el formulario
    });

}
        
    const params = new URLSearchParams(window.location.search);
    const idpersona = params.get("idpersona");
    const iddireccion = params.get("iddireccion");
    const idservicio = params.get("idservicio");
    const idtecnologia = params.get("idtecnologia");

    $.post("../../ajax/cliente.php?op=selectCliente", function(r){
      if ($.fn.select2 && $('#idpersona').data('select2')) {
        $('#idpersona').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idpersona").html('<option value="">Seleccione Cliente</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idpersona").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idpersona').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un cliente',
        allowClear: true,
      });
      if (idpersona) {
        $('#idpersona').val(idpersona).trigger('change'); // Seleccionar y notificar a Select2
    }
    });

    $.post("../../ajax/cliente.php?op=selectComision", function(r){
      if ($.fn.select2 && $('#idpersona_comision').data('select2')) {
        $('#idpersona_comision').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idpersona_comision").html('<option value="">Seleccione Persona Comision</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idpersona_comision").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idpersona_comision').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione una persona',
        allowClear: true,
      });
    });

    //Llenar el select del banco
    $.post("../../ajax/banco.php?op=selectbanco", function(r){
      if ($.fn.select2 && $('#idbanco').data('select2')) {
        $('#idbanco').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idbanco").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idbanco').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un banco',
        allowClear: true,
      });
    });

          // Evento para capturar el nombre del cliente
      $('#idpersona').on('change', function() {
        // Obtener el texto de la opción seleccionada
        var nombreCliente = $(this).find("option:selected").text();
        // Actualizar el valor del input con el nombre del cliente
        $('#nombre_cliente').val(nombreCliente);
      });

      $('#idbanco').on('change', function() {
        // Obtener el texto de la opción seleccionada
        var nombreBanco = $(this).find("option:selected").text();
        // Actualizar el valor del input con el nombre del cliente
        $('#nombre_banco').val(nombreBanco);
      });
    

    $("#idpersona").on("change", function() {
      var idpersona = $("#idpersona").val(); // Obtener el ID del cliente seleccionado
    
      // Establecer el ID del cliente seleccionado directamente en el select de dirección
      $("#iddireccion").html('<option value="">Seleccione Dirección</option>');
    
      // Hacer la solicitud AJAX para cargar las direcciones del cliente
      $.post("../../ajax/cliente.php?op=selectDireccion&idpersona=" + idpersona, function(r) {
        if ($.fn.select2 && $('#iddireccion').data('select2')) {
          $('#iddireccion').select2('destroy'); // Destruir Select2 si ya está inicializado
        }
    
        // Actualizar las opciones con la respuesta de AJAX
        $("#iddireccion").append(r);
    
        // Inicializar nuevamente Select2 para el select de direcciones
        $('#iddireccion').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione una Dirección',
          allowClear: true,
        });
        if (iddireccion) {
          $('#iddireccion').val(iddireccion).trigger('change'); // Seleccionar y notificar a Select2
      }
      });
    });

    $.post("../../ajax/servicio.php?op=selectServicio", function(r){
      if ($.fn.select2 && $('#idservicio').data('select2')) {
        $('#idservicio').select2('destroy');
      }
    
      // Limpiar las opciones antes de agregar las nuevas
      $("#idservicio").html('<option value="">Seleccione Servicio</option>'); 
      // Actualizar el contenido del select con las opciones de producto
      $("#idservicio").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idservicio').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un servicio',
        allowClear: true,
      });
      if (idservicio) {
        $('#idservicio').val(idservicio).trigger('change'); // Seleccionar y notificar a Select2
    }
    });

    $("#idservicio").on("change", function() {
      var idservicio = $("#idservicio").val(); // Obtener el ID del cliente seleccionado
    
      // Establecer el ID del cliente seleccionado directamente en el select de dirección
      $("#idtecnologia").html('<option value="">Seleccione Tecnologia</option>');
    
      // Hacer la solicitud AJAX para cargar las direcciones del cliente
      $.post("../../ajax/tecnologia.php?op=selectTecnologiaServicio&idservicio=" + idservicio, function(r) {
        if ($.fn.select2 && $('#idtecnologia').data('select2')) {
          $('#idtecnologia').select2('destroy'); // Destruir Select2 si ya está inicializado
        }
    
        // Actualizar las opciones con la respuesta de AJAX
        $("#idtecnologia").append(r);
    
        // Inicializar nuevamente Select2 para el select de direcciones
        $('#idtecnologia').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione una Tecnologia',
          allowClear: true,
        });
        if (idtecnologia) {
          $('#idtecnologia').val(idtecnologia).trigger('change'); // Seleccionar y notificar a Select2
       }
      });
    });

    $("#idtecnologia").on("change", function () {
      var idtecnologia = $("#idtecnologia").val(); // Obtener el ID de la tecnología seleccionada

      if (idtecnologia == 1 || idtecnologia == 2) { 
        // Tecnología 1: Mostrar solo el SELECT de Plan y vaciar OLT
        $("#idolt").html('<option value="">Seleccione OLT</option>').prop('disabled', true);
        $("#idplan").html('<option value="">Seleccione un Plan</option>').prop('disabled', false);
        $("#idrepetidor").html('<option value="">Seleccione un Repetidor</option>').prop('disabled', false);
    
        // Cargar planes para la tecnología 1
        $.post("../../ajax/plan.php?op=selectPlanTecnologia&idtecnologia=" + idtecnologia, function (r) {
          if ($.fn.select2 && $('#idplan').data('select2')) {
            $('#idplan').select2('destroy');
          }
          $("#idplan").append(r);
          $('#idplan').select2({
            theme: 'bootstrap4',
            placeholder: 'Seleccione un Plan',
            allowClear: true,
          });
        });
        
      } 
      else if (idtecnologia == 3) { 
        // Tecnología 3: Mostrar SELECT de OLT y deshabilitar el de Plan
        $("#idolt").html('<option value="">Seleccione OLT</option>').prop('disabled', false);
        $("#idplan").html('<option value="">Seleccione un Plan</option>').prop('disabled', true);
        $("#idrepetidor").html('<option value="">Seleccione un Repetidor</option>').prop('disabled', true);
    
        // Cargar OLTs para la tecnología 3
        $.post("../../ajax/olt.php?op=selectOltTecnologia&idtecnologia=" + idtecnologia, function (r) {
          if ($.fn.select2 && $('#idolt').data('select2')) {
            $('#idolt').select2('destroy');
          }
          $("#idolt").append(r);
          $('#idolt').select2({
            theme: 'bootstrap4',
            placeholder: 'Seleccione una OLT',
            allowClear: true,
          });
        });
      }
    });
    
   
    // Evento para cargar PLAN después de seleccionar una OLT
    $("#idolt").on("change", function () {
      var idolt = $("#idolt").val();
    
      if (idolt) {
        $("#idplan").html('<option value="">Seleccione un Plan</option>').prop('disabled', false);
    
        // Cargar planes filtrados por OLT seleccionada
        $.post("../../ajax/plan.php?op=selectPlanPorOlt&idolt=" + idolt, function (r) {
          if ($.fn.select2 && $('#idplan').data('select2')) {
            $('#idplan').select2('destroy');
          }
          $("#idplan").append(r);
          $('#idplan').select2({
            theme: 'bootstrap4',
            placeholder: 'Seleccione un Plan',
            allowClear: true,
          });
        });
      } else {
        // Si no hay OLT seleccionada, deshabilitar el SELECT de Plan
        $("#idplan").html('<option value="">Seleccione un Plan</option>').prop('disabled', true);
       
      }
    });

    // Evento cuando se selecciona un Plan
      $("#idplan").on("change", function () {
        var idplan = $("#idplan").val(); // Obtener el ID del plan seleccionado

        if (idplan) {
          // Hacer la solicitud AJAX para traer los datos del plan
          $.post("../../ajax/plan.php?op=obtenerDatosPlan&idplan=" + idplan, function (data) {
            var planData = JSON.parse(data); // Convertir la respuesta a JSON
            
            // Llenar los campos de descripción y mensualidad
            var mensualidad = parseFloat(planData.precio).toFixed(2);
            $("#desplan").val(planData.descripcion);
            $("#mensualidad").val(mensualidad);
            $("#upload_servicio").val(planData.upload_servicio);
            $("#download_servicio").val(planData.download_servicio);
          }).fail(function () {
            alert("Error al obtener los datos del plan. Intente nuevamente.");
          });
        } else {
          // Limpiar los inputs si no hay plan seleccionado
          $("#desplan").val('');
          $("#mensualidad").val('');
          $("#upload_servicio").val('');
          $("#download_servicio").val('');
        }
      });

      $.post("../../ajax/categoriaingreso.php?op=selectCategoriaIngreso", function(r){
        if ($.fn.select2 && $('#idcategoria_ingreso').data('select2')) {
          $('#idcategoria_ingreso').select2('destroy');
        }
           // Limpiar las opciones antes de agregar las nuevas
           $("#idcategoria_ingreso").html('<option value="">Seleccione Categoria</option>'); 
           // Actualizar el contenido del select con las opciones de producto
           $("#idcategoria_ingreso").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idcategoria_ingreso').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione una categoria',
          allowClear: true,
        });
      });

      $("#idcategoria_ingreso").on("change", function() {
        var idcategoria_ingreso = $("#idcategoria_ingreso").val(); // Obtener el ID del cliente seleccionado
        // Establecer el ID del cliente seleccionado directamente en el select de dirección
        $("#idconcepto_ingreso").html('<option value="">Seleccione Tipo Trabajo</option>');
        // Hacer la solicitud AJAX para cargar las direcciones del cliente
        $.post("../../ajax/registroingreso.php?op=selectIngreso&idcategoria_ingreso=" + idcategoria_ingreso, function(r) {
          if ($.fn.select2 && $('#idconcepto_ingreso').data('select2')) {
            $('#idconcepto_ingreso').select2('destroy'); // Destruir Select2 si ya está inicializado
          }
          // Actualizar las opciones con la respuesta de AJAX
          $("#idconcepto_ingreso").html('<option value="">Seleccione Tipo Trabajo</option>');
          $("#idconcepto_ingreso").append(r);
          // Inicializar nuevamente Select2 para el select de direcciones
          $('#idconcepto_ingreso').select2({
            theme: 'bootstrap4',
            placeholder: 'Seleccione Tipo Trabajo',
            allowClear: true,
          });
        });
      });

       // Cargar las torres inicialmente
       $.post("../../ajax/torre.php?op=selectTorre", function (r) {
        if ($.fn.select2 && $('#idtorre').data('select2')) {
            $('#idtorre').select2('destroy');
        }

        // Actualizar el contenido del select
        $("#idtorre").html('<option value="">Seleccione Torre</option>');
        $("#idtorre").append(r);

        // Inicializar Select2 nuevamente
        $('#idtorre').select2({
            theme: 'bootstrap4',
            placeholder: 'Seleccione una Torre',
            allowClear: true,
        });
      });

      $('#idtorre').on('change', function () {
        const torreid = $(this).val(); // Obtener el ID de la torre seleccionada
    
        if (torreid) {
            // Cargar las repetidoras relacionadas con la torre seleccionada
            $.post("../../ajax/repetidora.php?op=selectRepetidorTorre", { torreid: torreid }, function (r) {
                if ($.fn.select2 && $('#idrepetidor').data('select2')) {
                    $('#idrepetidor').select2('destroy');
                }
    
                // Actualizar el contenido del select de repetidoras
                $("#idrepetidor").html('<option value="">Seleccione Repetidor</option>');
                $("#idrepetidor").append(r);
    
                // Inicializar Select2 nuevamente
                $('#idrepetidor').select2({
                    theme: 'bootstrap4',
                    placeholder: 'Seleccione un Repetidor',
                    allowClear: true,
                });
            });
        } else {
            // Limpiar repetidoras y planes si no se selecciona una torre
            $("#idrepetidor").html('<option value="">Seleccione Repetidor</option>').select2({
                theme: 'bootstrap4',
                placeholder: 'Seleccione un Repetidor',
                allowClear: true,
            });
        }
    });

    



function cambiarEstado() {
  var estado = document.getElementById("sit_contrato").value;

  if (estado == 'pendiente') {
      document.getElementById("sit_contrato").value = 'listo';
  } else if (estado == 'listo') {
      document.getElementById("sit_contrato").value = 'activa';
  } else if (estado == 'activa') {
      document.getElementById("sit_contrato").value = 'notifica';
  } else if (estado == 'notifica') {
      document.getElementById("sit_contrato").value = 'corte';
  } else if (estado == 'corte') {
      document.getElementById("sit_contrato").value = 'suspende';
  } else if (estado == 'suspende') {
      document.getElementById("sit_contrato").value = 'baja';
   } else if (estado == 'baja') {
      document.getElementById("sit_contrato").value = 'negra';
  } else if (estado == 'negra') {
      document.getElementById("sit_contrato").value = 'pendiente';
  }
}

function cambiarContrato() {
  var estado = document.getElementById("estado_contrato").value;
  if (estado == 'Activo') {
      document.getElementById("estado_contrato").value = 'Cancelado';
  } else if (estado == 'Cancelado') {
      document.getElementById("estado_contrato").value = 'Activo';
  } 
}

//Función limpiar
function limpiar()
{
	$("#idcontrato").val("");
  $("#idpersona").val("");
  $("#iddireccion").val("");
  $("#fecha_hora").val("");
  $("#idtecnologia").val("");
  $("#idolt").val("");
  $("#idplan").val("");
  $("#desplan").val("");
  $("#tipo").val("");
  $("#fechapago").val("");
  $("#paga").val("");
  $("#modalidad").val("");
  $("#descripcion").val("");
  $("#idcategoria_ingreso").val("");
  $("#idconcepto_ingreso").val("");

}

document.addEventListener("DOMContentLoaded", function () {
  let radio = document.getElementById('radioTipoVenta');
  let bloqueSelect = document.getElementById('bloqueSelect');
  let select = document.getElementById('idpersona_comision');

  if (radio && bloqueSelect && select) { // Solo ejecuta si los elementos existen
      let lastChecked = null;

      radio.addEventListener('click', function () {
          if (this === lastChecked) {
              this.checked = false;
              bloqueSelect.style.display = 'none';
              select.innerHTML = ""; // Limpiar el select cuando se oculta
              lastChecked = null;
          } else {
              bloqueSelect.style.display = 'block';
              lastChecked = this;
          }
      });
  }
});
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/contrato.php?op=listarcontrato',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true,
          "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
    });
}

function lista_negra() {
  tabla=$("#negra").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/contrato.php?op=lista_negra',
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true
  });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});


// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/contrato.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Contrato Registrado") || datos.includes("Contrato Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Contrato Registrado") || datos.includes("Contrato Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

function editar_contrato(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm_contrato")[0]);
  var valor = formData.get("idcontrato");
  

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
       // Si el usuario confirma, hacer la petición AJAX
       $.ajax({
        url: "../../ajax/contrato.php?op=editar_contrato",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        dataType: "json", // Aseguramos que el backend devuelva JSON
        success: function (response) {
          // Verificamos si la respuesta tiene un status
          if (response.status === "success") {
            Swal.fire({
              title: "Éxito",
              text: response.message,
              icon: "success",
              confirmButtonText: "Aceptar"
            }).then(() => {
              window.location.href = "create_ver.php?idcontrato="+valor;
              limpiar();
            });
          } else {
            Swal.fire({
              title: "Error",
              text: response.message || "Hubo un problema al guardar.",
              icon: "error",
              confirmButtonText: "Aceptar"
            }).then(() => {
              window.location.href = "list.php"; // Redirigir al formulario de creación en caso de error
            });
          }
        },
        error: function () {
          Swal.fire("Error", "Hubo un problema con la solicitud. Intente nuevamente.", "error");
          $("#btnGuardar").prop("disabled", false);
        }
      });
    } else {
      // Si el usuario cancela, mostrar mensaje
      Swal.fire("Cancelado", "No se realizaron cambios.", "error");
      $("#btnGuardar").prop("disabled", false);
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

// Función para guardar o editar
function editar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm_edit")[0]);
  var valor = formData.get("idcontrato");

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
       url: "../../ajax/contrato.php?op=editar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Cuota Registrado") || datos.includes("Cuota Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Cuota Registrado") || datos.includes("Cuota Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "create_ver.php?idcontrato="+valor;
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create_ver.php?idcontrato="+valor;
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}


function guardarfacturacion(e) {
  e.preventDefault(); // Evitar acción predeterminada

  const btnActualizar = $("#btnActualizar");
  btnActualizar.prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos

  const formData = new FormData($("#refacturacionForm")[0]);
  const contratoId = formData.get("idcontrato1");
  const nrooperacion = $("#nrooperacion").val();
  const formaPago = $("input[name='pago']:checked").val();
  console.log(nrooperacion);

  // Validar si el nrooperacion existe antes de enviar el formulario
if (formaPago === "3") {
    $.ajax({
      url: "../../ajax/contrato.php?op=validarNroOperacion&id=" + nrooperacion,
      type: "GET",
      data: { nrooperacion: nrooperacion },
      dataType: "json",
      success: function (response) {
        if (response.exists) {
          swalWithBootstrapButtons.fire({
            title: "Error",
            text: "El número de operación ya existe. Por favor, verifica los datos.",
            icon: "error",
            confirmButtonText: "Aceptar"
          }).then(() => {
            btnActualizar.prop("disabled", false);
          });
        } else {
          confirmarGuardado(formData, contratoId);
        }
      },
      error: function () {
        showError("Hubo un problema al validar el número de operación. Intente nuevamente.");
        btnActualizar.prop("disabled", false);
      }
    });
  } else {
    // Si es efectivo (2), no validar nrooperacion
    confirmarGuardado(formData, contratoId);
  }
}

// Confirmación y guardado después de la validación
function confirmarGuardado(formData, contratoId){

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/contrato.php?op=guardarfacturacion",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Pago Cuota Registrado") || datos.includes("Pago Cuota Actualizar") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Pago Cuota Registrado") || datos.includes("Pago Cuota Actualizar")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "create_ver.php?idcontrato="+contratoId;
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnActualizar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnActualizar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnActualizar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

// Función para guardar o editar
function guardarllamada(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnLlamada").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#chatmodalForm")[0]);
  valor = formData.get("idcontrato");

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/contrato.php?op=guardarllamada",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Mensaje Registrado") || datos.includes("Mensaje Actualizar") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Mensaje Registrado") || datos.includes("Mensaje Actualizar")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "create_ver.php?idcontrato="+valor;
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnLlamada").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnLlamada").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnLlamada").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

function guardarextencion(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnExtender").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#extendermodalForm")[0]);
  valor = formData.get("idcontrato");

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/contrato.php?op=guardarextencion",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Extencion Registrado") || datos.includes("Extencion Actualizar") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Extencion Registrado") || datos.includes("Extencion Actualizar")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "create_ver.php?idcontrato="+valor;
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnExtender").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnExtender").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnExtender").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

function eliminar(idcontrato) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/contrato.php?op=eliminar", { idcontrato: idcontrato }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El contrato ha sido eliminado exitosamente.",
          icon: "success"
        }).then(() => {
          window.location.href = "list.php";
        });
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "La contrato está segura :)",
        icon: "error"
      });
    }
  });
}


let cont = 1;
let detalles = 0;

// Carga inicial
$(document).ready(function () {
  const idcontrato = new URLSearchParams(window.location.search).get('idcontrato');
  if (idcontrato) {
    cargarContrato(idcontrato);
  }
});

async function cargarContrato(id) {
  try {
    const data = await $.post("../../ajax/contrato.php?op=mostrar", { idcontrato: id });
    const response = JSON.parse(data);

    if (!response.contratos || response.contratos.length === 0) {
      console.warn("⚠️ Contrato no encontrado");
      return;
    }

    const contrato = response.contratos[0];
    precargarFormulario(contrato);
 try {
      await precargarSelects(contrato);
    } catch (error) {
      console.error("❌ Error al precargar selects:", error);
    }

    try {
      await precargarRepetidor(contrato);
    } catch (error) {
      console.error("❌ Error al precargar repetidor:", error);
    }

    cargarCuotas(response.cuotas || []);
  } catch (error) {
    console.error("❌ Error al cargar contrato:", error);
  }
}

// Rellenar campos simples del formulario
function precargarFormulario(c) {
  $("#idcontrato").val(c.idcontrato);
  $("#estado_contrato").val(c.estado_contrato);
  $("#fecha_hora").val(c.fecha_hora);
  $("#sit_contrato").val(c.sit_contrato);
  $("#modalidad").val(c.modalidad);
  $("#descripcion").val(c.descripcion);
  $("#nrocontrato").val(c.nrocontrato);
  $("#fechapago").val(c.fechapago);
  $("#paga").val(c.paga);
  $("#tipo").val(c.tipo).trigger('change');
  $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
}

// ==== Funciones con promesas para selects ====
function waitForOption(selector, value, maxTries = 10, delay = 200) {
  return new Promise((resolve, reject) => {
    let tries = 0;

    const interval = setInterval(() => {
      const exists = $(selector).find(`option[value="${value}"]`).length > 0;
      if (exists) {
        clearInterval(interval);
        resolve();
      } else if (++tries >= maxTries) {
        clearInterval(interval);
        reject(`⛔ Tiempo agotado esperando opción "${value}" en ${selector}`);
      }
    }, delay);
  });
}

async function setSelectValue(selector, value) {
  await waitForOption(selector, value); // Espera a que exista el valor
  $(selector).val(value).trigger('change');
  await new Promise(r => setTimeout(r, 200));
}

async function precargarSelects(c) {
  await setSelectValue("#idpersona", c.idcliente);
  await setSelectValue("#iddireccion", c.iddireccion);
  await setSelectValue("#idservicio", c.idservicio);
  await setSelectValue("#idtecnologia", c.idtecnologia);

  if (c.idtecnologia == 3) {
    await setSelectValue("#idolt", c.idolt);
    await setSelectValue("#idplan", c.idplan);
  } else {
    await setSelectValue("#idplan", c.idplan);
  }
}

// ==== Cargar repetidor y torre ====
async function precargarRepetidor(c) {
  await setSelectValue("#idtorre", c.idtorre);

  return new Promise((resolve, reject) => {
    $.post("../../ajax/repetidora.php?op=selectRepetidorTorre", { torreid: c.idtorre }, function (data) {
      $("#idrepetidor").html(data);
      $("#idrepetidor").val(c.idrepetidor).trigger('change');
      resolve();
    }).fail(function (err) {
      console.error("Error al cargar repetidores", err);
      reject(err);
    });
  });
}


// Cargar cuotas en la tabla
function cargarCuotas(cuotas) {
  let modalAbierto = false;

  cuotas.forEach((cuota, i) => {
    const estadoCuota = formatearEstadoCuota(cuota.estado_cuota);
    const mesTexto = obtenerMesTexto(cuota.fechainicial);
    const validar = v => v || '';

    const fila = `
      <tr class="filas" id="fila${cont}">
        <td style="font-size: 14px;">
          <a href="edit.php?idcuota=${cuota.idcuota}" class="btn btn-primary btn-xs"><i class="fa fa-pencil"></i></a>
          <a target="_blank" href="ticket.php?idcuota=${cuota.idcuota}" class="btn btn-warning btn-xs"><i class="fa fa-file"></i></a>
          <button type="button" data-idcuota="${cuota.idcuota}" class="btn btn-danger btn-xs" data-bs-toggle="modal" data-bs-target="#refacturacionModal" onclick="openRefacturacionModal(${cuota.idcuota})">Refacturación</button>
        </td>
        <td style="font-size: 14px;">${cont}</td>
        <td style="font-size: 14px;">${estadoCuota}</td>
        <td style="font-size: 14px;"><button class="btn btn-primary btn-xs">${mesTexto}</button></td>
        <td style="font-size: 14px;">${validar(cuota.fechainicial)} - ${validar(cuota.fechavencimiento)}</td>
        <td style="font-size: 14px;">${validar(cuota.fecha_pago)}</td>
        <td style="font-size: 14px;">${validar(cuota.monto)}</td>
        <td style="font-size: 14px;">${validar(cuota.montocuota)}</td>
        <td style="font-size: 14px;">${validar(cuota.descripcion_cuota)}</td>
        <td style="font-size: 14px;">${validar(cuota.montopagado)}</td>
        <td style="font-size: 14px;">${validar(cuota.nrorecibo)}</td>
        <td style="font-size: 14px;">${validar(cuota.comentario_mensualidad)}</td>
      </tr>
    `;
    $("#detallecuotas tbody").append(fila);

    cont++;
    detalles++;

    if (cuota.estado_cuota == 1 && !modalAbierto) {
      $('#refacturacionModal').modal('show');
      modalAbierto = true;
      openRefacturacionModal(cuota.idcuota);
      $('#refacturacionModal').on('shown.bs.modal', () => {
        $('#modalContent').text('IdCuota: ' + cuota.idcuota);
      });
    }
  });

  inicializarDataTable();
}

function formatearEstadoCuota(estado) {
  estado = parseInt(estado); // Forzar a número
  switch (estado) {
    case 1: return '<button class="btn btn-warning btn-xs">Pendiente</button>';
    case 2: return '<button class="btn btn-success btn-xs">Pagado</button>';
    default: return '<button class="btn btn-secondary btn-xs">Desconocido</button>';
  }
}

function obtenerMesTexto(fechaStr) {
  if (!fechaStr) return '';
  const fecha = new Date(fechaStr);
  const meses = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];
  return meses[fecha.getMonth()];
}

function inicializarDataTable() {
  $('#detallecuotas').DataTable({
    destroy: true,
    paging: true,
    searching: true,
    lengthChange: true,
    info: true,
    language: {
      url: "https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json"
    }
  });
}




document.addEventListener('DOMContentLoaded', function () {
  // Obtener referencias a los elementos
  const radioEfectivo = document.getElementById('pago_efectivo');
  const radioDeposito = document.getElementById('pago_deposito');
  const radioAcuenta = document.getElementById('pago_acuenta');
  const radioCompleto = document.getElementById('pago_completo');
  const div1 = document.getElementById('div1'); // Div para banco y operación
  const div2 = document.getElementById('div2'); // Div para "a cuenta"

  // Verifica si los elementos existen antes de agregar eventos
  if (radioEfectivo && radioDeposito && div1) {
      // Función para actualizar la visibilidad de efectivo/deposito
      function actualizarVisibilidad() {
          if (radioEfectivo.checked) {
              div1.style.display = 'none'; // Ocultar banco y operación
          } else if (radioDeposito.checked) {
              div1.style.display = 'block'; // Mostrar banco y operación
          }
      }

      // Agregar eventos y configuración inicial
      radioEfectivo.addEventListener('change', actualizarVisibilidad);
      radioDeposito.addEventListener('change', actualizarVisibilidad);
      actualizarVisibilidad(); // Configuración inicial
  }

  if (radioAcuenta && radioCompleto && div2) {
      // Función para actualizar la visibilidad de a cuenta/completo
      function actualizarVisibilidadAcuenta() {
          if (radioAcuenta.checked) {
              div2.style.display = 'block'; // Mostrar contenido relacionado con "a cuenta"
          } else if (radioCompleto.checked) {
              div2.style.display = 'none'; // Ocultar contenido relacionado con "a cuenta"
          }
      }
      // Agregar eventos y configuración inicial
      radioAcuenta.addEventListener('change', actualizarVisibilidadAcuenta);
      radioCompleto.addEventListener('change', actualizarVisibilidadAcuenta);
      actualizarVisibilidadAcuenta(); // Configuración inicial
  }
});



function openRefacturacionModal(idcuota) {
      // Asignar el ID al campo oculto
      $('#idcuota').val(idcuota);
      // Realizar una solicitud Ajax para obtener los datos relacionados
      $.ajax({
        url: "../../ajax/contrato.php?op=getCuota",
        method: "POST",
        data: { idcuota: idcuota },
        dataType: "json",
        success: function (data) {
          // Llenar los campos del modal con los datos obtenidos
          var monto_total = data.monto - data.montoacuenta
          $('#idcuota1').val(data.idcuota);
          $('#idcontrato1').val(data.idcontrato);
          $('#idtecnologia1').val(data.idtecnologia);
          $('#idcliente').val(data.idcliente);
          $('#fechainicial').val(data.fechainicial);
          $('#fechavencimiento').val(data.fechavencimiento);
          $('#fecha_pago').val(data.fecha_pago);
          $('#sit_contratof').val(data.sit_contrato);
          $('#montof').val(parseFloat(monto_total).toFixed(2));
          $('#montoacuenta').val(data.montoacuenta);
          $('#descripcionf').val(data.descripcion);
          $('#comentario').val(data.comentario_mensualidad);
          $('#monto_pagar').val(parseFloat(monto_total).toFixed(2));

           // **Antes de mostrar el modal, activar el radio y mostrar el div2**
          if (parseFloat(data.montoacuenta) > 0) {
            //console.log('Monto a cuenta mayor que 0, activando "A Cuenta"');
            $('#pago_acuenta').prop('checked', true); // Activar "A Cuenta"
            $('#pago_acuenta').trigger('change'); // Disparar el evento de cambio

            // Asegurarse de que el div2 se muestre
            div2.style.display = 'block';
          } else {
            //console.log('Monto a cuenta es 0, activando "Completo"');
            $('#pago_completo').prop('checked', true); // Activar "Completo"
            $('#pago_completo').trigger('change'); // Disparar el evento de cambio

            // Asegurarse de que el div2 se oculte
            div2.style.display = 'none';
          }
           // Mostrar el modal
          $('#refacturacionModal').modal('show');
        },
        error: function () {
          alert("Error al cargar los datos. Intenta nuevamente.");
        },
      });
}

function mostrardetallecontrato(idcontrato){   
  //var idingreso = idingreso;  
  //console.log(idingreso);
  $.ajax({  
       url:"../../ajax/contrato.php?op=mostrardetallecontrato&idcontrato=" + idcontrato,  
       method:"POST",  
       data:{idcontrato:idcontrato},  
       dataType:"json",  
       success:function(response){  
         //console.log(response); 
         $('#cliente').val(response.cliente);
         $('#nrocontrato').val(response.nrocontrato);
         $('#sit_contrato').val(response.sit_contrato);
         $('#nombre').val(response.nombre);
         $('#mensualidad').val(parseFloat(response.precio).toFixed(2));
         $('#direccion').val(response.address);
         $('#referencia').val(response.description);
      
      },
      error: function(xhr, status, error) {
         console.error("Error en la petición:", error);
         console.error(xhr.responseText);
     } 
  });  
         
}

function mostrarLlamada(id_llamada){ 
  var id_llamada = id_llamada; 
//  $('#idaveria1').val(idaveria);   
  console.log(id_llamada); 
      $.ajax({  
       url:"../../ajax./contrato.php?op=mostrarLlamada&id=" + id_llamada,  
       method:"POST",  
       data:{id_llamada:id_llamada},  
       dataType:"json",  
       success:function(response){  
         console.log(response);                 
    
       var cont=0;                  
        var html="<table class='table table-striped table-bordered table-condensed table-hover'>";
        html+="<thead>";
        html+="<tr style='background-color:#050505'>";
        html+="<th style='background-color:#050505; color: white;'>Fecha </th>";
        html+="<th style='background-color:#050505; color: white;'>Descripcion</th>";                
        html+="<th style='background-color:#050505; color: white;'>Responsable</th> </tr></thead>";

        html+="<tbody>";              

         for (i = 0; i < response.llamadas.length; i++) {             
            html += '<tr>' +
         //'<tr>'+
           '<td>' + response.llamadas[i].fecharegistro + '</td>' +
           '<td>' + response.llamadas[i].descripcion + '</td>' +
           '<td>' + response.llamadas[i].nombre + '</td>' +                               
           '</tr>' ;
           }
       
          html+="</tbody>";
          html+="</table>";                 
          document.getElementById("tblarticuloss").innerHTML=html;              
                      
       } 

  });  
} 



init();