var tabla;
function init(){
      

    $("#frmForm_fibra").on("submit", function(e) {
      editar_fibra(e);
    });

     // Cargar las torres inicialmente
        $.post("../../ajax/torre.php?op=selectTorre", function (r) {
          if ($.fn.select2 && $('#idtorre').data('select2')) {
              $('#idtorre').select2('destroy');
          }

          // Actualizar el contenido del select
          $("#idtorre").html('<option value="">Seleccione Torre</option>');
          $("#idtorre").append(r);

          // Inicializar Select2 nuevamente
          $('#idtorre').select2({
              theme: 'bootstrap4',
              placeholder: 'Seleccione una Torre',
              allowClear: true,
          });
        });

        // Evento para cargar las OLTs según la torre seleccionada
        $('#idtorre').on('change', function () {
          const torreid = $(this).val(); // Obtener el ID de la torre seleccionada

          if (torreid) {
              $.post("../../ajax/olt.php?op=selectOltTorre", { torreid: torreid }, function (r) {
                  if ($.fn.select2 && $('#idolt').data('select2')) {
                      $('#idolt').select2('destroy');
                  }

                  // Actualizar el contenido del select
                  $("#idolt").html('<option value="">Seleccione OLT</option>');
                  $("#idolt").append(r);

                  // Inicializar Select2 nuevamente
                  $('#idolt').select2({
                      theme: 'bootstrap4',
                      placeholder: 'Seleccione una OLT',
                      allowClear: true,
                  });
              });
          } else {
              // Si no se selecciona ninguna torre, limpiar las OLTs
              $("#idolt").html('<option value="">Seleccione OLT</option>').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione una OLT',
                  allowClear: true,
              });

              // Limpiar planes también
              $("#idplan").html('<option value="">Seleccione Plan</option>').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione un Plan',
                  allowClear: true,
              });
          }
        });

        // Evento para cargar los planes según la OLT seleccionada
        $('#idolt').on('change', function () {
          const idolt = $(this).val(); // Obtener el ID de la OLT seleccionada

          if (idolt) {
              $.post("../../ajax/plan.php?op=selectPlanPorOlt", { idolt: idolt }, function (r) {
                  if ($.fn.select2 && $('#idplan').data('select2')) {
                      $('#idplan').select2('destroy');
                  }

                  // Actualizar el contenido del select
                  $("#idplan").html('<option value="">Seleccione Plan</option>');
                  $("#idplan").append(r);

                  // Inicializar Select2 nuevamente
                  $('#idplan').select2({
                      theme: 'bootstrap4',
                      placeholder: 'Seleccione un Plan',
                      allowClear: true,
                  });
              });
          } else {
              // Si no se selecciona ninguna OLT, limpiar los planes
              $("#idplan").html('<option value="">Seleccione Plan</option>').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione un Plan',
                  allowClear: true,
              });
          }
        });

        $("#idplan").on("change", function () {
          var idplan = $("#idplan").val(); // Obtener el ID del plan seleccionado
  
          if (idplan) {
            // Hacer la solicitud AJAX para traer los datos del plan
            $.post("../../ajax/plan.php?op=obtenerDatosPlan&idplan=" + idplan, function (data) {
              var planData = JSON.parse(data); // Convertir la respuesta a JSON
              
              $("#upload_servicio").val(planData.upload_servicio);
              $("#download_servicio").val(planData.download_servicio);
            }).fail(function () {
              alert("Error al obtener los datos del plan. Intente nuevamente.");
            });
          } else {
            // Limpiar los inputs si no hay plan seleccionado
            $("#upload_servicio").val('');
            $("#download_servicio").val('');
          }
        });
    

}

function cambiarEstado() {
  var estado = document.getElementById("sit_linea").value;

  if (estado == 'pendiente') {
      document.getElementById("sit_linea").value = 'listo';
  } else if (estado == 'listo') {
      document.getElementById("sit_linea").value = 'activa';
  } else if (estado == 'activa') {
      document.getElementById("sit_linea").value = 'notifica';
  } else if (estado == 'notifica') {
      document.getElementById("sit_linea").value = 'corte';
  } else if (estado == 'corte') {
      document.getElementById("sit_linea").value = 'suspende';
  } else if (estado == 'suspende') {
      document.getElementById("sit_linea").value = 'baja';
  } else if (estado == 'baja') {
      document.getElementById("sit_linea").value = 'pendiente';
  }
}

// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});


// Función para guardar o editar
function editar_fibra(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm_fibra")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, hacer la petición AJAX
      $.ajax({
        url: "../../ajax/contrato.php?op=editar_fibra",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        dataType: "json", // Aseguramos que el backend devuelva JSON
        success: function (response) {
          // Verificamos si la respuesta tiene un status
          if (response.status === "success") {
            Swal.fire({
              title: "Éxito",
              text: response.message,
              icon: "success",
              confirmButtonText: "Aceptar"
            }).then(() => {
              window.location.href = "list.php"; // Redirigir al listado
              limpiar();
            });
          } else {
            Swal.fire({
              title: "Error",
              text: response.message || "Hubo un problema al guardar.",
              icon: "error",
              confirmButtonText: "Aceptar"
            }).then(() => {
              window.location.href = "list.php"; // Redirigir al formulario de creación en caso de error
            });
          }
        },
        error: function () {
          Swal.fire("Error", "Hubo un problema con la solicitud. Intente nuevamente.", "error");
          $("#btnGuardar").prop("disabled", false);
        }
      });
    } else {
      // Si el usuario cancela, mostrar mensaje
      Swal.fire("Cancelado", "No se realizaron cambios.", "error");
      $("#btnGuardar").prop("disabled", false);
    }
  }).catch(() => {
    $("#btnGuardar").prop("disabled", false); // Rehabilitar botón en caso de error
  });
}





$(document).ready(function () {
  // Obtener el parámetro idcliente de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idcontrato= urlParams.get('idcontrato');

  if (idcontrato) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/contrato.php?op=mostrar_fibra", { idcontrato: idcontrato }, function (data, status) {
          if (status === "success") {
              const contrato = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idcontrato").val(contrato.idcontrato);
              $("#sit_linea").val(contrato.sit_contrato);
              $("#usuario_cliente").val(contrato.usuario);
              $("#cliente_nombre").val(contrato.nombre);
              $("#password").val(contrato.password);

              setTimeout(() => {
                $("#idtorre").val(contrato.idtorre).trigger('change'); // Seleccionar torre
                setTimeout(() => {
                    $("#idolt").val(contrato.idolt).trigger('change'); // Seleccionar OLT
                    setTimeout(() => {
                        $("#idplan").val(contrato.idplan).trigger('change'); // Seleccionar plan
                    }, 200); // Tiempo para asegurar que la OLT se ha cargado
                }, 200); // Tiempo para asegurar que la torre se ha cargado
            }, 200); // Tiempo inicial para la torre 
              
              
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
            

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});



init();