var tabla;
function init(){
      

    $("#frmForm_internet").on("submit", function(e) {
      editar_internet(e);
    });

     // Cargar las torres inicialmente
        $.post("../../ajax/torre.php?op=selectTorre", function (r) {
          if ($.fn.select2 && $('#idtorre').data('select2')) {
              $('#idtorre').select2('destroy');
          }

          // Actualizar el contenido del select
          $("#idtorre").html('<option value="">Seleccione Torre</option>');
          $("#idtorre").append(r);

          // Inicializar Select2 nuevamente
          $('#idtorre').select2({
              theme: 'bootstrap4',
              placeholder: 'Seleccione una Torre',
              allowClear: true,
          });
        });

        // Evento para cargar las OLTs según la torre seleccionada
        $('#idtorre').on('change', function () {
          const torreid = $(this).val(); // Obtener el ID de la torre seleccionada
      
          if (torreid) {
              // Cargar las repetidoras relacionadas con la torre seleccionada
              $.post("../../ajax/repetidora.php?op=selectRepetidorTorre", { torreid: torreid }, function (r) {
                  if ($.fn.select2 && $('#idrepetidor').data('select2')) {
                      $('#idrepetidor').select2('destroy');
                  }
      
                  // Actualizar el contenido del select de repetidoras
                  $("#idrepetidor").html('<option value="">Seleccione Repetidor</option>');
                  $("#idrepetidor").append(r);
      
                  // Inicializar Select2 nuevamente
                  $('#idrepetidor').select2({
                      theme: 'bootstrap4',
                      placeholder: 'Seleccione un Repetidor',
                      allowClear: true,
                  });
              });
      
              // Cargar los planes relacionados con la torre seleccionada
              $.post("../../ajax/plan.php?op=selectPlanPorTorre", function (r) {
                  if ($.fn.select2 && $('#idplan').data('select2')) {
                      $('#idplan').select2('destroy');
                  }
      
                  // Actualizar el contenido del select de planes
                  $("#idplan").html('<option value="">Seleccione Plan</option>');
                  $("#idplan").append(r);
      
                  // Inicializar Select2 nuevamente
                  $('#idplan').select2({
                      theme: 'bootstrap4',
                      placeholder: 'Seleccione un Plan',
                      allowClear: true,
                  });
              });
          } else {
              // Limpiar repetidoras y planes si no se selecciona una torre
              $("#idrepetidor").html('<option value="">Seleccione Repetidor</option>').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione un Repetidor',
                  allowClear: true,
              });
      
              $("#idplan").html('<option value="">Seleccione Plan</option>').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione un Plan',
                  allowClear: true,
              });
          }
      });

      $("#idplan").on("change", function () {
        var idplan = $("#idplan").val(); // Obtener el ID del plan seleccionado

        if (idplan) {
          // Hacer la solicitud AJAX para traer los datos del plan
          $.post("../../ajax/plan.php?op=obtenerDatosPlan&idplan=" + idplan, function (data) {
            var planData = JSON.parse(data); // Convertir la respuesta a JSON
            
            $("#upload_servicio").val(planData.upload_servicio);
            $("#download_servicio").val(planData.download_servicio);
          }).fail(function () {
            alert("Error al obtener los datos del plan. Intente nuevamente.");
          });
        } else {
          // Limpiar los inputs si no hay plan seleccionado
          //$("#velocidad2_linea").val('');
          //$("#velocidad_linea").val('');
        }
      });


}

function cambiarEstado() {
  var estado = document.getElementById("sit_linea").value;

  if (estado == 'pendiente') {
      document.getElementById("sit_linea").value = 'listo';
  } else if (estado == 'listo') {
      document.getElementById("sit_linea").value = 'activa';
  } else if (estado == 'activa') {
      document.getElementById("sit_linea").value = 'notifica';
  } else if (estado == 'notifica') {
      document.getElementById("sit_linea").value = 'corte';
  } else if (estado == 'corte') {
      document.getElementById("sit_linea").value = 'suspende';
  } else if (estado == 'suspende') {
      document.getElementById("sit_linea").value = 'baja';
  } else if (estado == 'baja') {
      document.getElementById("sit_linea").value = 'pendiente';
  }
}

// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});


// Función para guardar o editar
function editar_internet(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm_internet")[0]);
  var valor = formData.get("idcontrato");

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
       url: "../../ajax/contrato.php?op=editar_internet",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Internet Wifi Registrado") || datos.includes("Datos Internet Wifi Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Internet Wifi Registrado") || datos.includes("Datos Internet Wifi Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "list.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}





$(document).ready(function () {
  // Obtener el parámetro idcliente de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idcontrato= urlParams.get('idcontrato');

  if (idcontrato) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/contrato.php?op=mostrar_internet", { idcontrato: idcontrato }, function (data, status) {
          if (status === "success") {
              const contrato = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idcontrato").val(contrato.idcontrato);
              $("#sit_linea").val(contrato.sit_contrato);
              $("#mac_linea").val(contrato.mac_linea);
              $("#ip_linea").val(contrato.ip_linea);
              $("#upload_servicio").val(contrato.velocidad2_linea);
              $("#download_servicio").val(contrato.velocidad_linea);
              $("#usuario_cliente").val(contrato.num_documento);
              $("#cliente_nombre").val(contrato.nombre);

              setTimeout(() => {
                $("#idtorre").val(contrato.idtorre).trigger('change'); // Seleccionar torre
                setTimeout(() => {
                    $("#idrepetidor").val(contrato.idrepetidor).trigger('change'); // Seleccionar OLT
                    setTimeout(() => {
                        $("#idplan").val(contrato.idplan).trigger('change'); // Seleccionar plan
                    }, 200); // Tiempo para asegurar que la OLT se ha cargado
                }, 200); // Tiempo para asegurar que la torre se ha cargado
            }, 200); // Tiempo inicial para la torre 
              
              
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
            

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});



init();