var tabla;
function init(){
    listar();
    listar_usuario();

    $("#formRegistroIngreso").on("submit", function(e) {
      guardar_ingreso(e);
    });
    
    $.post("../../ajax/categoriaingreso.php?op=selectCategoriaIngreso", function(r){
        if ($.fn.select2 && $('#idcategoria_ingreso').data('select2')) {
            $('#idcategoria_ingreso').select2('destroy');
        }
            // Limpiar las opciones antes de agregar las nuevas
            $("#idcategoria_ingreso").html('<option value="">Seleccione Categoria Ingreso</option>'); 
            // Actualizar el contenido del select con las opciones de producto
            $("#idcategoria_ingreso").append(r);
        
        // Inicializar Select2 nuevamente
        $('#idcategoria_ingreso').select2({
            theme: 'bootstrap4',
            placeholder: 'Seleccione un cliente',
            allowClear: true,
        });
    });

    $(document).on("change", "#idcategoria_ingreso", function() {
          var idcategoria_ingreso = $(this).val(); // Obtener el ID seleccionado
          //console.log(idcategoria_egreso);
          // Restablecer el select de idconcepto_egreso
          $("#idconcepto_ingreso").html('<option value="">Seleccione Tipo Ingreso</option>');
      
          // Hacer la solicitud AJAX para cargar las opciones del concepto de egreso
          $.post("../../ajax/registroingreso.php?op=selectIngreso&idcategoria_ingreso=" + idcategoria_ingreso, function(r) {
              if ($.fn.select2 && $('#idconcepto_ingreso').data('select2')) {
                  $('#idconcepto_ingreso').select2('destroy'); // Destruir Select2 si ya está inicializado
              }
      
              // Actualizar las opciones
              $("#idconcepto_ingreso").html('<option value="">Seleccione una Concepto</option>'); 
              $("#idconcepto_ingreso").append(r);
      
              // Inicializar Select2 nuevamente
              $('#idconcepto_ingreso').select2({
                  theme: 'bootstrap4',
                  placeholder: 'Seleccione un Concepto',
                  allowClear: true,
              });
          });
      });


    $.post("../../ajax/cliente.php?op=selectCliente", function(r){
        if ($.fn.select2 && $('#idpersona').data('select2')) {
            $('#idpersona').select2('destroy');
        }
            // Limpiar las opciones antes de agregar las nuevas
            $("#idpersona").html('<option value="">Seleccione Cliente</option>'); 
            // Actualizar el contenido del select con las opciones de producto
            $("#idpersona").append(r);
        
        // Inicializar Select2 nuevamente
        $('#idpersona').select2({
            theme: 'bootstrap4',
            placeholder: 'Seleccione un cliente',
            allowClear: true,
        });
    });

    $.post("../../ajax/banco.php?op=selectbanco", function(r){
      if ($.fn.select2 && $('#idbanco').data('select2')) {
        $('#idbanco').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idbanco").html('<option value="">Seleccione Banco</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idbanco").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idbanco').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un banco',
        allowClear: true,
      });
    });
}
// Función para listar datos
function listar() {
    //var idalmacen=$("#idalmacen").val();
    tabla=$("#producto").DataTable({
       "responsive": true,
        "autoWidth": false,
        buttons:[
          'copyHtml5',
          'excelHtml5',
                	],
        "ajax": {
            url: '../../ajax/consulta.php?op=listarIngreso',
           // data:{idalmacen:idalmacen},
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function listar_usuario() {
    //var idalmacen=$("#idalmacen").val();
    tabla=$("#ingreso_usuario").DataTable({
       "responsive": true,
        "autoWidth": false,
        buttons:[
          'copyHtml5',
          'excelHtml5',
                	],
        "ajax": {
            url: '../../ajax/consulta.php?op=listar_usuario',
           // data:{idalmacen:idalmacen},
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

function mostrarOcultarCampos() {
  const radioEfectivo = document.getElementById("radioEfectivo");
  const campoBanco = document.getElementById("campoBanco");
  const campoOperacion = document.getElementById("campoOperacion");
  const idBanco = document.getElementById("idbanco");
  const nroOperacion = document.getElementById("nro_operacion");

  // Mostrar u ocultar campos y gestionar el atributo requerido
  if (radioEfectivo.checked) {
      campoBanco.style.display = "none";
      campoOperacion.style.display = "none";
      idBanco.removeAttribute("required");
      nroOperacion.removeAttribute("required");
  } else {
      campoBanco.style.display = "block";
      campoOperacion.style.display = "block";
      idBanco.setAttribute("required", "required");
      nroOperacion.setAttribute("required", "required");
  }
}

// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardar_ingreso(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btn_Ingreso").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#formRegistroIngreso")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/categoriaingreso.php?op=guardar_ingreso",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Ingreso Registrado") || datos.includes("Ingreso Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Ingreso Registrado") || datos.includes("Ingreso Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btn_Ingreso").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btn_Ingreso").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btn_Ingreso").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}


function listar_administrador() {

  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();

  // Validar que las fechas no estén vacías
  if (!fecha_inicio || !fecha_fin) {
        Swal.fire({
            title: "Fechas requeridas",
            text: "Por favor, selecciona las fechas de inicio y fin.",
            icon: "warning",
            confirmButtonText: "Aceptar"
        });
        return;
    }
  tabla=$("#producto").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/consulta.php?op=listar_administrador',
          data:{fecha_inicio:fecha_inicio,fecha_fin:fecha_fin},
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true,
        "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
  });
}

function listar_fecha_usuario() {

  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();

  // Validar que las fechas no estén vacías
  if (!fecha_inicio || !fecha_fin) {
        Swal.fire({
            title: "Fechas requeridas",
            text: "Por favor, selecciona las fechas de inicio y fin.",
            icon: "warning",
            confirmButtonText: "Aceptar"
        });
        return;
    }
  tabla=$("#ingreso_usuario").DataTable({
      "responsive": true,
      "autoWidth": false,
      "ajax": {
          url: '../../ajax/consulta.php?op=listar_fecha_usuario',
          data:{fecha_inicio:fecha_inicio,fecha_fin:fecha_fin},
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true,
        "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
  });
}


init();