var tabla;
function init(){
    listar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $.post("../../ajax/usuario.php?op=selectUsuarioCuadrilla", function(r){
      if ($.fn.select2 && $('#idusuario').data('select2')) {
        $('#idusuario').select2('destroy');
      }
    
      // Actualizar el contenido del select
      $("#idusuario").html('<option value="">Seleccione una Cuadrilla</option>'); 
      // Actualizar el contenido del select con las opciones de producto
      $("#idusuario").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idusuario').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione una cuadrilla',
        allowClear: true,
      });
    });

    $.post("../../ajax/cliente.php?op=selectPersonaTecnico", function(r){
        if ($.fn.select2 && $('#idpersona').data('select2')) {
          $('#idpersona').select2('destroy');
        }
      
        $("#idpersona").html('<option value="">Seleccione un Tecnico</option>'); 
      // Actualizar el contenido del select con las opciones de producto
        $("#idpersona").append(r);
      
        // Inicializar Select2 nuevamente
        $('#idpersona').select2({
          theme: 'bootstrap4',
          placeholder: 'Seleccione un tecnico',
          allowClear: true,
        });
      });
}
//Función limpiar
function limpiar()
{
	$("#idusuario").val("");
	$("#idpersona").val("");
    $("#fecha_ingreso").val("");
    $("#fecha_salida").val("");
}
// Función para listar datos
function listar() {
    tabla=$("#cuadrilla").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/cuadrilla.php?op=listar',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/cuadrilla.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Cuadrilla Registrado") || datos.includes("Cuadrilla Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Cuadrilla Registrado") || datos.includes("Cuadrilla Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

function eliminar(idcaja) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/caja.php?op=eliminar", { idcaja: idcaja }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "La caja ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "La caja está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idcaja de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idpersona_cuadrilla = urlParams.get('idpersona_cuadrilla');

  if (idpersona_cuadrilla) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/cuadrilla.php?op=mostrar", { idpersona_cuadrilla: idpersona_cuadrilla }, function (data, status) {
          if (status === "success") {
              const cuadrilla = JSON.parse(data);

              // Precargar los campos del formulario
              setTimeout(function() {
              $("#idusuario").val(cuadrilla.idusuario).trigger('change');
              $("#idpersona").val(cuadrilla.idpersona).trigger('change'); // Actualiza Select2
            }, 200); // Retrasar ligeramente para asegurarse de que select2 esté inicializado
              $("#fecha_ingreso").val(cuadrilla.fecha_ingreso);
              $("#fecha_ingreso").val(cuadrilla.fecha_ingreso);
              $("#idpersona_cuadrilla").val(cuadrilla.idpersona_cuadrilla);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar Registro')

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});

init();