
var tabla;
function init(){

}

const chart = {
    getStockProducts: function () {
        const chartContainer = document.getElementById("graph-stock-products");
        if (!chartContainer) {
            //console.warn("El elemento #graph-stock-products no está en la página. Se omite la carga del gráfico.");
            return; // No hacer nada si el elemento no existe
        }
        // Realizando la solicitud AJAX
        $.post("../ajax/producto.php?op=grafico_stock", function (response, status) {
            if (status === "success") {
                // Convertimos la respuesta en un objeto JSON
                const parsedResponse = JSON.parse(response);
    
                // Configuración del gráfico con Highcharts
                Highcharts.chart('graph-stock-products', {
                    chart: {
                        type: 'pie',
                        options3d: {
                            enabled: true,
                            alpha: 45
                        }
                    },
                    exporting: {
                        enabled: false
                    },
                    title: {
                        text: 'Stock de Productos'
                    },
                    accessibility: {
                        point: {
                            valueSuffix: '%'
                        }
                    },
                    tooltip: {
                        pointFormat: 'Stock: <b>{point.y:.0f} Unidades</b>'
                    },
                    plotOptions: {
                        pie: {
                            allowPointSelect: true,
                            cursor: 'pointer',
                            depth: 35,
                            dataLabels: {
                                enabled: true,
                                format: '<b>{point.name}</b>: {point.percentage:.1f} %'
                            }
                        }
                    },
                    series: [{
                        name: 'Stock de Productos',
                        data: parsedResponse.data // Usamos los datos del servidor
                    }]
                });
            } else {
                console.error("Error en la solicitud AJAX:", status);
            }
        });
    },

    getPurchaseVSSale: function () {
        const chartContainer = document.getElementById("graph-purchase-vs-sale");
        if (!chartContainer) {
           // console.warn("El elemento #graph-purchase-vs-sale no está en la página. Se omite la carga del gráfico.");
            return; // No hacer nada si el elemento no existe
        }
        // Realizando la solicitud AJAX para obtener los datos
        $.post("../ajax/consulta.php?op=grafico_venta", function (response, status) {
            if (status === "success") {
                // Parseamos la respuesta JSON que contiene las series de datos
                const data = JSON.parse(response);
                // Creamos las series dinámicamente a partir de los datos recibidos
                const series = [
                  
                    { name: 'Ventas', data: data.ventas },
                    { name: 'Egresos', data: data.egresos }
                   
                ];
    
                // Configuración del gráfico con Highcharts
                Highcharts.chart('graph-purchase-vs-sale', {
                    chart: {
                        type: 'column'
                    },
                    title: {
                        text: ''
                    },
                    xAxis: {
                        categories: [
                            'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
                            'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
                        ],
                        crosshair: true
                    },
                    yAxis: {
                        min: 0,
                        title: {
                            text: 'Valores S/'
                        }
                    },
                    tooltip: {
                        headerFormat: '<span style="font-size:10px">{point.key}</span><table>',
                        pointFormat: '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                            '<td style="padding:0"><b>S/{point.y:.2f}</b></td></tr>',
                        footerFormat: '</table>',
                        shared: true,
                        useHTML: true
                    },
                    plotOptions: {
                        column: {
                            pointPadding: 0.2,
                            borderWidth: 0
                        }
                    },
                    series: series
                });
            } else {
                console.error("Error en la solicitud AJAX:", status);
            }
        });
    }
}

// Ejecutar gráficos al cargar la página
document.addEventListener('DOMContentLoaded', function () {
    chart.getStockProducts();
    chart.getPurchaseVSSale();
});


init();