var tabla;
function init(){
    listar();
    listar_facturacion();

    $("#facturacion_Form").on("submit", function (e) {
        actualizacion_comprobante(e);
    });
}
// Función para listar datos
function listar() {
    
    tabla=$("#producto").DataTable({
       "responsive": true,
        "autoWidth": false,
        buttons:[
          'copyHtml5',
          'excelHtml5',
                	],
        "ajax": {
            url: '../../ajax/facturacion.php?op=listarIngreso',
           // data:{idalmacen:idalmacen},
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true,
          "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
    });
    $.post("../../ajax/facturacion.php?op=cantidadTotales",{},function(data,status){
      data=JSON.parse(data);
      // console.log(data);
      $("#suma_egreso").text(parseFloat(data.egreso).toFixed(2));
      $("#suma_ingreso").text(parseFloat(data.ingreso).toFixed(2));

    });
}

function listar_facturacion() {
  //var idalmacen=$("#idalmacen").val();
  tabla=$("#facturacion").DataTable({
     "responsive": true,
      "autoWidth": false,
      buttons:[
        'copyHtml5',
        'excelHtml5',
                ],
      "ajax": {
          url: '../../ajax/facturacion.php?op=listar_facturacion',
         // data:{idalmacen:idalmacen},
          type: "GET",
          dataType: "json",
          error: function(e) {
              console.error("Error en la solicitud AJAX:", e.responseText);
              alert("No se pudo cargar la tabla. Verifique la consola.");
          }
      },
      "language": {
          "sProcessing": "Procesando...",
          "sLengthMenu": "Mostrar _MENU_ registros",
          "sZeroRecords": "No se encontraron resultados",
          "sEmptyTable": "Ningún dato disponible en esta tabla",
          "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
          "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
          "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
          "sSearch": "Buscar:",
          "oPaginate": {
              "sFirst": "Primero",
              "sLast": "Último",
              "sNext": "Siguiente",
              "sPrevious": "Anterior"
          }
        },
        "bDestroy": true,
        "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
  });
}

const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-primary mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  function enviar_facturacion(idpago) {
    console.log("Enviando facturación para el ID:", idpago);

    swalWithBootstrapButtons.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas enviar el pago a facturación?",
        icon: "question",
        showCancelButton: true,
        confirmButtonText: "Sí, enviar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            let formData = new FormData();
            formData.append("idpago", idpago);

            $.ajax({
                url: "../../ajax/facturacion.php?op=enviar_facturacion&idpago=" + encodeURIComponent(idpago),
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                dataType: "json",
                success: function (respuesta) {
                    console.log("Respuesta del servidor:", respuesta);
                    
                    if (respuesta.success) {
                        Swal.fire({
                            title: "Éxito",
                            text: respuesta.message,
                            icon: "success",
                            confirmButtonText: "Aceptar"
                          }).then(() => {
                            location.reload(); // Refresca la página después de cerrar la alerta
                        });

                        // Descargar el XML si existe
                        if (respuesta.rutaXML) {
                            let enlace = document.createElement("a");
                            enlace.href = respuesta.rutaXML;
                            enlace.download = "CDR-" + idpago + ".xml";
                            document.body.appendChild(enlace);
                            enlace.click();
                            document.body.removeChild(enlace);
                        }

                    } else {
                        Swal.fire({
                            title: "Error",
                            text: respuesta.message,
                            icon: "error",
                            confirmButtonText: "Aceptar"
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        title: "Error",
                        text: "Hubo un problema con la solicitud. Intente nuevamente.",
                        icon: "error",
                        confirmButtonText: "Aceptar"
                    });
                }
            });
        }
    });
}

function anular_documento(idpago) {
  console.log("Enviando facturación para el ID:", idpago);

  swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¿Deseas enviar el pago a facturación?",
      icon: "question",
      showCancelButton: true,
      confirmButtonText: "Sí, enviar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
  }).then((result) => {
      if (result.isConfirmed) {
          let formData = new FormData();
          formData.append("idpago", idpago);

          $.ajax({
              url: "../../ajax/facturacion.php?op=anular_documento&idpago=" + encodeURIComponent(idpago),
              type: "POST",
              data: formData,
              contentType: false,
              processData: false,
              dataType: "json",
              success: function (respuesta) {
                  console.log("Respuesta del servidor:", respuesta);
                  
                  if (respuesta.success) {
                      Swal.fire({
                          title: "Éxito",
                          text: respuesta.message,
                          icon: "success",
                          confirmButtonText: "Aceptar"
                        }).then(() => {
                          location.reload(); // Refresca la página después de cerrar la alerta
                      });

                      // Descargar el XML si existe
                      if (respuesta.rutaXML) {
                          let enlace = document.createElement("a");
                          enlace.href = respuesta.rutaXML;
                          enlace.download = "CDR-" + idpago + ".xml";
                          document.body.appendChild(enlace);
                          enlace.click();
                          document.body.removeChild(enlace);
                      }

                  } else {
                      Swal.fire({
                          title: "Error",
                          text: respuesta.message,
                          icon: "error",
                          confirmButtonText: "Aceptar"
                      });
                  }
              },
              error: function () {
                  Swal.fire({
                      title: "Error",
                      text: "Hubo un problema con la solicitud. Intente nuevamente.",
                      icon: "error",
                      confirmButtonText: "Aceptar"
                  });
              }
          });
      }
  });
}

function limpiarModal() {
  $("#idpago").val("");
  $("#codigotipo_comprobante").val("");
  $("#serie").val("");
  $("#correlativo").val("");
  $("#TipoDocumento").text("");
  $("#DocumentoID").text("");
  $("#ClienteDocumento").text("");
  $("#ClienteNumero").text("");
  $("#ClienteNombres").text("");
  $("#FechaRegistro").text("");
  $("#Comprobante_Importe").text("");
  $("#Comprobante_Total").text("");
  $("#Comprobante_Json").val("");
  $("#btnFacturacion").hide(); // Ocultar botón por defecto
}

function actualizacion_comprobante(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnFacturacion").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
    var formData = new FormData($("#facturacion_Form")[0]);
  
    // Configuración de alerta de confirmación
    swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¿Deseas guardar los cambios realizados?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, guardar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
    }).then((result) => {
      if (result.isConfirmed) {
        // Mostrar alerta de carga con spinner
        // Realizar la solicitud AJAX
        $.ajax({
          url: "../../ajax/facturacion.php?op=actualizacion_comprobante",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          success: function (datos) {
            // Solo cerrar la alerta de carga una vez que la solicitud haya terminado
          
          if (datos.includes("Comprobante Registrado") || datos.includes("Comprobante Actualizado")) {
            let timerInterval;
            Swal.fire({
              title: "Guardando...",
              html: "Por favor, espera mientras se procesan los datos.",
              timer: 1000, // 10 segundos de espera
              timerProgressBar: true,
              allowOutsideClick: false, // Desactiva interacciones externas
              backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
              didOpen: () => {
                Swal.showLoading(); // Mostrar spinner de carga
              },
              willClose: () => {
                clearInterval(timerInterval); // Limpiar interval cuando la alerta se cierre
                $(location).attr("href", "list.php");
              }
            });
          }else{
            let timerInterval;
            Swal.fire({
                position: 'center',
                title: "Error",
                html: "Datos no pudieron ser procesadas.<br>Cerrando en <b></b> ms.",
                icon: "error",
                timer: 1000,
                timerProgressBar: true,
                allowOutsideClick: false, // Desactiva interacciones externas
                backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                customClass: {
                    popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
                },
                didOpen: () => {
                    Swal.showLoading();
                    const timer = Swal.getPopup().querySelector("b");
                    timerInterval = setInterval(() => {
                        timer.textContent = `${Swal.getTimerLeft()}`;
                    }, 100);
                },
                willClose: () => {
                  $(location).attr("href", "list.php");
                }
            });
          }
          },
          error: function () {
            // Manejar errores en la solicitud AJAX
            Swal.close();
            swalWithBootstrapButtons.fire({
              title: "Error",
              text: "Hubo un problema con la solicitud. Intente nuevamente.",
              icon: "error",
              confirmButtonText: "Aceptar"
            }).then(() => {
              $("#btnFacturacion").prop("disabled", false); // Rehabilitar el botón tras un error
            });
          }
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        // Si el usuario cancela, mostrar un mensaje de cancelación
        swalWithBootstrapButtons.fire({
          title: "Cancelado",
          text: "No se realizaron cambios.",
          icon: "error",
          confirmButtonText: "Aceptar"
        }).then(() => {
          $("#btnFacturacion").prop("disabled", false); // Rehabilitar el botón si se cancela
        });
      }
    });
  }

        function mostrar_facturacion(idpago,idtipo_documento){
      limpiarModal(); // Limpiar datos previos
      if (idpago) {
        // Llamar a la función mostrar del backend
       $.post("../../ajax/facturacion.php?op=mostrar_facturacion", { idpago: idpago, idtipo_documento : idtipo_documento }, function (data, status) {
                if (status === "success") {
                  const response = JSON.parse(data);

                  // Si el backend envía un error
                  if (response.status === "error") {
                    Swal.fire({
                      title: "Error",
                      text: response.message,
                      icon: "error",
                      confirmButtonText: "Aceptar"
                   
                     }).then(() => {
			    // Refrescar la página al cerrar el mensaje
			    location.reload();
			  });
                    return; // detener ejecución
                  }
                  
                   const ahora = new Date();
                      const fechaHora = ahora.toLocaleString(); // Ejemplo: "13/5/2025, 14:45:12"
                      $("#FechaRegistro").text(fechaHora);

                  //Continuar con lógica normal si todo está bien
                  if (response.clientes && response.clientes.length > 0) {
                    const cliente = response.clientes[0];
                    let nro_comprobante = cliente.nro_comprobante.toString().padStart(8, '0');

                    $("#idpago").val(cliente.idpago);
                    $("#codigotipo_comprobante").val(cliente.codigotipo_comprobante);
                    $("#serie").val(cliente.serie_comprobante);
                    $("#correlativo").val(nro_comprobante);
                    $("#codigotipo_comprobante").val(cliente.codigotipo_comprobante);
                    $("#TipoDocumento").text(cliente.nombre_comprobante);
                    $("#DocumentoID").text(cliente.serie_comprobante + "-" + nro_comprobante);
                    $("#ClienteDocumento").text(cliente.documento);
                    $("#ClienteNumero").text(cliente.num_documento);
                    $("#ClienteNombres").text(cliente.cliente);
                    //$("#FechaRegistro").text(cliente.fecha_pago);
                    $("#Comprobante_Importe").text(cliente.monto + " (PEN)");
                    $("#Comprobante_Total").text(cliente.monto + " (PEN)");
                    $("#btnFacturacion").show(); 
                  } else {
                    console.error("No se encontraron datos para la venta.");
                  }

                  if (response.facturaElectronica) {
                    $("#Comprobante_Json").val(JSON.stringify(response.facturaElectronica, null, 2));
                  }

                } else {
                  // Error de conexión AJAX (no del backend)
                  Swal.fire({
                    title: "Error",
                    text: "No se pudo conectar al servidor.",
                    icon: "error",
                    confirmButtonText: "Aceptar"
                  });
                }
              });

      }
    }

    function mostrar(idpago,idtipo_documento){
      limpiarModal(); // Limpiar datos previos
      if (idpago) {
        // Llamar a la función mostrar del backend
        $.post("../../ajax/facturacion.php?op=mostrar", { idpago: idpago, idtipo_documento : idtipo_documento }, function (data, status) {
          if (status === "success") {
            const response = JSON.parse(data);
            if (response.clientes && response.clientes.length > 0) {
              const cliente = response.clientes[0];

              let nombre_comprobante; // Declarar la variable fuera del if

              if (cliente.codigotipo_comprobante == 3) {
                  nombre_comprobante = "BOLETA";
              } else {
                  nombre_comprobante = "FACTURA";
              }
              if(cliente.estado_facturacion == 2){
                $("#btnFacturacion").hide(); 
              }
              
              const ahora = new Date();
                      const fechaHora = ahora.toLocaleString(); // Ejemplo: "13/5/2025, 14:45:12"
                      $("#FechaRegistro").text(fechaHora);
           
                $("#idpago").val(cliente.idpago);
                $("#codigotipo_comprobante").val(cliente.codigotipo_comprobante);
                $("#serie").val(cliente.serie);
                $("#correlativo").val(cliente.correlativo);
                $("#TipoDocumento").text(nombre_comprobante);
                $("#DocumentoID").text(cliente.serie +"-"+ cliente.correlativo);
                $("#ClienteDocumento").text(cliente.documento);
                $("#ClienteNumero").text(cliente.num_documento);
                $("#ClienteNombres").text(cliente.cliente);
               // $("#FechaRegistro").text(cliente.fecha_pago);
                $("#Comprobante_Importe").text(cliente.monto + "(PEN)");
                $("#Comprobante_Total").text(cliente.monto + "(PEN)");
               /// $("#Comprobante_Json").text(cliente.);
               
              } else {
                console.error("No se encontraron datos para la venta.");
            }
            if (response.facturaElectronica) {
              $("#Comprobante_Json").val(JSON.stringify(response.facturaElectronica, null, 2));
            }

  
            } else {
                console.error("Error al cargar los datos");
            }
  
        });
    }

    }
    
    function procesarSeleccionados() {
  const seleccionados = [];
  document.querySelectorAll('.check-item:checked').forEach((checkbox) => {
    seleccionados.push(checkbox.value);
  });

  if (seleccionados.length === 0) {
    Swal.fire({
      title: "Error",
      text: "Debes seleccionar al menos uno comprobante.",
      icon: "error",
      confirmButtonText: "Aceptar"
    });
    return;
  }
  $("#btnProcesar").prop("disabled", true); // Deshabilita el botón mientras se procesa
  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: `¿Deseas procesar ${seleccionados.length} elemento(s)?`,
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, procesar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url: "../../ajax/facturacion.php?op=procesar",
        method: "POST",
        data: { ids: seleccionados },
        success: function (response) {
          try {
            const res = JSON.parse(response);

            let mensaje = res.message || "Operación completada.";
            if (Array.isArray(res.errores) && res.errores.length > 0) {
              mensaje += "\n\n⚠️ Errores encontrados:\n" + res.errores.map(e => `• ${e}`).join("\n");
            }

            swalWithBootstrapButtons.fire({
              title: "Resultado",
              html: `<pre style="text-align:left; white-space:pre-wrap;">${mensaje}</pre>`,
              icon: res.status === "ok" ? "success" : "error",
              confirmButtonText: "Aceptar"
            }).then(() => {
              if (res.status === "ok") {
                location.reload();
              }
            });

          } catch (e) {
		  console.error("Error al parsear respuesta:", response);
		  Swal.fire("Error", "Respuesta inesperada del servidor.", "error").then(() => {
		    location.reload(); // 🔁 Recarga la página luego del cierre del modal
		  });
		}
        },
        error: function (xhr) {
          console.error("Error AJAX:", xhr.responseText);
          Swal.fire("Error", "Hubo un problema con la solicitud.", "error");
        },
        complete: function () {
          $("#btnProcesar").prop("disabled", false);
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizó ninguna acción.",
        icon: "info",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnProcesar").prop("disabled", false);
      });
    }
  }).finally(() => {
    $("#btnProcesar").prop("disabled", false);
  });
}


init();