var tabla;
function init(){

}
var cont = 0;
function listar_caja_cerrada(event) {
  event.preventDefault();

  var tipo_pago = $("#tipopago").val();
  var idcierre = $("#idcierre").val();
  let tipo_pago_select = parseInt($("#tipopago").val());
  // Validar que las fechas no estén vacías
  if (!tipo_pago) {
    Swal.fire({
            title: "Tipo Ingreso requerido",
            text: "Por favor, seleccione un tipo ingreso.",
            icon: "warning",
            confirmButtonText: "Aceptar"
        });
        return;
        }
        if (tipo_pago) {
            $.post(
            "../../ajax/finanzas.php?op=mostrar_finanzas",
            { tipo_pago: tipo_pago, idcierre : idcierre },
            function (data, status) {
                if (status === "success") {
                const response = JSON.parse(data);

                let ingreso_efectivo = 0;
                let ingreso_transferencia = 0;
                let egreso_efectivo = 0;
                let egreso_transferencia = 0;
                let monto_apertura = 0;
                let total_ingreso = 0;
                let total_egreso = 0;
                if (response.ingresos && response.ingresos.length > 0) {
                    let cont = 0; // Reiniciar contador
                    $("#tabla_ingresos tbody").empty(); // Limpiar filas anteriores

                    for (var i = 0; i < response.ingresos.length; i++) {
                    const ingreso = response.ingresos[i];

                    const tipo_pago_codigo = ingreso.tipoingreso;
                    let tipo_pago = "";
                    let banco = ingreso.banco;
                    let nro_operacion = ingreso.nro_operacion;

                    let monto = parseFloat(ingreso.monto) || 0;
                    total_ingreso += monto;

                     // Traducir el tipo de ingreso
                    if (tipo_pago_codigo == 2) {
                        tipo_pago = "Efectivo";
                        banco = "";  // Vacío si es efectivo
                        nro_operacion = "";  // Vacío si es efectivo
                        ingreso_efectivo += monto;
                        
                    } else if (tipo_pago_codigo == 3) {
                        tipo_pago = "Transferencia";
                        ingreso_transferencia += monto
                        $("#apertura_caja").text("");
                    } else {
                        tipo_pago = "Otro";
                    }
                    
                
                    // Crear un contenedor para cabecera y detalles
                    let grupo = "";
                
                    // Fila principal del cliente (cabecera)
                    let filaGrupo = '<tr class="filas" id="fila' + cont + '">' +
                         '<td>' + (cont + 1) + '</td>' +
                        '<td>' + tipo_pago + '</td>' +
                        '<td>'+ ingreso.fecha_pago +'</td>' +
                        '<td>'+ ingreso.cliente +'</td>' +
                        '<td>'+ ingreso.categoria_ingreso +'</td>' +
                        '<td>' + (banco ?? '') + '</td>' +
                        '<td>' + (nro_operacion ?? '') + '</td>' +
                        '<td>'+ ingreso.correlativo_pago +'</td>' +
                        '<td>'+ ingreso.monto +'</td>' +
                        '</tr>';
                
                    grupo += filaGrupo;
                    cont++;
                    // Agregar todo el grupo (cabecera + detalles) de una sola vez
                   
                    $("#tabla_ingresos tbody").append(grupo);
                    $("#ingreso").text("Ingreso " + tipo_pago);
                }
                 
                $("#total_ingreso").text("S/ " + total_ingreso.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $("#total_ingresos").text("S/ " + total_ingreso.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                
                } else {
                    $("#tabla_ingresos tbody").empty();
                    $("#total_ingreso").text('');
                    $("#total_ingresos").text('');
                     Swal.fire({
                            title: "Sin Registros",
                            text: "Ingresos sin registros",
                            icon: "warning",
                            confirmButtonText: "Aceptar"
                        });
                      //  return;
                }

                if (response.egresos && response.egresos.length > 0) {
                    let cont = 0;
                    $("#tabla_egresos tbody").empty(); // Limpiar filas anteriores
                    for (var i = 0; i < response.egresos.length; i++) {
                    const egreso = response.egresos[i];

                    const tipo_pago_codigo = egreso.tipopago;
                    const tipo_costo_egreso = egreso.idtipo;
                    const tipo_comprobante_egreso = egreso.tipo_comprobante;
                    let tipo_pago = "";
                    let tipo_costo = "";
                    let comprobante = "";

                    let monto = parseFloat(egreso.monto) || 0;
                    total_egreso += monto;

                     // Traducir el tipo de ingreso
                    if (tipo_pago_codigo == 2) {
                        tipo_pago = "Efectivo";
                        banco = "";  // Vacío si es efectivo
                        nro_operacion = "";  // Vacío si es efectivo
                        egreso_efectivo += monto;
                    } else if (tipo_pago_codigo == 3) {
                        tipo_pago = "Transferencia";
                        egreso_transferencia += monto;
                        $("#apertura_caja").text("");
                    } else {
                        tipo_pago = "Otro";
                    }

                    if (tipo_costo_egreso == 1) {
                        tipo_costo = "Fijo";
                    } else if (tipo_pago_codigo == 2) {
                        tipo_costo = "Variable";
                    }

                     if (tipo_comprobante_egreso == 1) {
                        comprobante = "Recibo Egreso";
                    } else if (tipo_comprobante_egreso == 2) {
                        comprobante = "Boleta";
                    } else if (tipo_comprobante_egreso == 3) {
                        comprobante = "Factura";
                    }
                    $("#egreso").text("Egreso " + tipo_pago);
                    
                
                    // Crear un contenedor para cabecera y detalles
                    let grupoo = "";
                
                    // Fila principal del cliente (cabecera)
                    let filaGrupoo = '<tr class="filas" id="fila' + cont + '">' +
                         '<td>' + (cont + 1) + '</td>' +
                        '<td>' + tipo_pago + '</td>' +
                        '<td>'+ egreso.fechapago +'</td>' +
                        '<td>'+ tipo_costo +'</td>' +
                        '<td>'+ egreso.concepto +'</td>' +
                        '<td>' + egreso.descripcion + '</td>' +
                        '<td>' + comprobante + '</td>' +
                        '<td>'+ egreso.nrorecibo +'</td>' +
                        '<td>'+ monto.toFixed(2) +'</td>' +
                        '</tr>';
                
                    grupoo += filaGrupoo;
                    cont++;
                    // Agregar todo el grupo (cabecera + detalles) de una sola vez
                    $("#tabla_egresos tbody").append(grupoo);
                }
                // Mostrar total en el td final
                $("#total_egreso").text("S/ " + total_egreso.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $("#total_egresos").text("S/ " + total_egreso.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                }else{

                     $("#tabla_egresos tbody").empty();
                     $("#total_egreso").text("");
                     $("#total_egresos").text("");
                     $("#egreso").text("");
                     $("#apertura_caja").text("");
                     Swal.fire({
                            title: "Sin Registros",
                            text: "Egresos sin registros ",
                            icon: "warning",
                            confirmButtonText: "Aceptar"
                        });
                       // return;
                        
                }
                if (response.movimientos && response.movimientos.length > 0) {
                   
                    for (var i = 0; i < response.movimientos.length; i++) {
                    const movimiento = response.movimientos[i];
                    const estado_caja_movimiento = movimiento.estado_caja;

                    const year = movimiento.ano;
                    const mes =movimiento.mes;
                    const correlativo = movimiento.nrocorrelativo;

                    const resultado = `${year}${mes}-0${correlativo}`;

                        
                    if (estado_caja_movimiento == 1) {
                        $("#nombre_usuario").text(movimiento.usuario);
                       // $("#apertura_caja").text("S/ "+ movimiento.monto_apertura);
                       // monto_apertura = parseFloat(movimiento.monto_apertura) || 0;

                        if (tipo_pago_select === 2) {
                            $("#apertura").text("Apertura Caja");
                            $("#apertura_caja").text("S/ " + parseFloat(movimiento.monto_apertura).toFixed(2));
                            monto_apertura = parseFloat(movimiento.monto_apertura) || 0;
                        } else {
                            $("#apertura_caja").text("");
                            $("#apertura").text("");
                        }
                    } else if (estado_caja_movimiento == 2) {
                        $("#fecha_apertura").text("Fecha Apertura: "+ movimiento.fecha_apertura);
                        $("#fecha_cierre").text("Fecha Cierre: "+movimiento.fecha_cierre);
                        $("#correlativo_caja").text("Nro Correlativo Caja: "+ resultado);
                    }
                    }
                }

                let total_caja_efectivo = monto_apertura + ingreso_efectivo - egreso_efectivo;
                let total_caja_transferencia = ingreso_transferencia - egreso_transferencia;

                // Mostrar resultados en algún contenedor de texto
                $("#total_final_efectivo").text("Caja Efectivo: S/ " + total_caja_efectivo.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));
                $("#total_final_transferencia").text("Caja Transferencia: S/ " + total_caja_transferencia.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 }));

                } else {
                console.error("Error en la solicitud AJAX.");
                }
            }
            );
        }
}


async function generarExcel() {
    const workbook = new ExcelJS.Workbook();
    const worksheet = workbook.addWorksheet("Caja Cerrada");
    // Estilos
    const headerStyle = {
        font: { bold: true, color: { argb: 'FFFFFFFF' } },
        fill: { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FF4472C4' } },
        border: {
            top:    { style: 'thin' },
            left:   { style: 'thin' },
            bottom: { style: 'thin' },
            right:  { style: 'thin' }
        },
        alignment: { vertical: 'middle', horizontal: 'center' }
    };

    const cellBorder = {
        top:    { style: 'thin' },
        left:   { style: 'thin' },
        bottom: { style: 'thin' },
        right:  { style: 'thin' }
    };

    const totalStyle = {
        font: { bold: true, color: { argb: 'FF000000' } },
        fill: { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFF2CC' } },
        border: {
            top:    { style: 'medium' },
            left:   { style: 'medium' },
            bottom: { style: 'medium' },
            right:  { style: 'medium' }
        },
        alignment: { horizontal: 'right' }
    };

    const resumenStyle = {
        font: { bold: true, color: { argb: 'FFFFFFFF' } },
        fill: { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FF7030A0' } },
        border: {
            top:    { style: 'medium' },
            left:   { style: 'medium' },
            bottom: { style: 'medium' },
            right:  { style: 'medium' }
        },
        alignment: { horizontal: 'center' }
    };

    let rowIndex = 1;

    // --- Información general arriba ---
    // Aquí debes obtener los valores de la caja y responsable desde el DOM o variables

    const fechaApertura = document.getElementById("fecha_apertura")?.innerText || "01/01/2025";
    const fechaCierre = document.getElementById("fecha_cierre")?.innerText || "01/01/2025";
    const nroCorrelativo = document.getElementById("correlativo_caja")?.innerText || "0001";
    const responsable = document.getElementById("nombre_usuario")?.innerText || "Juan Pérez";

    

    worksheet.mergeCells(`C${rowIndex}:G${rowIndex}`);
    worksheet.getCell(`C${rowIndex}`).value = `${fechaApertura}   |   ${fechaCierre}   |   ${nroCorrelativo}`;
    worksheet.getCell(`C${rowIndex}`).font = { bold: true, size: 12, color: { argb: 'FF000000' } };
    worksheet.getCell(`C${rowIndex}`).alignment = { horizontal: 'center', vertical: 'middle' };
    worksheet.getCell(`C${rowIndex}`).border = {
        top: { style: 'medium' },
        bottom: { style: 'medium' }
    };
    rowIndex += 2;



    worksheet.mergeCells(`D${rowIndex}:F${rowIndex}`);
    worksheet.getCell(`D${rowIndex}`).value = `Responsable: ${responsable}`;
    worksheet.getCell(`D${rowIndex}`).font = { bold: true, size: 14, color: { argb: 'FF000000' } };
    worksheet.getCell(`D${rowIndex}`).alignment = { horizontal: 'center', vertical: 'middle' };
    rowIndex += 2;

    // --- Tabla de INGRESOS ---
    // Antes de la fila "Ingresos" agrega borde superior grueso:
    worksheet.mergeCells(`A${rowIndex}:I${rowIndex}`);
    const ingresosTitleCell = worksheet.getCell(`A${rowIndex}`);
    ingresosTitleCell.value = "Ingresos";
    ingresosTitleCell.font = { bold: true, size: 12 };
    ingresosTitleCell.alignment = { horizontal: 'left' };
    // Bordes gruesos arriba y abajo para la cabecera
    ingresosTitleCell.border = {
        top: { style: 'thick', color: { argb: 'FF000000' } },
        bottom: { style: 'thin' }
    };
    rowIndex++;

    const headersIngresos = ["#", "Tipo Pago", "Fecha Pago", "Nombre/Razón Social", "Servicio", "Banco", "Nro Operación", "Nro Comprobante", "Importe (S/)"];
    worksheet.addRow(headersIngresos).eachCell(cell => Object.assign(cell, headerStyle));
    rowIndex++;

    let totalIngresos = 0;
    const tbodyIngresos = document.querySelectorAll("#tbody_ingresos tr");
    tbodyIngresos.forEach((tr, index) => {
        const rowData = Array.from(tr.cells).map(td => td.innerText.trim());
        const importe = parseFloat(rowData[8].replace(/[^0-9.-]+/g,"")) || 0; // Asumiendo importe está en índice 8
        totalIngresos += importe;
        worksheet.addRow(rowData);  // Sin índice
        rowIndex++;
    });

    // Fila de total ingresos
    const totalRowIngreso = worksheet.addRow(["", "", "", "", "", "", "", "TOTAL INGRESOS", document.getElementById("total_ingresos").innerText]);
    totalRowIngreso.eachCell(cell => Object.assign(cell, totalStyle));
    rowIndex++;

    rowIndex++; // espacio

    // --- Tabla de EGRESOS ---
    worksheet.mergeCells(`A${rowIndex}:I${rowIndex}`);
    const egresosTitleCell = worksheet.getCell(`A${rowIndex}`);
    egresosTitleCell.value = "Egresos";
    egresosTitleCell.font = { bold: true, size: 12 };
    egresosTitleCell.alignment = { horizontal: 'left' };
    // Bordes gruesos arriba y abajo para la cabecera
    egresosTitleCell.border = {
        top: { style: 'thick', color: { argb: 'FF000000' } },
        bottom: { style: 'thin' }
    };
    rowIndex++;

    const headersEgresos = ["#", "Tipo Pago", "Fecha Pago", "Tipo Costo", "Clasificador de Gasto", "Detalle Gasto", "Comprobante", "Nro Comprobante", "Importe (S/)"];
    worksheet.addRow(headersEgresos).eachCell(cell => Object.assign(cell, headerStyle));
    rowIndex++;

    let totalEgresos = 0;
    const tbodyEgresos = document.querySelectorAll("#tbody_egresos tr");
    tbodyEgresos.forEach((tr, index) => {
        const rowData = Array.from(tr.cells).map(td => td.innerText.trim());
        const importe = parseFloat(rowData[8].replace(/[^0-9.-]+/g,"")) || 0;
        totalEgresos += importe;
        worksheet.addRow(rowData);  // Sin índice
        rowIndex++;
    });

    // Fila de total egresos
    const totalRowEgreso = worksheet.addRow(["", "", "", "", "", "", "", "TOTAL EGRESOS", document.getElementById("total_egresos").innerText]);
    totalRowEgreso.eachCell(cell => Object.assign(cell, totalStyle));
    rowIndex++;

    rowIndex++; // espacio

    // --- Resumen de caja ---
    worksheet.mergeCells(`A${rowIndex}:I${rowIndex}`);
    const resumenTitleCell = worksheet.getCell(`A${rowIndex}`);
    resumenTitleCell.value = "Resumen de Caja";
    resumenTitleCell.font = { bold: true, size: 12 };
    resumenTitleCell.alignment = { horizontal: 'left' };
    // Bordes gruesos arriba y abajo para la cabecera
    resumenTitleCell.border = {
        top: { style: 'thick', color: { argb: 'FF000000' } },
        bottom: { style: 'thin' }
    };
    rowIndex++;

    const resumen = [
        ["Apertura", document.getElementById("apertura_caja").innerText],
        ["Ingreso", document.getElementById("total_ingresos").innerText],
        ["Egreso", document.getElementById("total_egresos").innerText],
        ["TOTAL EFECTIVO", document.getElementById("total_final_efectivo").innerText],
        ["TOTAL TRANSFERENCIA", document.getElementById("total_final_transferencia").innerText]
    ];

resumen.forEach(([label, value]) => {
    const row = worksheet.addRow([label]);
    const rowNumber = row.number;

    // Unir columnas A a C para el label
    worksheet.mergeCells(`A${rowNumber}:C${rowNumber}`);

    // Unir columnas D a I para el valor
    worksheet.mergeCells(`D${rowNumber}:I${rowNumber}`);

    // Establecer valor del campo en D (que inicia el merge D-I)
    row.getCell(4).value = value;

    const whiteBackground = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFFFF' } };
    const blackFont = { bold: true, color: { argb: 'FF000000' } };
    const blackBorder = {
        top: { style: 'thin', color: { argb: 'FF000000' } },
        left: { style: 'thin', color: { argb: 'FF000000' } },
        bottom: { style: 'thin', color: { argb: 'FF000000' } },
        right: { style: 'thin', color: { argb: 'FF000000' } },
    };

    // Estilo para la celda combinada A-C
    row.getCell(1).fill = whiteBackground;
    row.getCell(1).font = blackFont;
    row.getCell(1).border = blackBorder;
    row.getCell(1).alignment = { horizontal: 'center' };

    // Estilo para la celda combinada D-I
    row.getCell(4).fill = whiteBackground;
    row.getCell(4).font = blackFont;
    row.getCell(4).border = blackBorder;
    row.getCell(4).alignment = { horizontal: 'right' };
});


    // Bordes para toda la hoja usada
    worksheet.eachRow({ includeEmpty: false }, function(row) {
        row.eachCell(function(cell) {
            if (!cell.border) {
                cell.border = cellBorder;
            }
        });
    });

    // Ajustar ancho columnas
    worksheet.columns.forEach((column, index) => {
    if (index === 0) {
        // Para la primera columna (índice 0), que es la del #
        column.width = 5; // ancho pequeño adecuado para números simples
    } else {
        let maxLength = 10;
        column.eachCell({ includeEmpty: true }, cell => {
            const length = cell.value ? cell.value.toString().length : 0;
            if (length > maxLength) maxLength = length;
        });
        column.width = maxLength > 30 ? 30 : maxLength + 2;
    }
});

    // Descargar archivo
    const buffer = await workbook.xlsx.writeBuffer();
    const blob = new Blob([buffer], { type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" });
    const link = document.createElement("a");
    link.href = URL.createObjectURL(blob);
    link.download = "caja_cerrada.xlsx";
    link.click();
}

function listar_caja_total(event) {
  event.preventDefault();

  var tipo_pago = $("#tipopago").val();
  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();
  var tipo_usuario = $("#tipo_usuario").val();

  if (!fecha_inicio || !fecha_fin || !tipo_pago || !tipo_usuario) {
    Swal.fire({
      title: "Tipo Ingreso requerido",
      text: "Por favor, seleccione los datos.",
      icon: "warning",
      confirmButtonText: "Aceptar"
    });
    return;
  }
        let resumen_apertura = {};
        let resumen_ingreso = {};
        let resumen_egreso = {};
      
         
        const resumen_ingreso_global = {}; 
        const resumen_egreso_global = {}; 
        const resumen_apertura_por_movimiento = {};
        const resumen_apertura_por_movimiento_p = {};

        let total_apertura_efectivo = 0;
        let total_apertura_deposito = 0;

        let total_ingreso_efectivo = 0;
        let total_ingreso_deposito = 0;

        let total_egreso_efectivo = 0;
        let total_egreso_deposito = 0;

  $.post(
    "../../ajax/finanzas.php?op=mostrar_finanzas_total",
    { tipo_pago: tipo_pago, fecha_inicio: fecha_inicio, fecha_fin: fecha_fin, tipo_usuario: tipo_usuario },
    function (data, status) {
      if (status === "success") {
        const response = JSON.parse(data);
        const movimientos = response.movimientos;
        const movimientos_apertura = response.movimientos_apertura;
        const ingresos = response.ingresos;
        const egresos = response.egresos;

        $("#contenedor_movimientos").empty(); 
        $("#contenedor_resumen").empty(); // Limpiar filas anteriores// Limpiar contenedor principal

        movimientos_apertura.forEach((movimiento_apertura, index) => {
          const usuario = movimiento_apertura.usuario;
          const correlativo = movimiento_apertura.nrocorrelativo;
          const fecha_apertura = movimiento_apertura.fecha_apertura;
          const fecha_cierre = movimiento_apertura.fecha_cierre;

          const monto_apertura = parseFloat(movimiento_apertura.monto_apertura) || 0;

          if (!resumen_apertura_por_movimiento_p[usuario]) {
              resumen_apertura_por_movimiento_p[usuario] = {};
            }

          if (!resumen_apertura_por_movimiento_p[usuario][fecha_apertura]) {
                resumen_apertura_por_movimiento_p[usuario][fecha_apertura] = {};
              }
            
            resumen_apertura_por_movimiento_p[usuario][fecha_apertura][correlativo] = monto_apertura;
            total_apertura_efectivo += monto_apertura;

        });
        movimientos.forEach((movimiento, index) => {
          let resumenPorMovimiento = {};
          let resumenPorEgresoMovimiento = {};
          const idmov = movimiento.idmovimientocaja;
          const usuario = movimiento.usuario;
          const correlativo = movimiento.nrocorrelativo;
          const fecha_apertura = movimiento.fecha_apertura;
          const fecha_cierre = movimiento.fecha_cierre;

          //const monto_apertura = parseFloat(movimiento.apertura_inicial) || 0;

          resumenPorMovimiento[usuario] = { efectivo: 0, deposito: 0 };
          resumenPorEgresoMovimiento[usuario] = { efectivo: 0, deposito: 0 };

           // if (!resumen_apertura_por_movimiento[usuario]) {
            //  resumen_apertura_por_movimiento[usuario] = {};
           // }
            
            // Guarda el monto apertura para este movimiento y usuario
            //resumen_apertura_por_movimiento[usuario][idmov] = monto_apertura;

            // Si quieres también acumular total global:
            //total_apertura_efectivo += monto_apertura;

          const ingresos_mov = ingresos.filter(ing => ing.idmovimiento == idmov);
          const egresos_mov = egresos.filter(egr => egr.idmovimiento == idmov);


          let total_ingreso = 0;
          let total_egreso = 0;

          let html = `
            <div class="mb-5 border p-3 rounded bg-white shadow-sm">
              <h4 class="mb-3">Caja Movimiento #${index + 1} - Correlativo: ${correlativo}</h4>
              <p><strong>Usuario:</strong> ${usuario} | <strong>Fecha Apertura:</strong> ${fecha_apertura} | <strong>Fecha Cierre:</strong> ${fecha_cierre}</p>

              <!-- INGRESOS -->
              <h5 class="mt-4">Ingresos</h5>
              <table class="table table-bordered">
                <thead class="thead-light">
                  <tr>
                    <th>#</th>
                    <th>Tipo Pago</th>
                    <th>Fecha Pago</th>
                    <th>Nombre/Razón Social</th>
                    <th>Servicio</th>
                    <th>Banco</th>
                    <th>Nro Operación</th>
                    <th>Nro Comprobante</th>
                    <th>Importe (S/)</th>
                  </tr>
                </thead>
                <tbody>`;
         
          ingresos_mov.forEach((ing, i) => {

            const responsable = ing.usuario;
            const tipo = ing.tipoingreso == 2 ? "Efectivo" : ing.tipoingreso == 3 ? "Transferencia" : "Otro";
            const banco = ing.banco ?? '';
            const nro_op = ing.nro_operacion ?? '';
            const monto = parseFloat(ing.monto) || 0;
            total_ingreso += monto;

              
              if (!resumen_ingreso[responsable]) resumen_ingreso[responsable] = { efectivo: 0, deposito: 0 };

              if (ing.tipoingreso == 2) {
                    resumen_ingreso[responsable].efectivo += monto;
                    total_ingreso_efectivo += monto;
                    resumenPorMovimiento[responsable].efectivo += monto;
                } else if (ing.tipoingreso == 3) {
                    resumen_ingreso[responsable].deposito += monto;
                    total_ingreso_deposito += monto;
                    resumenPorMovimiento[responsable].deposito += monto;
                }

            html += `
              <tr>
                <td>${i + 1}</td>
                <td>${tipo}</td>
                <td>${ing.fecha_pago}</td>
                <td>${ing.cliente}</td>
                <td>${ing.categoria_ingreso}</td>
                <td>${banco}</td>
                <td>${nro_op}</td>
                <td>${ing.correlativo_pago}</td>
                <td>${monto.toFixed(2)}</td>
              </tr>`;
          });

          Object.entries(resumenPorMovimiento).forEach(([responsable, montos]) => {
                    if (!resumen_ingreso_global[responsable]) resumen_ingreso_global[responsable] = {};

                    resumen_ingreso_global[responsable][idmov] = {
                      efectivo: montos.efectivo || 0,
                      deposito: montos.deposito || 0,
                      fecha_cierre: fecha_cierre,
                      correlativo : correlativo // ✅ se mantiene correctamente
                    };
                  });

          html += `
                </tbody>
                <tfoot>
                  <tr>
                    <td colspan="8" class="text-right font-weight-bold">Total Ingreso:</td>
                    <td class="font-weight-bold">S/ ${total_ingreso.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
                  </tr>
                </tfoot>
              </table>

              <!-- EGRESOS -->
              <h5 class="mt-4">Egresos</h5>
              <table class="table table-bordered">
                <thead class="thead-light">
                  <tr>
                    <th>#</th>
                    <th>Tipo Pago</th>
                    <th>Fecha Pago</th>
                    <th>Tipo Costo</th>
                    <th>Clasificador de Gasto</th>
                    <th>Detalle Gasto</th>
                    <th>Comprobante</th>
                    <th>Nro Comprobante</th>
                    <th>Importe (S/)</th>
                  </tr>
                </thead>
                <tbody>`;

          egresos_mov.forEach((egr, i) => {
            const responsable = egr.usuario;
            const tipo_costo_egreso = egr.idtipo;
            const tipo_comprobante_egreso = egr.tipo_comprobante;
            const tipo_pago = egr.tipopago == 2 ? "Efectivo" : egr.tipopago == 3 ? "Transferencia" : "Otro";
            const monto = parseFloat(egr.monto) || 0;
            total_egreso += monto;
            let tipo_costo = "";
            let comprobante = "";

            if (!resumen_egreso[responsable]) resumen_egreso[responsable] = { efectivo: 0, deposito: 0 };
            
            if (egr.tipopago == 2) {
                    resumen_egreso[responsable].efectivo += monto;
                    total_egreso_efectivo += monto;
                    resumenPorEgresoMovimiento[responsable].efectivo += monto;
                } else if (egr.tipopago == 3) {
                    resumen_egreso[responsable].deposito += monto;
                    total_egreso_deposito += monto;
                    resumenPorEgresoMovimiento[responsable].deposito += monto;
                }
              if (tipo_costo_egreso == 1) {
                  tipo_costo = "Fijo";
              } else if (tipo_costo_egreso == 2) {
                  tipo_costo = "Variable";
              }

                if (tipo_comprobante_egreso == 1) {
                  comprobante = "Recibo Egreso";
              } else if (tipo_comprobante_egreso == 2) {
                  comprobante = "Boleta";
              } else if (tipo_comprobante_egreso == 3) {
                  comprobante = "Factura";
              }
            html += `
              <tr>
                <td>${i + 1}</td>
                <td>${tipo_pago}</td>
                <td>${egr.fechapago}</td>
                <td>${tipo_costo}</td>
                <td>${egr.concepto}</td>
                <td>${egr.descripcion}</td>
                <td>${comprobante}</td>
                <td>${egr.nrorecibo}</td>
                <td>${monto.toFixed(2)}</td>
              </tr>`;
          });
          Object.entries(resumenPorEgresoMovimiento).forEach(([responsable, montos]) => {
              if (!resumen_egreso_global[responsable]) resumen_egreso_global[responsable] = {};

              resumen_egreso_global[responsable][idmov] = {
                efectivo: montos.efectivo || 0,
                deposito: montos.deposito || 0,
                fecha_cierre: fecha_cierre,
                correlativo : correlativo
              };
            });

          html += `
                </tbody>
                <tfoot>
                  <tr>
                    <td colspan="8" class="text-right font-weight-bold">Total Egreso:</td>
                    <td class="font-weight-bold">S/ ${total_egreso.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
                  </tr>
                </tfoot>
              </table>
            </div>
          `;

          $("#contenedor_movimientos").append(html);
        });
    // console.log("resumen_ingreso_global:", resumen_ingreso_global);
        // Generar HTML resumen
        let resumenHTML = `<div class="mb-5 border p-4 rounded bg-light">
        <h4>Resumen de Caja</h4>

        <h5 class="mt-4">Apertura Caja</h5>
        <table class="table table-striped table-bordered">
            <thead class="thead-light">
            <tr><th>Nombre Responsable</th><th>Monto Total</th></tr>
            </thead><tbody>`;

       for (const [usuario, fechas] of Object.entries(resumen_apertura_por_movimiento_p)) {
          for (const [fecha_apertura, correlativos] of Object.entries(fechas)) {
            for (const [correlativo, monto] of Object.entries(correlativos)) {
              const fecha = new Date(fecha_apertura);
              const anio = fecha.getFullYear();
              const mes = String(fecha.getMonth() + 1).padStart(2, '0'); // Mes 01-12
              resumenHTML += `<tr>
                <td>${usuario}-${anio}-${mes}-${correlativo}</td>
                <td>S/ ${monto.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
              </tr>`;
            }
          }
        }

        resumenHTML += `</tbody></table>

        <h5 class="mt-4">Ingreso Caja</h5>
        <table class="table table-striped table-bordered">
        <thead class="thead-light">
            <tr><th>Nombre Responsable</th><th>Monto Efectivo</th><th>Monto Depósito</th></tr>
        </thead><tbody>`;
        for (const [responsable, movimientosObj] of Object.entries(resumen_ingreso_global)) {
          for (const [idmov, data] of Object.entries(movimientosObj)) {
            const { efectivo, deposito, fecha_cierre, correlativo } = data;

             // Asegúrate de que sea una fecha válida
              const fecha = new Date(fecha_cierre);
              const anio = fecha.getFullYear();
              const mes = String(fecha.getMonth() + 1).padStart(2, '0'); // Mes 01-12

            resumenHTML += `
              <tr>
                <td>${responsable}-${anio}-${mes}-${correlativo}</td>
                <td>${efectivo.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
                <td>${deposito.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
              </tr>`;
          }
        }
        resumenHTML += `</tbody></table>

        <h5 class="mt-4">Egreso Caja</h5>
        <table class="table table-striped table-bordered">
        <thead class="thead-light">
            <tr><th>Nombre Responsable</th><th>Monto Efectivo</th><th>Monto Depósito</th></tr>
        </thead><tbody>`;

       for (const [responsable, movimientos] of Object.entries(resumen_egreso_global)) {
          for (const [idmov, datos] of Object.entries(movimientos)) {
            const { efectivo, deposito, fecha_cierre, correlativo } = datos;

            // Asegúrate de que sea una fecha válida
              const fecha = new Date(fecha_cierre);
              const anio = fecha.getFullYear();
              const mes = String(fecha.getMonth() + 1).padStart(2, '0'); // Mes 01-12
            resumenHTML += `<tr>
              <td>${responsable}-${anio}-${mes}-${correlativo}</td>
              <td>S/ ${efectivo.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
              <td>S/ ${deposito.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            </tr>`;
          }
        }

        resumenHTML += `</tbody></table>

        <h5>Saldo Total</h5>
        <table class="table table-striped table-bordered">
        <thead class="thead-light">
            <tr>
            <th>Tipo</th>
            <th>Monto Total Efectivo</th>
            <th>Monto Total Depósito</th>
            </tr>
        </thead>
        <tbody>
            <tr>
            <td>Saldo Inicial</td>
            <td>S/ ${total_apertura_efectivo.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            <td>S/ ${total_apertura_deposito.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            </tr>
            <tr>
            <td>Ingreso</td>
            <td>S/ ${total_ingreso_efectivo.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            <td>S/ ${total_ingreso_deposito.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            </tr>
            <tr>
            <td>Egreso</td>
            <td>S/ ${total_egreso_efectivo.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            <td>S/ ${total_egreso_deposito.toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            </tr>
            <tr class="font-weight-bold">
            <td>SALDO TOTAL</td>
            <td>S/ ${(total_apertura_efectivo + total_ingreso_efectivo - total_egreso_efectivo).toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            <td>S/ ${(total_apertura_deposito + total_ingreso_deposito - total_egreso_deposito).toLocaleString("es-PE", { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
            </tr>
        </tbody>
        </table>
        </div>`;

        // Agregar al final del contenedor
        $("#contenedor_resumen").append(resumenHTML);
      //generarExcelCaja(movimientos, ingresos, egresos);

      } else {
        console.error("Error en la solicitud AJAX.");
      }
    }
  );
}

async function generarPDF() {
  const { jsPDF } = window.jspdf;
  const doc = new jsPDF('p', 'mm', 'a4');
  let y = 10;

  doc.setFontSize(14);
  doc.text("Reporte Detallado de Caja", 105, y, { align: "center" });
  y += 10;

  // === 1. Detalles de movimientos (por caja) ===
  document.querySelectorAll("#contenedor_movimientos > div").forEach(section => {
    const clone = section.cloneNode(true);

    const h4 = clone.querySelector("h4");
    if (h4) {
      doc.setFontSize(12);
      doc.text(h4.textContent.trim(), 10, y);
      y += 7;
    }

    const p = clone.querySelector("p");
    if (p) {
      doc.setFontSize(10);
      doc.text(p.textContent.trim(), 10, y);
      y += 7;
    }

    clone.querySelectorAll("table").forEach(table => {
      doc.autoTable({
        html: table,
        startY: y,
        theme: 'grid',
        styles: { fontSize: 8 },
        headStyles: { fillColor: [220, 220, 220] }
      });
      y = doc.lastAutoTable.finalY + 10;

      if (y >= 270) {
        doc.addPage();
        y = 10;
      }
    });

    if (y >= 270) {
      doc.addPage();
      y = 10;
    }
  });

  // === 2. Agregar Resumen de Caja ===
   // === 2. Agregar Resumen de Caja ===
  const resumen = document.querySelector("#contenedor_resumen > div");
  if (resumen) {
    const clone = resumen.cloneNode(true);
    const h4 = clone.querySelector("h4");
    if (h4) {
      doc.setFontSize(12);
      doc.text(h4.textContent.trim(), 10, y);
      y += 7;
    }

    clone.querySelectorAll("h5").forEach((h5, index) => {
      const table = h5.nextElementSibling;
      if (table && table.tagName.toLowerCase() === 'table') {
        doc.setFontSize(11);
        doc.text(h5.textContent.trim(), 10, y);
        y += 5;

        doc.autoTable({
          html: table,
          startY: y,
          theme: 'grid',
          styles: { fontSize: 8 },
          headStyles: { fillColor: [220, 220, 220] }
        });

        y = doc.lastAutoTable.finalY + 10;

        if (y >= 270) {
          doc.addPage();
          y = 10;
        }
      }
    });
  }

  // === 3. Fecha y hora de impresión (hora peruana - UTC-5) ===
  const fechaHora = new Date();
  fechaHora.setHours(fechaHora.getHours() - 5);
  const fechaFormateada = fechaHora.toLocaleString('es-PE', {
    timeZone: 'America/Lima',
    hour12: false,
    year: 'numeric',
    month: '2-digit',
    day: '2-digit',
    hour: '2-digit',
    minute: '2-digit'
  });

  doc.setFontSize(10);
  doc.text(`Fecha de impresión: ${fechaFormateada}`, 10, 290);

  // === 4. Guardar el PDF ===
  doc.save("reporte_caja_total.pdf");
}


async function generarExcelCaja() {
  const workbook = new ExcelJS.Workbook();
  const worksheet = workbook.addWorksheet("Caja Total");

  let rowIndex = 1;

  document.querySelectorAll("#contenedor_movimientos > div").forEach(section => {
    const h4 = section.querySelector("h4")?.textContent.trim() || "";
    const p = section.querySelector("p")?.textContent.trim() || "";

    // Título del movimiento
    worksheet.mergeCells(`A${rowIndex}:I${rowIndex}`);
    worksheet.getCell(`A${rowIndex}`).value = h4;
    worksheet.getCell(`A${rowIndex}`).font = { bold: true, size: 13 };
    rowIndex++;

    worksheet.mergeCells(`A${rowIndex}:I${rowIndex}`);
    worksheet.getCell(`A${rowIndex}`).value = p;
    rowIndex += 2;

    section.querySelectorAll("table").forEach(table => {
      const headers = [];

      const thead = table.querySelector("thead");
      if (thead) {
        const headerCells = thead.querySelectorAll("th");

        // Asignar ancho personalizado a cada columna individualmente
        const columnWidths = [25, 15, 15, 40, 30, 30, 15, 15, 10];
        headerCells.forEach((_, index) => {
          worksheet.getColumn(index + 1).width = columnWidths[index] || 20;
        });

        const headerRow = worksheet.getRow(rowIndex);
        headerCells.forEach((th, index) => {
          const cell = headerRow.getCell(index + 1);
          cell.value = th.textContent.trim();
          cell.font = { bold: true, color: { argb: "FFFFFFFF" } };
          cell.fill = {
            type: "pattern",
            pattern: "solid",
            fgColor: { argb: "FF4472C4" }, // azul oscuro
          };
          cell.alignment = { vertical: "middle", horizontal: "center" };
        });

        rowIndex++;
        }

      // Cuerpo
      const tbody = table.querySelector("tbody");
      if (tbody) {
        tbody.querySelectorAll("tr").forEach(tr => {
          const row = worksheet.getRow(rowIndex);
          tr.querySelectorAll("td").forEach((td, index) => {
            let val = td.textContent.trim();
            if (!isNaN(val) && val !== '') val = parseFloat(val);
            row.getCell(index + 1).value = val;
          });
          rowIndex++;
        });
      }

      // Pie
      const tfoot = table.querySelector("tfoot");
      if (tfoot) {
        tfoot.querySelectorAll("tr").forEach(tr => {
          const row = worksheet.getRow(rowIndex);
          tr.querySelectorAll("td").forEach((td, index) => {
            row.getCell(index + 1).value = td.textContent.trim();
            row.getCell(index + 1).font = { bold: true };
          });
          rowIndex++;
        });
      }

      rowIndex += 2; // espacio
    });

    rowIndex += 2;
  });

  // === 2. Resumen de caja ===
  const resumen = document.querySelector("#contenedor_resumen > div");
  if (resumen) {
    const h4 = resumen.querySelector("h4")?.textContent.trim() || "";
    if (h4) {
      worksheet.mergeCells(`A${rowIndex}:I${rowIndex}`);
      worksheet.getCell(`A${rowIndex}`).value = h4;
      worksheet.getCell(`A${rowIndex}`).font = { bold: true, size: 13 };
      rowIndex += 2;
    }

    resumen.querySelectorAll("h5").forEach(h5 => {
      const titulo = h5.textContent.trim();
      const table = h5.nextElementSibling;

      if (table && table.tagName.toLowerCase() === 'table') {
        // Subtítulo
        worksheet.mergeCells(`A${rowIndex}:I${rowIndex}`);
        worksheet.getCell(`A${rowIndex}`).value = titulo;
        worksheet.getCell(`A${rowIndex}`).font = { bold: true, size: 12 };
        rowIndex++;

        // Encabezados
        const thead = table.querySelector("thead");
        if (thead) {
          const headerCells = thead.querySelectorAll("th");
          const columnWidths = [25, 15, 15, 40, 30, 30, 15, 15, 10];
          headerCells.forEach((_, index) => {
            worksheet.getColumn(index + 1).width = columnWidths[index] || 20;
          });

          const headerRow = worksheet.getRow(rowIndex);
          headerCells.forEach((th, index) => {
            const cell = headerRow.getCell(index + 1);
            cell.value = th.textContent.trim();
            cell.font = { bold: true, color: { argb: "FFFFFFFF" } };
            cell.fill = {
              type: "pattern",
              pattern: "solid",
              fgColor: { argb: "FF7030A0" }, // violeta oscuro
            };
            cell.alignment = { vertical: "middle", horizontal: "center" };
          });

          rowIndex++;
        }

        // Cuerpo
        const tbody = table.querySelector("tbody");
        if (tbody) {
          tbody.querySelectorAll("tr").forEach(tr => {
            const row = worksheet.getRow(rowIndex);
            tr.querySelectorAll("td").forEach((td, index) => {
              let val = td.textContent.trim();
              if (!isNaN(val) && val !== '') val = parseFloat(val);
              row.getCell(index + 1).value = val;
            });
            rowIndex++;
          });
        }

        // Pie de tabla
        const tfoot = table.querySelector("tfoot");
        if (tfoot) {
          tfoot.querySelectorAll("tr").forEach(tr => {
            const row = worksheet.getRow(rowIndex);
            tr.querySelectorAll("td").forEach((td, index) => {
              row.getCell(index + 1).value = td.textContent.trim();
              row.getCell(index + 1).font = { bold: true };
            });
            rowIndex++;
          });
        }

        rowIndex += 2;
      }
    });
  }

  // === 3. Exportar archivo ===
  const buffer = await workbook.xlsx.writeBuffer();
  const blob = new Blob([buffer], {
    type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
  });
  const link = document.createElement("a");
  link.href = URL.createObjectURL(blob);
  link.download = `caja_total_${new Date().toISOString().slice(0, 10)}.xlsx`;
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}





init()