var tabla;
function init(){
    
}

function generarExcel_Finanza() {
    // Obtener valores de las fechas
    var anio = $("#anio").val();
    var mes = $("#mes").val();
    // Validar que las fechas no estén vacías
    if (!anio || !mes) {
        Swal.fire({
            icon: 'error',
            title: 'Valor inválido',
            text: `Por favor ingrese el año y el mes.`,
            confirmButtonText: 'Aceptar',
            timer: 3000
        });
        return;
      }
    // Construir la URL con los parámetros
    var url = '../reporte/excel_finanza.php?anio=' + encodeURIComponent(anio) + '&mes=' + encodeURIComponent(mes);
  // Crear un formulario temporal para abrir la URL en una nueva pestaña
  // Abrir la URL en una nueva pestaña
  window.open(url, '_blank');
  }

var cont = 0;

function mostrar_finanza(event) {
  event.preventDefault();

  var anio = $("#anio").val();
  var mes = $("#mes").val();
  // Validar que las fechas no estén vacías
  if (!anio || !mes) {
    Swal.fire({
        icon: 'error',
        title: 'Valor inválido',
        text: `Por favor ingrese el año y el mes.`,
        confirmButtonText: 'Aceptar',
        timer: 3000
    });
    return;
  }
  if (anio) {
    $.post(
      "../../ajax/consulta.php?op=mostrar_finanza",
      { anio: anio, mes: mes },
      function (data, status) {
        if (status === "success") {
            const response = JSON.parse(data);
    
            if (response.cabeceras_ingreso && response.cabeceras_ingreso.length > 0) {
                if ($.fn.DataTable.isDataTable("#ingreso")) {
                    $("#ingreso").DataTable().clear().destroy();
                }
    
                $("#ingreso tbody").empty(); // Limpiar filas anteriores
    
                var totalGeneral = 0; // Inicializamos la variable
    
                for (var i = 0; i < response.cabeceras_ingreso.length; i++) {
                    const cabecera_i = response.cabeceras_ingreso[i];
    
                    let categoria = cabecera_i.categoria ? cabecera_i.categoria : " ";
                    let monto_cabecera = (cabecera_i.total_monto && !isNaN(cabecera_i.total_monto)) ? parseFloat(cabecera_i.total_monto).toFixed(2) : '0.00';
    
                    totalGeneral += parseFloat(monto_cabecera); // Sumamos al total general
    
                    let grupo = "";
                    let cat = "CAT";
                    let categoriaID = "categoriai" + i; // ID único para identificar los detalles
    
                    // Fila principal de la categoría con icono de colapsar/expandir
                    let filaGrupo = `
                        <tr class="filas" id="fila${i}">
                            <td style="background-color:#9ee39a; font-weight: bold; cursor:pointer;" onclick="toggleDetalles('${categoriaID}')">
                                <span id="icon${i}">🔽</span> ${cat}
                            </td>
                            <td style="background-color:#9ee39a; font-weight: bold;">${categoria}</td>
                            <td style="background-color:#9ee39a; font-weight: bold;">S/ ${monto_cabecera}</td>
                        </tr> `;
    
                    grupo += filaGrupo;
                    // Filtramos los detalles para este idcategoria_ingreso
                    const detallesCabecera = response.detalles_ingreso[cabecera_i.idcategoria_ingreso];
                    // Verificamos si hay detalles para esta categoría
                    if (detallesCabecera && detallesCabecera.length > 0) {
                        for (var j = 0; j < detallesCabecera.length; j++) {
                            const detalle = detallesCabecera[j];
                            let monto = (detalle.monto && !isNaN(detalle.monto)) ? parseFloat(detalle.monto).toFixed(2) : '0.00';
    
                            let filaDetalle = `
                                <tr class="filas detalles ${categoriaID}" style="display: none;">
                                    <td></td>
                                    <td>${detalle.tipo_trabajo}</td>
                                    <td>S/ ${monto}</td>
                                </tr>
                            `;
                            grupo += filaDetalle;
                        }
                    }
                    // Agregar todo el grupo (cabecera + detalles) de una sola vez
                    $("#ingreso tbody").append(grupo);
                }
                // Agregar fila final con el total general
                let filaTotal = `
                    <tr class="filas" id="totalFinal">
                        <td colspan="2" style="background-color:#f39c12; font-weight: bold; text-align:right;">TOTAL GENERAL INGRESOS:</td>
                        <td style="background-color:#f39c12; font-weight: bold;">S/ ${totalGeneral.toFixed(2)}</td>
                    </tr>
                `;
                $("#ingreso tbody").append(filaTotal);

            }if(response.cabeceras_egreso && response.cabeceras_egreso.length > 0){
                if ($.fn.DataTable.isDataTable("#egreso")) {
                    $("#egreso").DataTable().clear().destroy();
                }
    
                $("#egreso tbody").empty(); // Limpiar filas anteriores
    
                var totalGenerale = 0; // Inicializamos la variable
                for (var e = 0; e < response.cabeceras_egreso.length; e++) {
                    const cabecera_e = response.cabeceras_egreso[e];
    
                    let categoriae = cabecera_e.categoria ? cabecera_e.categoria : " ";
                    let monto_cabecerae = (cabecera_e.total_monto && !isNaN(cabecera_e.total_monto)) ? parseFloat(cabecera_e.total_monto).toFixed(2) : '0.00';
    
                    totalGenerale += parseFloat(monto_cabecerae); // Sumamos al total general
    
                    let grupoe = "";
                    let cate = "CAT";
                    let categoriaIDe = "categoriae" + e; // ID único para identificar los detalles
    
                    // Fila principal de la categoría con icono de colapsar/expandir
                    let filaGrupoe = `
                        <tr class="filas" id="fila${e}">
                            <td style="background-color:#9ee39a; font-weight: bold; cursor:pointer;" onclick="toggleDetalles('${categoriaIDe}')">
                                <span id="icon${e}">🔽</span> ${cate}
                            </td>
                            <td style="background-color:#9ee39a; font-weight: bold;">${categoriae}</td>
                            <td style="background-color:#9ee39a; font-weight: bold;">S/ ${monto_cabecerae}</td>
                        </tr> `;
    
                    grupoe += filaGrupoe;
                    // Filtramos los detalles para este idcategoria_ingreso
                    const detallesCabecerae = response.detalles_egreso[cabecera_e.idcategoria_egreso];
                    // Verificamos si hay detalles para esta categoría
                    if (detallesCabecerae && detallesCabecerae.length > 0) {
                        for (var j = 0; j < detallesCabecerae.length; j++) {
                            const detallee = detallesCabecerae[j];
                            let montoe = (detallee.monto && !isNaN(detallee.monto)) ? parseFloat(detallee.monto).toFixed(2) : '0.00';
    
                            let filaDetallee = `
                                <tr class="filas detalles ${categoriaIDe}" style="display: none;">
                                    <td></td>
                                    <td>${detallee.concepto}</td>
                                    <td>S/ ${montoe}</td>
                                </tr>
                            `;
                            grupoe += filaDetallee;
                        }
                    }
                    // Agregar todo el grupo (cabecera + detalles) de una sola vez
                    $("#egreso tbody").append(grupoe);
                }

                
                let filaTotale = `
                    <tr class="filas" id="totalFinal">
                        <td colspan="2" style="background-color:#f39c12; font-weight: bold; text-align:right;">TOTAL GENERAL EGRESOS:</td>
                        <td style="background-color:#f39c12; font-weight: bold;">S/ ${totalGenerale.toFixed(2)}</td>
                    </tr>
                `;
                $("#egreso tbody").append(filaTotale);


                if ($.fn.DataTable.isDataTable("#resumen")) {
                    $("#resumen").DataTable().clear().destroy();
                }
    
                $("#resumen tbody").empty();

                let grupo_resumen = "";
                let filaGrupo_resumen = `
                        <tr class="filas" id="fila">
                            <td style="font-weight: bold; cursor:pointer;" > </td>
                            <td style="font-weight: bold;text-align:right;">TOTAL GENERAL INGRESOS</td>
                            <td style="font-weight: bold;text-align:right;">S/${totalGeneral.toFixed(2)}</td>
                        </tr> 
                        <tr class="filas" id="fila">
                            <td style="font-weight: bold; cursor:pointer;" > </td>
                            <td style="font-weight: bold;text-align:right;">TOTAL GENERAL EGRESOS</td>
                            <td style="font-weight: bold;text-align:right;">S/${totalGenerale.toFixed(2)}</td>
                        </tr> 
                        <tr class="filas" id="fila">
                            <td style="font-weight: bold; cursor:pointer;" > </td>
                            <td style="font-weight: bold;text-align:right;">UTILIDADES</td>
                            <td style="font-weight: bold;text-align:right;">S/${(totalGeneral - totalGenerale).toFixed(2)}</td>
                        </tr> 
                        `;
    
                    grupo_resumen += filaGrupo_resumen;
                    $("#resumen tbody").append(grupo_resumen);


            }else {
                console.error("No se encontraron datos para 'cabeceras'.");
            }
        } else {
            console.error("Error en la solicitud AJAX.");
        }
    }
    
    );
 }
}
// Función para colapsar/expandir los detalles de una categoría
function toggleDetalles(categoriaID) {
  $("." + categoriaID).toggle(); // Muestra u oculta los detalles
  let icono = $("td[onclick*='" + categoriaID + "'] span"); // Seleccionamos el icono
  if ($("." + categoriaID).is(":visible")) {
      icono.text("🔼"); // Icono hacia arriba si está expandido
  } else {
      icono.text("🔽"); // Icono hacia abajo si está colapsado
  }
}  



init();