var tabla;
function init(){
    listar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $("#ticketForm").on("submit", function(e) {
      guardarproceso(e);
  });

  $("#retornoForm").on("submit", function(e) {
    guardarretorno(e);
  });


}

$(document).ready(function () {
  // Capturar número MAC desde la URL
  const params = new URLSearchParams(window.location.search);
  const codigoDesdeURL = params.get("numero_mac");

  if (codigoDesdeURL) {
      // Si hay un código en la URL, ejecutar automáticamente listar_garantia()
      $("#numero_mac").val(codigoDesdeURL); // Rellenar el input con el valor de la URL
      listar_garantia(); // Ejecutar la función automáticamente
  }
  
});

function mostrar_proceso(idgarantia) {
  // Asigna el valor de idaveria al input oculto en el modal
  $('#idgarantia').val(idgarantia);
  $('#idgarantiaa').val(idgarantia);
  //console.log(idaveria);
}
//Función limpiar
function limpiar()
{
	$("#idusuario").val("");
	$("#idgarantia").val("");
    $("#descripcion").val("");
}
// Función para listar datos
function listar() {
    tabla=$("#garantia").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/garantia.php?op=listar',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}
function listar_garantia() {

    let codigo_producto = $("#numero_mac").val().trim();
    console.log("Código ingresado:", codigo_producto); // Verifica si se está capturando el código

    if (codigo_producto) {
        // Llamar a la función mostrar del backend
        $.post("../../ajax/garantia.php?op=listar_garantia", { codigo_producto: codigo_producto }, function (data, status) {
            //console.log(data); // Verifica qué datos devuelve el servidor
            const response = JSON.parse(data);
            if (response.inventarios && response.inventarios.length > 0) {
                const garantia= response.inventarios[0]; 
                $("#idinventario_ingreso").val(garantia.idinventario_ingreso);
                $("#nro_factura").val(garantia.nrofactura);
                $("#nombre_proveedor").val(garantia.proveedor);
                $("#nombre_producto").val(garantia.producto);
                $("#nombre_almacen").val(garantia.almacen);
                $("#garantia_producto").val(garantia.garantia);
                $("#mac_producto").val(garantia.mac);
                $("#codigo_producto").val(garantia.codigo);
                $("#marca_producto").val(garantia.descripcion);
                $("#fecha_compra").val(garantia.fechaingreso);

                 // Lógica para verificar la garantía
                 verificarGarantia(garantia.fechaingreso, garantia.garantia);

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Codigo inválido',
                    text: `El codigo no se encuentra registrado BD(${codigo_producto}).`,
                    confirmButtonText: 'Aceptar',
                    timer: 3000
                });
                $("#numero_mac").val('');
            }
        });
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Codigo vacio',
            text: `Debes ingresar un codigo de producto.`,
            confirmButtonText: 'Aceptar',
            timer: 3000
        });
    }
}



function guardarproceso(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnProceso").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#ticketForm")[0]);

  // Configuración de alerta de confirmación
  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Mostrar alerta de carga con spinner
      

      // Realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/garantia.php?op=guardarproceso",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Solo cerrar la alerta de carga una vez que la solicitud haya terminado
        
        if (datos.includes("Proceso Garantia Registrado") || datos.includes("Proceso Garantia Actualizar")) {
          let timerInterval;
          Swal.fire({
            title: "Guardando...",
            html: "Por favor, espera mientras se procesan los datos.",
            timer: 5000, // 10 segundos de espera
            timerProgressBar: true,
            allowOutsideClick: false, // Desactiva interacciones externas
            backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
            didOpen: () => {
              Swal.showLoading(); // Mostrar spinner de carga
            },
            willClose: () => {
              clearInterval(timerInterval); // Limpiar interval cuando la alerta se cierre
              $(location).attr("href", "../garantia/list.php");
            }
          });
        }else{
          let timerInterval;
          Swal.fire({
              position: 'center',
              title: "Error",
              html: "Datos no pudieron ser procesadas.<br>Cerrando en <b></b> ms.",
              icon: "error",
              timer: 2000,
              timerProgressBar: true,
              allowOutsideClick: false, // Desactiva interacciones externas
              backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
              customClass: {
                  popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
              },
              didOpen: () => {
                  Swal.showLoading();
                  const timer = Swal.getPopup().querySelector("b");
                  timerInterval = setInterval(() => {
                      timer.textContent = `${Swal.getTimerLeft()}`;
                  }, 100);
              },
              willClose: () => {
                $(location).attr("href", "../garantia/list.php");
              }
          });
        }
        },
        error: function () {
          // Manejar errores en la solicitud AJAX
          Swal.close();
          swalWithBootstrapButtons.fire({
            title: "Error",
            text: "Hubo un problema con la solicitud. Intente nuevamente.",
            icon: "error",
            confirmButtonText: "Aceptar"
          }).then(() => {
            $("#btnProceso").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnProceso").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  });
}

function guardarretorno(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnRetorno").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#retornoForm")[0]);

  // Configuración de alerta de confirmación
  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Mostrar alerta de carga con spinner
      // Realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/garantia.php?op=guardarretorno",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Solo cerrar la alerta de carga una vez que la solicitud haya terminado
        
        if (datos.includes("Retorno Garantia Registrado") || datos.includes("Retorno Garantia Actualizar")) {
          let timerInterval;
          Swal.fire({
            title: "Guardando...",
            html: "Por favor, espera mientras se procesan los datos.",
            timer: 5000, // 10 segundos de espera
            timerProgressBar: true,
            allowOutsideClick: false, // Desactiva interacciones externas
            backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
            didOpen: () => {
              Swal.showLoading(); // Mostrar spinner de carga
            },
            willClose: () => {
              clearInterval(timerInterval); // Limpiar interval cuando la alerta se cierre
              $(location).attr("href", "../garantia/list.php");
            }
          });
        }else{
          let timerInterval;
          Swal.fire({
              position: 'center',
              title: "Error",
              html: "Datos no pudieron ser procesadas.<br>Cerrando en <b></b> ms.",
              icon: "error",
              timer: 2000,
              timerProgressBar: true,
              allowOutsideClick: false, // Desactiva interacciones externas
              backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
              customClass: {
                  popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
              },
              didOpen: () => {
                  Swal.showLoading();
                  const timer = Swal.getPopup().querySelector("b");
                  timerInterval = setInterval(() => {
                      timer.textContent = `${Swal.getTimerLeft()}`;
                  }, 100);
              },
              willClose: () => {
                $(location).attr("href", "../garantia/list.php");
              }
          });
        }
        },
        error: function () {
          // Manejar errores en la solicitud AJAX
          Swal.close();
          swalWithBootstrapButtons.fire({
            title: "Error",
            text: "Hubo un problema con la solicitud. Intente nuevamente.",
            icon: "error",
            confirmButtonText: "Aceptar"
          }).then(() => {
            $("#btnRetorno").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnRetorno").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  });
}

// Función para verificar si el producto está en garantía
function verificarGarantia(fechaIngreso, mesesGarantia) {
    if (!fechaIngreso || !mesesGarantia) {
        console.error("Faltan datos para verificar la garantía");
        return;
    }

    const fechaCompra = new Date(fechaIngreso); // Convertir a objeto Date
    const fechaActual = new Date(); // Obtener la fecha actual

    // Sumar los meses de garantía a la fecha de compra
    fechaCompra.setMonth(fechaCompra.getMonth() + parseInt(mesesGarantia));

    // Comparar la fecha actual con la fecha de vencimiento de la garantía
    if (fechaActual <= fechaCompra) {
        $("#condicion_texto").text("Apto para garantia").css({ "background-color": "green", "color": "white", "padding": "5px", "border-radius": "3px" });
        $("#condicion").val("Apto para garantia"); // Se guarda el valor en el input oculto
    } else {
        $("#condicion_texto").text("No apto para garantia").css({ "background-color": "red", "color": "white", "padding": "5px", "border-radius": "3px" });
        $("#condicion").val("No apto para garantia");
    }

    //console.log(`Fecha de compra: ${fechaIngreso}, Garantía: ${mesesGarantia} meses, Vencimiento: ${fechaCompra.toISOString().split('T')[0]}`);
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/garantia.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Garantia Registrado") || datos.includes("Garantia Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Garantia Registrado") || datos.includes("Garantia Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
}

function eliminar(idgarantia) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/garantia.php?op=eliminar", { idgarantia: idgarantia }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "La garantia ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "La garantia está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
    // Obtener el parámetro idcaja de la URL
    const urlParams = new URLSearchParams(window.location.search);
    const idgarantia = urlParams.get('idgarantia');
  
    if (idgarantia) {
        // Llamar a la función mostrar del backend
        $.post("../../ajax/garantia.php?op=mostrar", { idgarantia: idgarantia }, function (data, status) {
            if (status === "success") {
                const inventario = JSON.parse(data);
                const condicion = inventario.condicion;
                $("#idgarantia").val(inventario.idgarantia);
                $("#idinventario_ingreso").val(inventario.idinventario_ingreso);
                $("#nro_factura").val(inventario.nrofactura);
                $("#nombre_proveedor").val(inventario.proveedor);
                $("#nombre_producto").val(inventario.producto);
                $("#nombre_almacen").val(inventario.almacen);
                $("#garantia_producto").val(inventario.garantia);
                $("#mac_producto").val(inventario.mac);
                $("#codigo_producto").val(inventario.codigo);
                $("#marca_producto").val(inventario.descripcion);
                $("#fecha_compra").val(inventario.fechaingreso);
                $("#descripcion_garantia").val(inventario.descripcion_garantia);
                $("#nombre_envio").val(inventario.nombre_ticket);
                $("#fecha_retorno").val(inventario.fecharetorno);
                 // Verificar si hay imagen, si no, mostrar una imagen predeterminada
                let imagenTicket = inventario.imagenTicket ? `../../files/garantia/${inventario.imagenTicket}` : "../../files/averia/no_disponible.jpg";
                let imagenConstancia = inventario.imagenConstancia ? `../../files/garantia/${inventario.imagenConstancia}` : "../../files/averia/no_disponible.jpg";
                $("#imagenTicket").attr("src", imagenTicket);
                $("#imagenConstancia").attr("src", imagenConstancia);
                $("#fecha_envio").text(inventario.fechaenvio).css({ "background-color": "red", "color": "white", "padding": "5px", "border-radius": "3px" });
                const condicionTexto = $("#condicion_texto");
                if (condicion === "Apto para garantia") {
                  condicionTexto.text(condicion).css({ "background-color": "green", "color": "white", "padding": "5px", "border-radius": "3px" });
                }else{
                  condicionTexto.text(condicion).css({ "background-color": "red", "color": "white", "padding": "5px", "border-radius": "3px" });
                }
               // $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
                $("#idtitle").html('<i class="fas fa-plus"></i> Vista Garantia')
  
            } else {
                console.error("Error al cargar los datos");
            }
        });
    }
  });

init();