var tabla;
function init(){
    listar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

     $("#imagenmuestra").hide();

    
}
//Función limpiar
function limpiar()
{
    $("#idicono").val("");
  	$("#nombre").val("");
    $("#descripcion").val("");
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/icono.php?op=listaricono',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}
// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnGuardar").prop("disabled", true);

    let nombre = $("#nombre").val();

    if (!nombre ) {
        Swal.fire("Error", "Ingresa los datos requeridos", "error");
        $("#btnGuardar").prop("disabled", false);
        return;
    }
    var formData = new FormData($("#frmForm")[0]);
    
    Swal.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas guardar los cambios realizados?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, guardar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "../../ajax/icono.php?op=guardaryeditar",
                type: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    try {
                        let datos = JSON.parse(response);
                        if (datos.status === "success") {
                            Swal.fire({
                                title: "Guardando...",
                                html: "Por favor, espera mientras se procesan los datos.",
                                timer: 5000,
                                timerProgressBar: true,
                                allowOutsideClick: false,
                                backdrop: false,
                                didOpen: () => Swal.showLoading(),
                                willClose: () => $(location).attr("href", "list.php")
                            });
                        } else {
                            Swal.fire("Error", datos.message, "error");
                            $("#btnGuardar").prop("disabled", false);
                        }
                    } catch (error) {
                        Swal.fire("Error", "Hubo un problema con la respuesta del servidor.", "error");
                        $("#btnGuardar").prop("disabled", false);
                    }
                },
                error: function () {
                    Swal.fire("Error", "Hubo un problema con la solicitud. Intente nuevamente.", "error");
                    $("#btnGuardar").prop("disabled", false);
                }
            });
        } else {
            Swal.fire("Cancelado", "No se realizaron cambios.", "error");
            $("#btnGuardar").prop("disabled", false);
        }
    });
}

function eliminar(idicono) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡No podrás revertir esto!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/icono.php?op=eliminar", { idicono: idicono }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El icono ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "El icono está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idicono de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idicono = urlParams.get('idicono');

  if (idicono) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/icono.php?op=mostrar", { idicono: idicono }, function (data, status) {
          if (status === "success") {
              const icono = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idicono").val(icono.idicono);
              $("#nombre").val(icono.nombre);
              $("#descripcion").val(icono.descripcion);
              $("#imagenmuestra").show();
              $("#imagenmuestra").attr("src","../../files/icono/"+icono.imagen);
              $("#imagenactual").val(icono.imagen);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar icono')

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});

init();