var tabla;
function init(){
    listar_incidencia();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

   
}


// Función para listar datos
function listar_incidencia() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/consulta.php?op=listar_incidencia',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
  }

  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });
    function actualizar_incidencia(idincidencia) {
      // Configuración de alerta de confirmación
      swalWithBootstrapButtons.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas guardar los cambios realizados?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, guardar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
      }).then((result) => {
        if (result.isConfirmed) {
          let formData = new FormData();
          formData.append("idincidencia", idincidencia);  // Agregar idverificar al FormData
          // Realizar la solicitud AJAX
          $.ajax({
            url: "../../ajax/consulta.php?op=actualizar_incidencia&idincidencia=" + encodeURIComponent(idincidencia), // Pasar idverificar en la URL
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function (datos) {
              // Solo cerrar la alerta de carga una vez que la solicitud haya terminado
            
            if (datos.includes("Incidencia Cerrada")) {
              let timerInterval;
              Swal.fire({
                title: "Guardando...",
                html: "Por favor, espera mientras se procesan los datos.",
                timer: 5000, // 10 segundos de espera
                timerProgressBar: true,
                allowOutsideClick: false, // Desactiva interacciones externas
                backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                didOpen: () => {
                  Swal.showLoading(); // Mostrar spinner de carga
                },
                willClose: () => {
                  clearInterval(timerInterval); // Limpiar interval cuando la alerta se cierre
                  $(location).attr("href", "list.php");
                }
              });
            }else if (datos.includes("No puedes cerrar la Incidencia")) {
              swalWithBootstrapButtons.fire({
                title: "Advertencia",
                text: datos,
                icon: "warning",
                confirmButtonText: "Aceptar"
              });
            }else{
              let timerInterval;
              Swal.fire({
                  position: 'center',
                  title: "Error",
                  html: "Datos no pudieron ser Procesados.<br>Cerrando en <b></b> ms.",
                  icon: "error",
                  timer: 2000,
                  timerProgressBar: true,
                  allowOutsideClick: false, // Desactiva interacciones externas
                  backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                  customClass: {
                      popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
                  },
                  didOpen: () => {
                      Swal.showLoading();
                      const timer = Swal.getPopup().querySelector("b");
                      timerInterval = setInterval(() => {
                          timer.textContent = `${Swal.getTimerLeft()}`;
                      }, 100);
                  },
                  willClose: () => {
                    $(location).attr("href", "list.php");
                  }
              });
            }
            },
            error: function () {
              // Manejar errores en la solicitud AJAX
              Swal.close();
              swalWithBootstrapButtons.fire({
                title: "Error",
                text: "Hubo un problema con la solicitud. Intente nuevamente.",
                icon: "error",
                confirmButtonText: "Aceptar"
              }).then(() => {
               // $("#btnImagen").prop("disabled", false); // Rehabilitar el botón tras un error
              });
            }
          });
        } else if (result.dismiss === Swal.DismissReason.cancel) {
          // Si el usuario cancela, mostrar un mensaje de cancelación
          swalWithBootstrapButtons.fire({
            title: "Cancelado",
            text: "No se realizaron cambios.",
            icon: "error",
            confirmButtonText: "Aceptar"
          }).then(() => {
           // $("#btnImagen").prop("disabled", false); // Rehabilitar el botón si se cancela
          });
        }
      });
    }
    
     function actualizar_direccion(iddireccion,direccion,referencia,latitud,longitud) {
      // Configuración de alerta de confirmación
      swalWithBootstrapButtons.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas actualizar la direccion?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, guardar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
      }).then((result) => {
        if (result.isConfirmed) {
          let formData = new FormData();
          formData.append("iddireccion", iddireccion);
          formData.append("direccion", direccion);
          formData.append("referencia", referencia);
          formData.append("latitud", latitud);
          formData.append("longitud", longitud);
          // Realizar la solicitud AJAX
          $.ajax({
            url: "../../ajax/consulta.php?op=actualizar_direccion",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            success: function (datos) {
              // Solo cerrar la alerta de carga una vez que la solicitud haya terminado
            
            if (datos.includes("Direccion Actualizada")) {
              let timerInterval;
              Swal.fire({
                title: "Guardando...",
                html: "Por favor, espera mientras se procesan los datos.",
                timer: 5000, // 10 segundos de espera
                timerProgressBar: true,
                allowOutsideClick: false, // Desactiva interacciones externas
                backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                didOpen: () => {
                  Swal.showLoading(); // Mostrar spinner de carga
                },
                willClose: () => {
                  clearInterval(timerInterval); // Limpiar interval cuando la alerta se cierre
                  $(location).attr("href", "list.php");
                }
              });
            }else if (datos.includes("No se pudo actualizar la direccion")) {
              swalWithBootstrapButtons.fire({
                title: "Advertencia",
                text: datos,
                icon: "warning",
                confirmButtonText: "Aceptar"
              });
            }else{
              let timerInterval;
              Swal.fire({
                  position: 'center',
                  title: "Error",
                  html: "Datos no pudieron ser Procesados.<br>Cerrando en <b></b> ms.",
                  icon: "error",
                  timer: 50000,
                  timerProgressBar: true,
                  allowOutsideClick: false, // Desactiva interacciones externas
                  backdrop: false, // Elimina el fondo para evitar el cambio en la altura de la página
                  customClass: {
                      popup: 'no-margin-swal', // Clase personalizada para ajustar márgenes
                  },
                  didOpen: () => {
                      Swal.showLoading();
                      const timer = Swal.getPopup().querySelector("b");
                      timerInterval = setInterval(() => {
                          timer.textContent = `${Swal.getTimerLeft()}`;
                      }, 100);
                  },
                  willClose: () => {
                    $(location).attr("href", "list.php");
                  }
              });
            }
            },
            error: function () {
              // Manejar errores en la solicitud AJAX
              Swal.close();
              swalWithBootstrapButtons.fire({
                title: "Error",
                text: "Hubo un problema con la solicitud. Intente nuevamente.",
                icon: "error",
                confirmButtonText: "Aceptar"
              }).then(() => {
               // $("#btnImagen").prop("disabled", false); // Rehabilitar el botón tras un error
              });
            }
          });
        } else if (result.dismiss === Swal.DismissReason.cancel) {
          // Si el usuario cancela, mostrar un mensaje de cancelación
          swalWithBootstrapButtons.fire({
            title: "Cancelado",
            text: "No se realizaron cambios.",
            icon: "error",
            confirmButtonText: "Aceptar"
          }).then(() => {
           // $("#btnImagen").prop("disabled", false); // Rehabilitar el botón si se cancela
          });
        }
      });
    }




init();