var tabla;
function init(){
    listar();
    evaluar();
    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $("#listadoCantidad").hide();

    $.post("../../ajax/cliente.php?op=selectProveedor", function(r){
      if ($.fn.select2 && $('#idproveedor').data('select2')) {
        $('#idproveedor').select2('destroy');
      }
    
      $("#idproveedor").html('<option value="">Seleccione Proveedor</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idproveedor").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idproveedor').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un Proveedor',
        allowClear: true,
      });
    });
           
}


//Función limpiar
function limpiar()
{
    $("#idproveedor").val("");
    $("#idingreso").val("");
    $("#serie_comprobante").val("");
    $("#num_comprobante").val("");
    $("#fecha_hora").val("");
    $("#total_compra").val("");
	  $(".filas").remove();
	  $("#total").html("0");

    var now= new Date();
	  var day = ("0" + now.getDate()).slice(-2);
	  var month = ("0"+(now.getMonth()+1)).slice(-2);
	  var today= now.getFullYear()+"-"+(month)+"-"+(day);
	  $('#fecha_hora').val(today);
}
// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/ingreso.php?op=listaringreso',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true,
          "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
    });
}

function listarArticulos() {
    tabla=$("#modalproducto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/ingreso.php?op=listarArticulos',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

$('#myModalIngreso').on('shown.bs.modal', function () {
  listarArticulos();

});

function mostrardetalle(idingreso){   
  //var idingreso = idingreso;  
  //console.log(idingreso);
  $.ajax({  
       url:"../../ajax/inventario.php?op=mostrardetalle&id=" + idingreso,  
       method:"POST",  
       data:{idingreso:idingreso},  
       dataType:"json",  
       success:function(response){  
         console.log(response);                 
    
       var cont=0;                  
        var html="<table class='table table-striped table-bordered table-condensed table-hover'>";
        html+="<thead>";
        html+="<tr style='background-color:#4564ff'>";
        html+="<th style='background-color:#4564ff; color: white;'>Articulo</th>";
        html+="<th style='background-color:#4564ff; color: white;'>Cantidad</th>";
        html+="<th style='background-color:#4564ff; color: white;'>Precio Compra</th>";
        html+="<th style='background-color:#4564ff; color: white;'>Precio Venta</th>";
        html+="<th style='background-color:#4564ff; color: white;'>SubTotal</th> </tr></thead>";

        html += "<tbody>";
          for (var i = 0; i < response.ingresos.length; i++) {
              html += '<tr>' +
                  '<td>' + response.ingresos[i].nombre + '</td>' +
                  '<td>' + response.ingresos[i].cantidad + '</td>' +
                  '<td>' + response.ingresos[i].precio_compra + '</td>' +
                  '<td>' + response.ingresos[i].precio_venta + '</td>' +
                  '<td>' + (response.ingresos[i].cantidad * response.ingresos[i].precio_compra).toFixed(2) + '</td>' +
                  '</tr>';
          }
          html += "</tbody>";
          html += "</table>";
          document.getElementById("tblarticulos").innerHTML = html;             
       
// Construir la tabla de detalles
          var htmll = "<table class='table table-striped table-bordered table-condensed table-hover'>";
          htmll += "<thead>";
          htmll += "<tr style='background-color:#050505'>";
          htmll += "<th style='background-color:#050505; color: white;'>Fecha Registro</th>";
          htmll += "<th style='background-color:#050505; color: white;'>Cod Mad</th>";
          htmll += "<th style='background-color:#050505; color: white;'>Cod Producto</th>";
          htmll += "<th style='background-color:#050505; color: white;'>Cod Num</th>";
          htmll += "<th style='background-color:#050505; color: white;'>Mac</th>";
          htmll += "<th style='background-color:#050505; color: white;'>Nombre</th>";
          htmll += "<th style='background-color:#050505; color: white;'>Cant</th>";
          htmll += "<th style='background-color:#050505; color: white;'>Precio Ind</th></tr></thead>";

          htmll += "<tbody>";
          for (var i = 0; i < response.detalles.length; i++) {
              var mac = response.detalles[i].mac || 'S/N';
              htmll += '<tr>' +
                  '<td>' + response.detalles[i].fecha + '</td>' +
                  '<td>' + response.detalles[i].cat + '</td>' +
                  '<td>' + response.detalles[i].codigo + '</td>' +
                  '<td>' + response.detalles[i].codi + '</td>' +
                  '<td>' + mac + '</td>' +
                  '<td>' + response.detalles[i].nombre + '</td>' +
                  '<td>' + response.detalles[i].cantidad + '</td>' +
                  '<td>' + parseFloat(response.detalles[i].precio_compra).toFixed(2) + '</td>' +
                  '</tr>';
          }
          htmll += "</tbody>";
          htmll += "</table>";
          document.getElementById("tbldetalle").innerHTML = htmll;
      },
      error: function(xhr, status, error) {
         console.error("Error en la petición:", error);
         console.error(xhr.responseText);
     } 
  });  
         
}

var cont = 0; // Contador de filas
var detalles=0;
function agregarDetalle(idarticulo, codigo, articulo, nroproducto, filaBoton) {

  console.log("Producto seleccionado:", nroproducto);

  // Validar que el código no esté repetido
  if (codigoYaExiste(codigo, nroproducto)) {
    Swal.fire({
        icon: 'error',
        title: 'Artículo duplicado',
        text: `El artículo con código ${codigo}${nroproducto.toString().padStart(4, "0")} ya está agregado.`,
        confirmButtonText: 'Aceptar',
        timer: 3000
    });
    return; // Salir de la función para evitar agregar el artículo duplicado
}
   
  var cantidad = 1;
  var precio_compra = 0;
  var precio_venta = 1;
  var porcentajePrecio = 0;

  var pro = nroproducto.toString().padStart(4, "0");
  
  // Verificar que los datos sean válidos
  if (idarticulo != "") {
      var subtotal = cantidad * precio_compra;

      // Crear una nueva fila para agregar al detalle
      var fila = `
          <tr class="filas" id="fila${cont}">
              <td>
                  <button type="button" class="btn btn-danger btn-xs btn-flat" onclick="eliminarDetalle(${cont})"><i class="fa fa-trash"></i></button> 
                   <button type="button" class="btn btn-success btn-xs btn-flat" onclick="agregarCantidad(${idarticulo}, '${articulo}', ${cantidad}, ${codigo}, ${nroproducto})">
                      <span class="fa fa-plus"></span>
                  </button>
              </td>
              <td>
                  <input type="hidden" name="idarticulo[]" value="${idarticulo}">${articulo}
              </td>
              <td>
                  <input class="form-control" type="text" value="${codigo}${pro}" readonly>
                  <input class="form-control" type="hidden" name="codigo[]" value="${codigo}${pro}" readonly>
                  <input class="form-control" type="hidden" name="nroproducto[]" value="${nroproducto}" readonly>
              </td>
              <td>
                  <input class="form-control" type="text" name="marca[]">
              </td>
              <td>
                  <input type="number" name="cantidad[]" id="cantidad${cont}" value="${cantidad}" min="1" class="form-control">
              </td>
              <td>
                  <input type="number" step="any" name="precio_compra[]" id="precio_compra${cont}" value="${precio_compra}" class="form-control">
              </td>
              <td>
                  <input type="number" name="porcentajePrecio[]" id="porcentajePrecio${cont}" value="${porcentajePrecio}" class="form-control" onkeyup="modificarSubtotales()">
              </td>
              <td>
                  <input type="number" step="any" name="precio_venta[]" value="${precio_venta}" class="form-control">
              </td>
              <td>
                  <input type="text" name="garantia[]"  value="6" class="form-control">
              </td>
              <td>
                  <span name="subtotal" id="subtotal${cont}">${subtotal}</span>
              </td>
          </tr>
      `;

      // Agregar la fila a la tabla "detalles"
      detalles=detalles+1;
      $('#detalles').append(fila);
      // Agregar eventos para recalcular subtotales cuando se cambian los valores
      $("#cantidad" + cont).keyup(modificarSubtotales);
      $("#cantidad" + cont).change(modificarSubtotales);
      $("#porcentajePrecio" + cont).change(modificarSubtotales);
      $("#precio_compra" + cont).keyup(modificarSubtotales);
      $("#precio_compra" + cont).change(modificarSubtotales);
      // Incrementar el contador
      cont++;
      // Llamar a la función para actualizar los subtotales
      modificarSubtotales();
      // Eliminar la fila dentro del modal después de agregar al detalle
      $(filaBoton).closest('tr').remove();  // Esto elimina la fila en el modal
  } else {
      alert("Error al ingresar el detalle, revisar los datos del artículo");

  }
  
}

// Función para validar si el código ya existe
function codigoYaExiste(codigo, nroproducto) {
  let existe = false;
  const codigoCompleto = `${codigo}${nroproducto.toString().padStart(4, "0")}`;
  $("input[name='codigo[]']").each(function () {
      if ($(this).val() === codigoCompleto) {
          existe = true;
      }
  });
  return existe;
}

function modificarSubtotales() {
  // Lógica para actualizar los subtotales y total
      var cant=document.getElementsByName("cantidad[]");
      var prec=document.getElementsByName("precio_compra[]");
      var porcenPrecio=document.getElementsByName("porcentajePrecio[]");
      var precioVenta=document.getElementsByName("precio_venta[]");
      var sub=document.getElementsByName("subtotal");

      for (var i = 0; i < cant.length; i++) {
        var inpC=cant[i];
        var inpP=prec[i];
        var inpS=sub[i];
        var inpPorcentajeP=porcenPrecio[i];
        inpS.value=inpC.value*inpP.value;
        precioVenta[i].value = ((1+inpPorcentajeP.value/100) * inpP.value).toFixed(2);
        document.getElementsByName("subtotal")[i].innerHTML=(inpS.value).toFixed(2);
	}
	calcularTotales();
}

function calcularTotales()
{
      var sub=document.getElementsByName("subtotal");
      var total=0.0;
      for (var i = 0; i < sub.length; i++) {
        total+= document.getElementsByName("subtotal")[i].value;
      }

      $("#total").html("S/. "+total.toFixed(2));
      $("#total_compra").val(total.toFixed(2));
      evaluar();
}

function evaluar()
{
    if(detalles>0)
    {
      $("#btnGuardar").show();
    }
    else
      {
        $("#btnGuardar").hide();
       cont=0;
      }
	}

  function eliminarDetalle(index) {
    // Eliminar la fila especificada
    $('#fila' + index).remove();
    modificarSubtotales();
    calcularTotales(); // Actualizar los subtotales después de eliminar
  }


var contCantidad = 0;
var detalleCant = 0;
// Objeto para rastrear los correlativos por idarticulo
var correlativosPorArticulo = {};
function agregarCantidad(idarticulo, articulo, cantidad, codigo, nroproducto) {
    // Asegurarnos de que nroproducto tenga un valor inicial numérico
    nroproducto = parseInt(nroproducto, 10);

    // Verificar si ya existe un correlativo para este idarticulo
    if (!(idarticulo in correlativosPorArticulo)) {
        // Si no existe, inicializarlo con el valor actual de nroproducto
        correlativosPorArticulo[idarticulo] = nroproducto;
    } else {
        // Si existe, verificar si el correlativo actual es menor que el último valor de correlativo registrado
        if (nroproducto > correlativosPorArticulo[idarticulo]) {
          correlativosPorArticulo[idarticulo] = nroproducto;
      }
    }
    // Incrementar el correlativo existente
    correlativosPorArticulo[idarticulo]++;
    // Obtener el correlativo actual formateado
    var nroproductoFormateado = correlativosPorArticulo[idarticulo].toString().padStart(4, "0");

   

    $("#listadoCantidad").show();
    // Crear la fila con los datos
    var filaCantidad = `
        <tr class="filasCantidad" id="filaCantidad${contCantidad}">
            <td>${detalleCant + cantidad}</td>
            <td>
                <input class="form-control" type="hidden" name="idarticuloCant[]" value="${idarticulo}">
                ${articulo}
            </td>
            <td>
                <input class="form-control" type="text" name="codigoCant[]" readonly="" value="${codigo}${nroproductoFormateado}">
            </td>
            <td>
                <input class="form-control" type="text" name="cantidadCant[]" value="${cantidad}">
            </td>
            <td>
                <input class="form-control" type="text" name="macCant[]">
            </td>
            <td>
                <input class="form-control" type="text" name="serieCant[]">
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-xs btn-flat" onclick="eliminarDetalleCant(${contCantidad}, '${idarticulo}')"><i class="fa fa-trash"></i></button>
            </td>
        </tr>
    `;
    // Agregar la fila a la tabla
    $('#tblListadoCantidad tbody').append(filaCantidad);
    // Incrementar los contadores
    detalleCant += 1;
    contCantidad++;

    $('input[name="macCant[]"], input[name="serieCant[]"]').on('keypress', function (e) {
      const currentTime = new Date().getTime();
      const inputField = $(this);
  
      if (!inputField.data('lastKeyPress')) {
          inputField.data('lastKeyPress', currentTime);
          return;
      }
  
      const timeDifference = currentTime - inputField.data('lastKeyPress');
      inputField.data('lastKeyPress', currentTime);
  
      // Si la entrada es demasiado lenta, se asume que no es un escaneo
      if (timeDifference > 100) { // Ajusta el tiempo si es necesario
          e.preventDefault();
          Swal.fire({
            icon: 'error',
            title: 'Entrada por Escaner',
            text: `Solo se permite entrada mediante escáner.`,
            confirmButtonText: 'Aceptar',
            timer: 3000
        });
      }
  });

  $('input[name="macCant[]"], input[name="serieCant[]"]').on('change', function () {
    const inputValue = $(this).val();
    const inputField = $(this);

    if (inputValue.trim() !== '') {
        $.post('../../ajax/ingreso.php?op=validarRegistro', { valor: inputValue }, function (response) {
            if (response.cantidad>0) {
                //alert('Este valor ya está registrado. Ingrese uno diferente.');
                Swal.fire({
                  icon: 'error',
                  title: 'Valor Duplicado',
                  text: `Este valor ya está registrado. Ingrese uno diferente.`,
                  confirmButtonText: 'Aceptar',
                  timer: 3000
              });
                inputField.val(''); // Limpiar el campo si está duplicado
            }
        }, 'json').fail(function () {
            alert('Error al validar el dato.');
        });
    }
});
}

function eliminarDetalleCant(indiceCant,idarticulo) {
   // Remover la fila especificada
   $("#filaCantidad" + indiceCant).remove();

   // Actualizar el contador de detalle
   detalleCant -= 1;

   // Reducir el correlativo del idarticulo correspondiente
   if (idarticulo in correlativosPorArticulo && correlativosPorArticulo[idarticulo] > 0) {
       correlativosPorArticulo[idarticulo]--;
   }

   // Ocultar la tabla si no quedan filas
   if (detalleCant === 0) {
       $("#listadoCantidad").hide();
   }
}


// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

// Función para guardar o editar
function guardaryeditar(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#frmForm")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas guardar los cambios realizados?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, guardar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Si el usuario confirma, realizar la solicitud AJAX
      $.ajax({
        url: "../../ajax/ingreso.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
          // Mostrar mensaje de éxito o error según la respuesta del backend
          swalWithBootstrapButtons.fire({
            title: 'Resultado',
            text: datos, // Mostrar el mensaje devuelto por el backend
            icon: datos.includes("Compra Registrado") || datos.includes("Compra Actualizada") ? 'success' : 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            if (datos.includes("Compra Registrado") || datos.includes("Compra Actualizada")) {
              // Redirigir al listado si la operación fue exitosa
              window.location.href = "list.php";
              limpiar();
            } else {
              // Si hubo un error, redirigir al formulario de creación
              window.location.href = "create.php";
            }
          });
        },
        error: function (err) {
          // Manejar errores en la solicitud AJAX
          swalWithBootstrapButtons.fire({
            title: 'Error',
            text: 'Hubo un problema con la solicitud. Intente nuevamente.',
            icon: 'error',
            confirmButtonText: 'Aceptar'
          }).then(() => {
            $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
          });
        }
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      // Si el usuario cancela, mostrar un mensaje de cancelación
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "No se realizaron cambios.",
        icon: "error",
        confirmButtonText: "Aceptar"
      }).then(() => {
        $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
      });
    }
  }).finally(() => {
    $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
  });
  
}

function eliminar(idingreso) {
  const swalWithBootstrapButtons = Swal.mixin({
    customClass: {
      confirmButton: "btn btn-success mx-2",
      cancelButton: "btn btn-danger mx-2"
    },
    buttonsStyling: false
  });

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¡Eliminar si no hay salidas realizadas!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, eliminar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Realizar la eliminación vía AJAX
      $.post("../../ajax/ingreso.php?op=eliminar", { idingreso: idingreso }, function (e) {
        swalWithBootstrapButtons.fire({
          title: "Eliminado",
          text: "El ingreso ha sido eliminada exitosamente.",
          icon: "success"
        });

        // Recargar la tabla después de eliminar
        tabla.ajax.reload();
      });
    } else if (result.dismiss === Swal.DismissReason.cancel) {
      swalWithBootstrapButtons.fire({
        title: "Cancelado",
        text: "El ingreso está segura :)",
        icon: "error"
      });
    }
  });
}

$(document).ready(function () {
  // Obtener el parámetro idcliente de la URL
  const urlParams = new URLSearchParams(window.location.search);
  const idpersona = urlParams.get('idpersona');

  if (idpersona) {
      // Llamar a la función mostrar del backend
      $.post("../../ajax/cliente.php?op=mostrar", { idpersona: idpersona }, function (data, status) {
          if (status === "success") {
              const cliente = JSON.parse(data);

              // Precargar los campos del formulario
              $("#idproved").val(cliente.idpersona);
              $("#nombre").val(cliente.nombre);
              $("#idtipo_documento").val(cliente.idtipo_documento).trigger('change'); // Actualiza Select2
              $("#num_documento").val(cliente.num_documento);
              $("#celular").val(cliente.celular);
              $("#telefono").val(cliente.telefono);
              $("#whatsapp").val(cliente.whatsapp);
              $("#email").val(cliente.email);
              $("#estado").val(cliente.estado);
              $("#btnGuardar").html('<i class="fas fa-save"></i> Actualizar registro');
              $("#idtitle").html('<i class="fas fa-plus"></i> Actualizar cliente')

          } else {
              console.error("Error al cargar los datos");
          }
      });
  }
});



init();