var tabla;
function init(){
    listar();
    listarsalida();
    listarproducto();
    evaluar();

    $("#frmForm").on("submit", function(e) {
        guardaryeditar(e);
    });

    $.post("../../ajax/usuario.php?op=selectTecnico", function(r){
      if ($.fn.select2 && $('#idtecnico').data('select2')) {
        $('#idtecnico').select2('destroy');
      }
    
      // Limpiar las opciones antes de agregar las nuevas
      $("#idtecnico").html('<option value="">Seleccione Cliente</option>'); 
      // Actualizar el contenido del select con las opciones de producto
      $("#idtecnico").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idtecnico').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione un Tecnico',
        allowClear: true,
      });
    });

   
}

function setFechaHoraPeruana() {
  const now = new Date(); // Fecha y hora actual en UTC
  const offset = -5; // Zona horaria de Perú (UTC-5)

  // Ajustar a la zona horaria peruana RESTANDO el offset
  const peruTime = new Date(now.getTime() + (offset * 60 * 60 * 1000));

  // Obtener componentes de la fecha y hora
  const year = peruTime.getUTCFullYear();
  const month = String(peruTime.getUTCMonth() + 1).padStart(2, '0'); // Meses comienzan en 0
  const day = String(peruTime.getUTCDate()).padStart(2, '0');
  const hours = String(peruTime.getUTCHours()).padStart(2, '0');
  const minutes = String(peruTime.getUTCMinutes()).padStart(2, '0');

  // Formatear fecha y hora en formato 'YYYY-MM-DDTHH:MM'
  const formattedDateTime = `${year}-${month}-${day}T${hours}:${minutes}`;

  // Verificar si el elemento existe antes de asignarle un valor
  const inputFecha = document.getElementById('fecha_hora');
  if (inputFecha) {
    inputFecha.value = formattedDateTime;
  } else {
    //console.error("El elemento con id 'fecha_hora' no se encontró en el DOM.");
  }
}

// Ejecutar la función al cargar la página
document.addEventListener('DOMContentLoaded', setFechaHoraPeruana);

// Función para listar datos
function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/inventario.php?op=listarinventario',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true,
          "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
    });
}

// Función para listar datos
function listarsalida() {
    tabla=$("#productosalida").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/inventario.php?op=listarsalida',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true,
          "order": [[ 0, "desc" ]]//Ordenar (columna,orden)
    });
}

function listarproducto() {
    tabla=$("#modalproducto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/inventario.php?op=listarproducto',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}


function mostrardetalle(idingreso){   
    //var idingreso = idingreso;  
    //console.log(idingreso);
    $.ajax({  
         url:"../../ajax/inventario.php?op=mostrardetalle&id=" + idingreso,  
         method:"POST",  
         data:{idingreso:idingreso},  
         dataType:"json",  
         success:function(response){  
           console.log(response);                 
      
         var cont=0;                  
          var html="<table class='table table-striped table-bordered table-condensed table-hover'>";
          html+="<thead>";
          html+="<tr style='background-color:#4564ff'>";
          html+="<th style='background-color:#4564ff; color: white;'>Articulo</th>";
          html+="<th style='background-color:#4564ff; color: white;'>Cantidad</th>";
          html+="<th style='background-color:#4564ff; color: white;'>Precio Compra</th>";
          html+="<th style='background-color:#4564ff; color: white;'>Precio Venta</th>";
          html+="<th style='background-color:#4564ff; color: white;'>SubTotal</th> </tr></thead>";

          html += "<tbody>";
            for (var i = 0; i < response.ingresos.length; i++) {
                html += '<tr>' +
                    '<td>' + response.ingresos[i].nombre + '</td>' +
                    '<td>' + response.ingresos[i].cantidad + '</td>' +
                    '<td>' + response.ingresos[i].precio_compra + '</td>' +
                    '<td>' + response.ingresos[i].precio_venta + '</td>' +
                    '<td>' + response.ingresos[i].cantidad * response.ingresos[i].precio_compra + '</td>' +
                    '</tr>';
            }
            html += "</tbody>";
            html += "</table>";
            document.getElementById("tblarticulos").innerHTML = html;             
         
 // Construir la tabla de detalles
            var htmll = "<table class='table table-striped table-bordered table-condensed table-hover'>";
            htmll += "<thead>";
            htmll += "<tr style='background-color:#050505'>";
            htmll += "<th style='background-color:#050505; color: white;'>Fecha Registro</th>";
            htmll += "<th style='background-color:#050505; color: white;'>Cod Mad</th>";
            htmll += "<th style='background-color:#050505; color: white;'>Cod Producto</th>";
            htmll += "<th style='background-color:#050505; color: white;'>Cod Num</th>";
            htmll += "<th style='background-color:#050505; color: white;'>Mac</th>";
            htmll += "<th style='background-color:#050505; color: white;'>Nombre</th>";
            htmll += "<th style='background-color:#050505; color: white;'>Cant</th>";
            htmll += "<th style='background-color:#050505; color: white;'>Precio Ind</th></tr></thead>";

            htmll += "<tbody>";
            for (var i = 0; i < response.detalles.length; i++) {
                var mac = response.detalles[i].mac || 'S/N';
                htmll += '<tr>' +
                    '<td>' + response.detalles[i].fecha + '</td>' +
                    '<td>' + response.detalles[i].cat + '</td>' +
                    '<td>' + response.detalles[i].codigo + '</td>' +
                    '<td>' + response.detalles[i].codi + '</td>' +
                    '<td>' + mac + '</td>' +
                    '<td>' + response.detalles[i].nombre + '</td>' +
                    '<td>' + response.detalles[i].cantidad + '</td>' +
                    '<td>' + response.detalles[i].precio_compra + '</td>' +
                    '</tr>';
            }
            htmll += "</tbody>";
            htmll += "</table>";
            document.getElementById("tbldetalle").innerHTML = htmll;
        },
        error: function(xhr, status, error) {
           console.error("Error en la petición:", error);
           console.error(xhr.responseText);
       } 
    });  
           
}

function mostrardetallesalida(idsalida){   
    $.ajax({  
      url:"../../ajax/inventario.php?op=mostrardetallesalida&id=" + idsalida,  
         method:"POST",  
         data:{idsalida:idsalida},  
         dataType:"json",  
         success:function(response){  
           console.log(response);                 
      
         var cont=0;                  
          var html="<table class='table table-striped table-bordered table-condensed table-hover'>";
          html+="<thead>";
          html+="<tr style='background-color:#050505; color: white;'>";
          html+="<th style='background-color:#050505; color: white;'>Fecha Salida</th>";
          html+="<th style='background-color:#050505; color: white;'>Tecnico</th>";
          html+="<th style='background-color:#050505; color: white;'>Cod Madre</th>";
          html+="<th style='background-color:#050505; color: white;'>Codigo</th>";
          html+="<th style='background-color:#050505; color: white;'>Producto</th>";
          html+="<th style='background-color:#050505; color: white;'>Estado Material</th>";                 
          html+="<th style='background-color:#050505; color: white;'>Cantidad</th>";
          html+="<th style='background-color:#050505; color: white;'>U.Medida</th>";
          html+="<th style='background-color:#050505; color: white;'>Precio Salida</th>";
          html+="<th style='background-color:#050505; color: white;'>Movimiento</th> </tr></thead>";

          html+="<tbody>";              

          for (i = 0; i < response.detalles.length; i++) {  

            response.detalles[i].estadomovimiento='<button class="btn btn-danger btn-xs btn-flat">Salida</button>';

          if(response.detalles[i].estadomaterial =='1'){
            response.detalles[i].estadomaterial='<button class="btn btn-success btn-xs btn-flat">Nuevo</button>';
          }else if(response.detalles[i].estadomaterial =='2'){
            response.detalles[i].estadomaterial='<button class="btn btn-warning btn-xs btn-flat">Usado</button>';
          }else if(response.detalles[i].estadomaterial =='3'){
            response.detalles[i].estadomaterial='<button class="btn btn-primary btn-xs btn-flat">Reparado</button>';
          }else if(response.detalles[i].estadomaterial =='4'){
            response.detalles[i].estadomaterial='<button class="btn btn-danger btn-xs btn-flat">Malogrado</button>';
          }             
             html += '<tr>' +
            //'<tr>'+
            '<td>' + response.detalles[i].fechasalida + '</td>' +
            '<td>' + response.detalles[i].tecnico + '</td>' +
            '<td>' + response.detalles[i].madre + '</td>' +
            '<td>' + response.detalles[i].codigo + '</td>' +
            '<td>' + response.detalles[i].producto + '</td>' +
            '<td>' + response.detalles[i].estadomaterial + '</td>' +                   
            '<td>' + response.detalles[i].cantidad + '</td>' +
            '<td>' + response.detalles[i].unidadmedida + '</td>' +
            '<td>' + response.detalles[i].precio_compra + '</td>' +
            '<td>' + response.detalles[i].estadomovimiento + '</td>' +               
            '</tr>' ;
            }
         
            html+="</tbody>";
            html+="</table>";                 
            document.getElementById("tblarticulosSalida").innerHTML=html;              
                        
         } ,
         error: function(xhr, status, error) {
            console.error("Error en la petición:", error);
            console.error(xhr.responseText);
          } 

    });  
}

let detalles = 0;
let cont = 0;

function agregarDetalle(idarticulo, articulo, marca, mac, serie, precio_compra, codigo, unidad_medida, nrofactura, idprovedor, garantia, estadomaterial, precio_venta, stock, filaBoton) {
    let cantidad = 1;

    // Validar que el código no esté repetido
    if (codigoYaExiste(codigo)) {
      Swal.fire({
          icon: 'error',
          title: 'Artículo duplicado',
          text: `El artículo con código ${codigo} ya está agregado.`,
          confirmButtonText: 'Aceptar',
          timer: 3000
      });
      return; // Salir de la función para evitar agregar el artículo duplicado
  }

    if (idarticulo !== "") {
        const subtotal = cantidad * precio_venta;
        const fila = `
            <tr class="filas" id="fila${cont}">
                <td><button type="button" class="btn btn-danger btn-xs btn-flat" onclick="eliminarDetalle(${cont})"><i class="fa fa-trash"></i></button></td>
                <td>
                    <input type="hidden" name="idarticulo[]" value="${idarticulo}">
                    <input  type="hidden" name="precio_compra[]" value="${precio_compra}">
                    <input type="hidden" name="estadomaterial[]" value="${estadomaterial}">
                    ${articulo}
                </td>
                <td><input readonly class="form-control" type="text" name="codigo[]" value="${codigo}"></td>
                <td><input readonly class="form-control" type="text" name="marca[]" value="${marca}"></td>
                <td><input readonly class="form-control" type="text" name="mac[]" value="${mac}"></td>
                <td><input readonly class="form-control" type="text" name="serie[]" value="${serie}"></td>
                <td><input readonly class="form-control" type="text" name="unidadmedida[]" value="${unidad_medida}"></td>
                <td>
                    <input type="number" class="form-control" name="cantidad[]" id="cantidad${cont}" value="${cantidad}" min="1" max="${stock}" data-stock="${stock}">
                    <input type="hidden" name="nrofactura[]" value="${nrofactura}">
                    <input type="hidden" name="idprovedor[]" value="${idprovedor}">
                    <input type="hidden" name="garantia[]" value="${garantia}">
                </td>
                <td><input readonly type="number" class="form-control" step="0.01" name="precio_venta[]" id="precio_venta${cont}" min="1" value="${precio_venta}"></td>
                <td><span name="subtotal" id="subtotal${cont}">${subtotal.toFixed(2)}</span></td>
            </tr>
        `;

        detalles++;
        $('#detalles').append(fila);

        // Registrar eventos

        $(`#cantidad${cont}`).on('keyup change', function () {
          validarStock(this);
          modificarSubtotales();
          });

        $(`#cantidad${cont}, #precio_venta${cont}`).on('keyup change', modificarSubtotales);

        cont++;
        modificarSubtotales();
        
        $(filaBoton).closest('tr').remove();  // Esto elimina la fila en el modal
    } else {
        alert("Error al ingresar el detalle, revisar los datos del artículo");
    }
}

// Función para validar si el código ya existe
  function codigoYaExiste(codigo) {
    let existe = false;
    $("input[name='codigo[]']").each(function () {
        if ($(this).val() === codigo) {
            existe = true;
        }
    });
    return existe;
  }

function validarStock(elemento) {
      const stock = parseFloat($(elemento).data('stock'));
      const cantidad = parseFloat($(elemento).val());

      if (cantidad > stock) {
            Swal.fire({
              icon: 'error',
              title: 'Cantidad excedida',
              text: `La cantidad no puede exceder el stock disponible (${stock}).`,
              confirmButtonText: 'Aceptar',
              timer: 3000
          });
          $(elemento).val(stock); // Ajustar al valor máximo permitido
      }
}

function modificarSubtotales() {
    const cantidades = document.getElementsByName("cantidad[]");
    const precios = document.getElementsByName("precio_venta[]");
    const subtotales = document.getElementsByName("subtotal");

    for (let i = 0; i < cantidades.length; i++) {
        const cantidad = parseFloat(cantidades[i].value) || 0;
        const precio = parseFloat(precios[i].value) || 0;
        const subtotal = cantidad * precio;

        subtotales[i].textContent = subtotal.toFixed(2);
    }

    calcularTotales();
}

function calcularTotales() {
    const subtotales = document.getElementsByName("subtotal");
    let total = 0;

    for (let i = 0; i < subtotales.length; i++) {
        total += parseFloat(subtotales[i].textContent) || 0;
    }

    $("#total").html(`S/. ${total.toFixed(2)}`);
    $("#total_compra").val(total.toFixed(2));
    evaluar();
}

function evaluar() {
    if (detalles > 0) {
        $("#btnGuardar").show();
    } else {
        $("#btnGuardar").hide();
        cont = 0;
    }
}

function eliminarDetalle(indice) {
    $(`#fila${indice}`).remove();
    detalles--;
    calcularTotales();
}


// Configuración de SweetAlert2 con botones personalizados
const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});
// Función para guardar o editar
function guardaryeditar(e) {
    e.preventDefault(); // Evitar acción predeterminada
    $("#btnGuardar").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
    var formData = new FormData($("#frmForm")[0]);
  
    swalWithBootstrapButtons.fire({
      title: "¿Estás seguro?",
      text: "¿Deseas guardar los cambios realizados?",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Sí, guardar",
      cancelButtonText: "No, cancelar",
      reverseButtons: true
    }).then((result) => {
      if (result.isConfirmed) {
        // Si el usuario confirma, realizar la solicitud AJAX
        $.ajax({
          url: "../../ajax/inventario.php?op=guardaryeditar",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          success: function (datos) {
            // Mostrar mensaje de éxito o error según la respuesta del backend
            swalWithBootstrapButtons.fire({
              title: 'Resultado',
              text: datos, // Mostrar el mensaje devuelto por el backend
              icon: datos.includes("Salida Registrado") || datos.includes("Salida Actualizada") ? 'success' : 'error',
              confirmButtonText: 'Aceptar'
            }).then(() => {
              if (datos.includes("Salida Registrado") || datos.includes("Salida Actualizada")) {
                // Redirigir al listado si la operación fue exitosa
                window.location.href = "list.php";
                limpiar();
              } else {
                // Si hubo un error, redirigir al formulario de creación
                window.location.href = "create.php";
              }
            });
          },
          error: function (err) {
            // Manejar errores en la solicitud AJAX
            swalWithBootstrapButtons.fire({
              title: 'Error',
              text: 'Hubo un problema con la solicitud. Intente nuevamente.',
              icon: 'error',
              confirmButtonText: 'Aceptar'
            }).then(() => {
              $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón tras un error
            });
          }
        });
      } else if (result.dismiss === Swal.DismissReason.cancel) {
        // Si el usuario cancela, mostrar un mensaje de cancelación
        swalWithBootstrapButtons.fire({
          title: "Cancelado",
          text: "No se realizaron cambios.",
          icon: "error",
          confirmButtonText: "Aceptar"
        }).then(() => {
          $("#btnGuardar").prop("disabled", false); // Rehabilitar el botón si se cancela
        });
      }
    }).finally(() => {
      $("#btnGuardar").prop("disabled", false); // Asegurar que el botón se habilite al final
    });
    
  }



init();