// Función para listar datos
function init(){
  listar();

  $("#formActualizarMikrotik").on("submit", function(e) {
    enviar_mikrotik(e);
});
  
}

$(document).ready(function () {
  $("#btn_actualizar").on("click", function (e) {
      e.preventDefault(); // Evitar la acción predeterminada del enlace
      actualizarLinea();
  });
});



$('#producto').on('click', '.actualizar-mikrotik', function () {
    const idtorre = $(this).data('id');
    
    // Limpia el modal y establece el ID
    $('#idtorre').val(idtorre);
    $('#idtecnologia').empty(); // Limpia opciones previas
    
    $.post("../../ajax/tecnologia.php?op=selectTecnologia", function(r){
      if ($.fn.select2 && $('#idtecnologia').data('select2')) {
        $('#idtecnologia').select2('destroy');
      }
         // Limpiar las opciones antes de agregar las nuevas
         $("#idtecnologia").html('<option value="">Seleccione una tecnologia</option>'); 
         // Actualizar el contenido del select con las opciones de producto
         $("#idtecnologia").append(r);
    
      // Inicializar Select2 nuevamente
      $('#idtecnologia').select2({
        theme: 'bootstrap4',
        placeholder: 'Seleccione una tecnologia',
        allowClear: true,
      });
    });

    // Abre el modal
    $('#modalActualizarMikrotik').modal('show');
});


function listar() {
    tabla=$("#producto").DataTable({
        "responsive": true,
        "autoWidth": false,
        "ajax": {
            url: '../../ajax/mikrotik.php?op=listarmikrotik',
            type: "GET",
            dataType: "json",
            error: function(e) {
                console.error("Error en la solicitud AJAX:", e.responseText);
                alert("No se pudo cargar la tabla. Verifique la consola.");
            }
        },
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_",
            "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
          },
          "bDestroy": true
    });
}

const swalWithBootstrapButtons = Swal.mixin({
  customClass: {
    confirmButton: "btn btn-success mx-2", // Añadimos margen (Bootstrap `me-2`) para separar los botones
    cancelButton: "btn btn-danger mx-2"
  },
  buttonsStyling: false
});

function enviar_mikrotik(e) {
  e.preventDefault(); // Evitar acción predeterminada
  $("#btn_mikrotik").prop("disabled", true); // Deshabilitar el botón para evitar múltiples envíos
  var formData = new FormData($("#formActualizarMikrotik")[0]);

  swalWithBootstrapButtons.fire({
    title: "¿Estás seguro?",
    text: "¿Deseas enviar datos al mikrotik?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Sí, enviar",
    cancelButtonText: "No, cancelar",
    reverseButtons: true
    
  }).then((result) => {
    if (result.isConfirmed) {
      // Mostrar loading sin timer
      Swal.fire({
          title: "Procesando...",
          text: "Esto puede tardar varios minutos.",
          allowOutsideClick: false,
          allowEscapeKey: false,
          showConfirmButton: false,
          backdrop: true,
          didOpen: () => {
              Swal.showLoading();
          }
      });

      $.ajax({
          url: "../../ajax/mikrotik.php?op=enviar_mikrotik",
          type: "POST",
          data: formData,
          contentType: false,
          processData: false,
          success: function (response) {
              try {
                  let datos = JSON.parse(response);

                  if (datos.status === "success") {
                      Swal.fire({
                          title: "Proceso completado",
                          html: `
                          <b>Total de líneas listo:</b> ${datos.listo} <br>
                          <b>Total de líneas activa:</b> ${datos.activa} <br>
                          <b>Total de líneas notifica:</b> ${datos.notifica} <br>
                          <b>Total de líneas corte:</b> ${datos.corte} <br>
                          <b>Total de líneas suspende:</b> ${datos.suspende} <br>
                          <b>Total de líneas baja:</b> ${datos.baja} <br>
                          <b>Usuarios ya existentes:</b> ${datos.existentes}
                      `,
                          icon: "success",
                          timer: 5000,
                          timerProgressBar: true,
                          allowOutsideClick: false,
                          backdrop: false,
                          willClose: () => {
                              $(location).attr("href", "list.php");
                          }
                      });
                  } else {
                      Swal.fire({
                          title: "Error",
                          text: "Hubo un problema en la actualización.",
                          icon: "error",
                          confirmButtonText: "Aceptar"
                      });
                  }
              } catch (error) {
                  console.error("Error al procesar respuesta:", error);
                  Swal.fire({
                      title: "Error",
                      text: "Respuesta inesperada del servidor.",
                      icon: "error",
                      confirmButtonText: "Aceptar"
                  });
              }
          },
          error: function () {
              Swal.fire({
                  title: "Error",
                  text: "Hubo un problema con la solicitud. Intente nuevamente.",
                  icon: "error",
                  confirmButtonText: "Aceptar"
              });
          }
      });
  }
  }).finally(() => {
    $("#btn_mikrotik").prop("disabled", false);
  });
}
 
  function actualizarLinea() {

    swalWithBootstrapButtons.fire({
        title: "¿Estás seguro?",
        text: "¿Deseas actualizar las líneas?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Sí, realizar",
        cancelButtonText: "No, cancelar",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            // Mostrar loading sin timer
            Swal.fire({
                title: "Procesando...",
                text: "Esto puede tardar varios minutos.",
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                backdrop: true,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            $.ajax({
                url: "../../ajax/mikrotik.php?op=actualizar_linea",
                type: "POST",
                contentType: false,
                processData: false,
                success: function (response) {
                    try {
                        let datos = JSON.parse(response);

                        if (datos.status === "success") {
                            Swal.fire({
                                title: "Proceso completado",
                                html: `Se procesaron ${datos.procesados} líneas.<br>Se actualizaron ${datos.actualizados} líneas.`,
                                icon: "success",
                                timer: 5000,
                                timerProgressBar: true,
                                allowOutsideClick: false,
                                backdrop: false,
                                willClose: () => {
                                    $(location).attr("href", "list.php");
                                }
                            });
                        } else {
                            Swal.fire({
                                title: "Error",
                                text: "Hubo un problema en la actualización.",
                                icon: "error",
                                confirmButtonText: "Aceptar"
                            });
                        }
                    } catch (error) {
                        console.error("Error al procesar respuesta:", error);
                        Swal.fire({
                            title: "Error",
                            text: "Respuesta inesperada del servidor.",
                            icon: "error",
                            confirmButtonText: "Aceptar"
                        });
                    }
                },
                error: function () {
                    Swal.fire({
                        title: "Error",
                        text: "Hubo un problema con la solicitud. Intente nuevamente.",
                        icon: "error",
                        confirmButtonText: "Aceptar"
                    });
                }
            });
        }
    });
}

init();